/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm;
import com.jetbrains.plugins.remotesdk.ui.DeploymentProjectLevelSetupForm;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteSdkByDeploymentForm {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.plugins.remotesdk.ui.RemoteSdkByDeploymentForm");
    private static final WebDeploymentCredentialsHolder DEPLOYMENT_EMPTY_CREDENTIALS = new WebDeploymentCredentialsHolder();
    private static final Condition<WebServerConfig> mySftpServersFilter = config -> config.getFileTransferConfig().getAccessType() == AccessType.SFTP;
    private JPanel myDeploymentPanel;
    private JLabel myDeploymentConfigurationLabel;
    protected WebServerCombo myDeploymentConfigurationsCombo;
    private JLabel myDeploymentHostLabel;
    private JLabel myDeploymentUrl;
    protected JPanel myDeploymentProjectLevelServerSetupPanel;
    protected ActionLink myDeploymentMoveServerLink;
    protected HyperlinkLabel myDeploymentLevelWarningLabel;
    protected JBLabel myDeploymentMoveServerLabel;
    protected JPanel myCustomActionPanel;
    private JPanel myDeploymentWarningPanel;
    private JBLabel myDeploymentWarningLabel;
    private final Project myProject;
    private WebDeploymentCredentialsHolder myDeploymentCredentials;
    @Nullable
    private final CreateRemoteSdkForm.BundleAccessor myBundleAccessor;
    private final DeploymentProjectLevelSetupForm myDeploymentProjectLevelSetupForm;

    public RemoteSdkByDeploymentForm(@Nullable Project project, @NotNull Disposable disposable) {
        if (disposable == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(0);
        }
        this(project, disposable, null);
    }

    public RemoteSdkByDeploymentForm(@Nullable Project project, @NotNull Disposable disposable, @Nullable CreateRemoteSdkForm.BundleAccessor bundleAccessor) {
        if (disposable == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myBundleAccessor = bundleAccessor;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)disposable, (Disposable)this.myDeploymentConfigurationsCombo);
        List<WebServerConfig> serverList = RemoteSdkUtil.getSftpServerList(this.myProject);
        this.myDeploymentWarningLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myDeploymentWarningPanel.setVisible(serverList.isEmpty());
        this.myDeploymentProjectLevelServerSetupPanel.setVisible(false);
        this.myDeploymentConfigurationsCombo.setProject(project);
        this.myDeploymentConfigurationsCombo.setWebServerFilter(mySftpServersFilter);
        this.myDeploymentConfigurationsCombo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RemoteSdkByDeploymentForm.this.deploymentSelected();
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            public void deploymentConfigChanged() {
                RemoteSdkByDeploymentForm.this.myDeploymentWarningPanel.setVisible(RemoteSdkUtil.getSftpServerList(RemoteSdkByDeploymentForm.this.myProject).isEmpty());
            }
        });
        this.myDeploymentProjectLevelSetupForm = new DeploymentProjectLevelSetupForm(project, bundleAccessor, new DeploymentProjectLevelSetupForm.Listener(){

            @Override
            public void onConfigCopied(@NotNull WebServerConfig global) {
                if (global == null) {
                    3.$$$reportNull$$$0(0);
                }
                RemoteSdkByDeploymentForm.this.setupDeploymentCombo(global);
                RemoteSdkByDeploymentForm.this.deploymentSelected();
            }

            @Override
            public void onConfigMoved(@NotNull WebServerConfig movedServer) {
                if (movedServer == null) {
                    3.$$$reportNull$$$0(1);
                }
                RemoteSdkByDeploymentForm.this.setupDeploymentCombo(movedServer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "global";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "movedServer";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteSdkByDeploymentForm$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConfigCopied";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConfigMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myDeploymentProjectLevelServerSetupPanel.setLayout(new BorderLayout());
        this.myDeploymentProjectLevelServerSetupPanel.add((Component)this.myDeploymentProjectLevelSetupForm.getMainPanel(), "Center");
        this.myDeploymentMoveServerLink = this.myDeploymentProjectLevelSetupForm.getDeploymentMoveServerLink();
        this.myDeploymentLevelWarningLabel = this.myDeploymentProjectLevelSetupForm.getDeploymentLevelWarningLabel();
        this.myDeploymentMoveServerLabel = this.myDeploymentProjectLevelSetupForm.getDeploymentMoveServerLabel();
        this.myCustomActionPanel = this.myDeploymentProjectLevelSetupForm.getCustomActionPanel();
        this.setupDeploymentCombo(this.defaultDeploymentConfig(project));
    }

    private WebServerConfig defaultDeploymentConfig(@Nullable Project project) {
        List<WebServerConfig> serverList;
        if (project != null) {
            PublishConfig config = PublishConfig.getInstance((Project)project);
            Pair idAndName = config.getDefaultServerIdAndName();
            if (idAndName.first != null) {
                return WebServersConfigManager.getInstance((Project)this.myProject).findServer((String)idAndName.first);
            }
        }
        return (serverList = RemoteSdkUtil.getSftpServerList(this.myProject)).isEmpty() ? null : serverList.get(0);
    }

    public void init(@NotNull WebDeploymentCredentialsHolder cred) {
        if (cred == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(2);
        }
        this.setDeploymentCredentials(new WebDeploymentCredentialsHolder().copyFrom(cred));
        WebServerConfig server = WebServersConfigManager.getInstance((Project)this.myProject).findServer(cred.getWebServerConfigId());
        if (server != null && mySftpServersFilter.value((Object)server)) {
            this.myDeploymentConfigurationsCombo.selectServer(server);
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(server.getId());
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(server)));
        } else {
            this.myDeploymentConfigurationsCombo.reset(Pair.create((Object)cred.getWebServerConfigId(), (Object)cred.getWebServerConfigName()));
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(false);
            LOG.warn("Can not find selected deployment server: " + cred.getWebServerConfigName());
        }
    }

    public Component getMainPanel() {
        return this.myDeploymentPanel;
    }

    public JLabel getNavigatableLabel() {
        return this.myDeploymentConfigurationLabel;
    }

    public abstract void onDeploymentUpdated(@NotNull WebDeploymentCredentialsHolder var1);

    public abstract void updateCredentials(@Nullable RemoteCredentials var1, @NotNull JLabel var2, @NotNull JLabel var3, @Nullable Runnable var4);

    public WebDeploymentCredentialsHolder getDeploymentCredentials() {
        return this.myDeploymentCredentials;
    }

    public void deploymentSelected() {
        this.useDeploymentSettings(this.myDeploymentConfigurationsCombo.getSelectedServer());
    }

    private void useDeploymentSettings(@Nullable WebServerConfig config) {
        if (config != null) {
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(config.getId());
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(config)));
            this.setDeploymentCredentials(new WebDeploymentCredentialsHolder(config.getId(), config.getName(), WebDeploymentCredentialHelper.getRemoteCredentials((WebServerConfig)config)));
        } else {
            this.setDeploymentCredentials(DEPLOYMENT_EMPTY_CREDENTIALS);
        }
    }

    private void setDeploymentCredentials(WebDeploymentCredentialsHolder deploymentCredentials) {
        this.myDeploymentCredentials = deploymentCredentials;
        this.onDeploymentUpdated(deploymentCredentials);
        RemoteCredentials sshCredentials = RemoteSdkCredentialsProducerImpl.getCredentialsBySftpServerId(this.myProject, this.myDeploymentCredentials.getWebServerConfigId());
        this.updateCredentials(sshCredentials, this.myDeploymentHostLabel, this.myDeploymentUrl, null);
    }

    protected void createUIComponents() {
        this.myDeploymentConfigurationsCombo = new WebServerCombo(true, -1, false);
    }

    private void setupDeploymentCombo(@Nullable WebServerConfig configToSelect) {
        if (configToSelect == null) {
            this.myDeploymentConfigurationsCombo.reset(null);
        } else {
            this.myDeploymentConfigurationsCombo.reset(Pair.create((Object)configToSelect.getId(), (Object)configToSelect.getName()));
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(configToSelect.getId());
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(configToSelect)));
        }
    }

    @Nullable
    public ValidationInfo validate() {
        WebServerConfig server = this.myDeploymentConfigurationsCombo.getSelectedServer();
        if (server == null) {
            return new ValidationInfo("Deployment configuration is not selected", (JComponent)this.myDeploymentConfigurationsCombo);
        }
        String deploymentError = this.validateDeployment(server);
        if (StringUtil.isNotEmpty((String)deploymentError)) {
            return new ValidationInfo(deploymentError, (JComponent)this.myDeploymentConfigurationsCombo);
        }
        return null;
    }

    @Nullable
    public String validateDeployment(@NotNull WebServerConfig server) {
        if (server == null) {
            RemoteSdkByDeploymentForm.$$$reportNull$$$0(3);
        }
        if (server.isProjectLevel()) {
            return "Project level deployment servers are not currently supported. Please create one using any of the two links above.";
        }
        return null;
    }

    public void updateWarningPanel() {
        WebServerConfig server = this.myDeploymentConfigurationsCombo.getSelectedServer();
        if (server != null) {
            String error = this.validateDeployment(server);
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(server.getId());
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)error));
        }
    }

    public String getValidationError() {
        WebServerConfig server = this.myDeploymentConfigurationsCombo.getSelectedServer();
        if (server != null) {
            return this.validateDeployment(server);
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDeploymentConfigurationsCombo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cred";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteSdkByDeploymentForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "validateDeployment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel3;
        this.createUIComponents();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeploymentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeploymentConfigurationLabel = jLabel3 = new JLabel();
        jLabel3.setText("Deployment configuration:");
        jLabel3.setDisplayedMnemonic('C');
        jLabel3.setDisplayedMnemonicIndex(11);
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        WebServerCombo webServerCombo = this.myDeploymentConfigurationsCombo;
        jPanel3.add((Component)webServerCombo, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDeploymentHostLabel = jLabel2 = new JLabel();
        jLabel2.setText("Deployment Host URL:");
        jPanel3.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentUrl = jLabel = new JLabel();
        jLabel.setText("");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, new Dimension(7, -1), null, new Dimension(7, -1)));
        this.myDeploymentProjectLevelServerSetupPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentWarningPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentWarningLabel = jBLabel = new JBLabel();
        jBLabel.setText("Create SFTP deployment server to configure connection credentials and path mappings.");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel3.setLabelFor((Component)webServerCombo);
    }
}

