/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.generators;

import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInstaller;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanInstalledGeneratorListProvider {
    public static final String GENERATOR_PREFIX = "generator-";

    public static YeomanInstalledGeneratorListProvider getProvider() {
        return new YeomanInstalledGeneratorListProvider();
    }

    private static List<VirtualFile> getGlobalInstalledGeneratorFiles() {
        NodeJsLocalInterpreter interpreter = YeomanGlobalSettings.getInstance().getInterpreter();
        if (interpreter == null) {
            return ContainerUtil.emptyList();
        }
        ArrayList possibleCandidates = ContainerUtil.newArrayList();
        VirtualFile virtualFile = interpreter.getGlobalNodeModulesVirtualDir();
        if (virtualFile == null) {
            return ContainerUtil.emptyList();
        }
        for (VirtualFile file : virtualFile.getChildren()) {
            if (!file.isValid() || !file.isDirectory() || !file.getName().startsWith(GENERATOR_PREFIX)) continue;
            possibleCandidates.add(file);
        }
        return possibleCandidates;
    }

    public List<YeomanInstalledGeneratorInfo> getAllInstalledGenerators() {
        return ContainerUtil.concat(YeomanInstalledGeneratorListProvider.getGlobalInstalledGenerators(), YeomanInstalledGeneratorListProvider.getLocalInstalledGenerators());
    }

    @NotNull
    private static List<YeomanInstalledGeneratorInfo> getGlobalInstalledGenerators() {
        List list = ContainerUtil.map(YeomanInstalledGeneratorListProvider.getGlobalInstalledGeneratorFiles(), file -> new YeomanInstalledGeneratorInfo((VirtualFile)file));
        if (list == null) {
            YeomanInstalledGeneratorListProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private static List<YeomanInstalledGeneratorInfo> getLocalInstalledGenerators() {
        File file = new File(PathManager.getSystemPath(), YeomanGeneratorInstaller.LOCAL_GENERATORS_RELATIVE_PATH);
        if (!file.exists()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                YeomanInstalledGeneratorListProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Object[] files = file.listFiles();
        if (files == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                YeomanInstalledGeneratorListProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List fileList = ContainerUtil.filter((Object[])files, file12 -> file12.isDirectory() && file12.getName().startsWith(GENERATOR_PREFIX));
        List list = ContainerUtil.map((Collection)fileList, file1 -> new YeomanInstalledGeneratorInfo((File)file1));
        if (list == null) {
            YeomanInstalledGeneratorListProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public YeomanInstalledGeneratorInfo getGeneratorByYoName(@NotNull String name) {
        if (name == null) {
            YeomanInstalledGeneratorListProvider.$$$reportNull$$$0(4);
        }
        for (YeomanInstalledGeneratorInfo info : this.getAllInstalledGenerators()) {
            if (!name.equals(info.getYoName())) continue;
            return info;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/plugins/yeoman/generators/YeomanInstalledGeneratorListProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalInstalledGenerators";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalInstalledGenerators";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/plugins/yeoman/generators/YeomanInstalledGeneratorListProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratorByYoName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

