/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.template;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGenerator;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorOwnerPanel;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorRunPanel;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorSubPanel;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanInstalledGeneratorsMain;
import jetbrains.plugins.yeoman.settings.YeomanConfigurable;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanProjectGeneratorWelcomePanel
implements YeomanProjectGeneratorSubPanel {
    private final YeomanProjectGeneratorOwnerPanel myOwner;
    private final YeomanProjectGenerator.Settings mySettings;
    private final YeomanGlobalSettings myYeomanGlobalSettings;
    private YeomanInstalledGeneratorsMain myGeneratorsMain;
    private HyperlinkLabel myNodeAndYeomanLink;
    private JBTextField myOptionsTextField;

    public YeomanProjectGeneratorWelcomePanel(YeomanProjectGeneratorOwnerPanel parent, YeomanProjectGenerator.Settings settings) {
        this.myOwner = parent;
        this.mySettings = settings;
        this.myYeomanGlobalSettings = YeomanGlobalSettings.getInstance();
    }

    @Override
    public void render() {
        this.myGeneratorsMain = new YeomanInstalledGeneratorsMain();
        JPanel bottomPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 5, true, false));
        ArrayList toMergeWithAnchorList = ContainerUtil.newArrayList();
        LabeledComponent<TextFieldWithBrowseButton> location = this.myOwner.getLocationComponent();
        if (location != null) {
            bottomPanel.add((Component)location);
            toMergeWithAnchorList.add(location);
        }
        this.myNodeAndYeomanLink = this.createNodeAndYeomanLink();
        JPanel generatorsPanel = YeomanProjectGeneratorWelcomePanel.createGeneratorsWithLabelPanel(toMergeWithAnchorList);
        JPanel generatorsMainPanel = this.myGeneratorsMain.getMainPanel();
        generatorsPanel.add((Component)generatorsMainPanel, "Center");
        bottomPanel.add(generatorsPanel);
        LabeledComponent<JBTextField> optionsTextLabelComponent = this.createOptionsPanel(toMergeWithAnchorList);
        LabeledComponent<?> installedGeneratorsButtonComponent = this.createInstallGeneratorsButtonPanel(toMergeWithAnchorList);
        bottomPanel.add((Component)optionsTextLabelComponent);
        bottomPanel.add((Component)installedGeneratorsButtonComponent);
        UIUtil.mergeComponentsWithAnchor((Collection)toMergeWithAnchorList);
        JPanel wrapperForWelcome = new JPanel(new BorderLayout());
        wrapperForWelcome.add((Component)bottomPanel, "North");
        this.myOwner.setBottomComponent((JComponent)this.myNodeAndYeomanLink);
        this.myOwner.setCentralComponent(wrapperForWelcome);
    }

    @NotNull
    private LabeledComponent<?> createInstallGeneratorsButtonPanel(ArrayList<PanelWithAnchor> toMergeWithAnchor) {
        JButton button = this.myGeneratorsMain.getInstallGeneratorsButton();
        JPanel buttonToLeftPanel = new JPanel(new BorderLayout());
        buttonToLeftPanel.add((Component)button, "West");
        LabeledComponent installedGeneratorsButtonComponent = LabeledComponent.create((JComponent)buttonToLeftPanel, (String)"", (String)"West");
        toMergeWithAnchor.add((PanelWithAnchor)installedGeneratorsButtonComponent);
        LabeledComponent labeledComponent = installedGeneratorsButtonComponent;
        if (labeledComponent == null) {
            YeomanProjectGeneratorWelcomePanel.$$$reportNull$$$0(0);
        }
        return labeledComponent;
    }

    @NotNull
    private LabeledComponent<JBTextField> createOptionsPanel(ArrayList<PanelWithAnchor> toMergeWithAnchor) {
        this.myOptionsTextField = new JBTextField(10);
        LabeledComponent optionsTextLabelComponent = LabeledComponent.create((JComponent)this.myOptionsTextField, (String)"Options:", (String)"West");
        toMergeWithAnchor.add((PanelWithAnchor)optionsTextLabelComponent);
        LabeledComponent labeledComponent = optionsTextLabelComponent;
        if (labeledComponent == null) {
            YeomanProjectGeneratorWelcomePanel.$$$reportNull$$$0(1);
        }
        return labeledComponent;
    }

    @NotNull
    private static JPanel createGeneratorsWithLabelPanel(ArrayList<PanelWithAnchor> toMergeWithAnchor) {
        JPanel generatorsPanel = new JPanel(new BorderLayout(10, 2));
        JPanel labelToTopPanel = new JPanel(new BorderLayout());
        final JBLabel labelGenerator = new JBLabel("Generator:");
        labelToTopPanel.add((Component)labelGenerator, "North");
        generatorsPanel.add((Component)labelToTopPanel, "West");
        toMergeWithAnchor.add(new PanelWithAnchor(){
            JComponent anchor;
            {
                this.anchor = labelGenerator;
            }

            public JComponent getAnchor() {
                return this.anchor;
            }

            public void setAnchor(@Nullable JComponent newAnchor) {
                this.anchor = newAnchor;
                labelGenerator.setAnchor(newAnchor);
            }
        });
        JPanel jPanel = generatorsPanel;
        if (jPanel == null) {
            YeomanProjectGeneratorWelcomePanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private HyperlinkLabel createNodeAndYeomanLink() {
        HyperlinkLabel nodeAndYeomanLink = new HyperlinkLabel(YeomanBundle.message("yeoman.generators.dialog.configure.node", new Object[0]), UIUtil.getTextFieldBackground());
        nodeAndYeomanLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)YeomanProjectGeneratorWelcomePanel.this.myOwner.getMainPanel(), "SettingsEditor", (Configurable)new YeomanConfigurable()) && YeomanProjectGeneratorWelcomePanel.this.myOwner.getValidateHandler() != null) {
                    YeomanProjectGeneratorWelcomePanel.this.myOwner.getValidateHandler().validate();
                }
            }
        });
        return nodeAndYeomanLink;
    }

    @Override
    public String validate() {
        if (this.myYeomanGlobalSettings.getInterpreter() == null) {
            return YeomanBundle.message("yeoman.generators.dialog.configure.error.node", new Object[0]);
        }
        if (StringUtil.isEmpty((String)this.myYeomanGlobalSettings.getYoPackagePath())) {
            return YeomanBundle.message("yeoman.generators.dialog.configure.error.yeoman", new Object[0]);
        }
        return null;
    }

    @Override
    @NotNull
    public YeomanProjectGeneratorSubPanel next(ActionEvent e) {
        this.commitSettings();
        this.myNodeAndYeomanLink.setVisible(false);
        this.myOwner.setMainButtonEnable(false);
        YeomanProjectGeneratorRunPanel yeomanProjectGeneratorRunPanel = new YeomanProjectGeneratorRunPanel(this.myOwner, this.mySettings);
        if (yeomanProjectGeneratorRunPanel == null) {
            YeomanProjectGeneratorWelcomePanel.$$$reportNull$$$0(3);
        }
        return yeomanProjectGeneratorRunPanel;
    }

    @Override
    public void commitSettings() {
        String path = this.mySettings.tempPath;
        File file = this.createTempStoreDirectory(path);
        this.mySettings.appPath = file.getAbsolutePath();
        this.mySettings.options = this.myOptionsTextField.getText();
        YeomanGeneratorInfo object = this.myGeneratorsMain.getSelectedObject();
        this.mySettings.info = object instanceof YeomanInstalledGeneratorInfo ? (YeomanInstalledGeneratorInfo)object : null;
    }

    @NotNull
    private File createTempStoreDirectory(String path) {
        File file = new File(path, new File(this.myOwner.getLocationTitle()).getName());
        if (file.exists()) {
            FileUtil.delete((File)file);
        }
        FileUtil.createDirectory((File)file);
        File file2 = file;
        if (file2 == null) {
            YeomanProjectGeneratorWelcomePanel.$$$reportNull$$$0(4);
        }
        return file2;
    }

    @Override
    public boolean isCreateButtonEnabled() {
        return true;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorWelcomePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstallGeneratorsButtonPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneratorsWithLabelPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "next";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempStoreDirectory";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

