/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.list;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorTableModel;

public class YeomanGeneratorTable
extends JBTable {
    public YeomanGeneratorTable(YeomanGeneratorTableModel model) {
        super((TableModel)model);
        this.getColumnModel().setColumnMargin(0);
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setStriped(true);
        this.setTableHeader(null);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        YeomanGeneratorTableModel model = (YeomanGeneratorTableModel)this.getModel();
        ColumnInfo columnInfo = model.getColumnInfos()[column];
        return columnInfo.getRenderer(model.getRowValue(row));
    }

    public YeomanGeneratorInfo[] getSelectedObjects() {
        YeomanGeneratorInfo[] selection = null;
        if (this.getSelectedRowCount() > 0) {
            int[] poses = this.getSelectedRows();
            selection = new YeomanGeneratorInfo[poses.length];
            for (int i = 0; i < poses.length; ++i) {
                selection[i] = this.getObjectAt(poses[i]);
            }
        }
        return selection;
    }

    public YeomanGeneratorInfo getObjectAt(int row) {
        return ((YeomanGeneratorTableModel)this.getModel()).getObjectAt(this.convertRowIndexToModel(row));
    }

    public void select(YeomanGeneratorInfo ... descriptors) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        YeomanGeneratorTableModel tableModel = (YeomanGeneratorTableModel)this.getModel();
        this.getSelectionModel().clearSelection();
        if (descriptors == null) {
            return;
        }
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            YeomanGeneratorInfo descriptorAt = this.getObjectAt(i);
            if (ArrayUtil.find((Object[])descriptors, (Object)descriptorAt) == -1) continue;
            int row = this.convertRowIndexToView(i);
            this.getSelectionModel().addSelectionInterval(row, row);
        }
        TableUtil.scrollSelectionToVisible((JTable)((Object)this));
    }

    protected boolean isSortOnUpdates() {
        return false;
    }

    public Object[] getElements() {
        return ((YeomanGeneratorTableModel)this.getModel()).getView().toArray();
    }
}

