/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerSettingsManager;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanCommandLineUtil {
    public static Runnable createExecuteCommandLineAction(final @Nullable Project project, final @NotNull GeneralCommandLine commandLine, final @NotNull Ref<RuntimeException> exceptionRef, final @Nullable ProgressIndicator currentIndicator) {
        if (commandLine == null) {
            YeomanCommandLineUtil.$$$reportNull$$$0(0);
        }
        if (exceptionRef == null) {
            YeomanCommandLineUtil.$$$reportNull$$$0(1);
        }
        return new Runnable(){

            @Override
            public void run() {
                ProcessOutput output;
                block11: {
                    final ProgressIndicator indicator = currentIndicator == null ? ProgressManager.getInstance().getProgressIndicator() : currentIndicator;
                    indicator.setText(commandLine.getCommandLineString());
                    output = new ProcessOutput();
                    try {
                        Alarm alarm;
                        ProcessAdapter listener = new ProcessAdapter(){

                            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                                if (event == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (outputType == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (event == null) {
                                    return;
                                }
                                String text = event.getText().trim();
                                if (outputType == ProcessOutputTypes.STDERR || outputType == ProcessOutputTypes.STDOUT) {
                                    indicator.setText2(text);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "event";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "outputType";
                                        break;
                                    }
                                }
                                objectArray[1] = "jetbrains/plugins/yeoman/projectGenerator/util/YeomanCommandLineUtil$1$1";
                                objectArray[2] = "onTextAvailable";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        };
                        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
                        Alarm alarm2 = alarm = project == null ? null : new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
                        if (alarm != null) {
                            alarm.addRequest(new Runnable((OSProcessHandler)processHandler, indicator, alarm){
                                final /* synthetic */ OSProcessHandler val$processHandler;
                                final /* synthetic */ ProgressIndicator val$indicator;
                                final /* synthetic */ Alarm val$alarm;
                                {
                                    this.val$processHandler = oSProcessHandler;
                                    this.val$indicator = progressIndicator;
                                    this.val$alarm = alarm;
                                }

                                @Override
                                public void run() {
                                    if (!this.val$processHandler.isProcessTerminated()) {
                                        if (this.val$indicator.isCanceled()) {
                                            this.val$processHandler.destroyProcess();
                                        } else {
                                            this.val$alarm.addRequest((Runnable)this, TimeUnit.SECONDS.toMillis(1L));
                                        }
                                    }
                                }
                            }, TimeUnit.SECONDS.toMillis(1L));
                        }
                        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                                if (event == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                if (outputType == null) {
                                    3.$$$reportNull$$$0(1);
                                }
                                if (outputType == ProcessOutputTypes.STDERR) {
                                    output.appendStderr(event.getText());
                                } else if (outputType != ProcessOutputTypes.SYSTEM) {
                                    output.appendStdout(event.getText());
                                }
                            }

                            public void processTerminated(@NotNull ProcessEvent event) {
                                if (event == null) {
                                    3.$$$reportNull$$$0(2);
                                }
                                if (alarm != null) {
                                    Disposer.dispose((Disposable)alarm);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "event";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "outputType";
                                        break;
                                    }
                                }
                                objectArray2[1] = "jetbrains/plugins/yeoman/projectGenerator/util/YeomanCommandLineUtil$1$3";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onTextAvailable";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "processTerminated";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                        processHandler.addProcessListener((ProcessListener)listener);
                        processHandler.startNotify();
                        if (processHandler.waitFor((long)((int)TimeUnit.MINUTES.toMillis(10L)))) {
                            try {
                                output.setExitCode(processHandler.getProcess().exitValue());
                                break block11;
                            }
                            catch (Exception e) {
                                throw new ExecutionException((Throwable)e);
                            }
                        }
                        processHandler.destroyProcess();
                        output.setTimeout();
                    }
                    catch (ExecutionException e) {
                        exceptionRef.set((Object)new RuntimeException("Cannot execute " + commandLine.getCommandLineString(), e));
                        return;
                    }
                }
                String errorMessage = null;
                if (output.isTimeout()) {
                    errorMessage = "Time limit exceeded for command:\n" + commandLine.getCommandLineString();
                }
                if (output.getExitCode() != 0) {
                    errorMessage = "Failed command:\n" + commandLine.getCommandLineString() + "\nExit code: " + output.getExitCode();
                }
                if (errorMessage != null) {
                    if (!output.getStdout().isEmpty()) {
                        errorMessage = errorMessage + "\nStandard output:\n" + output.getStdout();
                    }
                    if (!output.getStderr().isEmpty()) {
                        errorMessage = errorMessage + "\nStandard error:\n" + output.getStderr();
                    }
                    exceptionRef.set((Object)new RuntimeException(errorMessage));
                }
            }
        };
    }

    public static GeneralCommandLine createBowerInstallCommandLine(@NotNull Project project, @NotNull File workingDirectory) {
        if (project == null) {
            YeomanCommandLineUtil.$$$reportNull$$$0(2);
        }
        if (workingDirectory == null) {
            YeomanCommandLineUtil.$$$reportNull$$$0(3);
        }
        BowerSettings settings = BowerSettingsManager.getInstance((Project)project).getSettings();
        BowerSettings build = settings.createBuilder().setBowerJsonPath(new File(workingDirectory, "bower.json").getAbsolutePath()).build();
        try {
            GeneralCommandLine line = BowerCommandLineUtil.createCommandLine((BowerSettings)build);
            line.addParameter("install");
            return line;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @NotNull
    public static GeneralCommandLine createNpmInstallCommandLine(@Nullable Project project, @NotNull File workingDirectory) {
        GeneralCommandLine generalCommandLine;
        if (workingDirectory == null) {
            YeomanCommandLineUtil.$$$reportNull$$$0(4);
        }
        YeomanGlobalSettings files = YeomanGlobalSettings.getInstance();
        NodeJsLocalInterpreter interpreter = files.getInterpreter();
        assert (interpreter != null);
        try {
            generalCommandLine = NpmUtil.createNpmCommandLine((Project)project, (File)workingDirectory, (NodeJsLocalInterpreter)interpreter, (NpmCommand)NpmCommand.INSTALL, Collections.emptyList());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (generalCommandLine == null) {
            YeomanCommandLineUtil.$$$reportNull$$$0(5);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/plugins/yeoman/projectGenerator/util/YeomanCommandLineUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/plugins/yeoman/projectGenerator/util/YeomanCommandLineUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNpmInstallCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExecuteCommandLineAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createBowerInstallCommandLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNpmInstallCommandLine";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

