/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import jetbrains.plugins.yeoman.settings.YeomanNodeFiles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="YeomanSettings", storages={@Storage(value="yeomanSettings.xml")})
public class YeomanGlobalSettings
implements YeomanNodeFiles,
PersistentStateComponent<SettingsState> {
    public static final String PACKAGES_URL_KEY = "yeoman.settings.packages.url";
    public static final String PACKAGES_URL_DEFAULT = "https://storage.googleapis.com/generators.yeoman.io/cache.json";
    public static final String RELATIVE_CLI_HELPER_PATH = "runner/yeoman-simple-cli/lib";
    public static final String CLI_HELPER_NAME = "cli.js";
    @NotNull
    private SettingsState myStoreSettings = new SettingsState();

    @Nullable
    public SettingsState getState() {
        return this.myStoreSettings;
    }

    public void loadState(@NotNull SettingsState state) {
        if (state == null) {
            YeomanGlobalSettings.$$$reportNull$$$0(0);
        }
        this.myStoreSettings = state;
    }

    @NotNull
    public static YeomanGlobalSettings getInstance() {
        YeomanGlobalSettings yeomanGlobalSettings = (YeomanGlobalSettings)ServiceManager.getService(YeomanGlobalSettings.class);
        if (yeomanGlobalSettings == null) {
            YeomanGlobalSettings.$$$reportNull$$$0(1);
        }
        return yeomanGlobalSettings;
    }

    @NotNull
    public String getGeneratorsFileUrl() {
        String string = PropertiesComponent.getInstance().getValue(PACKAGES_URL_KEY, PACKAGES_URL_DEFAULT);
        if (string == null) {
            YeomanGlobalSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getGeneratorsFileDefaultEncoding() {
        if ("UTF-8" == null) {
            YeomanGlobalSettings.$$$reportNull$$$0(3);
        }
        return "UTF-8";
    }

    @Nullable
    public String getNodeInterpreterRefName() {
        if (!StringUtil.isEmpty((String)this.myStoreSettings.nodeExePath)) {
            return this.myStoreSettings.nodeExePath;
        }
        return null;
    }

    @Override
    @Nullable
    public NodeJsLocalInterpreter getInterpreter() {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        return NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)NodeJsInterpreterRef.create((String)this.getNodeInterpreterRefName()).resolve(defaultProject));
    }

    public String getYoPackagePath() {
        if (!StringUtil.isEmpty((String)this.myStoreSettings.yoPackagePath)) {
            return this.myStoreSettings.yoPackagePath;
        }
        return this.getDefaultYoPackagePath();
    }

    public void setNodePath(String path) {
        this.myStoreSettings.nodeExePath = path;
    }

    public void setYoPackage(String path) {
        String normalizedPath = YeomanGlobalSettings.trimAndNotNullize(path);
        this.myStoreSettings.yoPackagePath = !StringUtil.isEmpty((String)normalizedPath) && !StringUtil.equals((CharSequence)normalizedPath, (CharSequence)this.getDefaultYoPackagePath()) ? normalizedPath : null;
    }

    @NotNull
    private static String trimAndNotNullize(String path) {
        String string = StringUtil.notNullize((String)path).trim();
        if (string == null) {
            YeomanGlobalSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private String getDefaultYoPackagePath() {
        String yoPath;
        VirtualFile yo;
        VirtualFile dir;
        NodeJsLocalInterpreter interpreter = this.getInterpreter();
        if (interpreter != null && (dir = interpreter.getGlobalNodeModulesVirtualDir()) != null && (yo = dir.findChild("yo")) != null && yo.exists() && (yoPath = yo.getCanonicalPath()) != null) {
            return FileUtil.toSystemDependentName((String)yoPath);
        }
        return null;
    }

    public String getCLIHelperPath() {
        try {
            String jarPath = PathUtil.getJarPathForClass(YeomanGlobalSettings.class);
            if (!jarPath.endsWith(".jar")) {
                return YeomanGlobalSettings.getCLIHelperPathFromWorkspace();
            }
            return YeomanGlobalSettings.getCLIHelperPathFromJar(jarPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @NotNull
    private static String getCLIHelperPathFromJar(String jarPath) {
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            throw new RuntimeException("jar file cannot be null");
        }
        File pluginBaseDir = jarFile.getParentFile().getParentFile();
        String string = new File(new File(pluginBaseDir, RELATIVE_CLI_HELPER_PATH), CLI_HELPER_NAME).getAbsolutePath();
        if (string == null) {
            YeomanGlobalSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getCLIHelperPathFromWorkspace() throws UnsupportedEncodingException {
        URL resource = YeomanGlobalSettings.class.getClassLoader().getResource(RELATIVE_CLI_HELPER_PATH);
        if (resource == null) {
            throw new RuntimeException("Cannot find file compiler implementation");
        }
        String string = new File(URLDecoder.decode(resource.getPath(), "UTF-8"), CLI_HELPER_NAME).getAbsolutePath();
        if (string == null) {
            YeomanGlobalSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/plugins/yeoman/settings/YeomanGlobalSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/plugins/yeoman/settings/YeomanGlobalSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorsFileUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorsFileDefaultEncoding";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "trimAndNotNullize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCLIHelperPathFromJar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCLIHelperPathFromWorkspace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SettingsState {
        public String yoPackagePath;
        public String nodeExePath;
    }
}

