/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.execution;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintFixInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLinterError
extends JSLinterError
implements JSAnnotationRangeError {
    @Nullable
    private final String myPath;
    private final int myEndLine;
    private final int myEndColumn;
    @Nullable
    private final TsLintFixInfo myFixInfo;
    private final boolean myIsGlobal;

    public TsLinterError(@Nullable String path, int line, int column, int endLine, int endColumn, @NotNull String description, @Nullable String code, boolean isWarning, @Nullable TsLintFixInfo fixInfo) {
        if (description == null) {
            TsLinterError.$$$reportNull$$$0(0);
        }
        super(line, column, description, code, isWarning ? HighlightSeverity.WARNING : HighlightSeverity.ERROR);
        this.myPath = path;
        this.myEndLine = endLine;
        this.myEndColumn = endColumn;
        this.myFixInfo = fixInfo;
        this.myIsGlobal = false;
    }

    public TsLinterError(@NotNull String description) {
        if (description == null) {
            TsLinterError.$$$reportNull$$$0(1);
        }
        super(1, 1, description, null);
        this.myPath = null;
        this.myEndLine = 1;
        this.myEndColumn = 1;
        this.myFixInfo = null;
        this.myIsGlobal = true;
    }

    public int getEndLine() {
        return this.myEndLine;
    }

    public int getEndColumn() {
        return this.myEndColumn;
    }

    @Nullable
    public String getAbsoluteFilePath() {
        return this.myPath;
    }

    public boolean hasFix() {
        return this.myFixInfo != null;
    }

    @Nullable
    public TsLintFixInfo getFixInfo() {
        return this.myFixInfo;
    }

    public boolean isGlobal() {
        return this.myIsGlobal;
    }

    public String toString() {
        return "TsLinterError{myDescription='" + this.myDescription + '\'' + ", myCode='" + this.myCode + '\'' + ", myPath='" + this.myPath + '\'' + ", myEndLine=" + this.myEndLine + ", myEndColumn=" + this.myEndColumn + ", myFixInfo=" + this.myFixInfo + ", myIsGlobal=" + this.myIsGlobal + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/tslint/execution/TsLinterError", "<init>"));
    }
}

