/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.fix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintFixInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TsLintErrorFixAction
extends BaseIntentionAction
implements HighPriorityAction {
    @NotNull
    private final TsLinterError myError;
    private final long myModificationStamp;

    public TsLintErrorFixAction(@NotNull TsLinterError error, @NotNull Document document) {
        if (error == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(0);
        }
        if (document == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(1);
        }
        this.setText(this.getFamilyName());
        this.myError = error;
        this.myModificationStamp = document.getModificationStamp();
    }

    @NotNull
    public String getText() {
        String string = TsLintBundle.message("tslint.action.fix.problems.current.text", new Object[0]);
        if (string == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(4);
        }
        return editor != null && editor.getDocument().getModificationStamp() == this.myModificationStamp && this.myError.getFixInfo() != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(5);
        }
        if (!this.isAvailable(project, editor, file)) {
            return;
        }
        TsLintFixInfo info = this.myError.getFixInfo();
        if (info == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> {
            if (project == null) {
                TsLintErrorFixAction.$$$reportNull$$$0(12);
            }
            Document document = editor.getDocument();
            String separator = FileDocumentManager.getInstance().getLineSeparator(file.getViewProvider().getVirtualFile(), project);
            TsLintFixInfo.TsLintFixReplacements[] replacements = info.innerReplacements;
            if (replacements == null || replacements.length == 0) {
                return;
            }
            Arrays.sort(replacements, Comparator.comparingInt(el -> -el.innerStart));
            if (!this.applyReplacements(document, separator, replacements)) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }, (PsiFile[])new PsiFile[0]);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
    }

    public boolean applyReplacements(@NotNull Document document, @NotNull String separator, @NotNull TsLintFixInfo.TsLintFixReplacements[] replacements) {
        if (document == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(6);
        }
        if (separator == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(7);
        }
        if (replacements == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(8);
        }
        if ("\n".equals(separator)) {
            if (!this.applyFor(document.getTextLength(), replacements, (Consumer<TsLintFixInfo.TsLintFixReplacements>)((Consumer)replacement -> {
                if (document == null) {
                    TsLintErrorFixAction.$$$reportNull$$$0(11);
                }
                document.replaceString(replacement.innerStart, replacement.innerStart + replacement.innerLength, (CharSequence)StringUtil.notNullize((String)replacement.innerText));
            }))) {
                return false;
            }
        } else {
            StringBuilder newContent = new StringBuilder(StringUtilRt.convertLineSeparators((String)document.getText(), (String)separator));
            if (!this.applyFor(newContent.length(), replacements, (Consumer<TsLintFixInfo.TsLintFixReplacements>)((Consumer)replacement -> newContent.replace(replacement.innerStart, replacement.innerStart + replacement.innerLength, StringUtil.notNullize((String)replacement.innerText))))) {
                return false;
            }
            document.setText(StringUtilRt.convertLineSeparators((CharSequence)newContent, (String)"\n"));
        }
        return true;
    }

    public boolean applyFor(int documentLength, @NotNull TsLintFixInfo.TsLintFixReplacements[] replacements, @NotNull Consumer<TsLintFixInfo.TsLintFixReplacements> apply) {
        if (replacements == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(9);
        }
        if (apply == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(10);
        }
        for (TsLintFixInfo.TsLintFixReplacements replacement : replacements) {
            int offset = replacement.innerStart;
            if (offset > documentLength || offset + replacement.innerLength > documentLength) {
                return false;
            }
            apply.consume((Object)replacement);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyReplacements";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyReplacements$2";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

