/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.highlight;

import com.google.gson.JsonElement;
import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TsLintFixInfo {
    @Nullable
    public String innerRuleName;
    public TsLintFixReplacements[] innerReplacements;

    @Nullable
    public static TsLintFixInfo createTsLintFixInfo(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        try {
            if (element.isJsonArray()) {
                List replacements = ContainerUtil.mapNotNull((Iterable)element.getAsJsonArray(), el -> (TsLintFixReplacements)JSLanguageServiceQueue.GSON.fromJson(el, TsLintFixReplacements.class));
                TsLintFixInfo info = new TsLintFixInfo();
                info.innerReplacements = replacements.toArray(new TsLintFixReplacements[0]);
                return info;
            }
            if (element.getAsJsonObject().has("innerReplacements")) {
                return (TsLintFixInfo)JSLanguageServiceQueue.GSON.fromJson(element, TsLintFixInfo.class);
            }
            TsLintFixReplacements replacement = (TsLintFixReplacements)JSLanguageServiceQueue.GSON.fromJson(element, TsLintFixReplacements.class);
            TsLintFixInfo info = new TsLintFixInfo();
            info.innerReplacements = new TsLintFixReplacements[]{replacement};
            return info;
        }
        catch (Exception e) {
            TslintUtil.LOG.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static class TsLintFixReplacements {
        public int innerStart;
        public int innerLength;
        public String innerText;
    }
}

