/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.convertcontentstoattribute;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;

class ConvertContentsToAttributeDialog
extends BaseRefactoringDialog {
    private final JLabel wrappingTagNameLabel = new JLabel();
    private final JTextField wrappingTagNameField;
    private final JCheckBox trimTextBox;
    private final XmlTag tag;

    ConvertContentsToAttributeDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.tag = tag;
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Convert Tag Contents to Attribute");
        this.wrappingTagNameLabel.setText("Name for attribute");
        this.wrappingTagNameField = new JTextField("");
        this.trimTextBox = new JCheckBox("Trim contents");
        this.trimTextBox.setSelected(true);
        Document document = this.wrappingTagNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.ConvertContentsToAttribute";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.wrappingTagNameField;
    }

    public String getAttributeName() {
        String text = this.wrappingTagNameField.getText();
        return text.trim();
    }

    public boolean getTrimContents() {
        return this.trimTextBox.isSelected();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)("Convert contents of tag " + tagName), (boolean)true);
        panel.add((Component)this.wrappingTagNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder((Border)border);
        this.wrappingTagNameField.setEditable(true);
        box.add(this.wrappingTagNameField);
        box.add(this.trimTextBox);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        return XMLUtil.attributeNameIsValid(this.getAttributeName()) && this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String attributeName = this.getAttributeName();
        if (this.getTrimContents()) {
            return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy> \n\t\t<xsl:attribute name = \"" + attributeName + "\">\n\t\t\t<xsl:value-of select=\"normalize-space(.)\"/>\n\t\t</xsl:attribute>\n\t</xsl:copy>\n</xsl:template>";
        }
        return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy> \n\t\t<xsl:attribute name = \"" + attributeName + "\">\n\t\t\t<xsl:value-of select=\".\"/>\n\t\t</xsl:attribute>\n\t</xsl:copy>\n</xsl:template>";
    }

    @Override
    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactoring.convertContentsToAttribute");
    }
}

