/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.angularjs.cli.Blueprint;
import org.angularjs.cli.BlueprintJsonParser;
import org.angularjs.cli.BlueprintParser;
import org.angularjs.cli.BlueprintsExternalizer;
import org.angularjs.cli.BlueprintsLoaderKt;
import org.angularjs.lang.AngularJSLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"(\u0010\u0004\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"DEFAULT_OUTPUT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ourGist", "Lcom/intellij/util/gist/VirtualFileGist;", "", "Lorg/angularjs/cli/Blueprint;", "kotlin.jvm.PlatformType", "doLoad", "project", "Lcom/intellij/openapi/project/Project;", "cli", "Lcom/intellij/openapi/vfs/VirtualFile;", "grabCommandOutput", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "workingDir", "loadBlueprintHelpOutput", "node", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter;", "loadSchematicsInfoJson", "intellij.angularJS"})
public final class BlueprintsLoaderKt {
    private static VirtualFileGist<List<Blueprint>> ourGist = GistManager.getInstance().newVirtualFileGist("AngularBlueprints", 3, (DataExternalizer)new BlueprintsExternalizer(), (VirtualFileGist.GistCalculator)ourGist.1.INSTANCE);
    private static final Logger LOG;
    @NotNull
    public static final String DEFAULT_OUTPUT = "\n\n  Available blueprints:\n    class <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    component <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --inline-template (Boolean) Specifies if the template will be in the ts file.\n        aliases: -it, --inlineTemplate\n      --inline-style (Boolean) Specifies if the style will be in the ts file.\n        aliases: -is, --inlineStyle\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --view-encapsulation (String) Specifies the view encapsulation strategy.\n        aliases: -ve <value>, --viewEncapsulation <value>\n      --change-detection (String) Specifies the change detection strategy.\n        aliases: -cd <value>, --changeDetection <value>\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    directive <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    enum <name> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    guard <name> <options...>\n      --flat (Boolean) Indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n    interface <interface-type> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    module <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --routing (Boolean) (Default: false) Specifies if a routing module file should be generated.\n        aliases: --routing\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    pipe <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the pipe.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    service <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n\nng generate <blueprint> <options...>\n  Generates new code from blueprints.\n  aliases: g\n  --dry-run (Boolean) (Default: false) Run through without making any changes.\n    aliases: -d, --dryRun\n  --verbose (Boolean) (Default: false) Adds more details to output logging.\n    aliases: -v, --verbose\n\n    ";

    private static final List<Blueprint> doLoad(Project project, VirtualFile cli) {
        String blueprintHelpOutput;
        Object object;
        NodeJsInterpreterManager nodeJsInterpreterManager = NodeJsInterpreterManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterManager, (String)"NodeJsInterpreterManager.getInstance(project)");
        NodeJsInterpreter interpreter = nodeJsInterpreterManager.getInterpreter();
        NodeJsLocalInterpreter nodeJsLocalInterpreter = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter);
        if (nodeJsLocalInterpreter == null) {
            return CollectionsKt.emptyList();
        }
        NodeJsLocalInterpreter node = nodeJsLocalInterpreter;
        Collection<Blueprint> parse = CollectionsKt.emptyList();
        NodeJsLocalInterpreter nodeJsLocalInterpreter2 = node;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsLocalInterpreter2, (String)"node");
        String schematicsInfoJson = BlueprintsLoaderKt.loadSchematicsInfoJson(nodeJsLocalInterpreter2, cli);
        CharSequence charSequence = schematicsInfoJson;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((String)schematicsInfoJson, (String)"No schematics", (boolean)false, (int)2, null)) {
            try {
                List<Blueprint> list = BlueprintJsonParser.parse(schematicsInfoJson);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"BlueprintJsonParser.parse(schematicsInfoJson)");
                parse = (Collection<Blueprint>)list;
            }
            catch (Exception e) {
                LOG.error("Failed to parse schematics: " + e.getMessage(), (Throwable)e, new Attachment[]{new Attachment("output", schematicsInfoJson)});
            }
        }
        if (parse.isEmpty() && (object = (CharSequence)(blueprintHelpOutput = BlueprintsLoaderKt.loadBlueprintHelpOutput(node, cli))).length() > 0) {
            try {
                parse = new BlueprintParser().parse(blueprintHelpOutput);
            }
            catch (Exception e) {
                LOG.error("Failed to parse blueprints: " + e.getMessage(), (Throwable)e, new Attachment[]{new Attachment("output", blueprintHelpOutput)});
            }
        }
        if (parse.isEmpty()) {
            parse = new BlueprintParser().parse(DEFAULT_OUTPUT);
        }
        Iterable $receiver$iv = parse;
        object = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                Blueprint it = (Blueprint)a;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Blueprint)b;
                Comparable comparable2 = comparable;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)object, (Comparator)comparator);
    }

    @NotNull
    public static final String loadSchematicsInfoJson(@NotNull NodeJsLocalInterpreter node, @NotNull VirtualFile cli) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)cli, (String)"cli");
        File directory = JSLanguageServiceUtil.getPluginDirectory(AngularJSLanguage.class, (String)"ngCli");
        String utilityExe = directory + File.separator + "runner.js";
        return BlueprintsLoaderKt.grabCommandOutput(new GeneralCommandLine(new String[]{node.getInterpreterSystemDependentPath(), utilityExe, cli.getPath(), "./schematicsInfoProvider.js"}), cli.getPath());
    }

    @NotNull
    public static final String loadBlueprintHelpOutput(@NotNull NodeJsLocalInterpreter node, @NotNull VirtualFile cli) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)cli, (String)"cli");
        List modules = new ArrayList();
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)"@angular/cli", (VirtualFile)cli, (boolean)false, (NodeJsInterpreter)((NodeJsInterpreter)node));
        CompletionModuleInfo completionModuleInfo = (CompletionModuleInfo)CollectionsKt.firstOrNull((List)modules);
        if (completionModuleInfo == null) {
            return "";
        }
        CompletionModuleInfo module = completionModuleInfo;
        StringBuilder stringBuilder = new StringBuilder();
        VirtualFile virtualFile = module.getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"module.virtualFile!!");
        String moduleExe = stringBuilder.append(virtualFile.getPath()).append(File.separator).append("bin").append(File.separator).append("ng").toString();
        return BlueprintsLoaderKt.grabCommandOutput(new GeneralCommandLine(new String[]{node.getInterpreterSystemDependentPath(), moduleExe, "help", "generate"}), cli.getPath());
    }

    @NotNull
    public static final String grabCommandOutput(@NotNull GeneralCommandLine commandLine, @Nullable String workingDir) {
        ProcessOutput output;
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProcessOutput processOutput = output = handler.runProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"output");
        if (processOutput.getExitCode() == 0) {
            String string = output.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stderr");
            CharSequence charSequence = string;
            String string2 = charSequence;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (charSequence.length() > 0) {
                LOG.error("Error while loading schematics info.", new Attachment[]{new Attachment("err-output", output.getStderr())});
            }
            String string3 = output.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"output.stdout");
            return string3;
        }
        LOG.error("Failed to load schematics info.", new Attachment[]{new Attachment("err-output", output.getStderr()), new Attachment("std-output", output.getStdout())});
        return "";
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.angularjs.cli.BlueprintsLoader");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#org\u2026js.cli.BlueprintsLoader\")");
        LOG = logger;
    }

    @NotNull
    public static final /* synthetic */ VirtualFileGist access$getOurGist$p() {
        return ourGist;
    }

    public static final /* synthetic */ void access$setOurGist$p(@NotNull VirtualFileGist virtualFileGist) {
        ourGist = virtualFileGist;
    }

    @NotNull
    public static final /* synthetic */ List access$doLoad(@NotNull Project project, @NotNull VirtualFile cli) {
        return BlueprintsLoaderKt.doLoad(project, cli);
    }
}

