/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlEmbeddedContentImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Consumer;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.lang.parser.AngularJSElementTypes;
import org.angularjs.lang.psi.AngularJSRecursiveVisitor;
import org.angularjs.lang.psi.AngularJSRepeatExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AngularJSProcessor {
    private static final Map<String, String> NG_REPEAT_IMPLICITS = new HashMap<String, String>();
    private static volatile Map<String, String> TAG_TO_CLASS;
    public static final String $EVENT = "$event";

    public static void process(PsiElement element, Consumer<JSPsiElementBase> consumer) {
        PsiElement original = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        PsiFile hostFile = FileContextUtil.getContextFile((PsiElement)(original != element ? original : element.getContainingFile().getOriginalFile()));
        if (!(hostFile instanceof XmlFile)) {
            hostFile = original.getContainingFile();
        }
        if (!(hostFile instanceof XmlFile)) {
            return;
        }
        XmlFile file = (XmlFile)hostFile;
        Collection cache = (Collection)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            ArrayList<JSPsiElementBase> result = new ArrayList<JSPsiElementBase>();
            AngularJSProcessor.processDocument(file.getDocument(), result);
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        for (JSPsiElementBase namedElement : cache) {
            if (!AngularJSProcessor.scopeMatches(original, (PsiElement)namedElement)) continue;
            consumer.consume((Object)namedElement);
        }
    }

    private static void processDocument(XmlDocument document, final Collection<JSPsiElementBase> result) {
        if (document == null) {
            return;
        }
        final AngularInjectedFilesVisitor visitor = new AngularInjectedFilesVisitor(result);
        for (XmlTag tag : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)document, XmlTag.class)) {
            new XmlBackedJSClassImpl.InjectedScriptsVisitor(tag, null, true, true, (XmlBackedJSClass.InjectedFileVisitor)visitor, true){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof HtmlEmbeddedContentImpl) {
                        AngularJSProcessor.processDocument((XmlDocument)PsiTreeUtil.findChildOfType((PsiElement)element, XmlDocument.class), result);
                    }
                    if (element instanceof XmlAttribute) {
                        visitor.accept(element);
                    }
                    return super.execute(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/AngularJSProcessor$1", "execute"));
                }
            }.go();
        }
    }

    private static boolean scopeMatches(PsiElement element, PsiElement declaration) {
        InjectedLanguageManager injector = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (declaration instanceof JSImplicitElement) {
            if ($EVENT.equals(((JSImplicitElement)declaration).getName())) {
                return AngularJSProcessor.eventScopeMatches(injector, element, declaration.getParent());
            }
            if (declaration.getParent() instanceof XmlAttribute && AngularAttributesRegistry.isTagReferenceAttribute(((XmlAttribute)declaration.getParent()).getName(), declaration.getProject())) {
                return true;
            }
            declaration = declaration.getParent();
        }
        boolean angular2 = AngularIndexUtil.hasAngularJS2(element.getContainingFile().getProject());
        PsiLanguageInjectionHost elementContainer = injector.getInjectionHost(element);
        XmlTagChild elementTag = (XmlTagChild)PsiTreeUtil.getNonStrictParentOfType((PsiElement)(angular2 ? element : elementContainer), (Class[])new Class[]{XmlTag.class, XmlText.class});
        PsiLanguageInjectionHost declarationContainer = injector.getInjectionHost(declaration);
        XmlTagChild declarationTag = (XmlTagChild)PsiTreeUtil.getNonStrictParentOfType((PsiElement)(angular2 ? declaration : declarationContainer), (Class[])new Class[]{XmlTag.class});
        if (declarationContainer != null && elementContainer != null && elementTag != null && declarationTag != null) {
            return PsiTreeUtil.isAncestor((PsiElement)declarationTag, (PsiElement)elementTag, (boolean)true) || angular2 && PsiTreeUtil.isAncestor((PsiElement)declarationTag, (PsiElement)elementTag, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)declarationTag, (PsiElement)elementTag, (boolean)false) && declarationContainer.getTextOffset() < elementContainer.getTextOffset() || AngularJSProcessor.isInRepeatStartEnd(declarationTag, declarationContainer, elementContainer);
        }
        return true;
    }

    private static boolean isInRepeatStartEnd(XmlTagChild declarationTag, PsiLanguageInjectionHost declarationContainer, PsiLanguageInjectionHost elementContainer) {
        PsiElement parent = declarationContainer.getParent();
        if (parent instanceof XmlAttribute && "ng-repeat-start".equals(((XmlAttribute)parent).getName())) {
            for (XmlTagChild next = declarationTag.getNextSiblingInTag(); next != null; next = next.getNextSiblingInTag()) {
                if (PsiTreeUtil.isAncestor((PsiElement)next, (PsiElement)elementContainer, (boolean)true)) {
                    return true;
                }
                if (next instanceof XmlTag && ((XmlTag)next).getAttribute("ng-repeat-end") != null) break;
            }
        }
        return false;
    }

    private static boolean eventScopeMatches(InjectedLanguageManager injector, PsiElement element, PsiElement parent) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{XmlAttribute.class});
        if (attribute == null) {
            PsiLanguageInjectionHost elementContainer = injector.getInjectionHost(element);
            attribute = (XmlAttribute)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementContainer, (Class[])new Class[]{XmlAttribute.class});
        }
        return attribute != null && CompletionUtil.getOriginalOrSelf((PsiElement)attribute) == CompletionUtil.getOriginalOrSelf((PsiElement)parent);
    }

    public static JSImplicitElementImpl.Builder createTagReference(HtmlTag tag, XmlAttribute attribute, String name) {
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(name.substring(1), (PsiElement)attribute).setType(JSImplicitElement.Type.Variable);
        String tagName = tag.getName();
        if (HtmlDescriptorsTable.getTagDescriptor((String)tagName) != null) {
            elementBuilder.setTypeString(AngularJSProcessor.getHtmlElementClass(tag.getProject(), tagName));
        }
        return elementBuilder;
    }

    @NotNull
    @NonNls
    private static String getHtmlElementClass(@NotNull Project project, @NotNull @NonNls String tagName) {
        if (project == null) {
            AngularJSProcessor.$$$reportNull$$$0(0);
        }
        if (tagName == null) {
            AngularJSProcessor.$$$reportNull$$$0(1);
        }
        if (TAG_TO_CLASS == null) {
            AngularJSProcessor.initTagToClassMap(project);
        }
        String string = TAG_TO_CLASS.getOrDefault(tagName.toLowerCase(), "HTMLElement");
        if (string == null) {
            AngularJSProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static synchronized void initTagToClassMap(@NotNull Project project) {
        if (project == null) {
            AngularJSProcessor.$$$reportNull$$$0(3);
        }
        if (TAG_TO_CLASS != null) {
            return;
        }
        HashMap<String, String> tagToClass = new HashMap<String, String>();
        Collection libs = JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().stream().filter(lib -> "lib.dom.d.ts".equals(lib.getName())).collect(Collectors.toList());
        List elements = TypeScriptClassResolver.getInstance().findClassesByQName("HTMLElementTagNameMap", GlobalSearchScope.filesScope((Project)project, (Collection)libs));
        for (JSQualifiedNamedElement el : elements) {
            TypeScriptInterface intf;
            if (!(el instanceof TypeScriptInterface) || (intf = (TypeScriptInterface)el).getBody() == null) continue;
            for (TypeScriptTypeMember member : intf.getBody().getTypeMembers()) {
                TypeScriptPropertySignature sig;
                JSTypeDeclaration decl;
                if (!(member instanceof TypeScriptPropertySignature) || !((decl = (sig = (TypeScriptPropertySignature)member).getTypeDeclaration()) instanceof TypeScriptSingleType)) continue;
                String tagName = sig.getMemberName();
                String className = ((TypeScriptSingleType)decl).getQualifiedTypeName();
                if (className == null || !className.startsWith("HTML") || !className.endsWith("Element")) continue;
                tagToClass.put(tagName.toLowerCase(), className);
            }
        }
        TAG_TO_CLASS = tagToClass;
    }

    static {
        NG_REPEAT_IMPLICITS.put("$index", "Number");
        NG_REPEAT_IMPLICITS.put("$first", "Boolean");
        NG_REPEAT_IMPLICITS.put("$middle", "Boolean");
        NG_REPEAT_IMPLICITS.put("$last", "Boolean");
        NG_REPEAT_IMPLICITS.put("$even", "Boolean");
        NG_REPEAT_IMPLICITS.put("$odd", "Boolean");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/codeInsight/AngularJSProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/codeInsight/AngularJSProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlElementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlElementClass";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initTagToClassMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AngularInjectedFilesVisitor
    extends JSResolveUtil.JSInjectedFilesVisitor {
        private final Collection<JSPsiElementBase> myResult;

        public AngularInjectedFilesVisitor(Collection<JSPsiElementBase> result) {
            this.myResult = result;
        }

        protected void process(JSFile file) {
            this.accept((PsiElement)file);
        }

        protected void accept(PsiElement element) {
            element.accept((PsiElementVisitor)new AngularJSRecursiveVisitor(){

                public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                    myResult.add(node);
                    super.visitJSDefinitionExpression(node);
                }

                public void visitJSVariable(JSVariable node) {
                    myResult.add(node);
                    super.visitJSVariable(node);
                }

                @Override
                public void visitAngularJSRepeatExpression(AngularJSRepeatExpression repeatExpression) {
                    if (repeatExpression.getNode().getElementType() == AngularJSElementTypes.REPEAT_EXPRESSION) {
                        for (Map.Entry entry : NG_REPEAT_IMPLICITS.entrySet()) {
                            myResult.add(new JSLocalImplicitElementImpl((String)entry.getKey(), (String)entry.getValue(), (PsiElement)repeatExpression));
                        }
                    }
                    super.visitAngularJSRepeatExpression(repeatExpression);
                }
            });
            if (element instanceof XmlAttribute) {
                JSImplicitElementImpl.Builder builder;
                String name = ((XmlAttribute)element).getName();
                if (AngularAttributesRegistry.isTagReferenceAttribute(name, element.getProject())) {
                    builder = AngularJSProcessor.createTagReference((HtmlTag)element.getParent(), (XmlAttribute)element, name);
                    this.myResult.add((JSPsiElementBase)builder.toImplicitElement());
                }
                if (AngularAttributesRegistry.isVariableAttribute(name, element.getProject())) {
                    builder = new JSImplicitElementImpl.Builder(name.substring(4), element).setType(JSImplicitElement.Type.Variable);
                    this.myResult.add((JSPsiElementBase)builder.toImplicitElement());
                }
                if (AngularAttributesRegistry.isEventAttribute(name, element.getProject())) {
                    builder = new JSImplicitElementImpl.Builder(AngularJSProcessor.$EVENT, element).setType(JSImplicitElement.Type.Variable);
                    this.myResult.add((JSPsiElementBase)builder.toImplicitElement());
                }
            }
        }
    }
}

