/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.Collections;
import java.util.List;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributeDescriptor;
import org.angularjs.codeInsight.attributes.AngularJSAttributeDescriptorsProvider;
import org.angularjs.index.AngularControllerIndex;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularModuleIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularAttributesRegistry {
    private static final List<String> CUSTOM_NG_ATTRS = Collections.singletonList("i18n");

    @NotNull
    static AngularAttributeDescriptor createDescriptor(@Nullable Project project, @NotNull String directiveName, @Nullable PsiElement declaration) {
        if (directiveName == null) {
            AngularAttributesRegistry.$$$reportNull$$$0(0);
        }
        if ("ng-controller".equals(directiveName)) {
            AngularAttributeDescriptor angularAttributeDescriptor = new AngularAttributeDescriptor(project, directiveName, AngularControllerIndex.KEY, declaration);
            if (angularAttributeDescriptor == null) {
                AngularAttributesRegistry.$$$reportNull$$$0(1);
            }
            return angularAttributeDescriptor;
        }
        if ("ng-app".equals(directiveName)) {
            AngularAttributeDescriptor angularAttributeDescriptor = new AngularAttributeDescriptor(project, directiveName, AngularModuleIndex.KEY, declaration);
            if (angularAttributeDescriptor == null) {
                AngularAttributesRegistry.$$$reportNull$$$0(2);
            }
            return angularAttributeDescriptor;
        }
        AngularAttributeDescriptor angularAttributeDescriptor = new AngularAttributeDescriptor(project, directiveName, null, declaration);
        if (angularAttributeDescriptor == null) {
            AngularAttributesRegistry.$$$reportNull$$$0(3);
        }
        return angularAttributeDescriptor;
    }

    public static boolean isAngularExpressionAttribute(XmlAttribute parent) {
        String type = AngularAttributesRegistry.getType(parent);
        return type.endsWith("expression") || type.startsWith("string");
    }

    public static boolean isJSONAttribute(XmlAttribute parent) {
        String value = parent.getValue();
        if (value == null || !value.startsWith("{")) {
            return false;
        }
        String type = AngularAttributesRegistry.getType(parent);
        return type.contains("object literal") || type.equals("mixed");
    }

    @NotNull
    private static String getType(XmlAttribute parent) {
        PsiElement directive;
        String attributeName = DirectiveUtil.normalizeAttributeName(parent.getName());
        XmlAttributeDescriptor descriptor = AngularJSAttributeDescriptorsProvider.getDescriptor(attributeName, parent.getParent());
        PsiElement psiElement = directive = descriptor != null ? descriptor.getDeclaration() : null;
        if (directive instanceof JSImplicitElement) {
            String restrict = ((JSImplicitElement)directive).getTypeString();
            String[] args = restrict != null ? restrict.split(";", -1) : null;
            String string = args != null && args.length > 2 ? args[2] : "";
            if (string == null) {
                AngularAttributesRegistry.$$$reportNull$$$0(4);
            }
            return string;
        }
        if ("" == null) {
            AngularAttributesRegistry.$$$reportNull$$$0(5);
        }
        return "";
    }

    @NotNull
    public static List<String> getCustomAngularAttributes() {
        List<String> list = CUSTOM_NG_ATTRS;
        if (list == null) {
            AngularAttributesRegistry.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static boolean isEventAttribute(String name, Project project) {
        return name.startsWith("(") && name.endsWith(")") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isTagReferenceAttribute(String name, Project project) {
        return name.startsWith("#") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isVariableAttribute(String name, Project project) {
        return name.startsWith("let-") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isTemplateAttribute(String name, Project project) {
        return name.startsWith("*") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isBindingAttribute(String name, Project project) {
        return name.startsWith("[") && name.endsWith("]") && AngularIndexUtil.hasAngularJS2(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/codeInsight/attributes/AngularAttributesRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/codeInsight/attributes/AngularAttributesRegistry";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomAngularAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

