/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributeDescriptor;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.codeInsight.attributes.AngularBindingDescriptor;
import org.angularjs.codeInsight.attributes.AngularEventHandlerDescriptor;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag xmlTag) {
        if (xmlTag != null) {
            Project project = xmlTag.getProject();
            boolean hasAngularJS2 = AngularIndexUtil.hasAngularJS2(project);
            if (!AngularIndexUtil.hasAngularJS(xmlTag.getProject())) {
                return XmlAttributeDescriptor.EMPTY;
            }
            LinkedHashMap<String, XmlAttributeDescriptor> result = new LinkedHashMap<String, XmlAttributeDescriptor>();
            XmlElementDescriptor descriptor = xmlTag.getDescriptor();
            Collection<String> directives = AngularIndexUtil.getAllKeys(AngularDirectivesIndex.KEY, project);
            if (hasAngularJS2) {
                if (descriptor instanceof HtmlElementDescriptorImpl) {
                    XmlAttribute[] descriptors;
                    XmlAttribute[] xmlAttributeArray = descriptors = ((HtmlElementDescriptorImpl)descriptor).getDefaultAttributeDescriptors(xmlTag);
                    int n = xmlAttributeArray.length;
                    for (int i = 0; i < n; ++i) {
                        XmlAttribute attributeDescriptor = xmlAttributeArray[i];
                        String name = attributeDescriptor.getName();
                        if (name.startsWith("on")) {
                            this.addAttributes(project, result, "(" + name.substring(2) + ")", attributeDescriptor.getDeclaration());
                            continue;
                        }
                        this.addAttributes(project, result, "[" + name + "]", attributeDescriptor.getDeclaration());
                    }
                }
                for (XmlAttribute attribute : xmlTag.getAttributes()) {
                    PsiElement declaration;
                    String name = attribute.getName();
                    if (AngularJSAttributeDescriptorsProvider.isAngular2Attribute(name, project) || !directives.contains(name) || !AngularJSAttributeDescriptorsProvider.isApplicable(declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, name, xmlTag, AngularDirectivesIndex.KEY))) continue;
                    for (XmlAttributeDescriptor binding : AngularAttributeDescriptor.getFieldBasedDescriptors((JSImplicitElement)declaration)) {
                        result.put(binding.getName(), binding);
                    }
                }
                AngularAttributesRegistry.getCustomAngularAttributes().forEach(attr -> this.addAttributes(project, (Map<String, XmlAttributeDescriptor>)result, (String)attr, null));
            }
            Collection<String> docDirectives = AngularIndexUtil.getAllKeys(AngularDirectivesDocIndex.KEY, project);
            for (String directiveName : docDirectives) {
                PsiElement declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, directiveName, xmlTag, AngularDirectivesDocIndex.KEY);
                if (!AngularJSAttributeDescriptorsProvider.isApplicable(declaration)) continue;
                this.addAttributes(project, result, directiveName, declaration);
            }
            for (String directiveName : directives) {
                PsiElement declaration;
                if (docDirectives.contains(directiveName) || !AngularJSAttributeDescriptorsProvider.isApplicable(declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, directiveName, xmlTag, AngularDirectivesIndex.KEY))) continue;
                this.addAttributes(project, result, directiveName, declaration);
            }
            return result.values().toArray(XmlAttributeDescriptor.EMPTY);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    protected void addAttributes(Project project, Map<String, XmlAttributeDescriptor> result, String directiveName, PsiElement declaration) {
        result.put(directiveName, (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, directiveName, declaration));
        if ("ng-repeat".equals(directiveName)) {
            result.put(directiveName + "-start", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, directiveName + "-start", declaration));
            result.put(directiveName + "-end", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, directiveName + "-end", declaration));
        }
    }

    private static PsiElement applicableDirective(Project project, String directiveName, XmlTag tag, StubIndexKey<String, JSImplicitElementProvider> index) {
        Ref result = Ref.create((Object)PsiUtilCore.NULL_PSI_ELEMENT);
        AngularIndexUtil.multiResolve(project, index, directiveName, (Processor<JSImplicitElement>)((Processor)directive -> {
            ThreeState applicable = AngularJSAttributeDescriptorsProvider.isApplicable(project, tag, directive);
            if (applicable == ThreeState.YES) {
                result.set(directive);
            }
            if (applicable == ThreeState.NO && result.get() == PsiUtilCore.NULL_PSI_ELEMENT) {
                result.set(null);
            }
            return !result.isNull();
        }));
        return (PsiElement)result.get();
    }

    @NotNull
    private static ThreeState isApplicable(Project project, XmlTag tag, JSImplicitElement directive) {
        if (directive == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(0);
            }
            return threeState;
        }
        String restrictions = directive.getTypeString();
        if (restrictions != null) {
            String[] split = restrictions.split(";", -1);
            String restrict = AngularIndexUtil.convertRestrictions(project, split[0]);
            String requiredTag = split[1];
            if (!StringUtil.isEmpty((String)restrict) && !StringUtil.containsIgnoreCase((String)restrict, (String)"A")) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(1);
                }
                return threeState;
            }
            if (!AngularJSAttributeDescriptorsProvider.tagMatches(tag, requiredTag)) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(2);
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(3);
        }
        return threeState;
    }

    private static boolean tagMatches(XmlTag tag, String requiredTag) {
        if (StringUtil.isEmpty((String)requiredTag) || StringUtil.equalsIgnoreCase((CharSequence)requiredTag, (CharSequence)"ANY")) {
            return true;
        }
        for (String s : requiredTag.split(",")) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)tag.getName(), (CharSequence)s.trim())) continue;
            return true;
        }
        if ("input".equalsIgnoreCase(requiredTag)) {
            XmlTag parent = tag;
            while (parent != null && !(parent instanceof PsiFile)) {
                if (!((parent = parent.getParent()) instanceof XmlTag) || !AngularJSAttributeDescriptorsProvider.isForm(parent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isForm(XmlTag parent) {
        String name = parent.getName();
        return "form".equalsIgnoreCase(name) || "ng-form".equalsIgnoreCase(name);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attrName, XmlTag xmlTag) {
        return AngularJSAttributeDescriptorsProvider.getDescriptor(attrName, xmlTag);
    }

    static XmlAttributeDescriptor getDescriptor(String attrName, XmlTag xmlTag) {
        if (xmlTag != null) {
            String attributeName;
            Project project = xmlTag.getProject();
            PsiElement declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, attributeName = DirectiveUtil.normalizeAttributeName(attrName), xmlTag, AngularDirectivesDocIndex.KEY);
            if (declaration == PsiUtilCore.NULL_PSI_ELEMENT) {
                declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, attributeName, xmlTag, AngularDirectivesIndex.KEY);
            }
            if (AngularJSAttributeDescriptorsProvider.isApplicable(declaration)) {
                return AngularAttributesRegistry.createDescriptor(project, attributeName, declaration);
            }
            if (!AngularIndexUtil.hasAngularJS2(project)) {
                return null;
            }
            for (XmlAttribute attribute : xmlTag.getAttributes()) {
                String name = attribute.getName();
                if (AngularJSAttributeDescriptorsProvider.isAngular2Attribute(name, project) || name.equals(attrName) || !AngularJSAttributeDescriptorsProvider.isApplicable(declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, name, xmlTag, AngularDirectivesIndex.KEY))) continue;
                for (XmlAttributeDescriptor binding : AngularAttributeDescriptor.getFieldBasedDescriptors((JSImplicitElement)declaration)) {
                    if (!binding.getName().equals(attrName)) continue;
                    return binding;
                }
            }
            XmlElementDescriptor descriptor = xmlTag.getDescriptor();
            if (descriptor instanceof HtmlElementDescriptorImpl) {
                XmlAttributeDescriptor[] descriptors;
                for (XmlAttributeDescriptor attributeDescriptor : descriptors = ((HtmlElementDescriptorImpl)descriptor).getDefaultAttributeDescriptors(xmlTag)) {
                    String name = attributeDescriptor.getName();
                    if (name.startsWith("on") && attrName.equals("(" + name.substring(2) + ")")) {
                        return new AngularBindingDescriptor(attributeDescriptor.getDeclaration(), attrName);
                    }
                    if (!attrName.equals("[" + name + "]")) continue;
                    return new AngularEventHandlerDescriptor(attributeDescriptor.getDeclaration(), attrName);
                }
            }
            if (AngularAttributesRegistry.isBindingAttribute(attrName, project)) {
                return new AngularBindingDescriptor((PsiElement)xmlTag, attrName);
            }
            if (AngularAttributesRegistry.isEventAttribute(attrName, project)) {
                return new AngularEventHandlerDescriptor((PsiElement)xmlTag, attrName);
            }
            return AngularJSAttributeDescriptorsProvider.getAngular2Descriptor(attrName, project);
        }
        return null;
    }

    private static boolean isApplicable(PsiElement declaration) {
        return declaration != null && declaration != PsiUtilCore.NULL_PSI_ELEMENT;
    }

    @Nullable
    public static AngularAttributeDescriptor getAngular2Descriptor(String attrName, Project project) {
        if (AngularJSAttributeDescriptorsProvider.isAngular2Attribute(attrName, project)) {
            return AngularAttributesRegistry.createDescriptor(project, attrName, null);
        }
        return null;
    }

    protected static boolean isAngular2Attribute(String attrName, Project project) {
        return AngularAttributesRegistry.isEventAttribute(attrName, project) || AngularAttributesRegistry.isBindingAttribute(attrName, project) || AngularAttributesRegistry.isVariableAttribute(attrName, project) || AngularAttributesRegistry.isTagReferenceAttribute(attrName, project) || AngularAttributesRegistry.getCustomAngularAttributes().contains(attrName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/attributes/AngularJSAttributeDescriptorsProvider", "isApplicable"));
    }
}

