/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.codeInsight.PackageJsonMismatchedDependencyInspection;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.angularjs.cli.AngularCliSchematicsRegistryService;
import org.angularjs.cli.AngularCliUtil;
import org.angularjs.cli.actions.AngularCliAddDependencyAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AngularCliAddDependencyInspection
extends LocalInspectionTool {
    private static final long TIMEOUT = 2000L;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(0);
        }
        JsonElementVisitor jsonElementVisitor = new JsonElementVisitor(){

            public void visitFile(PsiFile file) {
                if (PackageJsonUtil.isPackageJsonFile((PsiFile)file) && AngularCliUtil.findCliJson(file.getVirtualFile().getParent()) != null) {
                    AngularCliAddDependencyInspection.annotate((JsonFile)file, holder);
                }
            }
        };
        if (jsonElementVisitor == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(1);
        }
        return jsonElementVisitor;
    }

    private static void annotate(@NotNull JsonFile file, @NotNull ProblemsHolder holder) {
        VirtualFile packageJson;
        if (file == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(3);
        }
        if ((packageJson = file.getVirtualFile()) == null) {
            return;
        }
        Project project = file.getProject();
        VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(packageJson, false);
        if (contentRoot != null && NodeModuleUtil.hasNodeModulesDirInPath((VirtualFile)packageJson, (VirtualFile)contentRoot)) {
            return;
        }
        List properties = PackageJsonMismatchedDependencyInspection.getDependencies((JsonFile)file);
        if (properties.isEmpty()) {
            return;
        }
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(project, packageJson);
        for (JsonProperty property : properties) {
            JsonStringLiteral nameLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getNameElement(), JsonStringLiteral.class);
            JsonStringLiteral versionLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
            if (nameLiteral == null) continue;
            String packageName = property.getName();
            String version = versionLiteral == null ? "" : versionLiteral.getValue();
            InstalledPackageVersion pkgVersion = finder.findInstalledPackage(packageName);
            if ((pkgVersion == null || !AngularCliSchematicsRegistryService.getInstance().supportsNgAdd(pkgVersion)) && (pkgVersion != null || !AngularCliSchematicsRegistryService.getInstance().supportsNgAdd(packageName, 2000L))) continue;
            String message = StringUtil.wrapWithDoubleQuote((String)packageName) + " can be installed using 'ng add' command";
            AngularCliAddQuickFix quickFix = new AngularCliAddQuickFix(packageJson, packageName, version, pkgVersion != null);
            if (versionLiteral != null) {
                if (pkgVersion == null) {
                    holder.registerProblem((PsiElement)versionLiteral, AngularCliAddDependencyInspection.getTextRange((JsonValue)versionLiteral), message, new LocalQuickFix[]{quickFix});
                } else if (holder.isOnTheFly()) {
                    holder.registerProblem((PsiElement)versionLiteral, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{quickFix});
                }
            }
            if (!holder.isOnTheFly()) continue;
            holder.registerProblem((PsiElement)nameLiteral, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{quickFix});
        }
    }

    @NotNull
    private static TextRange getTextRange(@NotNull JsonValue element) {
        if (element == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(4);
        }
        TextRange range = element.getTextRange();
        if (element instanceof JsonStringLiteral && range.getLength() > 2 && StringUtil.isQuotedString((String)element.getText())) {
            TextRange textRange = new TextRange(1, range.getLength() - 1);
            if (textRange == null) {
                AngularCliAddDependencyInspection.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        TextRange textRange = TextRange.create((int)0, (int)range.getLength());
        if (textRange == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/inspections/AngularCliAddDependencyInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/inspections/AngularCliAddDependencyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AngularCliAddQuickFix
    implements LocalQuickFix,
    HighPriorityAction {
        private final VirtualFile myPackageJson;
        private final String myPackageName;
        private final String myVersionSpec;
        private final boolean myReinstall;

        public AngularCliAddQuickFix(@NotNull VirtualFile packageJson, @NotNull String packageName, @NotNull String versionSpec, boolean reinstall) {
            if (packageJson == null) {
                AngularCliAddQuickFix.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                AngularCliAddQuickFix.$$$reportNull$$$0(1);
            }
            if (versionSpec == null) {
                AngularCliAddQuickFix.$$$reportNull$$$0(2);
            }
            this.myPackageJson = packageJson;
            this.myPackageName = packageName;
            this.myVersionSpec = versionSpec;
            this.myReinstall = reinstall;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = (this.myReinstall ? "Reinstall with" : "Run") + " 'ng add " + this.myPackageName + "'";
            if (string == null) {
                AngularCliAddQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Run 'ng add'" == null) {
                AngularCliAddQuickFix.$$$reportNull$$$0(4);
            }
            return "Run 'ng add'";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AngularCliAddQuickFix.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                AngularCliAddQuickFix.$$$reportNull$$$0(6);
            }
            if (AngularCliUtil.hasAngularCLIPackageInstalled(project, this.myPackageJson)) {
                AngularCliAddDependencyAction.runAndShowConsoleLater(project, this.myPackageJson.getParent(), this.myPackageName, this.myVersionSpec.trim(), !this.myReinstall);
            } else {
                AngularCliUtil.notifyAngularCliNotInstalled(project, this.myPackageJson.getParent(), "Can't run 'ng add'");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionSpec";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/angularjs/inspections/AngularCliAddDependencyInspection$AngularCliAddQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/angularjs/inspections/AngularCliAddDependencyInspection$AngularCliAddQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

