/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.build.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.build.webapi.model.AgentPoolQueue;
import com.microsoft.alm.build.webapi.model.Build;
import com.microsoft.alm.build.webapi.model.BuildArtifact;
import com.microsoft.alm.build.webapi.model.BuildController;
import com.microsoft.alm.build.webapi.model.BuildDefinition;
import com.microsoft.alm.build.webapi.model.BuildDefinitionRevision;
import com.microsoft.alm.build.webapi.model.BuildDefinitionTemplate;
import com.microsoft.alm.build.webapi.model.BuildLog;
import com.microsoft.alm.build.webapi.model.BuildOptionDefinition;
import com.microsoft.alm.build.webapi.model.BuildQueryOrder;
import com.microsoft.alm.build.webapi.model.BuildReason;
import com.microsoft.alm.build.webapi.model.BuildResourceUsage;
import com.microsoft.alm.build.webapi.model.BuildResult;
import com.microsoft.alm.build.webapi.model.BuildSettings;
import com.microsoft.alm.build.webapi.model.BuildStatus;
import com.microsoft.alm.build.webapi.model.Change;
import com.microsoft.alm.build.webapi.model.DefinitionReference;
import com.microsoft.alm.build.webapi.model.DefinitionType;
import com.microsoft.alm.build.webapi.model.Deployment;
import com.microsoft.alm.build.webapi.model.QueryDeletedOption;
import com.microsoft.alm.build.webapi.model.Timeline;
import com.microsoft.alm.client.AlmHttpClientBase;
import com.microsoft.alm.client.model.ApiResourceVersion;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.visualstudio.services.webapi.model.ResourceRef;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Invocation;

public abstract class BuildHttpClientBase
extends AlmHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected BuildHttpClientBase(Object jaxrsClient, URI baseUrl) {
        super(jaxrsClient, baseUrl);
    }

    protected BuildHttpClientBase(Object tfsConnection) {
        super(tfsConnection);
    }

    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public BuildArtifact createArtifact(BuildArtifact artifact, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)artifact, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (BuildArtifact)super.sendRequest((Object)httpRequest, BuildArtifact.class);
    }

    public BuildArtifact createArtifact(BuildArtifact artifact, String project, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)artifact, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (BuildArtifact)super.sendRequest((Object)httpRequest, BuildArtifact.class);
    }

    public BuildArtifact createArtifact(BuildArtifact artifact, UUID project, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)artifact, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (BuildArtifact)super.sendRequest((Object)httpRequest, BuildArtifact.class);
    }

    public BuildArtifact getArtifact(String project, int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (BuildArtifact)super.sendRequest((Object)httpRequest, BuildArtifact.class);
    }

    public BuildArtifact getArtifact(UUID project, int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (BuildArtifact)super.sendRequest((Object)httpRequest, BuildArtifact.class);
    }

    public BuildArtifact getArtifact(int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (BuildArtifact)super.sendRequest((Object)httpRequest, BuildArtifact.class);
    }

    public InputStream getArtifactContentZip(String project, int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getArtifactContentZip(UUID project, int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getArtifactContentZip(int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<BuildArtifact> getArtifacts(int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildArtifact>>(){});
    }

    public List<BuildArtifact> getArtifacts(String project, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildArtifact>>(){});
    }

    public List<BuildArtifact> getArtifacts(UUID project, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildArtifact>>(){});
    }

    public String getBadge(UUID project, int definitionId, String branchName) {
        UUID locationId = UUID.fromString("de6a4df8-22cd-44ee-af2d-39f6aa7a4261");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("definitionId", Integer.valueOf(definitionId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("branchName", branchName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (String)super.sendRequest((Object)httpRequest, String.class);
    }

    public void deleteBuild(int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteBuild(String project, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteBuild(UUID project, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public Build getBuild(String project, int buildId, String propertyFilters) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("propertyFilters", propertyFilters);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (Build)super.sendRequest((Object)httpRequest, Build.class);
    }

    public Build getBuild(UUID project, int buildId, String propertyFilters) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("propertyFilters", propertyFilters);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (Build)super.sendRequest((Object)httpRequest, Build.class);
    }

    public Build getBuild(int buildId, String propertyFilters) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("propertyFilters", propertyFilters);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (Build)super.sendRequest((Object)httpRequest, Build.class);
    }

    public List<Build> getBuilds(String project, List<Integer> definitions, List<Integer> queues, String buildNumber, Date minFinishTime, Date maxFinishTime, String requestedFor, BuildReason reasonFilter, BuildStatus statusFilter, BuildResult resultFilter, List<String> tagFilters, List<String> properties, DefinitionType type, Integer top, String continuationToken, Integer maxBuildsPerDefinition, QueryDeletedOption deletedFilter, BuildQueryOrder queryOrder) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitions", definitions);
        queryParameters.addIfNotNull("queues", queues);
        queryParameters.addIfNotEmpty("buildNumber", buildNumber);
        queryParameters.addIfNotNull("minFinishTime", (Object)minFinishTime);
        queryParameters.addIfNotNull("maxFinishTime", (Object)maxFinishTime);
        queryParameters.addIfNotEmpty("requestedFor", requestedFor);
        queryParameters.addIfNotNull("reasonFilter", (Object)reasonFilter);
        queryParameters.addIfNotNull("statusFilter", (Object)statusFilter);
        queryParameters.addIfNotNull("resultFilter", (Object)resultFilter);
        queryParameters.addIfNotNull("tagFilters", tagFilters);
        queryParameters.addIfNotNull("properties", properties);
        queryParameters.addIfNotNull("type", (Object)type);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("maxBuildsPerDefinition", (Object)maxBuildsPerDefinition);
        queryParameters.addIfNotNull("deletedFilter", (Object)deletedFilter);
        queryParameters.addIfNotNull("queryOrder", (Object)queryOrder);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Build>>(){});
    }

    public List<Build> getBuilds(UUID project, List<Integer> definitions, List<Integer> queues, String buildNumber, Date minFinishTime, Date maxFinishTime, String requestedFor, BuildReason reasonFilter, BuildStatus statusFilter, BuildResult resultFilter, List<String> tagFilters, List<String> properties, DefinitionType type, Integer top, String continuationToken, Integer maxBuildsPerDefinition, QueryDeletedOption deletedFilter, BuildQueryOrder queryOrder) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitions", definitions);
        queryParameters.addIfNotNull("queues", queues);
        queryParameters.addIfNotEmpty("buildNumber", buildNumber);
        queryParameters.addIfNotNull("minFinishTime", (Object)minFinishTime);
        queryParameters.addIfNotNull("maxFinishTime", (Object)maxFinishTime);
        queryParameters.addIfNotEmpty("requestedFor", requestedFor);
        queryParameters.addIfNotNull("reasonFilter", (Object)reasonFilter);
        queryParameters.addIfNotNull("statusFilter", (Object)statusFilter);
        queryParameters.addIfNotNull("resultFilter", (Object)resultFilter);
        queryParameters.addIfNotNull("tagFilters", tagFilters);
        queryParameters.addIfNotNull("properties", properties);
        queryParameters.addIfNotNull("type", (Object)type);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("maxBuildsPerDefinition", (Object)maxBuildsPerDefinition);
        queryParameters.addIfNotNull("deletedFilter", (Object)deletedFilter);
        queryParameters.addIfNotNull("queryOrder", (Object)queryOrder);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Build>>(){});
    }

    public List<Build> getBuilds(List<Integer> definitions, List<Integer> queues, String buildNumber, Date minFinishTime, Date maxFinishTime, String requestedFor, BuildReason reasonFilter, BuildStatus statusFilter, BuildResult resultFilter, List<String> tagFilters, List<String> properties, DefinitionType type, Integer top, String continuationToken, Integer maxBuildsPerDefinition, QueryDeletedOption deletedFilter, BuildQueryOrder queryOrder) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitions", definitions);
        queryParameters.addIfNotNull("queues", queues);
        queryParameters.addIfNotEmpty("buildNumber", buildNumber);
        queryParameters.addIfNotNull("minFinishTime", (Object)minFinishTime);
        queryParameters.addIfNotNull("maxFinishTime", (Object)maxFinishTime);
        queryParameters.addIfNotEmpty("requestedFor", requestedFor);
        queryParameters.addIfNotNull("reasonFilter", (Object)reasonFilter);
        queryParameters.addIfNotNull("statusFilter", (Object)statusFilter);
        queryParameters.addIfNotNull("resultFilter", (Object)resultFilter);
        queryParameters.addIfNotNull("tagFilters", tagFilters);
        queryParameters.addIfNotNull("properties", properties);
        queryParameters.addIfNotNull("type", (Object)type);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("maxBuildsPerDefinition", (Object)maxBuildsPerDefinition);
        queryParameters.addIfNotNull("deletedFilter", (Object)deletedFilter);
        queryParameters.addIfNotNull("queryOrder", (Object)queryOrder);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Build>>(){});
    }

    public Build queueBuild(Build build, Boolean ignoreWarnings) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ignoreWarnings", (Object)ignoreWarnings);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)build, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (Build)super.sendRequest((Object)httpRequest, Build.class);
    }

    public Build queueBuild(Build build, String project, Boolean ignoreWarnings) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ignoreWarnings", (Object)ignoreWarnings);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)build, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (Build)super.sendRequest((Object)httpRequest, Build.class);
    }

    public Build queueBuild(Build build, UUID project, Boolean ignoreWarnings) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ignoreWarnings", (Object)ignoreWarnings);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)build, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (Build)super.sendRequest((Object)httpRequest, Build.class);
    }

    public Build updateBuild(Build build, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)build, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (Build)super.sendRequest((Object)httpRequest, Build.class);
    }

    public Build updateBuild(Build build, String project, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)build, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (Build)super.sendRequest((Object)httpRequest, Build.class);
    }

    public Build updateBuild(Build build, UUID project, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)build, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (Build)super.sendRequest((Object)httpRequest, Build.class);
    }

    public List<Change> getBuildCommits(String project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("54572c7b-bbd3-45d4-80dc-28be08941620");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Change>>(){});
    }

    public List<Change> getBuildCommits(UUID project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("54572c7b-bbd3-45d4-80dc-28be08941620");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Change>>(){});
    }

    public List<Change> getChangesBetweenBuilds(String project, Integer fromBuildId, Integer toBuildId, Integer top) {
        UUID locationId = UUID.fromString("f10f0ea5-18a1-43ec-a8fb-2042c7be9b43");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.2");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fromBuildId", (Object)fromBuildId);
        queryParameters.addIfNotNull("toBuildId", (Object)toBuildId);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Change>>(){});
    }

    public List<Change> getChangesBetweenBuilds(UUID project, Integer fromBuildId, Integer toBuildId, Integer top) {
        UUID locationId = UUID.fromString("f10f0ea5-18a1-43ec-a8fb-2042c7be9b43");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.2");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fromBuildId", (Object)fromBuildId);
        queryParameters.addIfNotNull("toBuildId", (Object)toBuildId);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Change>>(){});
    }

    public BuildController getBuildController(int controllerId) {
        UUID locationId = UUID.fromString("fcac1932-2ee1-437f-9b6f-7f696be858f6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("controllerId", controllerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (BuildController)super.sendRequest((Object)httpRequest, BuildController.class);
    }

    public List<BuildController> getBuildControllers(String name) {
        UUID locationId = UUID.fromString("fcac1932-2ee1-437f-9b6f-7f696be858f6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildController>>(){});
    }

    public BuildDefinition createDefinition(BuildDefinition definition, Integer definitionToCloneId, Integer definitionToCloneRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionToCloneId", (Object)definitionToCloneId);
        queryParameters.addIfNotNull("definitionToCloneRevision", (Object)definitionToCloneRevision);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)definition, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (BuildDefinition)super.sendRequest((Object)httpRequest, BuildDefinition.class);
    }

    public BuildDefinition createDefinition(BuildDefinition definition, String project, Integer definitionToCloneId, Integer definitionToCloneRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionToCloneId", (Object)definitionToCloneId);
        queryParameters.addIfNotNull("definitionToCloneRevision", (Object)definitionToCloneRevision);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)definition, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (BuildDefinition)super.sendRequest((Object)httpRequest, BuildDefinition.class);
    }

    public BuildDefinition createDefinition(BuildDefinition definition, UUID project, Integer definitionToCloneId, Integer definitionToCloneRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionToCloneId", (Object)definitionToCloneId);
        queryParameters.addIfNotNull("definitionToCloneRevision", (Object)definitionToCloneRevision);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)definition, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (BuildDefinition)super.sendRequest((Object)httpRequest, BuildDefinition.class);
    }

    public void deleteDefinition(int definitionId) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("definitionId", definitionId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteDefinition(String project, int definitionId) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteDefinition(UUID project, int definitionId) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("definitionId", Integer.valueOf(definitionId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public DefinitionReference getDefinition(String project, int definitionId, Integer revision, List<String> propertyFilters) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("revision", (Object)revision);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (DefinitionReference)super.sendRequest((Object)httpRequest, DefinitionReference.class);
    }

    public DefinitionReference getDefinition(UUID project, int definitionId, Integer revision, List<String> propertyFilters) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("definitionId", Integer.valueOf(definitionId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("revision", (Object)revision);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (DefinitionReference)super.sendRequest((Object)httpRequest, DefinitionReference.class);
    }

    public DefinitionReference getDefinition(int definitionId, Integer revision, List<String> propertyFilters) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("revision", (Object)revision);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (DefinitionReference)super.sendRequest((Object)httpRequest, DefinitionReference.class);
    }

    public List<DefinitionReference> getDefinitions(String project, String name, DefinitionType type) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        queryParameters.addIfNotNull("type", (Object)type);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<DefinitionReference>>(){});
    }

    public List<DefinitionReference> getDefinitions(UUID project, String name, DefinitionType type) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        queryParameters.addIfNotNull("type", (Object)type);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<DefinitionReference>>(){});
    }

    public List<DefinitionReference> getDefinitions(String name, DefinitionType type) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        queryParameters.addIfNotNull("type", (Object)type);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<DefinitionReference>>(){});
    }

    public BuildDefinition updateDefinition(BuildDefinition definition, int definitionId, Integer secretsSourceDefinitionId, Integer secretsSourceDefinitionRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("secretsSourceDefinitionId", (Object)secretsSourceDefinitionId);
        queryParameters.addIfNotNull("secretsSourceDefinitionRevision", (Object)secretsSourceDefinitionRevision);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)definition, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (BuildDefinition)super.sendRequest((Object)httpRequest, BuildDefinition.class);
    }

    public BuildDefinition updateDefinition(BuildDefinition definition, String project, int definitionId, Integer secretsSourceDefinitionId, Integer secretsSourceDefinitionRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("secretsSourceDefinitionId", (Object)secretsSourceDefinitionId);
        queryParameters.addIfNotNull("secretsSourceDefinitionRevision", (Object)secretsSourceDefinitionRevision);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)definition, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (BuildDefinition)super.sendRequest((Object)httpRequest, BuildDefinition.class);
    }

    public BuildDefinition updateDefinition(BuildDefinition definition, UUID project, int definitionId, Integer secretsSourceDefinitionId, Integer secretsSourceDefinitionRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("definitionId", Integer.valueOf(definitionId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("secretsSourceDefinitionId", (Object)secretsSourceDefinitionId);
        queryParameters.addIfNotNull("secretsSourceDefinitionRevision", (Object)secretsSourceDefinitionRevision);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)definition, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (BuildDefinition)super.sendRequest((Object)httpRequest, BuildDefinition.class);
    }

    public List<Deployment> getBuildDeployments(String project, int buildId) {
        UUID locationId = UUID.fromString("f275be9a-556a-4ee9-b72f-f9c8370ccaee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Deployment>>(){});
    }

    public List<Deployment> getBuildDeployments(UUID project, int buildId) {
        UUID locationId = UUID.fromString("f275be9a-556a-4ee9-b72f-f9c8370ccaee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Deployment>>(){});
    }

    public InputStream getBuildLog(String project, int buildId, int logId, Integer startLine, Integer endLine) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("logId", logId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startLine", (Object)startLine);
        queryParameters.addIfNotNull("endLine", (Object)endLine);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBuildLog(UUID project, int buildId, int logId, Integer startLine, Integer endLine) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        routeValues.put("logId", Integer.valueOf(logId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startLine", (Object)startLine);
        queryParameters.addIfNotNull("endLine", (Object)endLine);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<BuildLog> getBuildLogs(String project, int buildId) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildLog>>(){});
    }

    public List<BuildLog> getBuildLogs(UUID project, int buildId) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildLog>>(){});
    }

    public InputStream getBuildLogsZip(String project, int buildId) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBuildLogsZip(UUID project, int buildId) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<BuildOptionDefinition> getBuildOptionDefinitions() {
        UUID locationId = UUID.fromString("591cb5a4-2d46-4f3a-a697-5cd42b6bd332");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildOptionDefinition>>(){});
    }

    public AgentPoolQueue createQueue(AgentPoolQueue queue) {
        UUID locationId = UUID.fromString("09f2a4b8-08c9-4991-85c3-d698937568be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)queue, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (AgentPoolQueue)super.sendRequest((Object)httpRequest, AgentPoolQueue.class);
    }

    public void deleteQueue(int id) {
        UUID locationId = UUID.fromString("09f2a4b8-08c9-4991-85c3-d698937568be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"id", (Object)String.valueOf(id));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public AgentPoolQueue getAgentPoolQueue(int controllerId) {
        UUID locationId = UUID.fromString("09f2a4b8-08c9-4991-85c3-d698937568be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("controllerId", controllerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (AgentPoolQueue)super.sendRequest((Object)httpRequest, AgentPoolQueue.class);
    }

    public List<AgentPoolQueue> getQueues(String name) {
        UUID locationId = UUID.fromString("09f2a4b8-08c9-4991-85c3-d698937568be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<AgentPoolQueue>>(){});
    }

    public BuildResourceUsage getResourceUsage() {
        UUID locationId = UUID.fromString("3813d06c-9e36-4ea1-aac3-61a485d60e3d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.2");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, APPLICATION_JSON_TYPE);
        return (BuildResourceUsage)super.sendRequest((Object)httpRequest, BuildResourceUsage.class);
    }

    public List<BuildDefinitionRevision> getDefinitionRevisions(String project, int definitionId) {
        UUID locationId = UUID.fromString("7c116775-52e5-453e-8c5d-914d9762d8c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildDefinitionRevision>>(){});
    }

    public List<BuildDefinitionRevision> getDefinitionRevisions(UUID project, int definitionId) {
        UUID locationId = UUID.fromString("7c116775-52e5-453e-8c5d-914d9762d8c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("definitionId", Integer.valueOf(definitionId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildDefinitionRevision>>(){});
    }

    public BuildSettings getBuildSettings() {
        UUID locationId = UUID.fromString("aa8c1c9c-ef8b-474a-b8c4-785c7b191d0d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, APPLICATION_JSON_TYPE);
        return (BuildSettings)super.sendRequest((Object)httpRequest, BuildSettings.class);
    }

    public BuildSettings updateBuildSettings(BuildSettings settings) {
        UUID locationId = UUID.fromString("aa8c1c9c-ef8b-474a-b8c4-785c7b191d0d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, apiVersion, (Object)settings, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (BuildSettings)super.sendRequest((Object)httpRequest, BuildSettings.class);
    }

    public List<String> addBuildTag(String project, int buildId, String tag) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("tag", tag);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<String> addBuildTag(UUID project, int buildId, String tag) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("tag", tag);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<String> addBuildTags(List<String> tags, String project, int buildId) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, tags, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<String> addBuildTags(List<String> tags, UUID project, int buildId) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, tags, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<String> deleteBuildTag(String project, int buildId, String tag) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("tag", tag);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<String> deleteBuildTag(UUID project, int buildId, String tag) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("tag", tag);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<String> getBuildTags(String project, int buildId) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<String> getBuildTags(UUID project, int buildId) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<String> getTags(String project) {
        UUID locationId = UUID.fromString("d84ac5c6-edc7-43d5-adc9-1b34be5dea09");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public List<String> getTags(UUID project) {
        UUID locationId = UUID.fromString("d84ac5c6-edc7-43d5-adc9-1b34be5dea09");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public void deleteTemplate(String project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteTemplate(UUID project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public BuildDefinitionTemplate getTemplate(String project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (BuildDefinitionTemplate)super.sendRequest((Object)httpRequest, BuildDefinitionTemplate.class);
    }

    public BuildDefinitionTemplate getTemplate(UUID project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (BuildDefinitionTemplate)super.sendRequest((Object)httpRequest, BuildDefinitionTemplate.class);
    }

    public List<BuildDefinitionTemplate> getTemplates(String project) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildDefinitionTemplate>>(){});
    }

    public List<BuildDefinitionTemplate> getTemplates(UUID project) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<BuildDefinitionTemplate>>(){});
    }

    public BuildDefinitionTemplate saveTemplate(BuildDefinitionTemplate template, String project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)template, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (BuildDefinitionTemplate)super.sendRequest((Object)httpRequest, BuildDefinitionTemplate.class);
    }

    public BuildDefinitionTemplate saveTemplate(BuildDefinitionTemplate template, UUID project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)template, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (BuildDefinitionTemplate)super.sendRequest((Object)httpRequest, BuildDefinitionTemplate.class);
    }

    public Timeline getBuildTimeline(String project, int buildId, UUID timelineId, Integer changeId) {
        UUID locationId = UUID.fromString("8baac422-4c6e-4de5-8532-db96d92acffa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("timelineId", timelineId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeId", (Object)changeId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (Timeline)super.sendRequest((Object)httpRequest, Timeline.class);
    }

    public Timeline getBuildTimeline(UUID project, int buildId, UUID timelineId, Integer changeId) {
        UUID locationId = UUID.fromString("8baac422-4c6e-4de5-8532-db96d92acffa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        routeValues.put("timelineId", timelineId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeId", (Object)changeId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (Timeline)super.sendRequest((Object)httpRequest, Timeline.class);
    }

    public List<ResourceRef> getBuildWorkItemsRefs(String project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("5a21f5d2-5642-47e4-a0bd-1356e6731bee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<ResourceRef>>(){});
    }

    public List<ResourceRef> getBuildWorkItemsRefs(UUID project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("5a21f5d2-5642-47e4-a0bd-1356e6731bee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<ResourceRef>>(){});
    }

    public List<ResourceRef> getBuildWorkItemsRefsFromCommits(List<String> commitIds, String project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("5a21f5d2-5642-47e4-a0bd-1356e6731bee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, commitIds, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<ResourceRef>>(){});
    }

    public List<ResourceRef> getBuildWorkItemsRefsFromCommits(List<String> commitIds, UUID project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("5a21f5d2-5642-47e4-a0bd-1356e6731bee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("buildId", Integer.valueOf(buildId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, commitIds, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<ResourceRef>>(){});
    }

    public List<ResourceRef> getWorkItemsBetweenBuilds(String project, int fromBuildId, int toBuildId, Integer top) {
        UUID locationId = UUID.fromString("52ba8915-5518-42e3-a4bb-b0182d159e2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.2");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"fromBuildId", (Object)String.valueOf(fromBuildId));
        queryParameters.put((Object)"toBuildId", (Object)String.valueOf(toBuildId));
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<ResourceRef>>(){});
    }

    public List<ResourceRef> getWorkItemsBetweenBuilds(UUID project, int fromBuildId, int toBuildId, Integer top) {
        UUID locationId = UUID.fromString("52ba8915-5518-42e3-a4bb-b0182d159e2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.2");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"fromBuildId", (Object)String.valueOf(fromBuildId));
        queryParameters.put((Object)"toBuildId", (Object)String.valueOf(toBuildId));
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<ResourceRef>>(){});
    }
}

