/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseFamilyId
implements Comparable<DatabaseFamilyId> {
    private static final ConcurrentMap<String, DatabaseFamilyId> ourFamilies = ContainerUtil.newConcurrentMap();
    public static final DatabaseFamilyId UNKNOWN = DatabaseFamilyId.create("UNKNOWN");
    public static final DatabaseFamilyId ORACLE = DatabaseFamilyId.create("Oracle");
    public static final DatabaseFamilyId MEMSQL = DatabaseFamilyId.create("MemSQL");
    public static final DatabaseFamilyId MARIADB = DatabaseFamilyId.create("MariaDB");
    public static final DatabaseFamilyId MYSQL = DatabaseFamilyId.create("MySQL");
    public static final DatabaseFamilyId POSTGRES = DatabaseFamilyId.create("Postgres");
    public static final DatabaseFamilyId REDSHIFT = DatabaseFamilyId.create("RedShift");
    public static final DatabaseFamilyId MSSQL = DatabaseFamilyId.create("MSSQL", "SQLServer");
    public static final DatabaseFamilyId AZURE = DatabaseFamilyId.create("Azure");
    public static final DatabaseFamilyId SYBASE = DatabaseFamilyId.create("Sybase");
    public static final DatabaseFamilyId DB2 = DatabaseFamilyId.create("DB2");
    public static final DatabaseFamilyId SQLITE = DatabaseFamilyId.create("SQLite");
    public static final DatabaseFamilyId HSQLDB = DatabaseFamilyId.create("HSQLDB");
    public static final DatabaseFamilyId H2 = DatabaseFamilyId.create("H2");
    public static final DatabaseFamilyId DERBY = DatabaseFamilyId.create("Derby");
    public static final DatabaseFamilyId EXASOL = DatabaseFamilyId.create("Exasol");
    public static final DatabaseFamilyId CLICKHOUSE = DatabaseFamilyId.create("ClickHouse");
    public static final DatabaseFamilyId VERTICA = DatabaseFamilyId.create("Vertica");
    public static final DatabaseFamilyId PRESTO = DatabaseFamilyId.create("Presto");
    public static final DatabaseFamilyId INFORMIX = DatabaseFamilyId.create("Informix");
    public static final DatabaseFamilyId IMPALA = DatabaseFamilyId.create("Impala");
    public static final DatabaseFamilyId NETEZZA = DatabaseFamilyId.create("Netezza");
    public static final DatabaseFamilyId PHOENIX = DatabaseFamilyId.create("Phoenix");
    public static final DatabaseFamilyId HIVE = DatabaseFamilyId.create("Hive");
    public static final DatabaseFamilyId SNOWFLAKE = DatabaseFamilyId.create("Snowflake");
    public static final DatabaseFamilyId INGRES = DatabaseFamilyId.create("Ingres");
    public static final DatabaseFamilyId TERADATA = DatabaseFamilyId.create("Teradata");
    public static final DatabaseFamilyId OPENEDGE = DatabaseFamilyId.create("OpenEdge");
    public static final DatabaseFamilyId TIBERO = DatabaseFamilyId.create("Tibero");
    public static final DatabaseFamilyId FILEMAKER = DatabaseFamilyId.create("FileMaker");
    public static final DatabaseFamilyId FRONTBASE = DatabaseFamilyId.create("FrontBase");
    private final String myName;
    private final String myDisplayName;

    @NotNull
    public static DatabaseFamilyId create(@NotNull String displayName) {
        if (displayName == null) {
            DatabaseFamilyId.$$$reportNull$$$0(0);
        }
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.create(displayName, displayName);
        if (databaseFamilyId == null) {
            DatabaseFamilyId.$$$reportNull$$$0(1);
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseFamilyId create(@NotNull String name, @NotNull String displayName) {
        DatabaseFamilyId existing;
        if (name == null) {
            DatabaseFamilyId.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            DatabaseFamilyId.$$$reportNull$$$0(3);
        }
        if ((existing = (DatabaseFamilyId)ourFamilies.get(name = StringUtil.toUpperCase((String)name))) != null) {
            DatabaseFamilyId databaseFamilyId = existing;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(4);
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = (DatabaseFamilyId)ConcurrencyUtil.cacheOrGet(ourFamilies, (Object)name, (Object)new DatabaseFamilyId(name, displayName));
        if (databaseFamilyId == null) {
            DatabaseFamilyId.$$$reportNull$$$0(5);
        }
        return databaseFamilyId;
    }

    private DatabaseFamilyId(@NotNull String name, @NotNull String displayName) {
        if (name == null) {
            DatabaseFamilyId.$$$reportNull$$$0(6);
        }
        if (displayName == null) {
            DatabaseFamilyId.$$$reportNull$$$0(7);
        }
        this.myName = name;
        this.myDisplayName = displayName;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DatabaseFamilyId.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            DatabaseFamilyId.$$$reportNull$$$0(9);
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOracle() {
        return this == ORACLE;
    }

    public boolean isMysql() {
        return this == MYSQL || this == MARIADB || this == MEMSQL;
    }

    public boolean isPostgres() {
        return this == POSTGRES || this == REDSHIFT;
    }

    public boolean isRedshift() {
        return this == REDSHIFT;
    }

    public boolean isVertica() {
        return this == VERTICA;
    }

    public boolean isMicrosoft() {
        return this == MSSQL || this == AZURE;
    }

    public boolean isSybase() {
        return this == SYBASE;
    }

    public boolean isDb2() {
        return this == DB2;
    }

    public boolean isHsqldb() {
        return this == HSQLDB;
    }

    public boolean isH2() {
        return this == H2;
    }

    public boolean isDerby() {
        return this == DERBY;
    }

    public boolean isSqlite() {
        return this == SQLITE;
    }

    public boolean isTransactSql() {
        return this.isMicrosoft() || this.isSybase();
    }

    public boolean isExasol() {
        return this == EXASOL;
    }

    public boolean isClickHouse() {
        return this == CLICKHOUSE;
    }

    @NotNull
    public static DatabaseFamilyId forDataSource(@NotNull DasDataSource o) {
        if (o == null) {
            DatabaseFamilyId.$$$reportNull$$$0(10);
        }
        NameVersion p = o.getDatabaseVersion();
        DatabaseFamilyId result = DatabaseFamilyId.fromString(p.version);
        if (result == UNKNOWN) {
            result = DatabaseFamilyId.fromString(p.name);
        }
        if (result == UNKNOWN && o instanceof RawConnectionConfig) {
            result = DatabaseFamilyId.forConnection((RawConnectionConfig)((Object)o));
        }
        if (result == POSTGRES) {
            Version version;
            Version version2 = version = p.version != null && p.version.contains("8") ? Version.parseVersion((String)p.version) : null;
            if (version != null && version.major == 8 && version.bugfix == 2) {
                result = REDSHIFT;
            }
        }
        DatabaseFamilyId databaseFamilyId = result;
        if (databaseFamilyId == null) {
            DatabaseFamilyId.$$$reportNull$$$0(11);
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseFamilyId forConnection(@Nullable RawConnectionConfig o) {
        if (o == null) {
            DatabaseFamilyId databaseFamilyId = UNKNOWN;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(12);
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId result = DatabaseFamilyId.fromString(o.getUrl());
        if (result != UNKNOWN) {
            DatabaseFamilyId databaseFamilyId = result;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(13);
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.fromString(o.getDriverClass());
        if (databaseFamilyId == null) {
            DatabaseFamilyId.$$$reportNull$$$0(14);
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseFamilyId fromString(@Nullable String text) {
        if (text == null) {
            DatabaseFamilyId databaseFamilyId = UNKNOWN;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(15);
            }
            return databaseFamilyId;
        }
        String pattern = "(?i).*(?:%s).*";
        for (DatabaseFamilyId family : ourFamilies.values()) {
            if (!text.matches(String.format(pattern, family.getName()))) continue;
            DatabaseFamilyId databaseFamilyId = family;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(16);
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "hsql"))) {
            DatabaseFamilyId databaseFamilyId = HSQLDB;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(17);
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "microsoft|sqlserver"))) {
            DatabaseFamilyId databaseFamilyId = MSSQL;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(18);
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "adaptive server")) || StringUtil.startsWithIgnoreCase((String)text, (String)"ase")) {
            DatabaseFamilyId databaseFamilyId = SYBASE;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(19);
            }
            return databaseFamilyId;
        }
        if (text.startsWith("ids")) {
            DatabaseFamilyId databaseFamilyId = INFORMIX;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(20);
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "exa"))) {
            DatabaseFamilyId databaseFamilyId = EXASOL;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(21);
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = UNKNOWN;
        if (databaseFamilyId == null) {
            DatabaseFamilyId.$$$reportNull$$$0(22);
        }
        return databaseFamilyId;
    }

    @Nullable
    public static DatabaseFamilyId byName(@NotNull String name) {
        if (name == null) {
            DatabaseFamilyId.$$$reportNull$$$0(23);
        }
        return (DatabaseFamilyId)ourFamilies.get(name);
    }

    public static Collection<DatabaseFamilyId> allFamilyIds() {
        return ourFamilies.values();
    }

    @Override
    public int compareTo(@NotNull DatabaseFamilyId o) {
        if (o == null) {
            DatabaseFamilyId.$$$reportNull$$$0(24);
        }
        return Comparing.compare((Comparable)((Object)this.getName()), (Comparable)((Object)o.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/DatabaseFamilyId";
                break;
            }
            case 2: 
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/DatabaseFamilyId";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "forDataSource";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forConnection";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forDataSource";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

