/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class ObjectKind
implements Comparable<ObjectKind> {
    public static final ObjectKind NONE = new ObjectKind("NONE", 0);
    public static final ObjectKind ROOT = new ObjectKind("ROOT", 1);
    public static final ObjectKind DATABASE = new ObjectKind("DATABASE", 2);
    public static final ObjectKind SCHEMA = new ObjectKind("SCHEMA", 3);
    public static final ObjectKind SEQUENCE = new ObjectKind("SEQUENCE", 4);
    public static final ObjectKind CLUSTER = new ObjectKind("CLUSTER", 5);
    public static final ObjectKind OBJECT_TYPE = new ObjectKind("OBJECT TYPE", 6);
    public static final ObjectKind COLLECTION_TYPE = new ObjectKind("COLLECTION TYPE", 7);
    public static final ObjectKind TABLE_TYPE = new ObjectKind("TABLE TYPE", 8);
    public static final ObjectKind ALIAS_TYPE = new ObjectKind("ALIAS TYPE", 9);
    public static final ObjectKind TABLE = new ObjectKind("TABLE", 10);
    public static final ObjectKind MAT_LOG = new ObjectKind("MATERIALIZED LOG", 11);
    public static final ObjectKind MAT_VIEW = new ObjectKind("MATERIALIZED VIEW", 12);
    public static final ObjectKind VIEW = new ObjectKind("VIEW", 13);
    public static final ObjectKind PACKAGE = new ObjectKind("PACKAGE", 14);
    public static final ObjectKind BODY = new ObjectKind("BODY", 15);
    public static final ObjectKind ROUTINE = new ObjectKind("ROUTINE", 16);
    public static final ObjectKind OPERATOR = new ObjectKind("OPERATOR", 17);
    public static final ObjectKind OBJECT_ATTRIBUTE = new ObjectKind("OBJECT ATTRIBUTE", 18);
    public static final ObjectKind COLUMN = new ObjectKind("COLUMN", 19);
    public static final ObjectKind INDEX = new ObjectKind("INDEX", 20);
    public static final ObjectKind KEY = new ObjectKind("KEY", 21);
    public static final ObjectKind FOREIGN_KEY = new ObjectKind("FOREIGN KEY", 22);
    public static final ObjectKind CHECK = new ObjectKind("CHECK", 23);
    public static final ObjectKind DEFAULT = new ObjectKind("DEFAULT", 24);
    public static final ObjectKind RULE = new ObjectKind("RULE", 25);
    public static final ObjectKind TRIGGER = new ObjectKind("TRIGGER", 26);
    public static final ObjectKind ARGUMENT = new ObjectKind("ARGUMENT", 27);
    public static final ObjectKind VARIABLE = new ObjectKind("VARIABLE", 28);
    public static final ObjectKind COMMENT = new ObjectKind("COMMENT", 29);
    public static final ObjectKind SYNONYM = new ObjectKind("SYNONYM", 30);
    public static final ObjectKind DB_LINK = new ObjectKind("DBLINK", 31);
    public static final ObjectKind VIRTUAL_TABLE = new ObjectKind("VIRTUAL TABLE", 32);
    public static final ObjectKind COLLATION = new ObjectKind("COLLATION", 33);
    public static final ObjectKind SCRIPT = new ObjectKind("SCRIPT", 34);
    public static final ObjectKind TABLESPACE = new ObjectKind("TABLESPACE", 35);
    public static final ObjectKind DATA_FILE = new ObjectKind("DATA FILE", 36);
    public static final ObjectKind ROLE = new ObjectKind("ROLE", 37);
    public static final ObjectKind USER = new ObjectKind("USER", 38);
    public static final ObjectKind CONNECTION = new ObjectKind("CONNECTION", 39);
    public static final ObjectKind FOREIGN_DATA_WRAPPER = new ObjectKind("FOREIGN DATA WRAPPER", 40);
    public static final ObjectKind SERVER = new ObjectKind("SERVER", 41);
    public static final ObjectKind USER_MAPPING = new ObjectKind("USER MAPPING", 42);
    public static final ObjectKind FOREIGN_TABLE = new ObjectKind("FOREIGN TABLE", 43);
    public static final ObjectKind EXTERNAL_SCHEMA = new ObjectKind("EXTERNAL SCHEMA", 44);
    public static final ObjectKind SCHEDULED_EVENT = new ObjectKind("SCHEDULED EVENT", 45);
    public static final ObjectKind ACCESS_METHOD = new ObjectKind("ACCESS METHOD", 46);
    public static final ObjectKind AGGREGATE = new ObjectKind("AGGREGATE", 47);
    public static final ObjectKind EXCEPTION = new ObjectKind("EXCEPTION", 48);
    public static final ObjectKind UNKNOWN_OBJECT = new ObjectKind("UNKNOWN OBJECT", Integer.MAX_VALUE);
    private final String myName;
    private final int myOrderNum;
    private static final AtomicInteger ourOrderNumCounter = new AtomicInteger(100);
    private final String myCode;
    public static final Map<String, ObjectKind> ourKinds;

    public ObjectKind(@NotNull String name) {
        if (name == null) {
            ObjectKind.$$$reportNull$$$0(0);
        }
        this(name, ourOrderNumCounter.incrementAndGet());
    }

    private ObjectKind(@NotNull String name, int orderNum) {
        if (name == null) {
            ObjectKind.$$$reportNull$$$0(1);
        }
        assert (name.length() > 0);
        assert (orderNum >= 0);
        this.myName = name;
        this.myCode = this.myName.toLowerCase(Locale.ENGLISH).replace(' ', '-');
        this.myOrderNum = orderNum;
    }

    public String name() {
        return this.myName;
    }

    public String code() {
        return this.myCode;
    }

    public int getOrder() {
        return this.myOrderNum;
    }

    public String toString() {
        return this.code();
    }

    @Override
    public int compareTo(@NotNull ObjectKind that) {
        if (that == null) {
            ObjectKind.$$$reportNull$$$0(2);
        }
        if (this == that) {
            return 0;
        }
        if (this.myOrderNum < that.myOrderNum) {
            return -1;
        }
        if (this.myOrderNum > that.myOrderNum) {
            return 1;
        }
        throw new IllegalStateException(String.format("Uncomparable object kinds: %s and %s", this.code(), that.code()));
    }

    static {
        ObjectKind[] theKinds = new ObjectKind[]{NONE, ROOT, DATABASE, SCHEMA, SEQUENCE, CLUSTER, TABLE, MAT_LOG, MAT_VIEW, VIEW, OBJECT_TYPE, COLLECTION_TYPE, PACKAGE, BODY, TABLE_TYPE, ALIAS_TYPE, ROUTINE, OPERATOR, OBJECT_ATTRIBUTE, COLUMN, INDEX, KEY, FOREIGN_KEY, CHECK, DEFAULT, RULE, TRIGGER, ARGUMENT, VARIABLE, COMMENT, SYNONYM, DB_LINK, VIRTUAL_TABLE, COLLATION, SCRIPT, USER, ROLE, CONNECTION, FOREIGN_DATA_WRAPPER, SERVER, USER_MAPPING, FOREIGN_TABLE, EXTERNAL_SCHEMA, SCHEDULED_EVENT, ACCESS_METHOD, AGGREGATE, EXCEPTION, UNKNOWN_OBJECT};
        LinkedHashMap m = new LinkedHashMap(60);
        for (ObjectKind kind : theKinds) {
            m.put((Object)kind.code(), (Object)kind);
        }
        ourKinds = Collections.unmodifiableMap(m);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/model/ObjectKind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

