/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseFamilyBean
extends AbstractExtensionPointBean {
    public static final ExtensionPointName<DatabaseFamilyBean> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.databaseFamily");
    @Attribute(value="familyId")
    public String familyId;
    @Attribute(value="rdbms")
    public String rdbms;
    @Attribute(value="languageClass")
    public String languageClass;
    @Attribute(value="dialectClass")
    public String dialectClass;
    public final NotNullLazyValue<SqlLanguageDialect> language = NotNullLazyValue.createValue(() -> (SqlLanguageDialect)((Object)((Object)this.getInstanceField(this.languageClass))));
    public final NotNullLazyValue<DatabaseDialect> dialect = NotNullLazyValue.createValue(() -> (DatabaseDialect)this.getInstanceField(this.dialectClass));
    public final NotNullLazyValue<DatabaseFamilyId> family = NotNullLazyValue.createValue(() -> (DatabaseFamilyId)ObjectUtils.assertNotNull((Object)DatabaseFamilyId.byName(this.familyId)));

    @Nullable
    public static DatabaseFamilyBean findFamily(@NotNull Condition<? super DatabaseFamilyBean> condition) {
        DatabaseFamilyBean[] extensions;
        if (condition == null) {
            DatabaseFamilyBean.$$$reportNull$$$0(0);
        }
        if ((extensions = DatabaseFamilyBean.getExtensions()) == null) {
            return null;
        }
        for (DatabaseFamilyBean extension : extensions) {
            if (!condition.value((Object)extension)) continue;
            return extension;
        }
        return null;
    }

    @Nullable
    public static DatabaseFamilyBean findByRdbms(@Nullable String rdbms) {
        return rdbms == null ? null : DatabaseFamilyBean.findFamily((Condition<? super DatabaseFamilyBean>)((Condition)f -> rdbms.equals(f.rdbms)));
    }

    @Nullable
    public static DatabaseFamilyBean findByFamilyId(@Nullable DatabaseFamilyId familyId) {
        return familyId == null ? null : DatabaseFamilyBean.findFamily((Condition<? super DatabaseFamilyBean>)((Condition)f -> familyId.equals(f.family.getValue())));
    }

    private <T> T getInstanceField(String className) {
        try {
            Class clazz = this.findClass(className);
            Field field = clazz.getField("INSTANCE");
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new AssertionError((Object)"INSTANCE field is not static");
            }
            return (T)field.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public <T> T getDialectClass(String suffix) {
        String base = this.languageClass.replace("Hsqldb", "Hsql");
        Object object = ReflectionUtil.newInstance((Class)ReflectionUtil.forName((String)base.replace("Dialect", suffix)));
        if (object == null) {
            DatabaseFamilyBean.$$$reportNull$$$0(1);
        }
        return (T)object;
    }

    @Nullable
    public static DatabaseFamilyBean[] getExtensions() {
        if (Extensions.getRootArea().hasExtensionPoint(EP_NAME)) {
            return (DatabaseFamilyBean[])EP_NAME.getExtensions();
        }
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            return TestHelper.getExtensions();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/DatabaseFamilyBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/DatabaseFamilyBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFamily";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TestHelper {
        private static final ExtensionsArea ourArea = new ExtensionsAreaImpl(null, null, null);

        private TestHelper() {
        }

        @NotNull
        public static DatabaseFamilyBean[] getExtensions() {
            DatabaseFamilyBean[] databaseFamilyBeanArray = (DatabaseFamilyBean[])ourArea.getExtensionPoint(EP_NAME).getExtensions();
            if (databaseFamilyBeanArray == null) {
                TestHelper.$$$reportNull$$$0(0);
            }
            return databaseFamilyBeanArray;
        }

        static {
            ourArea.registerExtensionPoint(EP_NAME.getName(), DatabaseFamilyBean.class.getCanonicalName(), ExtensionPoint.Kind.BEAN_CLASS);
            ExtensionPoint point = ourArea.getExtensionPoint(EP_NAME);
            DefaultPluginDescriptor descriptor = new DefaultPluginDescriptor(PluginId.getId((String)"com.intellij.database"), DatabaseFamilyBean.class.getClassLoader());
            URL xml = descriptor.getPluginClassLoader().getResource("/META-INF/dialects/all-dialects.xml");
            if (xml != null) {
                try (InputStream stream = xml.openStream();){
                    Document doc = JDOMUtil.loadDocument((InputStream)stream);
                    doc = JDOMXIncluder.resolve((Document)doc, (String)xml.toExternalForm());
                    JBIterable beans = JBIterable.from((Iterable)doc.getRootElement().getChildren("extensions")).flatten(e -> e.getChildren()).filter(e -> e.getName().endsWith("databaseFamily"));
                    for (Element bean : beans) {
                        ourArea.registerExtension(point, (PluginDescriptor)descriptor, bean);
                    }
                }
                catch (Exception e2) {
                    throw new AssertionError("Failed to load dialect list", e2);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/DatabaseFamilyBean$TestHelper", "getExtensions"));
        }
    }
}

