/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.database.util.Case;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsDefault;
import com.intellij.sql.psi.SqlLanguage;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCodeStyleSettings
extends CustomCodeStyleSettings
implements SqlCodeStyleConst {
    public int myVersion = 1;
    public boolean DISABLE_FORMATTING = false;
    @SqlCodeStyleConst.AliasCase
    public int ALIAS_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int KEYWORD_CASE;
    @SqlCodeStyleConst.IdentifierCaseExt
    public int TYPE_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int IDENTIFIER_CASE;
    @SqlCodeStyleConst.IdentifierCase
    public int QUOTED_IDENTIFIER_CASE;
    public int QUOTE_IDENTIFIER;
    public int QUERY_SECTION_1ST_WORD_ALIGN;
    public int QUERY_EL_LINE;
    public int QUERY_IN_ONE_STRING;
    public boolean SUBQUERY_L_PAR_NL_OUTSIDE;
    public boolean SUBQUERY_L_PAR_NL_INSIDE;
    public boolean SUBQUERY_R_PAR_NL_INSIDE;
    public int SUBQUERY_R_PAR_ALIGN;
    public boolean SUBQUERY_INDENT_INSIDE;
    public boolean SUBQUERY_PAR_SPACE_INSIDE;
    public int INSERT_INTO_NL;
    public boolean INSERT_COLLAPSE_MULTI_ROW_VALUES;
    public int SET_EL_WRAP;
    public int SET_EL_COMMA;
    public boolean SET_ALIGN_EQUAL_SIGN;
    public int WITH_EL_WRAP;
    public int WITH_EL_COMMA;
    public boolean WITH_ALIGN_AS;
    public int SELECT_EL_WRAP;
    public int SELECT_EL_COMMA;
    public boolean SELECT_NEW_LINE_AFTER_ALL_DISTINCT;
    public int SELECT_KEEP_N_ITEMS_IN_LINE;
    public int SELECT_USE_AS_WORD;
    public boolean SELECT_ALIGN_AS;
    public int FROM_EL_WRAP;
    public int FROM_EL_COMMA;
    public boolean FROM_WRAP_JOIN_1;
    public boolean FROM_WRAP_JOIN_2;
    public boolean FROM_WRAP_ON;
    public boolean FROM_ALIGN_JOIN_TABLES;
    public boolean FROM_ALIGN_ALIASES;
    public boolean FROM_INDENT_JOIN;
    public int WHERE_EL_WRAP;
    public int WHERE_EL_BOUND;
    public int ORDER_EL_WRAP;
    public int ORDER_EL_COMMA;
    public boolean ORDER_ALIGN_ASC_DESC;
    public boolean CORTEGE_SPACE_BEFORE_L_PAREN;
    public boolean CORTEGE_COMMA_1ST;
    public int CORTEGE_CLOSING;
    public int EXPR_SPACE_AROUND_OPERATOR;
    public boolean EXPR_BINARY_OP_ALIGN;
    public boolean EXPR_CASE_WHEN_WRAP;
    public boolean EXPR_CASE_WHEN_INDENT;
    public boolean EXPR_CASE_THEN_WRAP;
    public boolean EXPR_CASE_THEN_ALIGN;
    public boolean EXPR_CASE_ELSE_ALIGN_THEN;
    public int EXPR_CASE_END;
    public boolean EXPR_CASE_KEEP_NL_AFTER_THEN;
    public boolean EXPR_CASE_COLLAPSE;
    public String INDEX_NAME_TEMPLATE;
    public String PRIMARY_KEY_NAME_TEMPLATE;
    public String FOREIGN_KEY_NAME_TEMPLATE;
    @Deprecated
    public boolean SPACES_AROUND_OPERATORS;
    @Deprecated
    public boolean ALIGN_AS_IN_SELECT_STATEMENT;
    @Deprecated
    public boolean ALIGN_TYPE_IN_CREATE_STATEMENT;
    @Deprecated
    public boolean ALIGN_TYPE_IN_BLOCK_STATEMENT;
    @Deprecated
    public boolean ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
    @Deprecated
    public boolean ALIGN_INSIDE_BINARY_EXPRESSION;
    @Deprecated
    public boolean ALIGN_INSIDE_QUERY_EXPRESSION;
    @Deprecated
    public boolean ALIGN_EQ_INSIDE_SET_CLAUSE;
    @Deprecated
    public boolean NEW_LINE_BEFORE_FROM;
    @Deprecated
    public boolean NEW_LINE_BEFORE_JOIN;
    @Deprecated
    public boolean NEW_LINE_BEFORE_JOIN_CONDITION;
    @Deprecated
    public boolean NEW_LINE_BEFORE_WHERE;
    @Deprecated
    public boolean NEW_LINE_BEFORE_GROUP_BY;
    @Deprecated
    public boolean NEW_LINE_BEFORE_ORDER_BY;
    @Deprecated
    public boolean NEW_LINE_BEFORE_HAVING;
    @Deprecated
    public boolean NEW_LINE_BEFORE_THEN;
    @Deprecated
    public boolean NEW_LINE_BEFORE_ELSE;
    @Deprecated
    public boolean NEW_LINE_BEFORE_OTHER_CLAUSES;
    @Deprecated
    public boolean NEW_LINE_BEFORE_COMMA;
    @Deprecated
    public boolean NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
    @Deprecated
    public boolean NEW_LINE_BEFORE_QUERY_INSIDE_DML;
    @Deprecated
    public boolean NEW_LINE_AROUND_SEMICOLON;
    @Deprecated
    public boolean INDENT_JOIN;
    @Deprecated
    public boolean INDENT_JOIN_CONDITION;
    @Deprecated
    public boolean INDENT_SELECT_INTO_CLAUSE;
    @Deprecated
    public int WRAP_INSIDE_CREATE_TABLE;
    @Deprecated
    public int WRAP_INSIDE_SELECT;
    @Deprecated
    public int WRAP_INSIDE_JOIN_EXPRESSION;
    @Deprecated
    public int WRAP_INSIDE_GROUP_BY;
    @Deprecated
    public int WRAP_INSIDE_WHERE;
    @Deprecated
    public int WRAP_INSIDE_ORDER_BY;
    @Deprecated
    public int WRAP_INSIDE_SET;
    @Deprecated
    public int WRAP_INSIDE_ARGUMENT_DEFINITION;
    @Deprecated
    public int WRAP_INSIDE_CALL_EXPRESSION;
    @Deprecated
    public int WRAP_INSIDE_VALUES_EXPRESSION;
    @Deprecated
    public int WRAP_VALUES_EXPRESSION;
    @Deprecated
    public int WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES;
    @Deprecated
    public boolean NEW_LINE_AFTER_SELECT;
    @Deprecated
    public boolean NEW_LINE_AFTER_SELECT_ITEM;
    @Deprecated
    public int NEW_LINE_AFTER_SELECT_2;
    private static final Logger LOG = Logger.getInstance(SqlCodeStyleSettings.class);

    public SqlCodeStyleSettings(CodeStyleSettings container) {
        super("SqlCodeStyleSettings", container);
        this.ALIAS_CASE = SqlCodeStyleSettingsDefault.MODERN.ALIAS_CASE;
        this.KEYWORD_CASE = SqlCodeStyleSettingsDefault.MODERN.KEYWORD_CASE;
        this.TYPE_CASE = SqlCodeStyleSettingsDefault.MODERN.TYPE_CASE;
        this.IDENTIFIER_CASE = SqlCodeStyleSettingsDefault.MODERN.IDENTIFIER_CASE;
        this.QUOTED_IDENTIFIER_CASE = SqlCodeStyleSettingsDefault.MODERN.QUOTED_IDENTIFIER_CASE;
        this.QUOTE_IDENTIFIER = SqlCodeStyleSettingsDefault.MODERN.QUOTE_IDENTIFIER;
        this.QUERY_SECTION_1ST_WORD_ALIGN = SqlCodeStyleSettingsDefault.MODERN.QUERY_SECTION_1ST_WORD_ALIGN;
        this.QUERY_EL_LINE = SqlCodeStyleSettingsDefault.MODERN.QUERY_EL_LINE;
        this.QUERY_IN_ONE_STRING = SqlCodeStyleSettingsDefault.MODERN.QUERY_IN_ONE_STRING;
        this.SUBQUERY_L_PAR_NL_OUTSIDE = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_L_PAR_NL_OUTSIDE;
        this.SUBQUERY_L_PAR_NL_INSIDE = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_L_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_NL_INSIDE = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_R_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_ALIGN = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_R_PAR_ALIGN;
        this.SUBQUERY_INDENT_INSIDE = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_INDENT_INSIDE;
        this.SUBQUERY_PAR_SPACE_INSIDE = SqlCodeStyleSettingsDefault.MODERN.SUBQUERY_PAR_SPACE_INSIDE;
        this.INSERT_INTO_NL = SqlCodeStyleSettingsDefault.MODERN.INSERT_INTO_NL;
        this.INSERT_COLLAPSE_MULTI_ROW_VALUES = SqlCodeStyleSettingsDefault.MODERN.INSERT_COLLAPSE_MULTI_ROW_VALUES;
        this.SET_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.SET_EL_WRAP;
        this.SET_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.SET_EL_COMMA;
        this.SET_ALIGN_EQUAL_SIGN = SqlCodeStyleSettingsDefault.MODERN.SET_ALIGN_EQUAL_SIGN;
        this.WITH_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.WITH_EL_WRAP;
        this.WITH_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.WITH_EL_COMMA;
        this.WITH_ALIGN_AS = SqlCodeStyleSettingsDefault.MODERN.WITH_ALIGN_AS;
        this.SELECT_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.SELECT_EL_WRAP;
        this.SELECT_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.SELECT_EL_COMMA;
        this.SELECT_NEW_LINE_AFTER_ALL_DISTINCT = SqlCodeStyleSettingsDefault.MODERN.SELECT_NEW_LINE_AFTER_ALL_DISTINCT;
        this.SELECT_KEEP_N_ITEMS_IN_LINE = SqlCodeStyleSettingsDefault.MODERN.SELECT_KEEP_N_ITEMS_IN_LINE;
        this.SELECT_USE_AS_WORD = SqlCodeStyleSettingsDefault.MODERN.SELECT_USE_AS_WORD;
        this.SELECT_ALIGN_AS = SqlCodeStyleSettingsDefault.MODERN.SELECT_ALIGN_AS;
        this.FROM_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.FROM_EL_WRAP;
        this.FROM_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.FROM_EL_COMMA;
        this.FROM_WRAP_JOIN_1 = SqlCodeStyleSettingsDefault.MODERN.FROM_WRAP_JOIN_1;
        this.FROM_WRAP_JOIN_2 = SqlCodeStyleSettingsDefault.MODERN.FROM_WRAP_JOIN_2;
        this.FROM_WRAP_ON = SqlCodeStyleSettingsDefault.MODERN.FROM_WRAP_ON;
        this.FROM_ALIGN_JOIN_TABLES = SqlCodeStyleSettingsDefault.MODERN.FROM_ALIGN_JOIN_TABLES;
        this.FROM_ALIGN_ALIASES = SqlCodeStyleSettingsDefault.MODERN.FROM_ALIGN_ALIASES;
        this.FROM_INDENT_JOIN = SqlCodeStyleSettingsDefault.MODERN.FROM_INDENT_JOIN;
        this.WHERE_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.WHERE_EL_WRAP;
        this.WHERE_EL_BOUND = SqlCodeStyleSettingsDefault.MODERN.WHERE_EL_BOUND;
        this.ORDER_EL_WRAP = SqlCodeStyleSettingsDefault.MODERN.ORDER_EL_WRAP;
        this.ORDER_EL_COMMA = SqlCodeStyleSettingsDefault.MODERN.ORDER_EL_COMMA;
        this.ORDER_ALIGN_ASC_DESC = SqlCodeStyleSettingsDefault.MODERN.ORDER_ALIGN_ASC_DESC;
        this.CORTEGE_SPACE_BEFORE_L_PAREN = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_SPACE_BEFORE_L_PAREN;
        this.CORTEGE_COMMA_1ST = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_COMMA_1ST;
        this.CORTEGE_CLOSING = SqlCodeStyleSettingsDefault.MODERN.CORTEGE_CLOSING;
        this.EXPR_SPACE_AROUND_OPERATOR = SqlCodeStyleSettingsDefault.MODERN.EXPR_SPACE_AROUND_OPERATOR;
        this.EXPR_BINARY_OP_ALIGN = SqlCodeStyleSettingsDefault.MODERN.EXPR_BINARY_OP_ALIGN;
        this.EXPR_CASE_WHEN_WRAP = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_WHEN_WRAP;
        this.EXPR_CASE_WHEN_INDENT = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_WHEN_INDENT;
        this.EXPR_CASE_THEN_WRAP = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_THEN_WRAP;
        this.EXPR_CASE_THEN_ALIGN = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_THEN_ALIGN;
        this.EXPR_CASE_ELSE_ALIGN_THEN = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_ELSE_ALIGN_THEN;
        this.EXPR_CASE_END = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_END;
        this.EXPR_CASE_KEEP_NL_AFTER_THEN = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_KEEP_NL_AFTER_THEN;
        this.EXPR_CASE_COLLAPSE = SqlCodeStyleSettingsDefault.MODERN.EXPR_CASE_COLLAPSE;
        this.INDEX_NAME_TEMPLATE = SqlCodeStyleSettingsDefault.MODERN.INDEX_NAME_TEMPLATE;
        this.PRIMARY_KEY_NAME_TEMPLATE = SqlCodeStyleSettingsDefault.MODERN.PRIMARY_KEY_NAME_TEMPLATE;
        this.FOREIGN_KEY_NAME_TEMPLATE = SqlCodeStyleSettingsDefault.MODERN.FOREIGN_KEY_NAME_TEMPLATE;
        this.SPACES_AROUND_OPERATORS = SqlCodeStyleSettingsDefault.LEGACY.SPACES_AROUND_OPERATORS;
        this.ALIGN_AS_IN_SELECT_STATEMENT = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_AS_IN_SELECT_STATEMENT;
        this.ALIGN_TYPE_IN_CREATE_STATEMENT = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.ALIGN_TYPE_IN_BLOCK_STATEMENT = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_TYPE_IN_BLOCK_STATEMENT;
        this.ALIGN_TYPE_IN_ARGUMENT_DEFINITION = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
        this.ALIGN_INSIDE_BINARY_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_INSIDE_BINARY_EXPRESSION;
        this.ALIGN_INSIDE_QUERY_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_INSIDE_QUERY_EXPRESSION;
        this.ALIGN_EQ_INSIDE_SET_CLAUSE = SqlCodeStyleSettingsDefault.LEGACY.ALIGN_EQ_INSIDE_SET_CLAUSE;
        this.NEW_LINE_BEFORE_FROM = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_FROM;
        this.NEW_LINE_BEFORE_JOIN = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_JOIN;
        this.NEW_LINE_BEFORE_JOIN_CONDITION = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_JOIN_CONDITION;
        this.NEW_LINE_BEFORE_WHERE = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_WHERE;
        this.NEW_LINE_BEFORE_GROUP_BY = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_GROUP_BY;
        this.NEW_LINE_BEFORE_ORDER_BY = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_ORDER_BY;
        this.NEW_LINE_BEFORE_HAVING = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_HAVING;
        this.NEW_LINE_BEFORE_THEN = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_THEN;
        this.NEW_LINE_BEFORE_ELSE = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_ELSE;
        this.NEW_LINE_BEFORE_OTHER_CLAUSES = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.NEW_LINE_BEFORE_COMMA = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_COMMA;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_DML = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_BEFORE_QUERY_INSIDE_DML;
        this.NEW_LINE_AROUND_SEMICOLON = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AROUND_SEMICOLON;
        this.INDENT_JOIN = SqlCodeStyleSettingsDefault.LEGACY.INDENT_JOIN;
        this.INDENT_JOIN_CONDITION = SqlCodeStyleSettingsDefault.LEGACY.INDENT_JOIN_CONDITION;
        this.INDENT_SELECT_INTO_CLAUSE = SqlCodeStyleSettingsDefault.LEGACY.INDENT_SELECT_INTO_CLAUSE;
        this.WRAP_INSIDE_CREATE_TABLE = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_CREATE_TABLE;
        this.WRAP_INSIDE_SELECT = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_SELECT;
        this.WRAP_INSIDE_JOIN_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_JOIN_EXPRESSION;
        this.WRAP_INSIDE_GROUP_BY = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_GROUP_BY;
        this.WRAP_INSIDE_WHERE = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_WHERE;
        this.WRAP_INSIDE_ORDER_BY = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_ORDER_BY;
        this.WRAP_INSIDE_SET = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_SET;
        this.WRAP_INSIDE_ARGUMENT_DEFINITION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_ARGUMENT_DEFINITION;
        this.WRAP_INSIDE_CALL_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_CALL_EXPRESSION;
        this.WRAP_INSIDE_VALUES_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_INSIDE_VALUES_EXPRESSION;
        this.WRAP_VALUES_EXPRESSION = SqlCodeStyleSettingsDefault.LEGACY.WRAP_VALUES_EXPRESSION;
        this.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES = SqlCodeStyleSettingsDefault.LEGACY.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES;
        this.NEW_LINE_AFTER_SELECT = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AFTER_SELECT;
        this.NEW_LINE_AFTER_SELECT_ITEM = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AFTER_SELECT_ITEM;
        this.NEW_LINE_AFTER_SELECT_2 = SqlCodeStyleSettingsDefault.LEGACY.NEW_LINE_AFTER_SELECT_2;
    }

    public SqlCodeStyleSettings clone() {
        SqlCodeStyleSettings clone = (SqlCodeStyleSettings)super.clone();
        clone.myVersion = this.myVersion;
        return clone;
    }

    @NotNull
    public static Case getCaseMode(@SqlCodeStyleConst.IdentifierCase int codeStyleSetting) {
        Case case_ = codeStyleSetting == 0 ? Case.UPPER : (codeStyleSetting == 1 ? Case.LOWER : Case.MIXED);
        if (case_ == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(0);
        }
        return case_;
    }

    @NotNull
    public Case getCaseModeExt(@SqlCodeStyleConst.IdentifierCaseExt int codeStyleSetting) {
        if (codeStyleSetting == 3) {
            Case case_ = this.getCaseModeExt(this.KEYWORD_CASE);
            if (case_ == null) {
                SqlCodeStyleSettings.$$$reportNull$$$0(1);
            }
            return case_;
        }
        Case case_ = SqlCodeStyleSettings.getCaseMode(codeStyleSetting);
        if (case_ == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(2);
        }
        return case_;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        Element sectionElement = parentElement.getChild(this.getTagName());
        if (sectionElement == null) {
            return;
        }
        this.myVersion = SqlCodeStyleSettings.readIntAttribute(sectionElement, "version");
        if (this.myVersion == 0) {
            this.assignDefaults(SqlCodeStyleSettingsDefault.LEGACY);
        }
        super.readExternal(parentElement);
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(3);
        }
        super.writeExternal(parentElement, parentSettings);
        Element sectionElement = parentElement.getChild(this.getTagName());
        if (sectionElement != null) {
            sectionElement.setAttribute("version", Integer.toString(this.myVersion));
        }
    }

    private static int readIntAttribute(@Nullable Element element, @NotNull String attributeName) {
        String value;
        if (attributeName == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(4);
        }
        if ((value = SqlCodeStyleSettings.readStringAttribute(element, attributeName)) == null) {
            return 0;
        }
        value = value.trim();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Reading SQL code style settings: Wrong integer attribute value: \"" + value + '\"');
            return 0;
        }
    }

    @Nullable
    private static String readStringAttribute(@Nullable Element element, @NotNull String attributeName) {
        if (attributeName == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return null;
        }
        return element.getAttributeValue(attributeName);
    }

    public void beforeLoading() {
    }

    public void afterLoaded() {
        switch (this.myVersion) {
            case 0: {
                this.migrateFromVersion0();
            }
        }
    }

    private void migrateFromVersion0() {
        LOG.debug("Migrating SQL code style settings from version 0");
        CommonCodeStyleSettings c = this.getCommonSettings();
        int x = SqlCodeStyleSettings.countValue(2, this.WRAP_INSIDE_SET, this.WRAP_INSIDE_SELECT, this.WRAP_INSIDE_WHERE, this.WRAP_INSIDE_GROUP_BY, this.WRAP_INSIDE_ORDER_BY);
        this.QUERY_EL_LINE = x <= 2 ? 1 : (x >= 4 ? 101 : 0);
        this.SUBQUERY_L_PAR_NL_OUTSIDE = c.SPACE_BEFORE_METHOD_PARENTHESES;
        this.SUBQUERY_L_PAR_NL_INSIDE = this.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
        this.SUBQUERY_PAR_SPACE_INSIDE = c.SPACE_WITHIN_PARENTHESES;
        this.SET_ALIGN_EQUAL_SIGN = this.ALIGN_EQ_INSIDE_SET_CLAUSE;
        this.SELECT_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_SELECT);
        this.SELECT_KEEP_N_ITEMS_IN_LINE = this.WRAP_INSIDE_SELECT == 2 ? 0 : 7;
        this.SELECT_ALIGN_AS = this.ALIGN_AS_IN_SELECT_STATEMENT;
        this.FROM_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_JOIN_EXPRESSION);
        if (this.FROM_EL_WRAP == 3) {
            this.FROM_EL_WRAP = 2;
        }
        this.FROM_WRAP_JOIN_1 = this.NEW_LINE_BEFORE_JOIN;
        this.FROM_WRAP_JOIN_2 = this.NEW_LINE_BEFORE_JOIN;
        this.FROM_INDENT_JOIN = this.INDENT_JOIN;
        this.WHERE_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_WHERE);
        this.ORDER_EL_WRAP = SqlCodeStyleSettings.convertWrap(this.WRAP_INSIDE_ORDER_BY);
        this.ORDER_EL_COMMA = this.NEW_LINE_BEFORE_COMMA ? 1 : 2;
        this.FROM_EL_COMMA = this.ORDER_EL_COMMA;
        this.SELECT_EL_COMMA = this.ORDER_EL_COMMA;
        this.CORTEGE_SPACE_BEFORE_L_PAREN = c.SPACE_BEFORE_METHOD_PARENTHESES;
        this.CORTEGE_COMMA_1ST = this.NEW_LINE_BEFORE_COMMA;
        this.EXPR_SPACE_AROUND_OPERATOR = this.SPACES_AROUND_OPERATORS ? 1 : 2;
        this.EXPR_BINARY_OP_ALIGN = this.ALIGN_INSIDE_BINARY_EXPRESSION;
        this.EXPR_CASE_THEN_WRAP = this.NEW_LINE_BEFORE_THEN;
    }

    @NotNull
    private CommonCodeStyleSettings getCommonSettings() {
        CodeStyleSettings container = this.getContainer();
        assert (container != null) : "The container of SQL custom settings must not be null";
        CommonCodeStyleSettings commonCodeStyleSettings = container.getCommonSettings((Language)SqlLanguage.INSTANCE);
        if (commonCodeStyleSettings == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(6);
        }
        return commonCodeStyleSettings;
    }

    private static int countValue(int valueToCount, int ... values) {
        int m = 0;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            if (values[i] != valueToCount) continue;
            ++m;
        }
        return m;
    }

    @Contract(pure=true)
    private static int convertWrap(int oldWrap) {
        switch (oldWrap) {
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return 0;
    }

    public void manuallyChanged() {
        if (this.myVersion < 1) {
            LOG.info(String.format("SQL code style settings version updated from %d to %d (because they were manually changed)", this.myVersion, 1));
            this.myVersion = 1;
        }
    }

    private void assignDefaults(@NotNull SqlCodeStyleSettingsDefault def) {
        if (def == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(7);
        }
        this.assignModernDefaults(def);
        this.assignLegacyDefaults(def);
    }

    private void assignModernDefaults(@NotNull SqlCodeStyleSettingsDefault def) {
        if (def == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(8);
        }
        this.ALIAS_CASE = def.ALIAS_CASE;
        this.KEYWORD_CASE = def.KEYWORD_CASE;
        this.TYPE_CASE = def.TYPE_CASE;
        this.IDENTIFIER_CASE = def.IDENTIFIER_CASE;
        this.QUOTED_IDENTIFIER_CASE = def.QUOTED_IDENTIFIER_CASE;
        this.QUOTE_IDENTIFIER = def.QUOTE_IDENTIFIER;
        this.QUERY_SECTION_1ST_WORD_ALIGN = def.QUERY_SECTION_1ST_WORD_ALIGN;
        this.QUERY_EL_LINE = def.QUERY_EL_LINE;
        this.QUERY_IN_ONE_STRING = def.QUERY_IN_ONE_STRING;
        this.SUBQUERY_L_PAR_NL_OUTSIDE = def.SUBQUERY_L_PAR_NL_OUTSIDE;
        this.SUBQUERY_L_PAR_NL_INSIDE = def.SUBQUERY_L_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_NL_INSIDE = def.SUBQUERY_R_PAR_NL_INSIDE;
        this.SUBQUERY_R_PAR_ALIGN = def.SUBQUERY_R_PAR_ALIGN;
        this.SUBQUERY_INDENT_INSIDE = def.SUBQUERY_INDENT_INSIDE;
        this.SUBQUERY_PAR_SPACE_INSIDE = def.SUBQUERY_PAR_SPACE_INSIDE;
        this.INSERT_INTO_NL = def.INSERT_INTO_NL;
        this.INSERT_COLLAPSE_MULTI_ROW_VALUES = def.INSERT_COLLAPSE_MULTI_ROW_VALUES;
        this.SET_EL_WRAP = def.SET_EL_WRAP;
        this.SET_EL_COMMA = def.SET_EL_COMMA;
        this.SET_ALIGN_EQUAL_SIGN = def.SET_ALIGN_EQUAL_SIGN;
        this.WITH_EL_WRAP = def.WITH_EL_WRAP;
        this.WITH_EL_COMMA = def.WITH_EL_COMMA;
        this.WITH_ALIGN_AS = def.WITH_ALIGN_AS;
        this.SELECT_EL_WRAP = def.SELECT_EL_WRAP;
        this.SELECT_EL_COMMA = def.SELECT_EL_COMMA;
        this.SELECT_NEW_LINE_AFTER_ALL_DISTINCT = def.SELECT_NEW_LINE_AFTER_ALL_DISTINCT;
        this.SELECT_KEEP_N_ITEMS_IN_LINE = def.SELECT_KEEP_N_ITEMS_IN_LINE;
        this.SELECT_USE_AS_WORD = def.SELECT_USE_AS_WORD;
        this.SELECT_ALIGN_AS = def.SELECT_ALIGN_AS;
        this.FROM_EL_WRAP = def.FROM_EL_WRAP;
        this.FROM_EL_COMMA = def.FROM_EL_COMMA;
        this.FROM_WRAP_JOIN_1 = def.FROM_WRAP_JOIN_1;
        this.FROM_WRAP_JOIN_2 = def.FROM_WRAP_JOIN_2;
        this.FROM_WRAP_ON = def.FROM_WRAP_ON;
        this.FROM_ALIGN_JOIN_TABLES = def.FROM_ALIGN_JOIN_TABLES;
        this.FROM_ALIGN_ALIASES = def.FROM_ALIGN_ALIASES;
        this.FROM_INDENT_JOIN = def.FROM_INDENT_JOIN;
        this.WHERE_EL_WRAP = def.WHERE_EL_WRAP;
        this.WHERE_EL_BOUND = def.WHERE_EL_BOUND;
        this.ORDER_EL_WRAP = def.ORDER_EL_WRAP;
        this.ORDER_EL_COMMA = def.ORDER_EL_COMMA;
        this.ORDER_ALIGN_ASC_DESC = def.ORDER_ALIGN_ASC_DESC;
        this.CORTEGE_SPACE_BEFORE_L_PAREN = def.CORTEGE_SPACE_BEFORE_L_PAREN;
        this.CORTEGE_COMMA_1ST = def.CORTEGE_COMMA_1ST;
        this.CORTEGE_CLOSING = def.CORTEGE_CLOSING;
        this.EXPR_SPACE_AROUND_OPERATOR = def.EXPR_SPACE_AROUND_OPERATOR;
        this.EXPR_BINARY_OP_ALIGN = def.EXPR_BINARY_OP_ALIGN;
        this.EXPR_CASE_WHEN_WRAP = def.EXPR_CASE_WHEN_WRAP;
        this.EXPR_CASE_WHEN_INDENT = def.EXPR_CASE_WHEN_INDENT;
        this.EXPR_CASE_THEN_WRAP = def.EXPR_CASE_THEN_WRAP;
        this.EXPR_CASE_THEN_ALIGN = def.EXPR_CASE_THEN_ALIGN;
        this.EXPR_CASE_ELSE_ALIGN_THEN = def.EXPR_CASE_ELSE_ALIGN_THEN;
        this.EXPR_CASE_END = def.EXPR_CASE_END;
        this.EXPR_CASE_KEEP_NL_AFTER_THEN = def.EXPR_CASE_KEEP_NL_AFTER_THEN;
        this.EXPR_CASE_COLLAPSE = def.EXPR_CASE_COLLAPSE;
        this.INDEX_NAME_TEMPLATE = def.INDEX_NAME_TEMPLATE;
        this.PRIMARY_KEY_NAME_TEMPLATE = def.PRIMARY_KEY_NAME_TEMPLATE;
        this.FOREIGN_KEY_NAME_TEMPLATE = def.FOREIGN_KEY_NAME_TEMPLATE;
    }

    private void assignLegacyDefaults(@NotNull SqlCodeStyleSettingsDefault def) {
        if (def == null) {
            SqlCodeStyleSettings.$$$reportNull$$$0(9);
        }
        this.SPACES_AROUND_OPERATORS = def.SPACES_AROUND_OPERATORS;
        this.ALIGN_AS_IN_SELECT_STATEMENT = def.ALIGN_AS_IN_SELECT_STATEMENT;
        this.ALIGN_TYPE_IN_CREATE_STATEMENT = def.ALIGN_TYPE_IN_CREATE_STATEMENT;
        this.ALIGN_TYPE_IN_BLOCK_STATEMENT = def.ALIGN_TYPE_IN_BLOCK_STATEMENT;
        this.ALIGN_TYPE_IN_ARGUMENT_DEFINITION = def.ALIGN_TYPE_IN_ARGUMENT_DEFINITION;
        this.ALIGN_INSIDE_BINARY_EXPRESSION = def.ALIGN_INSIDE_BINARY_EXPRESSION;
        this.ALIGN_INSIDE_QUERY_EXPRESSION = def.ALIGN_INSIDE_QUERY_EXPRESSION;
        this.ALIGN_EQ_INSIDE_SET_CLAUSE = def.ALIGN_EQ_INSIDE_SET_CLAUSE;
        this.NEW_LINE_BEFORE_FROM = def.NEW_LINE_BEFORE_FROM;
        this.NEW_LINE_BEFORE_JOIN = def.NEW_LINE_BEFORE_JOIN;
        this.NEW_LINE_BEFORE_JOIN_CONDITION = def.NEW_LINE_BEFORE_JOIN_CONDITION;
        this.NEW_LINE_BEFORE_WHERE = def.NEW_LINE_BEFORE_WHERE;
        this.NEW_LINE_BEFORE_GROUP_BY = def.NEW_LINE_BEFORE_GROUP_BY;
        this.NEW_LINE_BEFORE_ORDER_BY = def.NEW_LINE_BEFORE_ORDER_BY;
        this.NEW_LINE_BEFORE_HAVING = def.NEW_LINE_BEFORE_HAVING;
        this.NEW_LINE_BEFORE_THEN = def.NEW_LINE_BEFORE_THEN;
        this.NEW_LINE_BEFORE_ELSE = def.NEW_LINE_BEFORE_ELSE;
        this.NEW_LINE_BEFORE_OTHER_CLAUSES = def.NEW_LINE_BEFORE_OTHER_CLAUSES;
        this.NEW_LINE_BEFORE_COMMA = def.NEW_LINE_BEFORE_COMMA;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS = def.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS;
        this.NEW_LINE_BEFORE_QUERY_INSIDE_DML = def.NEW_LINE_BEFORE_QUERY_INSIDE_DML;
        this.NEW_LINE_AROUND_SEMICOLON = def.NEW_LINE_AROUND_SEMICOLON;
        this.INDENT_JOIN = def.INDENT_JOIN;
        this.INDENT_JOIN_CONDITION = def.INDENT_JOIN_CONDITION;
        this.INDENT_SELECT_INTO_CLAUSE = def.INDENT_SELECT_INTO_CLAUSE;
        this.WRAP_INSIDE_CREATE_TABLE = def.WRAP_INSIDE_CREATE_TABLE;
        this.WRAP_INSIDE_SELECT = def.WRAP_INSIDE_SELECT;
        this.WRAP_INSIDE_JOIN_EXPRESSION = def.WRAP_INSIDE_JOIN_EXPRESSION;
        this.WRAP_INSIDE_GROUP_BY = def.WRAP_INSIDE_GROUP_BY;
        this.WRAP_INSIDE_WHERE = def.WRAP_INSIDE_WHERE;
        this.WRAP_INSIDE_ORDER_BY = def.WRAP_INSIDE_ORDER_BY;
        this.WRAP_INSIDE_SET = def.WRAP_INSIDE_SET;
        this.WRAP_INSIDE_ARGUMENT_DEFINITION = def.WRAP_INSIDE_ARGUMENT_DEFINITION;
        this.WRAP_INSIDE_CALL_EXPRESSION = def.WRAP_INSIDE_CALL_EXPRESSION;
        this.WRAP_INSIDE_VALUES_EXPRESSION = def.WRAP_INSIDE_VALUES_EXPRESSION;
        this.WRAP_VALUES_EXPRESSION = def.WRAP_VALUES_EXPRESSION;
        this.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES = def.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES;
        this.NEW_LINE_AFTER_SELECT = def.NEW_LINE_AFTER_SELECT;
        this.NEW_LINE_AFTER_SELECT_ITEM = def.NEW_LINE_AFTER_SELECT_ITEM;
        this.NEW_LINE_AFTER_SELECT_2 = def.NEW_LINE_AFTER_SELECT_2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseMode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseModeExt";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyleSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readIntAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readStringAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assignDefaults";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assignModernDefaults";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assignLegacyDefaults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

