/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestSnapshotReferenceLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public static final String TO_MATCH_SNAPSHOT = "toMatchSnapshot";

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result2) {
        RelatedItemLineMarkerInfo<PsiElement> info;
        JSReferenceExpression parentReferenceExpression;
        PsiElement parent;
        LeafPsiElement leaf;
        if (element == null) {
            JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element.isValid() && element instanceof LeafPsiElement && (leaf = (LeafPsiElement)element).getElementType() == JSTokenTypes.IDENTIFIER && leaf.textMatches((CharSequence)TO_MATCH_SNAPSHOT) && (parent = leaf.getParent()) instanceof JSReferenceExpression && (parentReferenceExpression = (JSReferenceExpression)parent).getQualifier() != null && parentReferenceExpression.getReferenceNameElement() == element && (info = JestSnapshotReferenceLineMarkerProvider.createNavigationMarkerIfNeeded(element)) != null) {
            result2.add(info);
        }
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiElement> createNavigationMarkerIfNeeded(@NotNull PsiElement element) {
        PsiFile snapshotPsiFile;
        JSFile testFile;
        if (element == null) {
            JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((testFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class)) == null || !testFile.isTestFile()) {
            return null;
        }
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(testFile);
        JsTestElementPath path = jasmineStructure.findTestElementPath(element.getTextRange());
        if (path == null) {
            return null;
        }
        VirtualFile snapshotFile = JestSnapshotReferenceLineMarkerProvider.findSnapshotFile(testFile.getVirtualFile());
        PsiFile psiFile = snapshotPsiFile = snapshotFile != null ? element.getManager().findFile(snapshotFile) : null;
        if (snapshotPsiFile == null) {
            return null;
        }
        final GutterIconNavigationHandler<PsiElement> navigationHandler = JestSnapshotReferenceLineMarkerProvider.createNavigationHandler(element.getProject(), snapshotFile, path);
        return new RelatedItemLineMarkerInfo(element, element.getTextRange(), JavaScriptLanguageIcons.Jest.SnapshotGutter, 11, (Function)new ConstantFunction((Object)("Go to '" + StringUtil.join((Collection)path.getAllNames(), (String)" ") + "' snapshot")), navigationHandler, GutterIconRenderer.Alignment.RIGHT, Collections.singletonList(new GotoRelatedItem((PsiElement)snapshotPsiFile, "Jest Snapshot"){

            public void navigate() {
                navigationHandler.navigate(null, (PsiElement)snapshotPsiFile);
            }
        }));
    }

    @NotNull
    private static GutterIconNavigationHandler<PsiElement> createNavigationHandler(@NotNull Project project, @NotNull VirtualFile snapshotFile, @NotNull JsTestElementPath path) {
        if (project == null) {
            JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (snapshotFile == null) {
            JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (path == null) {
            JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(5);
        }
        GutterIconNavigationHandler gutterIconNavigationHandler = (e, elt) -> {
            if (snapshotFile == null) {
                JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(7);
            }
            if (path == null) {
                JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(8);
            }
            if (project == null) {
                JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(9);
            }
            Document document = FileDocumentManager.getInstance().getDocument(snapshotFile);
            int offset = -1;
            if (document != null) {
                offset = document.getTextLength();
                String prefix = "exports[`";
                int ind = StringUtil.indexOf((CharSequence)document.getCharsSequence(), (CharSequence)(prefix + StringUtil.join((Collection)path.getAllNames(), (String)" ")));
                if (ind != -1) {
                    offset = ind + prefix.length();
                }
            }
            new OpenFileDescriptor(project, snapshotFile, offset).navigate(true);
        };
        if (gutterIconNavigationHandler == null) {
            JestSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(6);
        }
        return gutterIconNavigationHandler;
    }

    @Nullable
    private static VirtualFile findSnapshotFile(@Nullable VirtualFile testFile) {
        if (testFile == null) {
            return null;
        }
        VirtualFile dir = testFile.getParent();
        if (dir == null) {
            return null;
        }
        VirtualFile snapshotDir = dir.findChild("__snapshots__");
        if (snapshotDir != null) {
            return snapshotDir.findChild(testFile.getName() + ".snap");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotFile";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestSnapshotReferenceLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestSnapshotReferenceLineMarkerProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationMarkerIfNeeded";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationHandler";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createNavigationHandler$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

