/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.documentation;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.documentation.NodeJsPackageDocumentation;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.documentation.JSMarkdownUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.Range;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsPackageDocUtil {
    private NodeJsPackageDocUtil() {
    }

    @Nullable
    public static NodeJsPackageDocumentation createByPackageDir(@NotNull VirtualFile packageDir, boolean showReadme) {
        Holder holder;
        if (packageDir == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(0);
        }
        if ((holder = (Holder)ReadAction.compute(() -> {
            VirtualFile packageJson;
            if (packageDir == null) {
                NodeJsPackageDocUtil.$$$reportNull$$$0(21);
            }
            if ((packageJson = PackageJsonUtil.findChildPackageJsonFile(packageDir)) != null) {
                PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
                VirtualFile markdownFile = showReadme ? NodeJsPackageDocUtil.findReadmeMarkdownFile(packageDir) : null;
                return new Holder(NodeJsPackageDocUtil.getPackageName(packageDir), data.getDescription(), markdownFile);
            }
            return null;
        })) != null) {
            String html = NodeJsPackageDocUtil.generateHtml(holder.myReadmeMd);
            return new NodeJsPackageDocumentation(holder.myPackageName, holder.myDescription, html, packageDir);
        }
        return null;
    }

    @NotNull
    private static String getPackageName(@NotNull VirtualFile packageDir) {
        VirtualFile parent;
        if (packageDir == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(1);
        }
        if ((parent = packageDir.getParent()) == null || NodeModulesDirectoryManager.isNodeModulesDir(parent)) {
            String string = packageDir.getName();
            if (string == null) {
                NodeJsPackageDocUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String compoundName = parent.getName() + "/" + packageDir.getName();
        String string = compoundName.startsWith("@") ? compoundName : packageDir.getName();
        if (string == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static VirtualFile findReadmeMarkdownFile(@NotNull VirtualFile packageDir) {
        VirtualFile[] children;
        if (packageDir == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(4);
        }
        if ((children = packageDir.getChildren()) != null) {
            for (VirtualFile child : children) {
                String name;
                if (!child.isValid() || !(name = child.getName()).equalsIgnoreCase("readme.md") && !name.equalsIgnoreCase("readme.markdown")) continue;
                return child;
            }
        }
        return null;
    }

    @NotNull
    private static String loadText(@NotNull VirtualFile file2) throws IOException {
        Document document;
        if (file2 == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(5);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file2)) != null) {
            String string = document.getText();
            if (string == null) {
                NodeJsPackageDocUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = VfsUtilCore.loadText((VirtualFile)file2);
        if (string == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String generateHtml(@Nullable VirtualFile readmeMd) {
        if (readmeMd == null) {
            return null;
        }
        try {
            String markdown = NodeJsPackageDocUtil.loadText(readmeMd);
            if (StringUtil.isEmptyOrSpaces((String)markdown)) {
                return null;
            }
            markdown = NodeJsPackageDocUtil.removeUselessImageLinks(markdown);
            return JSMarkdownUtil.toHtml(markdown);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static String removeUselessImageLinks(@NotNull String markdown) {
        if (markdown == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(8);
        }
        List<String> lines = Arrays.asList(StringUtil.splitByLinesDontTrim((String)markdown));
        Range<Integer> uselessLines = NodeJsPackageDocUtil.findUselessLineRange(lines);
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            if (uselessLines != null && uselessLines.isWithin((Comparable)Integer.valueOf(i))) continue;
            String line = lines.get(i);
            String usefulLine = NodeJsPackageDocUtil.clearUselessLinks(line);
            if (!StringUtil.isEmptyOrSpaces((String)line) && StringUtil.isEmptyOrSpaces((String)usefulLine)) continue;
            result2.add(usefulLine);
        }
        String string = StringUtil.join(result2, (String)LineSeparator.LF.getSeparatorString());
        if (string == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static Range<Integer> findUselessLineRange(@NotNull List<String> lines) {
        if (lines == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(10);
        }
        Range<Integer> range = NodeJsPackageDocUtil.findImageLinkRange(lines, 0);
        while (range != null) {
            boolean found = false;
            for (int i = ((Integer)range.getFrom()).intValue(); i <= (Integer)range.getTo(); ++i) {
                String line = lines.get(i);
                if (!NodeJsPackageDocUtil.isUselessImageLink(line, new TextRange(0, line.length()))) continue;
                found = true;
                break;
            }
            if (found) {
                return range;
            }
            range = NodeJsPackageDocUtil.findImageLinkRange(lines, (Integer)range.getTo() + 1);
        }
        return null;
    }

    @NotNull
    private static String clearUselessLinks(@NotNull String line) {
        TextRange link;
        if (line == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(11);
        }
        if ((link = NodeJsPackageDocUtil.findUselessLink(line, 0)) == null) {
            String string = line;
            if (string == null) {
                NodeJsPackageDocUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        int lastLinkEnd = 0;
        StringBuilder result2 = new StringBuilder();
        while (link != null) {
            result2.append(line, lastLinkEnd, link.getStartOffset());
            lastLinkEnd = link.getEndOffset();
            link = NodeJsPackageDocUtil.findUselessLink(line, lastLinkEnd);
        }
        result2.append(line.substring(lastLinkEnd));
        String string = result2.toString();
        if (string == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    private static TextRange findUselessLink(@NotNull String text, int startIndex) {
        if (text == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(14);
        }
        TextRange link = NodeJsPackageDocUtil.findImageLink(text, startIndex);
        while (link != null && !NodeJsPackageDocUtil.isUselessImageLink(text, link)) {
            link = NodeJsPackageDocUtil.findImageLink(text, link.getEndOffset());
        }
        return link;
    }

    private static boolean isUselessImageLink(@NotNull String text, @NotNull TextRange link) {
        String linkText;
        if (text == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(15);
        }
        if (link == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(16);
        }
        return (linkText = link.substring(text)).contains("travis-ci.org/") || linkText.contains("coveralls.io/") || linkText.contains("img.shields.io/") || linkText.contains("snyk.io/") || linkText.contains("gitter.im/") || linkText.contains("david-dm.org/") || linkText.contains("gratipay") || linkText.contains("npmjs.org/") || linkText.contains("codersclan") || linkText.contains("ci.testling.com/") || linkText.contains("[npm-url]") || linkText.contains("[npm-url]") || linkText.contains("[travis-url]") || linkText.contains("[coveralls-url]") || linkText.contains("[depstat-url]") || linkText.contains("ci.appveyor.com/") || linkText.contains("discord.gg/") || linkText.contains("/nodei.co/");
    }

    @Nullable
    private static TextRange findImageLink(@NotNull String text, int startIndex) {
        int urlClosingInd;
        int titleClosingInd;
        int mdStartInd;
        int htmlImgEndInd;
        if (text == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(17);
        }
        TextRange htmlImgRange = null;
        int htmlImgStartInd = text.indexOf("<img ", startIndex);
        if (htmlImgStartInd >= 0 && (htmlImgEndInd = text.indexOf(">", htmlImgStartInd)) != -1) {
            htmlImgRange = new TextRange(htmlImgStartInd, htmlImgEndInd + 1);
        }
        if ((mdStartInd = text.indexOf("![", startIndex)) < 0 || htmlImgRange != null && htmlImgRange.getStartOffset() < mdStartInd) {
            return htmlImgRange;
        }
        int titleOpeningInd = mdStartInd + 1;
        if (mdStartInd > 0 && text.charAt(mdStartInd - 1) == '[') {
            mdStartInd = titleOpeningInd = mdStartInd - 1;
        }
        if ((titleClosingInd = NodeJsPackageDocUtil.findClosingInd(text, titleOpeningInd)) != -1 && (urlClosingInd = NodeJsPackageDocUtil.findClosingInd(text, titleClosingInd + 1)) != -1) {
            return new TextRange(mdStartInd, urlClosingInd + 1);
        }
        return null;
    }

    private static int findClosingInd(@NotNull String text, int openingInd) {
        int i;
        if (text == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(18);
        }
        int squareBrackets = 0;
        int parentheses = 0;
        boolean empty = true;
        for (i = openingInd; i < text.length() && (empty || squareBrackets > 0 || parentheses > 0); ++i) {
            char ch = text.charAt(i);
            if (ch == '[') {
                ++squareBrackets;
            } else if (ch == '(') {
                ++parentheses;
            } else if (ch == ']') {
                --squareBrackets;
            } else if (ch == ')') {
                --parentheses;
            }
            if (squareBrackets < 0 || parentheses < 0) {
                return -1;
            }
            if (empty && squareBrackets == 0 && parentheses == 0) {
                return -1;
            }
            empty = false;
        }
        return !empty && squareBrackets == 0 && parentheses == 0 ? i - 1 : -1;
    }

    @Nullable
    private static Range<Integer> findImageLinkRange(@NotNull List<String> lines, int startInd) {
        if (lines == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(19);
        }
        int rangeStartInd = -1;
        int rangeEndInd = -1;
        for (int i = startInd; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (NodeJsPackageDocUtil.isImageLinks(line)) {
                if (rangeStartInd == -1) {
                    rangeStartInd = i;
                }
                rangeEndInd = i;
                continue;
            }
            if (rangeStartInd != -1) break;
        }
        return rangeStartInd == -1 ? null : new Range((Comparable)Integer.valueOf(rangeStartInd), (Comparable)Integer.valueOf(rangeEndInd));
    }

    private static boolean isImageLinks(@NotNull String line) {
        if (line == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(20);
        }
        int i = 0;
        while (i < line.length()) {
            while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            TextRange link = NodeJsPackageDocUtil.findImageLink(line, i);
            if (link == null || link.getStartOffset() != i) break;
            i = link.getEndOffset();
        }
        while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        return i == line.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markdown";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeUselessImageLinks";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "clearUselessLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createByPackageDir";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findReadmeMarkdownFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeUselessImageLinks";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findUselessLineRange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clearUselessLinks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findUselessLink";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUselessImageLink";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findImageLink";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findClosingInd";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findImageLinkRange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isImageLinks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createByPackageDir$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private final String myPackageName;
        private final String myDescription;
        private final VirtualFile myReadmeMd;

        public Holder(@NotNull String packageName, @Nullable String description, @Nullable VirtualFile readmeMd) {
            if (packageName == null) {
                Holder.$$$reportNull$$$0(0);
            }
            this.myPackageName = packageName;
            this.myDescription = description;
            this.myReadmeMd = readmeMd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocUtil$Holder", "<init>"));
        }
    }
}

