/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeInterpreterUtil {
    private NodeInterpreterUtil() {
    }

    @Contract(value="null -> !null")
    public static String validateAndGetErrorMessage(@Nullable NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            return "Please specify Node.js interpreter";
        }
        return interpreter.validate(null);
    }

    public static void checkForRunConfiguration(@Nullable NodeJsInterpreter interpreter) throws RuntimeConfigurationError {
        String errorMessage = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter);
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }

    @NotNull
    public static String convertPath(@NotNull String path, @Nullable NodeJsInterpreter interpreter) {
        if (path == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(0);
        }
        String string = NodeInterpreterUtil.convertLocalPathToRemote(path, interpreter);
        if (string == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String convertLocalPathToRemote(@NotNull String path, @Nullable NodeJsInterpreter interpreter) {
        WSLDistribution distribution;
        String wslPath;
        if (path == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(2);
        }
        if (interpreter instanceof WslNodeInterpreter && (wslPath = (distribution = Objects.requireNonNull(((WslNodeInterpreter)interpreter).getDistribution())).getWslPath(path)) != null) {
            String string = wslPath;
            if (string == null) {
                NodeInterpreterUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String convertRemotePathToLocal(@NotNull String path, @Nullable NodeJsInterpreter interpreter) {
        WSLDistribution distribution;
        String wslPath;
        if (path == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(5);
        }
        if (interpreter instanceof WslNodeInterpreter && (wslPath = (distribution = Objects.requireNonNull(((WslNodeInterpreter)interpreter).getDistribution())).getWindowsPath(path)) != null) {
            String string = wslPath;
            if (string == null) {
                NodeInterpreterUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static NodeJsInterpreter getValidInterpreterOrThrow(@Nullable NodeJsInterpreter interpreter) throws ExecutionException {
        String error = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter);
        if (error != null) {
            throw new ExecutionException(error);
        }
        NodeJsInterpreter nodeJsInterpreter = interpreter;
        if (nodeJsInterpreter == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(8);
        }
        return nodeJsInterpreter;
    }

    @NotNull
    public static String toRemoteName(@NotNull String path, @Nullable NodeJsInterpreter interpreter) {
        if (path == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(9);
        }
        if (interpreter instanceof WslNodeInterpreter) {
            String string = FileUtil.toSystemIndependentName((String)path);
            if (string == null) {
                NodeInterpreterUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeInterpreterUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeInterpreterUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLocalPathToRemote";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRemotePathToLocal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidInterpreterOrThrow";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toRemoteName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertLocalPathToRemote";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertRemotePathToLocal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toRemoteName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

