/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;

public class NodeModulesDirectoryScanner {
    private static final ExecutorService POOL = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Node_Modules Scanner");
    private final BlockingQueue<VirtualFile> myQueue;
    private final Project myProject;
    private final FileIndex myFileIndex;
    private Future<?> myFeature;

    public NodeModulesDirectoryScanner(@NotNull Project project, @NotNull ProjectFileIndex fileIndex) {
        if (project == null) {
            NodeModulesDirectoryScanner.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            NodeModulesDirectoryScanner.$$$reportNull$$$0(1);
        }
        this.myQueue = new LinkedBlockingQueue<VirtualFile>();
        this.myProject = project;
        this.myFileIndex = fileIndex;
    }

    public void findNodeModulesUnderDirectory(@NotNull VirtualFile dir, @NotNull Consumer<VirtualFile> nodeModulesDirConsumer, @NotNull Consumer<VirtualFile> packageJsonFileConsumer) {
        if (dir == null) {
            NodeModulesDirectoryScanner.$$$reportNull$$$0(2);
        }
        if (nodeModulesDirConsumer == null) {
            NodeModulesDirectoryScanner.$$$reportNull$$$0(3);
        }
        if (packageJsonFileConsumer == null) {
            NodeModulesDirectoryScanner.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.findNodeModulesUnderDirectories(Collections.singleton(dir), nodeModulesDirConsumer, packageJsonFileConsumer);
        } else {
            this.myQueue.add(dir);
            if (this.myFeature != null) {
                this.myFeature.cancel(false);
            }
            this.myFeature = POOL.submit(() -> {
                if (nodeModulesDirConsumer == null) {
                    NodeModulesDirectoryScanner.$$$reportNull$$$0(11);
                }
                if (packageJsonFileConsumer == null) {
                    NodeModulesDirectoryScanner.$$$reportNull$$$0(12);
                }
                ReadAction.run(() -> {
                    if (nodeModulesDirConsumer == null) {
                        NodeModulesDirectoryScanner.$$$reportNull$$$0(13);
                    }
                    if (packageJsonFileConsumer == null) {
                        NodeModulesDirectoryScanner.$$$reportNull$$$0(14);
                    }
                    HashSet dirs = ContainerUtil.newHashSet();
                    this.myQueue.drainTo(dirs);
                    this.findNodeModulesUnderDirectories(dirs, nodeModulesDirConsumer, packageJsonFileConsumer);
                });
            });
        }
    }

    private void findNodeModulesUnderDirectories(@NotNull Set<VirtualFile> dirs, @NotNull Consumer<VirtualFile> nodeModulesDirConsumer, @NotNull Consumer<VirtualFile> packageJsonFileConsumer) {
        if (dirs == null) {
            NodeModulesDirectoryScanner.$$$reportNull$$$0(5);
        }
        if (nodeModulesDirConsumer == null) {
            NodeModulesDirectoryScanner.$$$reportNull$$$0(6);
        }
        if (packageJsonFileConsumer == null) {
            NodeModulesDirectoryScanner.$$$reportNull$$$0(7);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile dir : dirs) {
            this.myFileIndex.iterateContentUnderDirectory(dir, descendant -> true, child -> {
                if (nodeModulesDirConsumer == null) {
                    NodeModulesDirectoryScanner.$$$reportNull$$$0(8);
                }
                if (packageJsonFileConsumer == null) {
                    NodeModulesDirectoryScanner.$$$reportNull$$$0(9);
                }
                if (dirs == null) {
                    NodeModulesDirectoryScanner.$$$reportNull$$$0(10);
                }
                if (NodeModulesDirectoryManager.isNodeModulesDir(child)) {
                    nodeModulesDirConsumer.consume((Object)child);
                    return false;
                }
                if (PackageJsonUtil.isPackageJsonFile(child)) {
                    packageJsonFileConsumer.consume((Object)child);
                    return false;
                }
                return dir.equals(child) || !dirs.contains(child);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirConsumer";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFileConsumer";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findNodeModulesUnderDirectory";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findNodeModulesUnderDirectories";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findNodeModulesUnderDirectories$3";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findNodeModulesUnderDirectory$1";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

