/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryUtil;
import com.intellij.javascript.nodejs.library.NodeJsCoreModulesCatalog;
import com.intellij.javascript.nodejs.library.core.NodeJsCoreSourcesFetchSession;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsCoreLibraryConfigurator {
    static final Logger LOG = Logger.getInstance(NodeJsCoreLibraryConfigurator.class);
    private static final String NODE_CORE_LIBRARY_CONFIGURED_VERSION = "javascript.nodejs.core.library.configured.version";
    private final Project myProject;
    private volatile List<VirtualFile> myTestCoreModuleFiles;

    public NodeJsCoreLibraryConfigurator(@NotNull Project project) {
        if (project == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public static NodeJsCoreLibraryConfigurator getInstance(@NotNull Project project) {
        if (project == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(1);
        }
        NodeJsCoreLibraryConfigurator nodeJsCoreLibraryConfigurator = (NodeJsCoreLibraryConfigurator)ServiceManager.getService((Project)project, NodeJsCoreLibraryConfigurator.class);
        if (nodeJsCoreLibraryConfigurator == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(2);
        }
        return nodeJsCoreLibraryConfigurator;
    }

    @Nullable
    public SemVer getConfiguredCoreLibraryVersion() {
        String value = this.getConfiguredCoreLibraryVersionStr();
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return null;
        }
        return SemVer.parseFromText((String)value);
    }

    @NotNull
    private String getConfiguredCoreLibraryVersionStr() {
        String value = PropertiesComponent.getInstance((Project)this.myProject).getValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION);
        String string = StringUtil.notNullize((String)value);
        if (string == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void setCoreLibraryConfigured(@NotNull String version) {
        if (version == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(4);
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION, version, null);
    }

    private void configure(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        if (interpreter == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(5);
        }
        if (version == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(6);
        }
        if (rootsToAssociateWith == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(7);
        }
        try {
            LOG.info("configure(" + interpreter.getPresentableName() + ", " + version + ")");
            String versionStr = version.getRawVersion();
            File coreModulesSrcDir = NodeJsCoreLibraryConfigurator.getCoreModulesSrcDir(versionStr);
            FileUtil.delete((File)coreModulesSrcDir);
            FileUtil.createDirectory((File)coreModulesSrcDir);
            NodeJsCoreSourcesFetchSession session = new NodeJsCoreSourcesFetchSession(this.myProject, interpreter, coreModulesSrcDir);
            session.fetchSourcesSync();
            this.setCoreLibraryConfigured(versionStr);
            NodeJsCoreLibraryConfigurator.refreshIfNeeded(coreModulesSrcDir, () -> {
                if (rootsToAssociateWith == null) {
                    NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(35);
                }
                this.scheduleLibrariesUpdate(true, rootsToAssociateWith, onDone);
            });
        }
        catch (ExecutionException | IOException e) {
            LOG.warn("Cannot configure Node.js Core library", e);
            this.scheduleLibrariesUpdate(false, rootsToAssociateWith, onDone);
        }
    }

    private static void refreshIfNeeded(@NotNull File coreModulesSrcDir, @NotNull Runnable finishRunnable) {
        if (coreModulesSrcDir == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(8);
        }
        if (finishRunnable == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(9);
        }
        boolean refreshNeeded = NodeJsCoreLibraryConfigurator.isRefreshNeeded(coreModulesSrcDir);
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
            if (coreModulesSrcDir == null) {
                NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(31);
            }
            if (finishRunnable == null) {
                NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(32);
            }
            WriteAction.run(() -> {
                if (coreModulesSrcDir == null) {
                    NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(33);
                }
                if (finishRunnable == null) {
                    NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(34);
                }
                if (refreshNeeded) {
                    VirtualFile coreModulesDirVirtualDir = VfsUtil.findFileByIoFile((File)coreModulesSrcDir, (boolean)true);
                    if (coreModulesDirVirtualDir == null) {
                        LOG.warn("Cannot find virtual file for " + coreModulesSrcDir.getAbsolutePath() + ", refresh skipped");
                    } else {
                        LOG.info("Refreshing " + coreModulesDirVirtualDir.getPath());
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{coreModulesDirVirtualDir});
                    }
                }
                finishRunnable.run();
            });
        });
    }

    private static boolean isRefreshNeeded(@NotNull File coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(10);
        }
        List<File> ioFiles = NodeJsCoreLibraryConfigurator.listAllCoreModulesFiles(coreModulesSrcDir.listFiles());
        for (File ioFile : ioFiles) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            if (file2 != null && file2.isValid()) continue;
            return true;
        }
        return false;
    }

    private void scheduleLibrariesUpdate(boolean success, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        if (rootsToAssociateWith == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(11);
        }
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> {
            if (rootsToAssociateWith == null) {
                NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(30);
            }
            WriteAction.run(() -> {
                boolean changed = NodeJsCoreLibraryUtil.removeOldLibraries(this.myProject);
                if (success || changed) {
                    JSLibraryManager.getInstance(this.myProject).commitChanges();
                }
            });
            if (success) {
                this.associateWith(rootsToAssociateWith);
            }
            if (onDone != null) {
                ApplicationManager.getApplication().invokeLater(onDone, ModalityState.any(), Condition.FALSE);
            }
        });
    }

    private void associateWith(@NotNull List<VirtualFile> rootsToAssociateWith) {
        if (rootsToAssociateWith == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(12);
        }
        JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(this.myProject);
        for (VirtualFile root : rootsToAssociateWith) {
            libraryMappings.associate(root, "Node.js Core", true);
            LOG.info("Library 'Node.js Core' have been associated with " + (root == null ? "project" : root.getPath()));
        }
    }

    @NotNull
    private static File getCoreModulesSrcDir(@NotNull String versionStr) {
        if (versionStr == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(13);
        }
        File file2 = new File(JSUtils.getConfigJavaScriptDirPath() + File.separatorChar + "nodejs" + File.separatorChar + versionStr + File.separatorChar + "core-modules");
        if (file2 == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(14);
        }
        return file2;
    }

    @NotNull
    private static ScriptingLibraryModel createLibraryModel(@NotNull File coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(15);
        }
        List<VirtualFile> allCoreModulesFiles = NodeJsCoreLibraryConfigurator.listAllCoreModulesFiles(coreModulesSrcDir);
        List compactFiles = ContainerUtil.filter(allCoreModulesFiles, file2 -> NodeJsCoreModulesCatalog.INSTANCE.isPublicExcludedCoreModule(file2.getNameWithoutExtension()));
        ArrayList sourceFiles = ContainerUtil.newArrayList(allCoreModulesFiles);
        sourceFiles.removeAll(compactFiles);
        sourceFiles.addAll(NodeJsCoreLibraryUtil.getNodeGlobalStubFiles());
        NodeCoreLibraryModel nodeCoreLibraryModel = new NodeCoreLibraryModel(sourceFiles, compactFiles);
        if (nodeCoreLibraryModel == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(16);
        }
        return nodeCoreLibraryModel;
    }

    @NotNull
    private static List<VirtualFile> listAllCoreModulesFiles(@NotNull File coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(17);
        }
        if (coreModulesSrcDir.isDirectory()) {
            List<File> files = NodeJsCoreLibraryConfigurator.listAllCoreModulesFiles(coreModulesSrcDir.listFiles());
            List<VirtualFile> list = NodeJsCoreLibraryConfigurator.toVirtualFiles(files);
            if (list == null) {
                NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private static List<File> listAllCoreModulesFiles(@Nullable File[] allFiles) {
        if (allFiles == null || allFiles.length == 0) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(20);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)allFiles.length);
        for (File file2 : allFiles) {
            String name;
            if (!file2.isFile() || !NodeJsCoreModulesCatalog.INSTANCE.isPublicCoreModule(name = FileUtil.getNameWithoutExtension((String)file2.getName())) && !NodeJsCoreModulesCatalog.INSTANCE.isPrivateIncludedCoreModule(name)) continue;
            result2.add(file2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> toVirtualFiles(@NotNull List<File> files) {
        if (files == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(22);
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)files.size());
        for (File file2 : files) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
            if (virtualFile == null || !virtualFile.isValid()) {
                LOG.warn("Cannot find virtual file by " + file2.getAbsolutePath());
                continue;
            }
            result2.add(virtualFile);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    public void setCoreModulesForTests(VirtualFile ... testCoreModuleFiles) {
        if (testCoreModuleFiles == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(24);
        }
        this.myTestCoreModuleFiles = Arrays.asList(testCoreModuleFiles);
        JSLibraryManager.getInstance(this.myProject).commitChanges();
    }

    public void removeAllCoreModulesForTests() {
        this.myTestCoreModuleFiles = null;
        JSLibraryManager.getInstance(this.myProject).commitChanges();
    }

    public void configureAndAssociateWithProject(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @Nullable Runnable onDone) {
        if (interpreter == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(25);
        }
        if (version == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(26);
        }
        this.configureAndAssociateWith(interpreter, version, Collections.singletonList(null), onDone);
    }

    public void configureAndAssociateWith(final @NotNull NodeJsInterpreter interpreter, final @NotNull SemVer version, final @NotNull List<VirtualFile> rootsToAssociateWith, final @Nullable Runnable onDone) {
        if (interpreter == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(27);
        }
        if (version == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(28);
        }
        if (rootsToAssociateWith == null) {
            NodeJsCoreLibraryConfigurator.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        new Task.Modal(this.myProject, "Configuring Node.js Support...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                NodeJsCoreLibraryConfigurator.this.configure(interpreter, version, rootsToAssociateWith, onDone);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/nodejs/library/core/NodeJsCoreLibraryConfigurator$1", "run"));
            }
        }.setCancelText("Cancel").queue();
    }

    public void disable() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String version = this.getConfiguredCoreLibraryVersionStr();
        if (StringUtil.isNotEmpty((String)version)) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                PropertiesComponent.getInstance((Project)this.myProject).unsetValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION);
                JSLibraryManager.getInstance(this.myProject).commitChanges();
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeJsCoreLibraryConfigurator";
                break;
            }
            case 4: 
            case 6: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAssociateWith";
                break;
            }
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreModulesSrcDir";
                break;
            }
            case 9: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishRunnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionStr";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCoreModuleFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeJsCoreLibraryConfigurator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredCoreLibraryVersionStr";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreModulesSrcDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryModel";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllCoreModulesFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toVirtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCoreLibraryConfigured";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshIfNeeded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isRefreshNeeded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scheduleLibrariesUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "associateWith";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCoreModulesSrcDir";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryModel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "listAllCoreModulesFiles";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "toVirtualFiles";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setCoreModulesForTests";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "configureAndAssociateWithProject";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "configureAndAssociateWith";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleLibrariesUpdate$4";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshIfNeeded$2";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configure$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeCoreLibraryModel
    extends ScriptingLibraryModel {
        public NodeCoreLibraryModel(@NotNull List<VirtualFile> sourceFiles, @NotNull List<VirtualFile> compactFiles) {
            if (sourceFiles == null) {
                NodeCoreLibraryModel.$$$reportNull$$$0(0);
            }
            if (compactFiles == null) {
                NodeCoreLibraryModel.$$$reportNull$$$0(1);
            }
            super("Node.js Core", VfsUtilCore.toVirtualFileArray(sourceFiles), VfsUtilCore.toVirtualFileArray(compactFiles), ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PREDEFINED, false);
        }

        public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result2) {
            if (result2 == null) {
                NodeCoreLibraryModel.$$$reportNull$$$0(2);
            }
            result2.addAll(NodeJsCoreLibraryUtil.getNodeGlobalStubFiles());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFiles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compactFiles";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeJsCoreLibraryConfigurator$NodeCoreLibraryModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectFilesWithGlobalDefinitions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NodeJsCorePredefinedLibraryProvider
    extends JSPredefinedLibraryProvider {
        @Override
        @NotNull
        public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
            if (project == null) {
                NodeJsCorePredefinedLibraryProvider.$$$reportNull$$$0(0);
            }
            NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance(project);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                List coreModuleFiles = configurator.myTestCoreModuleFiles;
                if (coreModuleFiles == null) {
                    NodeJsCoreLibraryManager.getInstance(project).setScriptingLibraryModel(null);
                    if (ScriptingLibraryModel.EMPTY_ARRAY == null) {
                        NodeJsCorePredefinedLibraryProvider.$$$reportNull$$$0(1);
                    }
                    return ScriptingLibraryModel.EMPTY_ARRAY;
                }
                ArrayList result2 = ContainerUtil.newArrayList((Iterable)coreModuleFiles);
                result2.addAll(NodeJsCoreLibraryUtil.getNodeGlobalStubFiles());
                NodeCoreLibraryModel libraryModel = new NodeCoreLibraryModel(result2, Collections.emptyList());
                NodeJsCoreLibraryManager.getInstance(project).setScriptingLibraryModel(libraryModel);
                ScriptingLibraryModel[] scriptingLibraryModelArray = new ScriptingLibraryModel[]{libraryModel};
                if (scriptingLibraryModelArray == null) {
                    NodeJsCorePredefinedLibraryProvider.$$$reportNull$$$0(2);
                }
                return scriptingLibraryModelArray;
            }
            String version = configurator.getConfiguredCoreLibraryVersionStr();
            if (StringUtil.isEmptyOrSpaces((String)version)) {
                NodeJsCoreLibraryManager.getInstance(project).setScriptingLibraryModel(null);
                if (ScriptingLibraryModel.EMPTY_ARRAY == null) {
                    NodeJsCorePredefinedLibraryProvider.$$$reportNull$$$0(3);
                }
                return ScriptingLibraryModel.EMPTY_ARRAY;
            }
            File coreModulesSrcDir = NodeJsCoreLibraryConfigurator.getCoreModulesSrcDir(version);
            ScriptingLibraryModel libraryModel = NodeJsCoreLibraryConfigurator.createLibraryModel(coreModulesSrcDir);
            NodeJsCoreLibraryManager.getInstance(project).setScriptingLibraryModel(libraryModel);
            ScriptingLibraryModel[] scriptingLibraryModelArray = new ScriptingLibraryModel[]{libraryModel};
            if (scriptingLibraryModelArray == null) {
                NodeJsCorePredefinedLibraryProvider.$$$reportNull$$$0(4);
            }
            return scriptingLibraryModelArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeJsCoreLibraryConfigurator$NodeJsCorePredefinedLibraryProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeJsCoreLibraryConfigurator$NodeJsCorePredefinedLibraryProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPredefinedLibraries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPredefinedLibraries";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

