/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeVmConnectionFactory;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.NodeJsCoreModulesCatalog;
import com.intellij.javascript.nodejs.library.core.NodeJsCoreLibraryConfigurator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;

public class NodeJsCoreSourcesFetchSession {
    private static final Logger LOG = NodeJsCoreLibraryConfigurator.LOG;
    private static final String CONTENT_SUFFIX = "});";
    private final Project myProject;
    private final NodeJsInterpreter myInterpreter;
    private final File myOutputDir;
    private File myWorkingDirectory;

    public NodeJsCoreSourcesFetchSession(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull File outputDir) {
        if (project == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(1);
        }
        if (outputDir == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myInterpreter = interpreter;
        this.myOutputDir = outputDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchSourcesSync() throws IOException, ExecutionException {
        long startNanoTime = System.nanoTime();
        int debugPort = NetUtils.findAvailableSocketPort();
        GeneralCommandLine commandLine = this.createCommandLine(debugPort);
        NodeCommandLineConfigurator.find(this.myInterpreter).configure(commandLine);
        LOG.info("Running " + commandLine.getCommandLineString());
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
        try {
            MyProcessListener listener2 = new MyProcessListener();
            processHandler.addProcessListener((ProcessListener)listener2);
            processHandler.startNotify();
            listener2.awaitReady();
            this.attachDebuggerSync(debugPort, NodeCommandLineUtil.shouldUseInspectorProtocol(commandLine));
        }
        finally {
            NodeJsCoreSourcesFetchSession.terminateSync((OSProcessHandler)processHandler);
        }
        FileUtil.delete((File)this.myWorkingDirectory);
        LOG.info("Done in " + TimeoutUtil.getDurationMillis((long)startNanoTime) + " ms, located in " + this.myOutputDir.getAbsolutePath());
    }

    private static void terminateSync(@NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(3);
        }
        ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)2000L, null);
    }

    private void attachDebuggerSync(int debugPort, boolean useInspectorProtocol) throws IOException, ExecutionException {
        List scripts;
        NodeVmConnectionFactory connectionFactory = (NodeVmConnectionFactory)ServiceManager.getService(NodeVmConnectionFactory.class);
        if (connectionFactory == null) {
            throw new ExecutionException("Please make sure 'JavaScript Debugger' plugin is enabled");
        }
        RemoteVmConnection connection = connectionFactory.createVmConnection(useInspectorProtocol);
        Vm vm = RemoteVmConnectionKt.initRemoteVmConnectionSync((RemoteVmConnection)connection, (int)debugPort);
        try {
            Promise<List<Pair<String, String>>> promise = NodeJsCoreSourcesFetchSession.fetchScripts(vm);
            scripts = (List)Objects.requireNonNull(promise.blockingGet(120, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to fetch node core modules", (Throwable)e);
        }
        for (Pair script : scripts) {
            String fileName = NodeJsCoreSourcesFetchSession.getFileNameToSave((String)script.getFirst());
            if (fileName == null) continue;
            File outFile = new File(this.myOutputDir, fileName);
            String content = NodeJsCoreSourcesFetchSession.refine((String)script.second);
            FileUtil.writeToFile((File)outFile, (String)content);
        }
    }

    @NotNull
    private static Promise<List<Pair<String, String>>> fetchScripts(@NotNull Vm vm) {
        if (vm == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(4);
        }
        AsyncPromise promise = new AsyncPromise();
        NodeJsCoreSourcesFetchSession.doWhenScriptLoadingSettlesDown(vm, System.currentTimeMillis(), 0, () -> {
            if (vm == null) {
                NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(17);
            }
            List<Script> scripts = NodeJsCoreSourcesFetchSession.listLoadedScripts(vm);
            CopyOnWriteArrayList data = new CopyOnWriteArrayList();
            CountDownLatch contentsLatch = new CountDownLatch(scripts.size());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (vm == null) {
                    NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(18);
                }
                for (Script script : scripts) {
                    vm.getScriptManager().getSource(script).onProcessed(content -> {
                        if (content == null) {
                            LOG.info("Cannot load content for " + script);
                        } else {
                            data.add(Pair.create((Object)script.getUrl().getPath(), (Object)content));
                        }
                        contentsLatch.countDown();
                    });
                }
            });
            try {
                contentsLatch.await(110L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                promise.setError((Throwable)e);
            }
            LOG.info("Loaded " + data.size() + " scripts with content");
            promise.setResult(data);
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(5);
        }
        return asyncPromise;
    }

    /*
     * WARNING - void declaration
     */
    private static void doWhenScriptLoadingSettlesDown(@NotNull Vm vm, long startTimeMillis, int prevLoadedScriptCount, @NotNull Runnable runnable) {
        void onReady;
        if (vm == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(7);
        }
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> NodeJsCoreSourcesFetchSession.lambda$doWhenScriptLoadingSettlesDown$3(vm, prevLoadedScriptCount, (Runnable)onReady, startTimeMillis), prevLoadedScriptCount == 0 ? 200L : 700L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    private static List<Script> listLoadedScripts(@NotNull Vm vm) {
        if (vm == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(8);
        }
        ArrayList<Script> scripts = new ArrayList<Script>();
        vm.getScriptManager().forEachScript(script -> {
            scripts.add((Script)script);
            return true;
        });
        ArrayList<Script> arrayList = scripts;
        if (arrayList == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static String getFileNameToSave(@NotNull String scriptPath) {
        NodeJsCoreModulesCatalog catalog;
        String name;
        if (scriptPath == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(10);
        }
        if ((name = (catalog = NodeJsCoreModulesCatalog.INSTANCE).getPublicReplacementName(scriptPath)) != null) {
            return name;
        }
        if (StringUtil.containsAnyChar((String)scriptPath, (String)"/\\")) {
            return null;
        }
        String moduleName = FileUtil.getNameWithoutExtension((String)scriptPath);
        if (catalog.isIncludedCoreModule(moduleName)) {
            return scriptPath;
        }
        return scriptPath.startsWith("_") ? null : scriptPath;
    }

    private static String refine(@NotNull String source) {
        String prefix;
        if (source == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(11);
        }
        if ((prefix = NodeJsCoreSourcesFetchSession.findPrefixToRemove(source = source.trim())) != null && source.endsWith(CONTENT_SUFFIX)) {
            return source.substring(prefix.length(), source.length() - CONTENT_SUFFIX.length());
        }
        return source;
    }

    @Nullable
    private static String findPrefixToRemove(@NotNull String source) {
        char ch;
        int lastPrefixCharInd;
        String start;
        if (source == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(12);
        }
        if (!source.startsWith(start = "(function (")) {
            return null;
        }
        int paramsStartInd = start.length();
        int paramsEndInd = source.indexOf(")", paramsStartInd);
        if (paramsEndInd == -1) {
            return null;
        }
        String params = source.substring(paramsStartInd, paramsEndInd);
        if (!params.contains("require")) {
            return null;
        }
        int openBraceInd = source.indexOf(123, paramsEndInd + 1);
        if (openBraceInd == -1) {
            return null;
        }
        if (!source.substring(paramsEndInd + 1, openBraceInd).trim().isEmpty()) {
            return null;
        }
        for (lastPrefixCharInd = openBraceInd + 1; lastPrefixCharInd < source.length() && (ch = source.charAt(lastPrefixCharInd)) != '\n'; ++lastPrefixCharInd) {
            if (Character.isWhitespace(ch)) continue;
            --lastPrefixCharInd;
            break;
        }
        if (lastPrefixCharInd >= source.length()) {
            return null;
        }
        return source.substring(0, lastPrefixCharInd + 1);
    }

    @NotNull
    private GeneralCommandLine createCommandLine(int debugPort) throws IOException, ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        this.myWorkingDirectory = NodeJsCoreSourcesFetchSession.createWorkingDirectory();
        commandLine.setWorkDirectory(this.myWorkingDirectory.getAbsolutePath());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setRedirectErrorStream(true);
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, Collections.emptyList(), debugPort, false, this.myInterpreter, true);
        File script = HelperFilesLocator.getFileRelativeToHelpersDir("node-core-modules/node-core-modules-loader.js");
        commandLine.addParameter(script.getAbsolutePath());
        commandLine.addParameters(NodeJsCoreModulesCatalog.INSTANCE.getPublicCoreModules());
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(13);
        }
        return generalCommandLine;
    }

    @NotNull
    private static File createWorkingDirectory() throws IOException {
        File file2 = FileUtil.createTempDirectory((String)"intellij-node-core-modules-", null, (boolean)true);
        if (file2 == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(14);
        }
        return file2;
    }

    private static /* synthetic */ void lambda$doWhenScriptLoadingSettlesDown$3(@NotNull Vm vm, int prevLoadedScriptCount, @NotNull Runnable onReady, long startTimeMillis) {
        if (vm == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(15);
        }
        if (onReady == null) {
            NodeJsCoreSourcesFetchSession.$$$reportNull$$$0(16);
        }
        List<Script> scripts = NodeJsCoreSourcesFetchSession.listLoadedScripts(vm);
        int loadedScriptCount = scripts.size();
        LOG.info("Loaded " + loadedScriptCount + " scripts, previously " + prevLoadedScriptCount);
        if (loadedScriptCount > 0 && loadedScriptCount == prevLoadedScriptCount) {
            onReady.run();
            return;
        }
        if (System.currentTimeMillis() - startTimeMillis > TimeUnit.SECONDS.toMillis(10L)) {
            LOG.info("Stop waiting for new loaded scripts");
            onReady.run();
            return;
        }
        NodeJsCoreSourcesFetchSession.doWhenScriptLoadingSettlesDown(vm, startTimeMillis, loadedScriptCount, onReady);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vm";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeJsCoreSourcesFetchSession";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onReady";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeJsCoreSourcesFetchSession";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchScripts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "listLoadedScripts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "terminateSync";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchScripts";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doWhenScriptLoadingSettlesDown";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "listLoadedScripts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileNameToSave";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "refine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findPrefixToRemove";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWhenScriptLoadingSettlesDown$3";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetchScripts$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProcessListener
    extends ProcessAdapter {
        private static final String READY_MESSAGE = "@debugger: core modules loaded, ready for communication";
        private final StringBuffer myStdOutBuffer = new StringBuffer();
        private final CountDownLatch myReadyLatch = new CountDownLatch(1);

        private MyProcessListener() {
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            String text;
            if (event == null) {
                MyProcessListener.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                MyProcessListener.$$$reportNull$$$0(1);
            }
            if ((text = StringUtil.notNullize((String)event.getText())).isEmpty() || outputType == ProcessOutputTypes.SYSTEM) {
                return;
            }
            String logPrefix = outputType == ProcessOutputTypes.STDERR ? "[stderr] " : "[stdout] ";
            LOG.info(logPrefix + StringUtil.trimEnd((String)text, (String)"\n"));
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myStdOutBuffer.append(text);
                if (this.isReady()) {
                    this.myReadyLatch.countDown();
                }
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MyProcessListener.$$$reportNull$$$0(2);
            }
            LOG.info("Process terminated with exit code " + event.getExitCode());
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.myReadyLatch.countDown(), 2L, TimeUnit.SECONDS);
        }

        private boolean isReady() {
            return this.myStdOutBuffer.indexOf(READY_MESSAGE) >= 0;
        }

        public void awaitReady() throws ExecutionException {
            try {
                boolean ready = this.myReadyLatch.await(60L, TimeUnit.SECONDS);
                if (!ready) {
                    throw new ExecutionException("Cannot fetch core modules: timed out");
                }
                if (!this.isReady()) {
                    throw new ExecutionException("Not ready for core modules configuration");
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeJsCoreSourcesFetchSession$MyProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

