/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class NpmRegistryServiceImpl
extends NpmRegistryService {
    private static final String USER_AGENT = "JetBrains IDE";
    private static final Logger LOG = Logger.getInstance(NpmRegistryServiceImpl.class);
    private static final String LATEST_DIST_TAG = "latest";
    private final ConcurrentMap<String, TimestampedDistTags> myDistTagsCache = ContainerUtil.createConcurrentSoftMap();
    private final ConcurrentMap<String, Future<DistTags>> myRunningFutures = ContainerUtil.newConcurrentMap();
    private final ExecutorService myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Npm Registry Pool", (int)2);

    @Override
    public void findPackagesByPrefix(@Nullable ProgressIndicator indicator, @NotNull String prefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) throws IOException, ProcessCanceledException {
        if (prefix == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(2);
        }
        this.findPackages(indicator, NpmRegistryServiceImpl.namePrefixSearch(prefix), limit, filter, consumer);
    }

    @Override
    public void findPackages(@Nullable ProgressIndicator indicator, @NotNull NpmRegistryService.SearchQuery searchQuery, int limit, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) throws IOException, ProcessCanceledException {
        if (searchQuery == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        int MAX_DUP_COUNT = 50;
        int limitMargin = 1 + limit / 100;
        int queryLimit = searchQuery.getMaxQueryBatchSize();
        HashSet all = ContainerUtil.newHashSet();
        int found = 0;
        int skip = 0;
        int dupCount = 0;
        while (found < limit) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            int localLimit = Math.min(queryLimit, limit - found + limitMargin);
            List<NodePackageBasicInfo> results = NpmRegistryServiceImpl.findPackagesOrWaitForIt(indicator, searchQuery, skip, localLimit);
            skip += results.size();
            for (NodePackageBasicInfo info : results) {
                if (all.add(info.getName())) {
                    if (!filter.value((Object)info)) continue;
                    consumer.consume((Object)info);
                    if (++found < limit) continue;
                    break;
                }
                ++dupCount;
            }
            if (results.size() < localLimit) break;
            if (dupCount <= 50) continue;
            LOG.warn("Found over 50 duplicated packages with query: " + searchQuery + ". Stopping to preserve infinite loop.");
            break;
        }
    }

    @NotNull
    private static List<NodePackageBasicInfo> findPackagesOrWaitForIt(@Nullable ProgressIndicator indicator, @NotNull NpmRegistryService.SearchQuery searchQuery, int skip, int limit) throws IOException {
        if (searchQuery == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            List list;
            try {
                list = (List)ApplicationUtil.runWithCheckCanceled(() -> {
                    if (searchQuery == null) {
                        NpmRegistryServiceImpl.$$$reportNull$$$0(42);
                    }
                    return NpmRegistryServiceImpl.doFetchPackages(indicator, searchQuery, skip, limit);
                }, (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)indicator));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<NodePackageBasicInfo> list = NpmRegistryServiceImpl.doFetchPackages(indicator, searchQuery, skip, limit);
        if (list == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> doFetchPackages(@Nullable ProgressIndicator indicator, @NotNull NpmRegistryService.SearchQuery searchQuery, int skip, int limit) throws IOException {
        List<NodePackageBasicInfo> list;
        if (searchQuery == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(9);
        }
        String url = searchQuery.getQueryUrl(skip, limit);
        try {
            long startNano = System.nanoTime();
            String content = HttpRequests.request((String)url).userAgent(USER_AGENT).readString(indicator);
            List<NodePackageBasicInfo> infos = searchQuery.parseContent(content);
            LOG.info("Found " + infos.size() + " packages matching " + searchQuery + " in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms (" + url + ")");
            list = infos;
        }
        catch (IOException e) {
            throw new IOException("Failed to fetch packages for " + searchQuery + ": " + e.getMessage(), e);
        }
        if (list == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @Nullable
    public List<Pair<String, SemVer>> getCachedPackageDistTags(@NotNull String packageName) {
        TimestampedDistTags cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(11);
        }
        if ((cache = (TimestampedDistTags)this.myDistTagsCache.get(packageName)) != null && cache.getCreateTimeNano() + TimeUnit.MINUTES.toNanos(10L) > System.nanoTime()) {
            DistTags tags = cache.getDistTags();
            return tags != null ? tags.getList() : Collections.emptyList();
        }
        return null;
    }

    @Override
    public void asyncUpdatePackageDistTags(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(12);
        }
        this.getOrCreateDistTagsFetchFuture(packageName);
    }

    @Override
    @NotNull
    public Promise<List<Pair<String, SemVer>>> asyncUpdateAndGetPackageDistTags(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(13);
        }
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (packageName == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(41);
            }
            Future<DistTags> future = this.getOrCreateDistTagsFetchFuture(packageName);
            try {
                DistTags distTags = future.get();
                promise.setResult(distTags.getList());
            }
            catch (Exception e) {
                promise.setError((Throwable)e);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(14);
        }
        return asyncPromise;
    }

    @Override
    @Nullable
    public JsonObject fetchPackageJson(@NotNull String packageName, @NotNull String versionOrRange, @Nullable ProgressIndicator indicator) {
        String packagePath;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(15);
        }
        if (versionOrRange == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(16);
        }
        if (versionOrRange.isEmpty()) {
            versionOrRange = "*";
        }
        SemVer version = SemVer.parseFromText((String)versionOrRange);
        Requirement req = null;
        if (version == null) {
            try {
                req = Requirement.buildNPM((String)versionOrRange);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean distTag = false;
        String versionSuffix = null;
        if (packageName.startsWith("@")) {
            if (version != null) {
                versionSuffix = "=" + versionOrRange;
            } else if (!LATEST_DIST_TAG.equals(versionOrRange) && req != null) {
                versionSuffix = versionOrRange;
            } else {
                distTag = true;
            }
            packagePath = "@" + URLUtil.encodeURIComponent((String)packageName.substring(1));
        } else {
            if (version != null) {
                versionSuffix = versionOrRange;
            } else if (LATEST_DIST_TAG.equals(versionOrRange) || req == null) {
                versionSuffix = versionOrRange;
            }
            packagePath = URLUtil.encodeURIComponent((String)packageName);
        }
        boolean fetchList = versionSuffix == null;
        String url = "https://registry.npmjs.org/" + packagePath + (!fetchList ? "/" + versionSuffix : "");
        long startNano = System.nanoTime();
        try {
            JsonObject result2;
            RequestBuilder builder = HttpRequests.request((String)url);
            builder.userAgent(USER_AGENT);
            builder.gzip(true);
            String content = builder.readString(null);
            if (fetchList) {
                version = distTag ? NpmRegistryServiceImpl.findDistTag(content, versionOrRange) : NpmRegistryServiceImpl.findHighestPackageVersion(content, versionOrRange);
                if (version == null) {
                    return null;
                }
                try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
                    result2 = NpmRegistryServiceImpl.loadPackageJson(reader, version.getRawVersion());
                }
            } else {
                result2 = (JsonObject)new JsonParser().parse(content);
            }
            LOG.info("Loaded package.json for " + packageName + " in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms");
            return result2;
        }
        catch (Exception e) {
            LOG.info("Failed to fetch package.json from " + url, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static SemVer findDistTag(@NotNull String content, @NotNull String distTag) throws IOException {
        if (content == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(17);
        }
        if (distTag == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(18);
        }
        try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
            SemVer semVer = NpmRegistryServiceImpl.readDistTagsFromPackageMetadata(reader).stream().filter(p -> {
                if (distTag == null) {
                    NpmRegistryServiceImpl.$$$reportNull$$$0(40);
                }
                return ((String)p.getFirst()).equals(distTag);
            }).findFirst().map(p -> (SemVer)p.getSecond()).orElse(null);
            return semVer;
        }
    }

    @Nullable
    private static SemVer findHighestPackageVersion(@NotNull String content, @NotNull String range) throws IOException {
        if (content == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(19);
        }
        if (range == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(20);
        }
        Requirement req = Requirement.buildNPM((String)range);
        Semver highest = null;
        try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals("versions")) {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        try {
                            Semver v = new Semver(reader.nextName(), Semver.SemverType.NPM);
                            if (req.isSatisfiedBy(v) && (highest == null || v.isGreaterThan(highest))) {
                                highest = v;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        reader.skipValue();
                    }
                    break;
                }
                reader.skipValue();
            }
        }
        if (highest == null) {
            return null;
        }
        return SemVer.parseFromText((String)highest.getOriginalValue());
    }

    @Nullable
    private static JsonObject loadPackageJson(@NotNull JsonReader reader, @NotNull String version) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(21);
        }
        if (version == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(22);
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("versions")) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String v = reader.nextName();
                    if (version.equals(v)) {
                        return (JsonObject)new JsonParser().parse(reader);
                    }
                    reader.skipValue();
                }
                break;
            }
            reader.skipValue();
        }
        return null;
    }

    @Override
    @NotNull
    public List<Pair<String, SemVer>> getCachedOrFetchPackageDistTags(@NotNull String packageName, @Nullable ProgressIndicator indicator) {
        List<Pair<String, SemVer>> cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(23);
        }
        if ((cache = this.getCachedPackageDistTags(packageName)) != null) {
            List<Pair<String, SemVer>> list = cache;
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(24);
            }
            return list;
        }
        Future<DistTags> future = this.getOrCreateDistTagsFetchFuture(packageName);
        DistTags distTags = null;
        if (indicator == null) {
            try {
                distTags = future.get();
            }
            catch (Exception exception) {}
        } else {
            while (true) {
                try {
                    distTags = future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (!indicator.isCanceled()) continue;
                    List<Pair<String, SemVer>> list = Collections.emptyList();
                    if (list == null) {
                        NpmRegistryServiceImpl.$$$reportNull$$$0(25);
                    }
                    return list;
                }
                catch (Exception e) {
                    // empty catch block
                }
                break;
            }
        }
        this.myDistTagsCache.put(packageName, new TimestampedDistTags(distTags));
        List<Object> list = distTags != null ? distTags.getList() : Collections.emptyList();
        if (list == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private Future<DistTags> getOrCreateDistTagsFetchFuture(@NotNull String packageName) {
        FutureTask<DistTags> newFuture;
        Future running;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(27);
        }
        if ((running = (Future)this.myRunningFutures.putIfAbsent(packageName, newFuture = new FutureTask<DistTags>(() -> {
            if (packageName == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(39);
            }
            DistTags tags = NpmRegistryServiceImpl.fetchPackageDistTags(packageName);
            this.myDistTagsCache.put(packageName, new TimestampedDistTags(tags));
            this.myRunningFutures.remove(packageName);
            return tags;
        }))) != null) {
            Future future = running;
            if (future == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(28);
            }
            return future;
        }
        this.myExecutorService.submit(newFuture);
        FutureTask<DistTags> futureTask = newFuture;
        if (futureTask == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(29);
        }
        return futureTask;
    }

    @Nullable
    private static DistTags fetchPackageDistTags(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(30);
        }
        String packagePath = packageName.startsWith("@") ? "@" + URLUtil.encodeURIComponent((String)packageName.substring(1)) : URLUtil.encodeURIComponent((String)packageName);
        String url = "http://registry.npmjs.org/" + packagePath;
        long startNano = System.nanoTime();
        try {
            RequestBuilder builder = HttpRequests.request((String)url);
            builder.userAgent(USER_AGENT);
            builder.accept("application/vnd.npm.install-v1+json; q=1.0, application/json; q=0.8, */*");
            builder.gzip(true);
            String content = builder.readString(null);
            JsonReader reader = new JsonReader((Reader)new StringReader(content));
            List<Pair<String, SemVer>> distTags = NpmRegistryServiceImpl.readDistTagsFromPackageMetadata(reader);
            reader.close();
            NpmRegistryServiceImpl.sortDistTags(distTags);
            LOG.info("Found " + distTags.size() + " dist-tags for " + packageName + " in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms");
            return new DistTags(distTags);
        }
        catch (Exception e) {
            LOG.info("Failed to fetch dist-tags from " + url, (Throwable)e);
            return null;
        }
    }

    private static void sortDistTags(@NotNull List<Pair<String, SemVer>> distTags) {
        if (distTags == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(31);
        }
        Collections.sort(distTags, (d1, d2) -> {
            String name1 = (String)d1.getFirst();
            String name2 = (String)d2.getFirst();
            if (LATEST_DIST_TAG.equals(name1) != LATEST_DIST_TAG.equals(name2)) {
                return LATEST_DIST_TAG.equals(name1) ? -1 : 1;
            }
            return -1 * ((SemVer)d1.getSecond()).compareTo((SemVer)d2.getSecond());
        });
    }

    @NotNull
    private static List<Pair<String, SemVer>> readDistTagsFromPackageMetadata(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(32);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            List<Pair<String, SemVer>> list = Collections.emptyList();
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(33);
            }
            return list;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("dist-tags".equals(name)) {
                List<Pair<String, SemVer>> list = NpmRegistryServiceImpl.readDistTags(reader);
                if (list == null) {
                    NpmRegistryServiceImpl.$$$reportNull$$$0(34);
                }
                return list;
            }
            reader.skipValue();
        }
        reader.endObject();
        List<Pair<String, SemVer>> list = Collections.emptyList();
        if (list == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    private static List<Pair<String, SemVer>> readDistTags(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(36);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            List<Pair<String, SemVer>> list = Collections.emptyList();
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(37);
            }
            return list;
        }
        reader.beginObject();
        ArrayList distTags = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            String distTagName = reader.nextName();
            String versionStr = reader.nextString();
            SemVer version = SemVer.parseFromText((String)versionStr);
            if (version == null) {
                LOG.info("Cannot parse dist-tag version from " + versionStr);
                continue;
            }
            distTags.add(Pair.create((Object)distTagName, (Object)version));
        }
        reader.endObject();
        ArrayList arrayList = distTags;
        if (arrayList == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchQuery";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 27: 
            case 30: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionOrRange";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 18: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTag";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 21: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackagesOrWaitForIt";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doFetchPackages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncUpdateAndGetPackageDistTags";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOrFetchPackageDistTags";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDistTagsFetchFuture";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "readDistTagsFromPackageMetadata";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "readDistTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesByPrefix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPackages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesOrWaitForIt";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doFetchPackages";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPackageDistTags";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdatePackageDistTags";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdateAndGetPackageDistTags";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageJson";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findDistTag";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findHighestPackageVersion";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadPackageJson";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOrFetchPackageDistTags";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDistTagsFetchFuture";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageDistTags";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sortDistTags";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "readDistTagsFromPackageMetadata";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "readDistTags";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateDistTagsFetchFuture$4";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDistTag$2";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$asyncUpdateAndGetPackageDistTags$1";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findPackagesOrWaitForIt$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PrefixPackageListJsonReader {
        private final JsonReader myReader;
        private final List<NodePackageBasicInfo> myResult;

        public PrefixPackageListJsonReader(@NotNull JsonReader reader) {
            if (reader == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(0);
            }
            this.myResult = ContainerUtil.newArrayList();
            this.myReader = reader;
        }

        @NotNull
        public List<NodePackageBasicInfo> read() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                List<NodePackageBasicInfo> list = Collections.emptyList();
                if (list == null) {
                    PrefixPackageListJsonReader.$$$reportNull$$$0(1);
                }
                return list;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if ("rows".equals(name)) {
                    this.readPackagesInsideRows();
                    break;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
            List<NodePackageBasicInfo> list = this.myResult;
            if (list == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(2);
            }
            return list;
        }

        private void readPackagesInsideRows() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                NodePackageBasicInfo info = PrefixPackageListJsonReader.readSinglePackage(this.myReader);
                if (info == null) continue;
                this.myResult.add(info);
            }
            this.myReader.endArray();
        }

        @Nullable
        private static NodePackageBasicInfo readSinglePackage(@NotNull JsonReader reader) throws IOException {
            if (reader == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(3);
            }
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                reader.skipValue();
                return null;
            }
            reader.beginObject();
            NodePackageBasicInfo info = null;
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("key".equals(name)) {
                    info = PrefixPackageListJsonReader.readArrayInsideKey(reader);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return info;
        }

        @Nullable
        private static NodePackageBasicInfo readArrayInsideKey(@NotNull JsonReader reader) throws IOException {
            if (reader == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(4);
            }
            if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                reader.skipValue();
                return null;
            }
            reader.beginArray();
            String name = null;
            String description = null;
            int i = 0;
            while (reader.hasNext()) {
                if (i < 2 && reader.peek() == JsonToken.STRING) {
                    String str = reader.nextString();
                    if (i == 0) {
                        name = str;
                    } else {
                        description = str;
                    }
                } else {
                    reader.skipValue();
                }
                ++i;
            }
            reader.endArray();
            return name != null ? new NodePackageBasicInfo(name, description) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$PrefixPackageListJsonReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$PrefixPackageListJsonReader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readSinglePackage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readArrayInsideKey";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FullTextPackageListJsonReader {
        private final JsonReader myReader;
        private final List<NodePackageBasicInfo> myResult;

        public FullTextPackageListJsonReader(@NotNull JsonReader reader) {
            if (reader == null) {
                FullTextPackageListJsonReader.$$$reportNull$$$0(0);
            }
            this.myResult = ContainerUtil.newArrayList();
            this.myReader = reader;
        }

        @NotNull
        public List<NodePackageBasicInfo> read() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                List<NodePackageBasicInfo> list = Collections.emptyList();
                if (list == null) {
                    FullTextPackageListJsonReader.$$$reportNull$$$0(1);
                }
                return list;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if (name.equals("objects")) {
                    this.readObjects();
                    continue;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
            List<NodePackageBasicInfo> list = this.myResult;
            if (list == null) {
                FullTextPackageListJsonReader.$$$reportNull$$$0(2);
            }
            return list;
        }

        private void readObjects() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                this.readObject();
            }
            this.myReader.endArray();
        }

        private void readObject() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if (name.equals("package")) {
                    this.readPackage();
                    continue;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
        }

        private void readPackage() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginObject();
            String name = null;
            String description = null;
            while (this.myReader.hasNext()) {
                String propName = this.myReader.nextName();
                if (propName.equals("name")) {
                    name = JsonUtil.nextStringOrSkip((JsonReader)this.myReader);
                    continue;
                }
                if (propName.equals("description")) {
                    description = JsonUtil.nextStringOrSkip((JsonReader)this.myReader);
                    continue;
                }
                this.myReader.skipValue();
            }
            if (name != null) {
                this.myResult.add(new NodePackageBasicInfo(name, description));
            }
            this.myReader.endObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$FullTextPackageListJsonReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$FullTextPackageListJsonReader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class NamePrefixSearchQuery
    implements NpmRegistryService.SearchQuery {
        private final String myPrefix;
        private final String myBaseUrl;
        private final String myStartKey;
        private final String myEndKey;

        public NamePrefixSearchQuery(@NotNull String prefix) {
            if (prefix == null) {
                NamePrefixSearchQuery.$$$reportNull$$$0(0);
            }
            this.myPrefix = prefix;
            this.myBaseUrl = prefix.startsWith("@") ? "https://replicate.npmjs.com" : "https://skimdb.npmjs.com";
            this.myStartKey = URLUtil.encodeURIComponent((String)("[\"" + this.myPrefix + "\"]"));
            this.myEndKey = URLUtil.encodeURIComponent((String)("[\"" + this.myPrefix + "z\",{}]"));
        }

        @Override
        @NotNull
        public String getQueryUrl(int from, int limit) {
            String string = this.myBaseUrl + "/registry/_design/app/_view/browseAll?group_level=2&skip=" + from + "&limit=" + limit + "&start_key=" + this.myStartKey + "&end_key=" + this.myEndKey;
            if (string == null) {
                NamePrefixSearchQuery.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public int getMaxQueryBatchSize() {
            return 10000;
        }

        @Override
        @NotNull
        public List<NodePackageBasicInfo> parseContent(@NotNull String content) throws IOException {
            List<NodePackageBasicInfo> list;
            if (content == null) {
                NamePrefixSearchQuery.$$$reportNull$$$0(2);
            }
            try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
                List<NodePackageBasicInfo> list2 = new PrefixPackageListJsonReader(reader).read();
                list = list2;
            }
            if (list == null) {
                NamePrefixSearchQuery.$$$reportNull$$$0(3);
            }
            return list;
        }

        public String toString() {
            return "'" + this.myPrefix + "*' (Prefix)";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$NamePrefixSearchQuery";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$NamePrefixSearchQuery";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueryUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class FullTextSearchQuery
    implements NpmRegistryService.SearchQuery {
        private final String myText;

        public FullTextSearchQuery(@NotNull String text) {
            if (text == null) {
                FullTextSearchQuery.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Override
        @NotNull
        public String getQueryUrl(int from, int limit) {
            String string = "https://registry.npmjs.org/-/v1/search?&text=" + URLUtil.encodeURIComponent((String)("\"" + this.myText + "\"")) + "&from=" + from + "&size=" + limit;
            if (string == null) {
                FullTextSearchQuery.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public int getMaxQueryBatchSize() {
            return 250;
        }

        @Override
        @NotNull
        public List<NodePackageBasicInfo> parseContent(@NotNull String content) throws IOException {
            List<NodePackageBasicInfo> list;
            if (content == null) {
                FullTextSearchQuery.$$$reportNull$$$0(2);
            }
            try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
                List<NodePackageBasicInfo> list2 = new FullTextPackageListJsonReader(reader).read();
                list = list2;
            }
            if (list == null) {
                FullTextSearchQuery.$$$reportNull$$$0(3);
            }
            return list;
        }

        public String toString() {
            return "'" + this.myText + "' (Full Text)";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$FullTextSearchQuery";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$FullTextSearchQuery";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueryUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DistTags {
        private final List<Pair<String, SemVer>> myList;

        public DistTags(@NotNull List<Pair<String, SemVer>> list) {
            if (list == null) {
                DistTags.$$$reportNull$$$0(0);
            }
            this.myList = list;
        }

        @NotNull
        public List<Pair<String, SemVer>> getList() {
            List<Pair<String, SemVer>> list = this.myList;
            if (list == null) {
                DistTags.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$DistTags";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$DistTags";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TimestampedDistTags {
        private final long myCreateTimeNano;
        private final DistTags myDistTags;

        private TimestampedDistTags(@Nullable DistTags distTags) {
            this.myDistTags = distTags;
            this.myCreateTimeNano = System.nanoTime();
        }

        public long getCreateTimeNano() {
            return this.myCreateTimeNano;
        }

        @Nullable
        public DistTags getDistTags() {
            return this.myDistTags;
        }
    }
}

