/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.common.collect.ImmutableSet;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="NodePackageJsonFileManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PackageJsonFileManager
implements PersistentStateComponent<State> {
    private final Project myProject;
    private final ProjectFileIndex myFileIndex;
    private final Object LOCK;
    private ImmutableSet<VirtualFile> myPackageJsonFiles;

    public PackageJsonFileManager(@NotNull Project project, @NotNull ProjectFileIndex fileIndex) {
        if (project == null) {
            PackageJsonFileManager.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            PackageJsonFileManager.$$$reportNull$$$0(1);
        }
        this.LOCK = new Object();
        this.myPackageJsonFiles = ImmutableSet.of();
        this.myProject = project;
        this.myFileIndex = fileIndex;
    }

    @NotNull
    public static PackageJsonFileManager getInstance(@NotNull Project project) {
        if (project == null) {
            PackageJsonFileManager.$$$reportNull$$$0(2);
        }
        PackageJsonFileManager packageJsonFileManager = (PackageJsonFileManager)ServiceManager.getService((Project)project, PackageJsonFileManager.class);
        if (packageJsonFileManager == null) {
            PackageJsonFileManager.$$$reportNull$$$0(3);
        }
        return packageJsonFileManager;
    }

    @Nullable
    public State getState() {
        List<String> list = this.getValidPackageJsonFiles().stream().map(VirtualFile::getPath).sorted().collect(Collectors.toList());
        return new State(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        if (state == null) {
            PackageJsonFileManager.$$$reportNull$$$0(4);
        }
        SmartList files = new SmartList();
        for (String path : state.myPaths) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 == null || !file2.isValid() || !PackageJsonUtil.isPackageJsonFile(file2)) continue;
            files.add(file2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myPackageJsonFiles = ImmutableSet.copyOf((Collection)files);
        }
    }

    private void detectAllPackageJsonFiles() {
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            Collection files = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"package.json", (GlobalSearchScope)ProjectScope.getContentScope((Project)this.myProject));
            this.setPackageJsonFiles(files);
        });
    }

    private boolean accept(@NotNull VirtualFile packageJson) {
        VirtualFile root;
        if (packageJson == null) {
            PackageJsonFileManager.$$$reportNull$$$0(5);
        }
        return packageJson.isValid() && PackageJsonUtil.isPackageJsonFile(packageJson) && (root = this.myFileIndex.getContentRootForFile(packageJson, true)) != null && !JSLibraryUtil.hasDirectoryInPath(packageJson, "node_modules", root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPackageJsonAdded(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonFileManager.$$$reportNull$$$0(6);
        }
        boolean shouldUpdateLibrary = false;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myPackageJsonFiles.contains((Object)packageJson) && this.accept(packageJson)) {
                this.myPackageJsonFiles = ImmutableSet.builder().addAll(this.myPackageJsonFiles).add((Object)packageJson).build();
                shouldUpdateLibrary = NodeModuleUtil.findNodeModulesByPackageJson(packageJson) == null;
            }
        }
        if (shouldUpdateLibrary) {
            this.updateLibrary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<VirtualFile> getValidPackageJsonFiles() {
        ImmutableSet packageJsonFiles;
        Object object = this.LOCK;
        synchronized (object) {
            packageJsonFiles = this.myPackageJsonFiles;
        }
        ArrayList<VirtualFile> toRemove = null;
        for (VirtualFile file2 : packageJsonFiles) {
            if (file2.isValid()) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<VirtualFile>();
            }
            toRemove.add(file2);
        }
        if (toRemove != null) {
            HashSet<VirtualFile> files = new HashSet<VirtualFile>((Collection<VirtualFile>)packageJsonFiles);
            files.removeAll(toRemove);
            packageJsonFiles = ImmutableSet.copyOf(files);
            Object object2 = this.LOCK;
            synchronized (object2) {
                this.myPackageJsonFiles = packageJsonFiles;
            }
        }
        ImmutableSet immutableSet = packageJsonFiles;
        if (immutableSet == null) {
            PackageJsonFileManager.$$$reportNull$$$0(7);
        }
        return immutableSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPackageJsonFiles(@NotNull Collection<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonFileManager.$$$reportNull$$$0(8);
        }
        boolean shouldUpdateLibrary = false;
        Object object = this.LOCK;
        synchronized (object) {
            for (VirtualFile file2 : packageJsonFiles) {
                if (this.myPackageJsonFiles.contains((Object)file2) || !this.accept(file2) || NodeModuleUtil.findNodeModulesByPackageJson(file2) != null) continue;
                shouldUpdateLibrary = true;
            }
            this.myPackageJsonFiles = ImmutableSet.copyOf(packageJsonFiles);
        }
        if (shouldUpdateLibrary) {
            this.updateLibrary();
        }
    }

    private void updateLibrary() {
        NodeModulesDirectoryManager directoryManager = NodeModulesDirectoryManager.getInstance(this.myProject);
        directoryManager.resetSnapshot();
        directoryManager.requestLibrariesUpdate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonFileManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonFileManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidPackageJsonFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonAdded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setPackageJsonFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyStartupActivity
    implements StartupActivity {
        MyStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            PackageJsonFileManager.getInstance(project).detectAllPackageJsonFiles();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/packageJson/PackageJsonFileManager$MyStartupActivity", "runActivity"));
        }
    }

    static class State {
        @XCollection(propertyElementName="packageJsonPaths", elementName="path")
        public final List<String> myPaths;

        public State() {
            this.myPaths = new SmartList();
        }

        public State(@NotNull List<String> paths) {
            if (paths == null) {
                State.$$$reportNull$$$0(0);
            }
            this.myPaths = new SmartList();
            this.myPaths.addAll(paths);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/javascript/nodejs/packageJson/PackageJsonFileManager$State", "<init>"));
        }
    }
}

