/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class PackageJsonGetDependenciesAction
extends DumbAwareAction {
    private final VirtualFile myPackageJson;
    private final Notification myNotification;

    public PackageJsonGetDependenciesAction(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull Notification notification2) {
        if (project == null) {
            PackageJsonGetDependenciesAction.$$$reportNull$$$0(0);
        }
        if (packageJson == null) {
            PackageJsonGetDependenciesAction.$$$reportNull$$$0(1);
        }
        if (notification2 == null) {
            PackageJsonGetDependenciesAction.$$$reportNull$$$0(2);
        }
        this.myPackageJson = packageJson;
        this.myNotification = notification2;
        NodePackageRef npmPkgRef = NpmManager.getInstance(project).getPackageRef();
        boolean yarn = NpmUtil.isYarnAlikePackageRef(npmPkgRef);
        String exe = yarn ? "yarn" : "npm";
        this.getTemplatePresentation().setText("Run '" + exe + " " + NpmCommand.INSTALL.getCliOption(yarn) + "'");
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        this.myNotification.expire();
        Project project = e.getProject();
        if (project != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, this.myPackageJson);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "packageJson";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "notification";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonGetDependenciesAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

