/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PackageJsonReferenceContributor
extends PsiReferenceContributor {
    private static final String ARRAY = "[]";
    private static final String[][] URL_PATHS = new String[][]{{"homepage"}, {"author", "url"}, {"repository"}, {"repository", "url"}, {"bugs"}, {"bugs", "url"}, {"publishConfig", "registry"}};
    private static final String[][] FILE_PATHS = new String[][]{{"main"}, {"esnext"}, {"esnext", "*"}, {"module"}, {"es2015"}, {"esm2015"}, {"esm5"}, {"fesm2015"}, {"fesm5"}, {"files", "[]"}, {"bin", "*"}, {"directories", "*"}, {"man"}};

    @NotNull
    private static PsiElementPattern.Capture<JsonStringLiteral> createDependencyPattern() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).with((PatternCondition)new PatternCondition<JsonStringLiteral>("package.json dependency"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                JsonProperty property;
                if (literal == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PackageJsonUtil.isInsidePackageJsonFile((PsiElement)literal) && (property = (JsonProperty)ObjectUtils.tryCast((Object)literal.getParent(), JsonProperty.class)) != null && PackageJsonUtil.isPackageDependencyProperty(property);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$1", "accepts"));
            }
        });
        if (capture == null) {
            PackageJsonReferenceContributor.$$$reportNull$$$0(0);
        }
        return capture;
    }

    @NotNull
    private static PsiElementPattern.Capture<JsonStringLiteral> createUrlPattern() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).with((PatternCondition)new PatternCondition<JsonStringLiteral>("package.json url"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                if (literal == null) {
                    2.$$$reportNull$$$0(0);
                }
                return PackageJsonUtil.isInsidePackageJsonFile((PsiElement)literal) && (PackageJsonReferenceContributor.pathMatches(literal, URL_PATHS) || PackageJsonReferenceContributor.startsWithUrlScheme(literal));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$2", "accepts"));
            }
        });
        if (capture == null) {
            PackageJsonReferenceContributor.$$$reportNull$$$0(1);
        }
        return capture;
    }

    private static boolean startsWithUrlScheme(@NotNull JsonStringLiteral literal) {
        LeafPsiElement element;
        ASTNode node;
        if (literal == null) {
            PackageJsonReferenceContributor.$$$reportNull$$$0(2);
        }
        if ((node = literal.getNode()) != null && (element = (LeafPsiElement)ObjectUtils.tryCast((Object)node.getFirstChildNode(), LeafPsiElement.class)) != null && element.getElementType() == JsonElementTypes.DOUBLE_QUOTED_STRING) {
            CharSequence text = element.getChars();
            return CharArrayUtil.regionMatches((CharSequence)text, (int)1, (CharSequence)"http://") || CharArrayUtil.regionMatches((CharSequence)text, (int)1, (CharSequence)"https://");
        }
        return false;
    }

    @NotNull
    private static PsiElementPattern.Capture<JsonStringLiteral> createFilePathPattern() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).with((PatternCondition)new PatternCondition<JsonStringLiteral>("package.json file path"){

            public boolean accepts(@NotNull JsonStringLiteral literal, ProcessingContext context) {
                if (literal == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PackageJsonUtil.isInsidePackageJsonFile((PsiElement)literal) && PackageJsonReferenceContributor.pathMatches(literal, FILE_PATHS);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$3", "accepts"));
            }
        });
        if (capture == null) {
            PackageJsonReferenceContributor.$$$reportNull$$$0(3);
        }
        return capture;
    }

    private static boolean pathMatches(@NotNull JsonStringLiteral literal, @NotNull String[][] patternPaths) {
        if (literal == null) {
            PackageJsonReferenceContributor.$$$reportNull$$$0(4);
        }
        if (patternPaths == null) {
            PackageJsonReferenceContributor.$$$reportNull$$$0(5);
        }
        PsiElement element = literal.getParent();
        ArrayList<String> pathUp = new ArrayList<String>();
        while (element instanceof JsonProperty || element instanceof JsonArray) {
            if (element instanceof JsonProperty) {
                pathUp.add(((JsonProperty)element).getName());
            }
            if (element instanceof JsonArray) {
                pathUp.add(ARRAY);
            }
            if ((element = element.getParent()) instanceof PsiFile) break;
            if (!(element instanceof JsonObject)) continue;
            element = element.getParent();
        }
        if (element == null) {
            return false;
        }
        Collections.reverse(pathUp);
        String[] actual = ArrayUtil.toStringArray(pathUp);
        for (String[] patternPath : patternPaths) {
            if (!PackageJsonReferenceContributor.pathMatches(actual, patternPath)) continue;
            return true;
        }
        return false;
    }

    private static boolean pathMatches(@NotNull String[] path, @NotNull String[] pathPattern) {
        if (path == null) {
            PackageJsonReferenceContributor.$$$reportNull$$$0(6);
        }
        if (pathPattern == null) {
            PackageJsonReferenceContributor.$$$reportNull$$$0(7);
        }
        if (path.length != pathPattern.length) {
            return false;
        }
        for (int i = 0; i < path.length; ++i) {
            if (pathPattern[i].equals("*") || pathPattern[i].equals(path[i])) continue;
            return false;
        }
        return true;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            PackageJsonReferenceContributor.$$$reportNull$$$0(8);
        }
        registrar.registerReferenceProvider(PackageJsonReferenceContributor.createUrlPattern(), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new WebReference(element)};
                if (psiReferenceArray == null) {
                    4.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        registrar.registerReferenceProvider(PackageJsonReferenceContributor.createFilePathPattern(), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                FileReference[] fileReferenceArray = new FileReferenceSet(element).getAllReferences();
                if (fileReferenceArray == null) {
                    5.$$$reportNull$$$0(2);
                }
                return fileReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        registrar.registerReferenceProvider(PackageJsonReferenceContributor.createDependencyPattern(), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    6.$$$reportNull$$$0(1);
                }
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)element, JsonStringLiteral.class);
                JsonProperty property = (JsonProperty)ObjectUtils.tryCast((Object)element.getParent(), JsonProperty.class);
                if (literal == null || property == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        6.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new PackageJsonDependencyReference(literal, property)};
                if (psiReferenceArray == null) {
                    6.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$6";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternPaths";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPattern";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependencyPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlPattern";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePathPattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startsWithUrlScheme";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pathMatches";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InstalledPackageElement
    extends FakePsiElement
    implements SyntheticElement {
        private final JsonProperty myDependencyProperty;
        private final JsonStringLiteral myLiteral;
        private final PsiReference myReference;

        public InstalledPackageElement(@NotNull JsonStringLiteral literal, @NotNull JsonProperty dependencyProperty, @NotNull PsiReference reference) {
            if (literal == null) {
                InstalledPackageElement.$$$reportNull$$$0(0);
            }
            if (dependencyProperty == null) {
                InstalledPackageElement.$$$reportNull$$$0(1);
            }
            if (reference == null) {
                InstalledPackageElement.$$$reportNull$$$0(2);
            }
            this.myLiteral = literal;
            this.myDependencyProperty = dependencyProperty;
            this.myReference = reference;
        }

        public PsiElement getParent() {
            return this.myLiteral;
        }

        public void navigate(boolean requestFocus) {
            NodeInstalledPackageFinder finder;
            InstalledPackageVersion pkg;
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)this.myLiteral);
            if (file2 != null && (pkg = (finder = new NodeInstalledPackageFinder(this.myLiteral.getProject(), file2)).findInstalledPackage(this.myDependencyProperty.getName())) != null) {
                new OpenFileDescriptor(this.myLiteral.getProject(), pkg.getPackageDir()).navigate(true);
            }
        }

        public String getPresentableText() {
            return this.myDependencyProperty.getName();
        }

        public String getName() {
            return this.myDependencyProperty.getName();
        }

        public TextRange getTextRange() {
            TextRange rangeInElement = this.myReference.getRangeInElement();
            TextRange elementRange = this.myLiteral.getTextRange();
            return elementRange != null ? rangeInElement.shiftRight(elementRange.getStartOffset()) : rangeInElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "literal";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependencyProperty";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reference";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$InstalledPackageElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PackageJsonDependencyReference
    extends PsiReferenceBase<PsiElement> {
        private final JsonStringLiteral myLiteral;
        private final JsonProperty myDependencyProperty;

        public PackageJsonDependencyReference(@NotNull JsonStringLiteral literal, @NotNull JsonProperty dependencyProperty) {
            if (literal == null) {
                PackageJsonDependencyReference.$$$reportNull$$$0(0);
            }
            if (dependencyProperty == null) {
                PackageJsonDependencyReference.$$$reportNull$$$0(1);
            }
            super((PsiElement)literal);
            this.myLiteral = literal;
            this.myDependencyProperty = dependencyProperty;
        }

        public PsiElement resolve() {
            return new InstalledPackageElement(this.myLiteral, this.myDependencyProperty, (PsiReference)this);
        }

        @NotNull
        public Object[] getVariants() {
            if (EMPTY_ARRAY == null) {
                PackageJsonDependencyReference.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyProperty";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$PackageJsonDependencyReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonReferenceContributor$PackageJsonDependencyReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

