/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.DispreferLiveTemplates;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages.PopularNodePackagesProvider;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.codeinsight.JsonStringPropertyInsertHandler;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(PackageJsonCompletionContributor.class);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(1);
        }
        if (PackageJsonUtil.isInsidePackageJsonFile((PsiElement)parameters.getOriginalFile())) {
            PackageJsonCompletionContributor.completeDependencies(parameters, result2);
        }
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(2);
        }
        if (PackageJsonUtil.isInsidePackageJsonFile(position) && !Character.isWhitespace(typeChar) && typeChar != ',') {
            PsiElement at = position;
            if (at.getNode().getElementType() == JsonElementTypes.COMMA) {
                at = at.getPrevSibling();
            }
            if (at instanceof PsiWhiteSpace) {
                at = at.getPrevSibling();
            }
            JsonProperty property = at != null ? PackageJsonUtil.findContainingProperty(at) : null;
            return property != null && PackageJsonUtil.isPackageDependencyProperty(property);
        }
        return false;
    }

    private static void completeDependencies(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        JsonProperty dependencyProperty;
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((dependencyProperty = PackageJsonUtil.findContainingProperty(parameters.getPosition())) != null && PackageJsonUtil.isPackageDependencyProperty(dependencyProperty)) {
            CompletionSorter sorter = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new DispreferLiveTemplates()).weigh(new LookupElementWeigher("priority"){

                @NotNull
                public Double weigh(@NotNull LookupElement element) {
                    PrioritizedLookupElement ple;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Double d = (ple = (PrioritizedLookupElement)ObjectUtils.tryCast((Object)element, PrioritizedLookupElement.class)) != null ? ple.getPriority() : 0.0;
                    if (d == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return d;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "weigh";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "weigh";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            result2 = result2.withRelevanceSorter(sorter);
            JsonValue nameElement = dependencyProperty.getNameElement();
            if (nameElement.getTextRange().containsOffset(parameters.getOffset())) {
                String prefix = PackageJsonCompletionContributor.findPrefix(parameters, (PsiElement)nameElement);
                result2 = result2.withPrefixMatcher(prefix);
                PackageJsonCompletionContributor.completeDependenciesNames(parameters, result2, prefix);
            } else {
                String packageName = StringUtil.unquoteString((String)nameElement.getText());
                PackageJsonCompletionContributor.completeDependenciesVersions(parameters, result2, packageName);
            }
        }
    }

    private static void completeDependenciesNames(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull String packageNamePrefix) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(6);
        }
        if (packageNamePrefix == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(7);
        }
        Set<String> alreadyUsedNames = PackageJsonCompletionContributor.getUsedPackageNames(parameters);
        List<NodePackageBasicInfo> popularPackages = PopularNodePackagesProvider.getInstance().findByPrefix(packageNamePrefix, packageNamePrefix.isEmpty() ? 20 : 10, (Condition<NodePackageBasicInfo>)((Condition)info -> !alreadyUsedNames.contains(info.getName())));
        AtomicInteger priority = new AtomicInteger(0);
        for (NodePackageBasicInfo pkg : popularPackages) {
            PackageJsonCompletionContributor.addPackageInfo(parameters, result2, pkg, priority.getAndIncrement());
        }
        if (!packageNamePrefix.isEmpty()) {
            Set popularNames = ContainerUtil.map2Set(popularPackages, NodePackageBasicInfo::getName);
            PackageJsonCompletionContributor.findPackagesInRegistryByPrefix(packageNamePrefix, Math.max(0, 10 - popularPackages.size()), (Condition<NodePackageBasicInfo>)((Condition)info -> !alreadyUsedNames.contains(info.getName()) && !popularNames.contains(info.getName())), (Consumer<NodePackageBasicInfo>)((Consumer)info -> {
                if (parameters == null) {
                    PackageJsonCompletionContributor.$$$reportNull$$$0(35);
                }
                if (result2 == null) {
                    PackageJsonCompletionContributor.$$$reportNull$$$0(36);
                }
                PackageJsonCompletionContributor.addPackageInfo(parameters, result2, info, priority.getAndIncrement());
            }));
        }
        result2.restartCompletionOnAnyPrefixChange();
        result2.addLookupAdvertisement("Start typing package name to get more specific results from the official public npm registry");
    }

    private static boolean isInsideStringLiteral(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(8);
        }
        return parameters.getPosition().getParent() instanceof JsonStringLiteral;
    }

    private static void completeDependenciesVersions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull String packageName) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(10);
        }
        if (packageName == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(11);
        }
        result2 = result2.withPrefixMatcher((PrefixMatcher)new MyPlainPrefixMatcher(PackageJsonCompletionContributor.findPrefix(parameters, parameters.getPosition())));
        List<Pair<String, SemVer>> distTags = PackageJsonCompletionContributor.fetchPackageDistTags(packageName);
        int order = 0;
        String[] versionPrefixes = PackageJsonCompletionContributor.getSortedVersionPrefixes(parameters);
        for (Pair<String, SemVer> tag : distTags) {
            for (String versionPrefix : versionPrefixes) {
                PackageJsonCompletionContributor.addDistTagCompletionItem(parameters, result2, versionPrefix, (SemVer)tag.getSecond(), (String)tag.getFirst(), order++);
            }
        }
        if (distTags.size() > 0) {
            result2.addLookupAdvertisement("Latest available versions for all distribution tags");
        }
    }

    @NotNull
    private static String[] getSortedVersionPrefixes(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(12);
        }
        Object[] prefixes = new String[]{"^", "~", ""};
        PsiElement position = parameters.getOriginalPosition();
        if (position != null) {
            int ind;
            String currentPrefix;
            String text = StringUtil.trimStart((String)StringUtil.unquoteString((String)position.getText()), (String)"\"");
            String string = currentPrefix = text.isEmpty() ? "^" : text.substring(0, 1);
            if (!currentPrefix.isEmpty() && Character.isDigit(currentPrefix.charAt(0))) {
                currentPrefix = "";
            }
            if ((ind = ArrayUtil.find((Object[])prefixes, (Object)currentPrefix)) > 0) {
                ArrayUtil.rotateRight((Object[])prefixes, (int)0, (int)ind);
            }
        }
        if (prefixes == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(13);
        }
        return prefixes;
    }

    private static void addPackageInfo(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, final @NotNull NodePackageBasicInfo info, int priority) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(15);
        }
        if (info == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(16);
        }
        String lookupString = info.getName() + " ";
        if (!PackageJsonCompletionContributor.isInsideStringLiteral(parameters)) {
            lookupString = StringUtil.wrapWithDoubleQuote((String)lookupString);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)info, (String)lookupString);
        builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(info.getName());
                presentation.setTypeGrayed(true);
                presentation.setTypeText(info.getDescription());
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(info.getName()));
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)priority));
    }

    private static void addDistTagCompletionItem(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, final @NotNull String versionPrefix, @NotNull SemVer version, final @Nullable String distTagName, int order) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(17);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(18);
        }
        if (versionPrefix == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(19);
        }
        if (version == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(20);
        }
        final String value = versionPrefix + version.getRawVersion();
        LookupElementBuilder builder = PackageJsonCompletionContributor.isInsideStringLiteral(parameters) ? LookupElementBuilder.create((Object)version, (String)value) : LookupElementBuilder.create((Object)version, (String)StringUtil.wrapWithDoubleQuote((String)value)).withLookupString(value);
        builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(versionPrefix.isEmpty() ? " " + value : value);
                presentation.setTypeGrayed(true);
                presentation.setTypeText(distTagName);
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(value));
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)order));
    }

    private static void findPackagesInRegistryByPrefix(@NotNull String prefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) {
        if (prefix == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(21);
        }
        if (filter == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(23);
        }
        try {
            NpmRegistryService.getInstance().findPackages(ProgressManager.getInstance().getProgressIndicator(), NpmRegistryService.namePrefixSearch(prefix), limit, filter, consumer);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Fetching '" + prefix + "*' packages from registry cancelled");
        }
        catch (IOException e) {
            LOG.info("Cannot fetch '" + prefix + "*' packages from registry", (Throwable)e);
        }
    }

    @NotNull
    private static List<Pair<String, SemVer>> fetchPackageDistTags(@NotNull String packageName) {
        List list;
        if (packageName == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(24);
        }
        try {
            list = (List)ApplicationUtil.runWithCheckCanceled(() -> {
                if (packageName == null) {
                    PackageJsonCompletionContributor.$$$reportNull$$$0(34);
                }
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                return NpmRegistryService.getInstance().getCachedOrFetchPackageDistTags(packageName, indicator);
            }, (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator()));
        }
        catch (ProcessCanceledException e) {
            LOG.info("Fetching dist-tags for " + packageName + " cancelled");
            List<Pair<String, SemVer>> list2 = Collections.emptyList();
            if (list2 == null) {
                PackageJsonCompletionContributor.$$$reportNull$$$0(26);
            }
            return list2;
        }
        catch (Exception e) {
            LOG.info("Cannot fetch dist-tags for " + packageName, (Throwable)e);
            List<Pair<String, SemVer>> list3 = Collections.emptyList();
            if (list3 == null) {
                PackageJsonCompletionContributor.$$$reportNull$$$0(27);
            }
            return list3;
        }
        if (list == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    private static String findPrefix(@NotNull CompletionParameters parameters, @NotNull PsiElement element) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(28);
        }
        if (element == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(29);
        }
        String name = element.getText();
        int prefixLength = Math.min(name.length(), parameters.getOffset() - element.getTextRange().getStartOffset());
        String string = StringUtil.trimStart((String)StringUtil.unquoteString((String)name.substring(0, prefixLength)), (String)"\"");
        if (string == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    private static Set<String> getUsedPackageNames(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(31);
        }
        PsiElement position = parameters.getPosition();
        JsonProperty currentProperty = PackageJsonUtil.findContainingProperty(position);
        JsonFile file2 = (JsonFile)ObjectUtils.tryCast((Object)position.getContainingFile(), JsonFile.class);
        if (file2 == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PackageJsonCompletionContributor.$$$reportNull$$$0(32);
            }
            return set;
        }
        List<JsonProperty> props = PackageJsonUtil.listAllPackageProperties(file2);
        HashSet<String> usedNames = new HashSet<String>();
        for (JsonProperty prop : props) {
            if (prop == currentProperty) continue;
            usedNames.add(prop.getName());
        }
        HashSet<String> hashSet = usedNames;
        if (hashSet == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNamePrefix";
                break;
            }
            case 11: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 13: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionPrefix";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedVersionPrefixes";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchPackageDistTags";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findPrefix";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedPackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeAutoPopup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "completeDependencies";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "completeDependenciesNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStringLiteral";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "completeDependenciesVersions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSortedVersionPrefixes";
                break;
            }
            case 13: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addPackageInfo";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addDistTagCompletionItem";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesInRegistryByPrefix";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageDistTags";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findPrefix";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getUsedPackageNames";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetchPackageDistTags$3";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$completeDependenciesNames$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyPlainPrefixMatcher
    extends PrefixMatcher {
        public MyPlainPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                MyPlainPrefixMatcher.$$$reportNull$$$0(0);
            }
            super(prefix);
        }

        public boolean isStartMatch(@NotNull String name) {
            if (name == null) {
                MyPlainPrefixMatcher.$$$reportNull$$$0(1);
            }
            return StringUtil.startsWithIgnoreCase((String)name, (String)this.getPrefix());
        }

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                MyPlainPrefixMatcher.$$$reportNull$$$0(2);
            }
            return StringUtil.startsWithIgnoreCase((String)name, (String)this.getPrefix());
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                MyPlainPrefixMatcher.$$$reportNull$$$0(3);
            }
            MyPlainPrefixMatcher myPlainPrefixMatcher = new MyPlainPrefixMatcher(prefix);
            if (myPlainPrefixMatcher == null) {
                MyPlainPrefixMatcher.$$$reportNull$$$0(4);
            }
            return myPlainPrefixMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$MyPlainPrefixMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$MyPlainPrefixMatcher";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cloneWithPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isStartMatch";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prefixMatches";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneWithPrefix";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DependencyCharFilter
    extends CharFilter {
        @Nullable
        public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup) {
            if (!lookup.isCompletion()) {
                return null;
            }
            PsiElement element = lookup.getPsiElement();
            if (element != null && JsonLanguage.INSTANCE.equals(element.getLanguage())) {
                if (StringUtil.containsChar((String)"@/-.^~", (char)c)) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
                if (c == '\"' && element instanceof PsiWhiteSpace) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
                if (c == ',') {
                    return prefixLength == 0 ? CharFilter.Result.HIDE_LOOKUP : CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
            }
            return null;
        }
    }
}

