/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.frameworks.modules.JSModuleReferenceBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeFileModulePsiReferenceBase
implements PsiReference,
JSModuleBaseReference {
    protected final PsiElement myPsiElement;
    protected final String myRequiredModuleName;
    private final int myOffset;

    public NodeFileModulePsiReferenceBase(@NotNull PsiElement literalOrModuleReferenceOwner, @NotNull String requiredModuleName, int offset) {
        if (literalOrModuleReferenceOwner == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(0);
        }
        if (requiredModuleName == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(1);
        }
        this.myPsiElement = literalOrModuleReferenceOwner;
        this.myRequiredModuleName = requiredModuleName;
        this.myOffset = offset;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)this.myOffset, (int)this.myRequiredModuleName.length());
        if (textRange == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public PsiElement resolve() {
        ResolvedModuleInfo resolvedModuleInfo = this.resolveModule();
        if (resolvedModuleInfo == null) {
            return null;
        }
        VirtualFile resolvedVirtualFile = resolvedModuleInfo.getModuleMainFile();
        if (resolvedVirtualFile.isValid()) {
            return this.myPsiElement.getManager().findFile(resolvedVirtualFile);
        }
        return null;
    }

    @Nullable
    public final ResolvedModuleInfo resolveModule() {
        ResolvedModuleInfo module = this.doResolveModule();
        return module != null ? this.getCanonicalModuleInProject(module) : null;
    }

    @Nullable
    protected abstract ResolvedModuleInfo doResolveModule();

    @NotNull
    private ResolvedModuleInfo getCanonicalModuleInProject(@NotNull ResolvedModuleInfo info) {
        VirtualFile canonicalModule;
        String relativePath;
        VirtualFile canonicalRoot;
        VirtualFile root;
        if (info == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(4);
        }
        if (!(root = info.getModuleSourceRoot()).equals(canonicalRoot = JSModuleReferenceBase.getCanonicalPreferredFile(this.myPsiElement.getProject(), root)) && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)info.getModuleMainFile(), (VirtualFile)root)) != null && (canonicalModule = canonicalRoot.findFileByRelativePath(relativePath)) != null) {
            ResolvedModuleInfo resolvedModuleInfo = new ResolvedModuleInfo(canonicalRoot, canonicalModule, info.getType());
            if (resolvedModuleInfo == null) {
                NodeFileModulePsiReferenceBase.$$$reportNull$$$0(5);
            }
            return resolvedModuleInfo;
        }
        ResolvedModuleInfo resolvedModuleInfo = info;
        if (resolvedModuleInfo == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(6);
        }
        return resolvedModuleInfo;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myRequiredModuleName;
        if (string == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    public PsiElement handleElementRename(String newContent) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    public boolean isReferenceTo(PsiElement psiElement) {
        return this.myPsiElement.getManager().areElementsEquivalent(this.resolve(), psiElement);
    }

    @NotNull
    public Object[] getVariants() {
        VirtualFile requester = this.getContainingFile();
        CompletionModuleInfo[] modules = this.getModuleInfos(requester);
        Arrays.sort(modules, Comparator.comparing(CompletionModuleInfo::getName));
        ArrayList lookupElements = Lists.newArrayListWithCapacity((int)modules.length);
        for (CompletionModuleInfo module : modules) {
            lookupElements.add(NodeFileModulePsiReferenceBase.createLookupElement(requester, module));
        }
        Object[] objectArray = lookupElements.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(9);
        }
        return objectArray;
    }

    @NotNull
    public static LookupElement createLookupElement(final @Nullable VirtualFile context, final @NotNull CompletionModuleInfo module) {
        if (module == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(10);
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)module.getName());
        LookupElementBuilder lookupElementBuilder = element = element.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(element.getLookupString());
                presentation.setTypeGrayed(true);
                presentation.setIcon(AllIcons.Nodes.Folder);
                if (module.getType() == ModuleType.CORE_MODULE) {
                    presentation.setTypeText("Node.js core module");
                } else {
                    String presentablePath = module.getPresentablePath(context);
                    if (presentablePath != null) {
                        presentation.setTypeText(presentablePath);
                        presentation.setTypeGrayed(true);
                    }
                }
            }
        });
        if (lookupElementBuilder == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(11);
        }
        return lookupElementBuilder;
    }

    @NotNull
    protected abstract CompletionModuleInfo[] getModuleInfos(VirtualFile var1);

    @Nullable
    public VirtualFile getContainingFile() {
        VirtualFile vFile;
        PsiFile psiFile = this.getElement().getContainingFile();
        if (psiFile != null && (vFile = (psiFile = psiFile.getOriginalFile()).getVirtualFile()) != null && vFile.isValid()) {
            return vFile;
        }
        return null;
    }

    @NotNull
    public String getRequiredModuleName() {
        String string = this.myRequiredModuleName;
        if (string == null) {
            NodeFileModulePsiReferenceBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalOrModuleReferenceOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalModuleInProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalModuleInProject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

