/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeJsCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.settings.NodeVersionListener;
import com.intellij.javascript.nodejs.settings.coreModules.NewSetupNodeCoreSourcesDialog;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ScriptingContextsConfigurable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreSourcesView
implements NodeVersionListener {
    private final Project myProject;
    private final VirtualFile myRequestor;
    private final ThreeStateCheckBox myCheckBox;
    private final JPanel myPanel;
    private final LinkLabel<Void> myLinkLabel;
    private NodeJsInterpreter myLastInterpreter;
    private SemVer myLastVersion;

    public NodeCoreSourcesView(@NotNull Project project, @Nullable VirtualFile requestor) {
        if (project == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRequestor = requestor;
        this.myCheckBox = new ThreeStateCheckBox("Coding assistance for Node.js");
        this.myCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeCoreSourcesView.this.selectionChanged(!ThreeStateCheckBox.State.NOT_SELECTED.equals((Object)NodeCoreSourcesView.this.myCheckBox.getState()));
            }
        });
        this.myLinkLabel = new LinkLabel("Manage Scopes...", null, (LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel aSource, Void aLinkData) {
                NodeCoreSourcesView.this.showUsageScopeDialog();
            }
        });
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.add((Component)this.myCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myPanel.add((Component)this.myLinkLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        this.myPanel.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 256, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myCheckBox.setEnabled(false);
        this.myLinkLabel.setEnabled(false);
    }

    private void selectionChanged(boolean selected) {
        this.myCheckBox.setSelected(selected);
        if (selected) {
            ModalityState modalityState = ModalityState.current();
            NodeJsInterpreter interpreter = Objects.requireNonNull(this.myLastInterpreter);
            interpreter.provideCachedVersionOrFetch((NullableConsumer<SemVer>)((NullableConsumer)version -> ApplicationManager.getApplication().invokeLater(() -> {
                if (version != null) {
                    NodeCoreSourcesView.enableCodeAssistance(this.myProject, interpreter, version, this.myRequestor, () -> this.versionUpdated(this.myLastInterpreter, this.myLastVersion));
                } else {
                    this.versionUpdated(this.myLastInterpreter, this.myLastVersion);
                }
            }, modalityState, this.myProject.getDisposed())));
        } else {
            NodeJsCoreLibraryConfigurator.getInstance(this.myProject).disable();
            this.versionUpdated(this.myLastInterpreter, this.myLastVersion);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public void versionUpdateStarted() {
    }

    @Override
    public void versionUpdated(@Nullable NodeJsInterpreter interpreter, @Nullable SemVer version) {
        this.myLastInterpreter = interpreter;
        this.myLastVersion = version;
        if (interpreter == null || version == null) {
            this.myCheckBox.setEnabled(false);
            this.myLinkLabel.setEnabled(false);
            return;
        }
        this.myCheckBox.setEnabled(true);
        ThreeStateCheckBox.State state = this.getState(interpreter, version);
        this.myCheckBox.setState(state);
        this.myLinkLabel.setEnabled(state != ThreeStateCheckBox.State.NOT_SELECTED);
    }

    @NotNull
    private ThreeStateCheckBox.State getState(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version) {
        NodeJsCoreLibraryConfigurator configurator;
        SemVer currentVersion;
        if (interpreter == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(2);
        }
        if (version == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(3);
        }
        if ((currentVersion = (configurator = NodeJsCoreLibraryConfigurator.getInstance(this.myProject)).getConfiguredCoreLibraryVersion()) == null || !currentVersion.getRawVersion().equals(version.getRawVersion())) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
            if (state == null) {
                NodeCoreSourcesView.$$$reportNull$$$0(4);
            }
            return state;
        }
        boolean hasLibrary = (Boolean)ReadAction.compute(() -> {
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
            ScriptingLibraryModel coreLibrary = libraryManager.getLibraryByName("Node.js Core");
            return coreLibrary != null;
        });
        if (!hasLibrary) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
            if (state == null) {
                NodeCoreSourcesView.$$$reportNull$$$0(5);
            }
            return state;
        }
        ThreeStateCheckBox.State state = (ThreeStateCheckBox.State)ReadAction.compute(() -> {
            JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(this.myProject);
            List mappings = libraryMappings.getMappingsByLibraryName("Node.js Core");
            if (mappings.contains(null)) {
                return ThreeStateCheckBox.State.SELECTED;
            }
            if (mappings.isEmpty()) {
                return ThreeStateCheckBox.State.NOT_SELECTED;
            }
            return ThreeStateCheckBox.State.DONT_CARE;
        });
        if (state == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(6);
        }
        return state;
    }

    public static void enableCodeAssistance(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @Nullable VirtualFile requestor, @Nullable Runnable onDone) {
        if (project == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(7);
        }
        if (interpreter == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(8);
        }
        if (version == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(9);
        }
        if (PlatformUtils.isIntelliJ()) {
            NewSetupNodeCoreSourcesDialog dialog = new NewSetupNodeCoreSourcesDialog(project, interpreter, version, requestor, onDone);
            dialog.show();
        } else {
            NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance(project);
            configurator.configureAndAssociateWithProject(interpreter, version, onDone);
        }
    }

    private void showUsageScopeDialog() {
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(this.myProject);
        boolean ok = ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new ScriptingContextsConfigurable(this.myProject, (ScriptingLibraryMappings)mappings));
        if (ok) {
            ApplicationManager.getApplication().runWriteAction(() -> JSLibraryManager.getInstance(this.myProject).commitChanges());
            this.versionUpdated(this.myLastInterpreter, this.myLastVersion);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/settings/NodeCoreSourcesView";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodeCoreSourcesView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enableCodeAssistance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

