/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackage {
    @NotNull
    private final String mySystemDependentPath;
    @Nullable
    private File myDir;

    public NodePackage(@NotNull String path) {
        if (path == null) {
            NodePackage.$$$reportNull$$$0(0);
        }
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (char)'/');
        this.mySystemDependentPath = FileUtil.toSystemDependentName((String)path);
    }

    @NotNull
    public String getSystemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.mySystemDependentPath);
        if (string == null) {
            NodePackage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getSystemDependentPath() {
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEmptyPath() {
        return this.mySystemDependentPath.isEmpty();
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.mySystemDependentPath);
        if (string == null) {
            NodePackage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public SemVer getVersion() {
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return null;
        }
        return NodePackageVersionUtil.getPackageVersion(this.getDir());
    }

    @NotNull
    private File getDir() {
        File file2 = this.myDir;
        if (file2 == null) {
            this.myDir = file2 = new File(this.mySystemDependentPath);
        }
        File file3 = file2;
        if (file3 == null) {
            NodePackage.$$$reportNull$$$0(4);
        }
        return file3;
    }

    @NotNull
    public String getPresentablePath() {
        String userHome = StringUtil.trimEnd((String)FileUtil.toSystemDependentName((String)SystemProperties.getUserHome()), (char)File.separatorChar);
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.mySystemDependentPath;
            if (string == null) {
                NodePackage.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (this.mySystemDependentPath.startsWith(userHome + File.separatorChar)) {
            String string = "~" + this.mySystemDependentPath.substring(userHome.length());
            if (string == null) {
                NodePackage.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isValid() {
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return false;
        }
        File dir = this.getDir();
        return dir.isAbsolute() && dir.isDirectory();
    }

    @Nullable
    public String getErrorMessage(@NotNull String packageName) {
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return "Unspecified " + packageName + " package";
        }
        File dir = this.getDir();
        if (!dir.isAbsolute() || !dir.isDirectory()) {
            return "Invalid " + packageName + " package: no such directory";
        }
        return null;
    }

    public void validateForRunConfiguration(@NotNull String packageName) throws RuntimeConfigurationError {
        String message;
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(9);
        }
        if ((message = this.getErrorMessage(packageName)) != null) {
            throw new RuntimeConfigurationError(message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePackage aPackage = (NodePackage)o;
        return this.mySystemDependentPath.equals(aPackage.mySystemDependentPath);
    }

    public int hashCode() {
        return this.mySystemDependentPath.hashCode();
    }

    @Nullable
    public static NodePackage findDefaultPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(10);
        }
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(11);
        }
        List<NodePackage> packages = new NodePackageDescriptor(packageName).listAvailable(project, interpreter, null);
        return (NodePackage)ContainerUtil.getFirstItem(packages);
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull List<String> packageNames, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(12);
        }
        if (packageNames == null) {
            NodePackage.$$$reportNull$$$0(13);
        }
        NodePackage nodePackage = new NodePackageDescriptor(packageNames).findFirstDirectDependencyPackage(project, interpreter, null);
        if (nodePackage == null) {
            NodePackage.$$$reportNull$$$0(14);
        }
        return nodePackage;
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(15);
        }
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(16);
        }
        NodePackage nodePackage = new NodePackageDescriptor(packageName).findFirstDirectDependencyPackage(project, interpreter, null);
        if (nodePackage == null) {
            NodePackage.$$$reportNull$$$0(17);
        }
        return nodePackage;
    }

    public String toString() {
        return this.mySystemDependentPath;
    }

    @Nullable
    public File findBinFile() {
        PackageJsonData data;
        VirtualFile packageJson;
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return null;
        }
        VirtualFile packageDir = LocalFileSystem.getInstance().findFileByIoFile(this.getDir());
        if (packageDir != null && packageDir.isValid() && (packageJson = PackageJsonUtil.findChildPackageJsonFile(packageDir)) != null && (data = PackageJsonData.getOrCreate(packageJson)).getBinPath() != null) {
            return Paths.get(packageDir.getPath(), data.getBinPath()).normalize().toFile();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackage";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemIndependentPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDependentPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDir";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findPreferredPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateForRunConfiguration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultPackage";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findPreferredPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

