/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageEditor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.javascript.nodejs.util.NodePackageRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class NodePackageField
extends ComponentWithBrowseButton<ComboBox<NodePackageRef>> {
    private static final NodePackageRef SELECT_PACKAGE = NodePackageRef.create("##Select package");
    private final Project myProject;
    private final NodePackageDescriptor myDescriptor;
    private final KeyEventAwareComboBox<NodePackageRef> myComboBox;
    private final DefaultComboBoxModel<NodePackageRef> myModel;
    private final NodePackageEditor myEditor;
    private final List<Consumer<NodePackage>> itemSelectedListeners;
    private final NodePackageRefResolver myResolver;

    public NodePackageField(@NotNull Project project, @NotNull String packageName, @Nullable Supplier<NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            NodePackageField.$$$reportNull$$$0(1);
        }
        this(project, Collections.singletonList(packageName), interpreterSupplier);
    }

    public NodePackageField(@NotNull Project project, @NotNull List<String> packageNames, @Nullable Supplier<NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(2);
        }
        if (packageNames == null) {
            NodePackageField.$$$reportNull$$$0(3);
        }
        this(project, new NodePackageDescriptor(packageNames), interpreterSupplier, null);
    }

    public NodePackageField(@NotNull NodeJsInterpreterField interpreterField, @NotNull String packageName) {
        if (interpreterField == null) {
            NodePackageField.$$$reportNull$$$0(4);
        }
        if (packageName == null) {
            NodePackageField.$$$reportNull$$$0(5);
        }
        this(interpreterField.getProject(), new NodePackageDescriptor(packageName), interpreterField::getInterpreter, interpreterField, null);
    }

    public NodePackageField(@NotNull NodeJsInterpreterField interpreterField, @NotNull NodePackageDescriptor descriptor2, @Nullable Supplier<VirtualFile> contextFileOrDirectorySupplier) {
        if (interpreterField == null) {
            NodePackageField.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            NodePackageField.$$$reportNull$$$0(7);
        }
        this(interpreterField.getProject(), descriptor2, interpreterField::getInterpreter, interpreterField, contextFileOrDirectorySupplier);
    }

    public NodePackageField(@NotNull Project project, @NotNull NodePackageDescriptor descriptor2, @Nullable Supplier<NodeJsInterpreter> interpreterSupplier, @Nullable Supplier<VirtualFile> contextFileOrDirectorySupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(8);
        }
        if (descriptor2 == null) {
            NodePackageField.$$$reportNull$$$0(9);
        }
        this(project, descriptor2, interpreterSupplier, null, contextFileOrDirectorySupplier);
    }

    private NodePackageField(@NotNull Project project, @NotNull NodePackageDescriptor descriptor2, @Nullable Supplier<NodeJsInterpreter> interpreterSupplier, @Nullable NodeJsInterpreterField interpreterField, @Nullable Supplier<VirtualFile> contextFileOrDirectorySupplier) {
        if (project == null) {
            NodePackageField.$$$reportNull$$$0(10);
        }
        if (descriptor2 == null) {
            NodePackageField.$$$reportNull$$$0(11);
        }
        super(new KeyEventAwareComboBox(), null);
        this.itemSelectedListeners = ContainerUtil.newArrayList();
        this.myProject = project;
        this.myDescriptor = descriptor2;
        this.myComboBox = (KeyEventAwareComboBox)((Object)this.getChildComponent());
        this.myModel = new DefaultComboBoxModel();
        this.myComboBox.setModel(this.myModel);
        this.myResolver = new NodePackageRefResolver(project, descriptor2, interpreterSupplier);
        this.myComboBox.setRenderer(new DelegatingListCellRenderer(this.myResolver));
        this.myComboBox.setEditable(true);
        this.myEditor = new NodePackageEditor(this.myModel, descriptor2, this.myResolver);
        this.myComboBox.setEditor(this.myEditor);
        if (interpreterField != null) {
            interpreterField.addChangeListener(newInterpreter -> this.myEditor.update());
        }
        this.myEditor.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NodePackageField.this.triggerItemSelectedListeners();
            }
        });
        this.installFileCompletionAndBrowserFolderListener(this.myEditor.getTextField());
        this.myComboBox.setMinimumAndPreferredWidth(0);
        this.installListeners(interpreterSupplier, contextFileOrDirectorySupplier);
    }

    @NotNull
    public JComponent getEditorComponent() {
        JTextField jTextField = this.myEditor.getTextField();
        if (jTextField == null) {
            NodePackageField.$$$reportNull$$$0(12);
        }
        return jTextField;
    }

    private void installListeners(final @Nullable Supplier<NodeJsInterpreter> interpreterSupplier, final @Nullable Supplier<VirtualFile> contextFileOrDirectorySupplier) {
        ItemListener itemListener = new ItemListener(){
            private Object myLastSelectedItem;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object selectedItem = NodePackageField.this.myComboBox.getSelectedItem();
                    if (selectedItem == SELECT_PACKAGE) {
                        NodePackageField.this.myComboBox.setSelectedItem(this.myLastSelectedItem);
                        if (!((KeyEventAwareComboBox)NodePackageField.this.myComboBox).myKeyEventProcessing) {
                            ApplicationManager.getApplication().invokeLater(() -> NodePackageField.this.performSelection((NodePackage)ObjectUtils.tryCast((Object)this.myLastSelectedItem, NodePackage.class)), ModalityState.defaultModalityState());
                        }
                    } else {
                        this.myLastSelectedItem = selectedItem;
                    }
                    NodePackageField.this.triggerItemSelectedListeners();
                }
            }
        };
        this.myComboBox.addItemListener(itemListener);
        this.myComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                NodeJsInterpreter interpreter = interpreterSupplier != null ? (NodeJsInterpreter)interpreterSupplier.get() : null;
                VirtualFile contextFileOrDirectory = contextFileOrDirectorySupplier != null ? (VirtualFile)contextFileOrDirectorySupplier.get() : null;
                List<NodePackageRef> refs = NodePackageField.this.myDescriptor.listPackageRefs(NodePackageField.this.myProject, interpreter, contextFileOrDirectory);
                NodePackageRef prevSelected = NodePackageField.this.getSelectedRef();
                NodePackageField.this.myComboBox.doWithItemStateChangedEventsDisabled(() -> {
                    SwingHelper.updateItems((JComboBox)((Object)NodePackageField.this.myComboBox), (List)refs, null);
                    NodePackageField.this.myComboBox.addItem(SELECT_PACKAGE);
                    if (!refs.contains(prevSelected) || !prevSelected.equals(NodePackageField.this.myComboBox.getSelectedItem())) {
                        NodePackageField.this.myComboBox.setSelectedItem(prevSelected);
                    }
                });
            }
        });
    }

    private void triggerItemSelectedListeners() {
        NodePackage selected = this.getSelected();
        this.itemSelectedListeners.forEach(consumer -> consumer.consume((Object)selected));
    }

    private void performSelection(@Nullable NodePackage initial) {
        VirtualFile initialFile = initial != null ? LocalFileFinder.findFile((String)initial.getSystemIndependentPath()) : null;
        FileChooserDescriptor descriptor2 = this.createFileChooserDescriptor();
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this.myProject, (VirtualFile)initialFile);
        if (file2 != null) {
            this.addIfMissingAndSelect(this.myDescriptor.createPackageRef(file2.getPath()));
        }
    }

    @NotNull
    private FileChooserDescriptor createFileChooserDescriptor() {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor().withShowHiddenFiles(SystemInfo.isUnix);
        if (this.myDescriptor.getPackageNames().size() == 1) {
            descriptor2.withTitle("Select " + this.myDescriptor.getPackageNames().get(0) + " Package Directory");
        } else {
            descriptor2.withTitle("Select Package Directory");
            String text = this.myDescriptor.getHintText();
            if (text != null) {
                descriptor2.withDescription("Select " + text);
            }
        }
        FileChooserDescriptor fileChooserDescriptor = descriptor2;
        if (fileChooserDescriptor == null) {
            NodePackageField.$$$reportNull$$$0(13);
        }
        return fileChooserDescriptor;
    }

    private void addIfMissingAndSelect(@NotNull NodePackageRef ref) {
        int i;
        if (ref == null) {
            NodePackageField.$$$reportNull$$$0(14);
        }
        if ((i = this.myModel.getIndexOf(ref)) >= 0) {
            this.myModel.setSelectedItem(this.myModel.getElementAt(i));
        } else {
            this.myModel.addElement(ref);
            this.myModel.setSelectedItem(ref);
        }
    }

    public void addSelectionListener(@NotNull Consumer<NodePackage> listener2) {
        if (listener2 == null) {
            NodePackageField.$$$reportNull$$$0(15);
        }
        this.itemSelectedListeners.add(listener2);
    }

    public void setSelected(@NotNull NodePackage pkg) {
        if (pkg == null) {
            NodePackageField.$$$reportNull$$$0(16);
        }
        this.setSelectedRef(NodePackageRef.create(pkg));
    }

    public void setSelectedRef(@NotNull NodePackageRef pkgRef) {
        if (pkgRef == null) {
            NodePackageField.$$$reportNull$$$0(17);
        }
        this.addIfMissingAndSelect(pkgRef);
    }

    @NotNull
    public NodePackage getSelected() {
        NodePackage pkg = this.myResolver.resolve(this.myEditor.getItem());
        NodePackage nodePackage = pkg != null ? pkg : new NodePackage("");
        if (nodePackage == null) {
            NodePackageField.$$$reportNull$$$0(18);
        }
        return nodePackage;
    }

    @NotNull
    public NodePackageRef getSelectedRef() {
        NodePackageRef nodePackageRef = this.myEditor.getItem();
        if (nodePackageRef == null) {
            NodePackageField.$$$reportNull$$$0(19);
        }
        return nodePackageRef;
    }

    public void setPreferredWidthToFitText() {
        NodePackageRef ref = (NodePackageRef)this.myComboBox.getSelectedItem();
        if (ref != null) {
            this.myComboBox.setMinimumAndPreferredWidth(-1);
            NodePackageRef prevPrototype = (NodePackageRef)this.myComboBox.getPrototypeDisplayValue();
            this.myComboBox.setPrototypeDisplayValue(ref);
            Dimension size = this.getPreferredSize();
            this.setPreferredSize(size);
            this.myComboBox.setMinimumAndPreferredWidth(0);
            this.myComboBox.setPrototypeDisplayValue(prevPrototype);
        }
    }

    private void installFileCompletionAndBrowserFolderListener(@NotNull JTextField textField) {
        if (textField == null) {
            NodePackageField.$$$reportNull$$$0(20);
        }
        FileChooserDescriptor descriptor2 = this.createFileChooserDescriptor();
        FileChooserFactory.getInstance().installFileCompletion(textField, descriptor2, true, (Disposable)this.myProject);
        this.addBrowseFolderListener(null, null, this.myProject, descriptor2, this.myEditor.getTextComponentAccessor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageField";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgRef";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageField";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileChooserDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelected";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addIfMissingAndSelect";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedRef";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "installFileCompletionAndBrowserFolderListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DelegatingListCellRenderer
    implements ListCellRenderer<NodePackageRef> {
        private final SpecialValueRenderer mySpecialValueRenderer;
        private final NodePackageRenderer myPackageRenderer;

        public DelegatingListCellRenderer(NodePackageRefResolver refResolver) {
            if (refResolver == null) {
                DelegatingListCellRenderer.$$$reportNull$$$0(0);
            }
            this.mySpecialValueRenderer = new SpecialValueRenderer();
            this.myPackageRenderer = new NodePackageRenderer(refResolver);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends NodePackageRef> list, NodePackageRef value, int index, boolean isSelected, boolean cellHasFocus) {
            SpecialValueRenderer renderer = value == null || value == SELECT_PACKAGE ? this.mySpecialValueRenderer : this.myPackageRenderer;
            list.setEnabled(NodePackageField.this.isEnabled());
            return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refResolver", "com/intellij/javascript/nodejs/util/NodePackageField$DelegatingListCellRenderer", "<init>"));
        }
    }

    private static class SpecialValueRenderer
    extends ColoredListCellRenderer<NodePackageRef> {
        public SpecialValueRenderer() {
            this.setIpad((Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0));
            NodeJsInterpreterRenderer.adjustBorderHeight((SimpleColoredComponent)this);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends NodePackageRef> list, @Nullable NodePackageRef value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                SpecialValueRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                this.append("No package", new SimpleTextAttributes(0, (Color)JBColor.RED));
            } else if (value == SELECT_PACKAGE) {
                this.append(" Select...", new SimpleTextAttributes(0, (Color)JBColor.darkGray));
            } else {
                this.append("Unexpected value: " + value.toString(), new SimpleTextAttributes(0, (Color)JBColor.RED));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/util/NodePackageField$SpecialValueRenderer", "customizeCellRenderer"));
        }
    }

    private static class KeyEventAwareComboBox<T>
    extends ComboBox<T> {
        private boolean myKeyEventProcessing = false;
        private boolean myItemStateChangedEventsAllowed = true;

        private KeyEventAwareComboBox() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            try {
                this.myKeyEventProcessing = true;
                boolean bl = super.processKeyBinding(ks, e, condition, pressed);
                return bl;
            }
            finally {
                this.myKeyEventProcessing = false;
            }
        }

        protected void selectedItemChanged() {
            if (this.myItemStateChangedEventsAllowed) {
                super.selectedItemChanged();
            }
        }

        public void doWithItemStateChangedEventsDisabled(@NotNull Runnable runnable) {
            if (runnable == null) {
                KeyEventAwareComboBox.$$$reportNull$$$0(0);
            }
            this.myItemStateChangedEventsAllowed = false;
            try {
                runnable.run();
            }
            finally {
                this.myItemStateChangedEventsAllowed = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/javascript/nodejs/util/NodePackageField$KeyEventAwareComboBox", "doWithItemStateChangedEventsDisabled"));
        }
    }
}

