/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.actions.CompatibleRunConfigurationProducer;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsTestRunConfigurationProducer<T extends RunConfiguration>
extends CompatibleRunConfigurationProducer<T> {
    private static final VolatileNotNullLazyValue<List<String>> TEST_RUNNER_PACKAGES = VolatileNotNullLazyValue.createValue(() -> {
        ArrayList testRunnerPackages = ContainerUtil.newArrayList();
        for (RunConfigurationProducer producer : (RunConfigurationProducer[])EP_NAME.getExtensions()) {
            if (!(producer instanceof JsTestRunConfigurationProducer)) continue;
            testRunnerPackages.addAll(((JsTestRunConfigurationProducer)producer).myTestRunnerPackageNames);
        }
        return testRunnerPackages;
    });
    private static final Key<CachedValue<Boolean>> KEY = Key.create((String)JsTestRunConfigurationProducer.class.getSimpleName());
    private final List<String> myTestRunnerPackageNames;
    private final List<String> myStopPackageNames;

    protected JsTestRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull List<String> testRunnerPackageNames) {
        if (configurationType == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (testRunnerPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        this(configurationType, testRunnerPackageNames, (List<String>)ImmutableList.of());
    }

    protected JsTestRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull List<String> testRunnerPackageNames, @NotNull List<String> stopPackageNames) {
        if (configurationType == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (testRunnerPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (stopPackageNames == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        super(configurationType);
        this.myTestRunnerPackageNames = ImmutableList.copyOf(testRunnerPackageNames);
        this.myStopPackageNames = ImmutableList.copyOf(stopPackageNames);
    }

    public boolean isTestRunnerPackageAvailableFor(@NotNull PsiElement element) {
        if (element == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        return this.isTestRunnerPackageAvailableFor(element.getProject(), PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    public boolean isTestRunnerPackageAvailableFor(@NotNull Project project, @Nullable VirtualFile fileOrDir) {
        if (project == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return JsTestRunConfigurationProducer.hasAnyPackageDeclaredAsDependency(project, fileOrDir, this.myTestRunnerPackageNames, this.myStopPackageNames);
    }

    private static boolean hasAnyPackageDeclaredAsDependency(@NotNull Project project, @Nullable VirtualFile fileOrDir, @NotNull List<String> packages, @NotNull List<String> stopPackages) {
        if (project == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (packages == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (stopPackages == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        Ref foundRef = Ref.create((Object)false);
        if (fileOrDir != null) {
            PackageJsonUtil.processUpPackageJsonFiles(project, fileOrDir, (Processor<VirtualFile>)((Processor)packageJson -> {
                if (stopPackages == null) {
                    JsTestRunConfigurationProducer.$$$reportNull$$$0(14);
                }
                if (packages == null) {
                    JsTestRunConfigurationProducer.$$$reportNull$$$0(15);
                }
                PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
                for (String stopPackage : stopPackages) {
                    if (!data.isDependencyOfAnyType(stopPackage)) continue;
                    return true;
                }
                for (String pkg : packages) {
                    if (!data.isDependencyOfAnyType(pkg)) continue;
                    foundRef.set((Object)true);
                    break;
                }
                return (Boolean)foundRef.get() == false;
            }));
        }
        return (Boolean)foundRef.get();
    }

    public static boolean isTestRunnerPackageAvailableFor(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiFile, KEY, () -> {
            if (psiFile == null) {
                JsTestRunConfigurationProducer.$$$reportNull$$$0(13);
            }
            boolean result2 = JsTestRunConfigurationProducer.hasAnyPackageDeclaredAsDependency(psiFile.getProject(), PsiUtilCore.getVirtualFile((PsiElement)psiFile), (List)TEST_RUNNER_PACKAGES.getValue(), Collections.emptyList());
            return new CachedValueProvider.Result((Object)result2, new Object[]{VirtualFileManager.getInstance()});
        });
    }

    @Nullable
    public static VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull String contextFilePath) {
        String dirPath;
        if (project == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (contextFilePath == null) {
            JsTestRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmptyOrSpaces((String)(dirPath = PathUtil.getParentPath((String)contextFilePath)))) {
            return project.getBaseDir();
        }
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(dirPath);
        if (dir == null) {
            return project.getBaseDir();
        }
        Ref ref = Ref.create();
        PackageJsonUtil.processUpPackageJsonFiles(project, dir, (Processor<VirtualFile>)((Processor)packageJson -> {
            ref.set(packageJson);
            return false;
        }));
        VirtualFile packageJson2 = (VirtualFile)ref.get();
        VirtualFile result2 = packageJson2 != null ? packageJson2.getParent() : null;
        return (VirtualFile)ObjectUtils.notNull((Object)result2, (Object)dir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerPackageNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPackageNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPackages";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFilePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testing/JsTestRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestRunnerPackageAvailableFor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAnyPackageDeclaredAsDependency";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "guessWorkingDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isTestRunnerPackageAvailableFor$2";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hasAnyPackageDeclaredAsDependency$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

