/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.modules.ImportES6ModuleFix;
import com.intellij.lang.javascript.modules.JSModuleFixDescriptor;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportPsiUtil {
    public static final String DEFAULT = "default";
    public static final TokenSet ES6_IMPORT_DECLARATION = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.IMPORT_DECLARATION});
    public static final TokenSet IMPORT_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{TypeScriptElementTypes.IMPORT_STATEMENT, ES6ElementTypes.IMPORT_DECLARATION});
    public static final Comparator<String> IMPORT_FROM_PART_COMPARATOR = (fromClauseText1, fromClauseText2) -> {
        if (fromClauseText1 != null) {
            if (fromClauseText2 == null) {
                return 1;
            }
            if (!fromClauseText1.startsWith(".") && fromClauseText2.startsWith(".")) {
                return -1;
            }
            if (fromClauseText1.startsWith(".") && !fromClauseText2.startsWith(".")) {
                return 1;
            }
        }
        return StringUtil.compare((String)fromClauseText1, (String)fromClauseText2, (boolean)true);
    };

    @Nullable
    public static ES6ImportDeclaration findExistingES6ImportByFromText(PsiElement[] declarations, @NotNull String moduleName, boolean checkAcceptable) {
        String unquotedModule;
        if (moduleName == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(0);
        }
        if (!(unquotedModule = StringUtil.unquoteString((String)moduleName)).isEmpty()) {
            for (PsiElement declaration : declarations) {
                String fromText;
                if (!(declaration instanceof ES6ImportDeclaration) || !unquotedModule.equals(fromText = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)((ES6ImportDeclaration)declaration))) || checkAcceptable && !ES6ImportPsiUtil.isAcceptableAsExistingImport((ES6ImportDeclaration)declaration)) continue;
                return (ES6ImportDeclaration)declaration;
            }
        }
        return null;
    }

    public static boolean isAcceptableAsExistingImport(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(1);
        }
        if (declaration.getImportSpecifiers().length > 0) {
            return true;
        }
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        return bindings.length == 0 || bindings.length == 1 && !bindings[0].isNamespaceImport();
    }

    public static boolean tryToAddImportToExistingDeclaration(@NotNull ES6ImportDeclaration declaration, @NotNull String name, @NotNull ImportExportType type) {
        ES6ImportedBinding[] bindings;
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(3);
        }
        if (type == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(4);
        }
        if (type == ImportExportType.BARE) {
            return true;
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)declaration)) {
            return false;
        }
        if (type == ImportExportType.DEFAULT && (bindings = declaration.getImportedBindings()).length == 0) {
            return ES6ImportPsiUtil.insertBinding(declaration, name) != null;
        }
        if (type == ImportExportType.SPECIFIER) {
            CreateImportExportInfo info = new CreateImportExportInfo(name, type);
            return ES6ImportPsiUtil.insertImportSpecifier(declaration, info) != null;
        }
        return false;
    }

    @NotNull
    public static Pair<Boolean, PsiElement> findPlaceByModuleName(@NotNull PsiElement scope, @NotNull String moduleName) {
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(5);
        }
        if (moduleName == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(6);
        }
        if (!JSCodeStyleSettings.getSettings((PsiElement)scope).IMPORT_SORT_MODULE_NAME) {
            Pair<Boolean, PsiElement> pair = ES6ImportPsiUtil.findPlaceForImport(scope);
            if (pair == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(7);
            }
            return pair;
        }
        List<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations(scope);
        if (declarations.isEmpty()) {
            Pair<Boolean, PsiElement> pair = ES6ImportPsiUtil.findPlaceForImport(scope);
            if (pair == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Function function = el -> ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)el);
        int position = ES6ImportPsiUtil.getInsertAfterPosition(declarations, function, IMPORT_FROM_PART_COMPARATOR, moduleName);
        if (position == -1) {
            List<PsiElement> comments;
            ES6ImportDeclaration importDeclaration;
            ES6ImportDeclaration insertBefore = importDeclaration = declarations.get(0);
            Document document = PsiDocumentManager.getInstance((Project)scope.getProject()).getDocument(importDeclaration.getContainingFile());
            if (document != null && (comments = JSOptimizeImportUtil.getPrevComments(document, (PsiElement)importDeclaration)).size() > 0) {
                insertBefore = comments.get(0);
            }
            Pair pair = Pair.create((Object)false, (Object)insertBefore);
            if (pair == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(9);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)true, (Object)declarations.get(position));
        if (pair == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @NotNull
    public static Pair<Boolean, PsiElement> findPlaceForImport(@NotNull PsiElement scope) {
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(11);
        }
        Pair<Boolean, PsiElement> pair = ES6ImportPsiUtil.findAnchorToInsert(scope, IMPORT_ELEMENT_TYPES, true);
        if (pair == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @NotNull
    public static Pair<Boolean, PsiElement> findAnchorToInsert(@NotNull PsiElement scope, TokenSet elementTypesToSkip, boolean first) {
        PsiElement afterWhitespaces;
        ASTNode lBrace;
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(13);
        }
        PsiElement startElement = scope.getFirstChild();
        if (scope instanceof TypeScriptModule && (lBrace = scope.getNode().findChildByType(JSTokenTypes.LBRACE)) != null) {
            startElement = lBrace.getPsi().getNextSibling();
        }
        if (startElement == null) {
            Pair pair = Pair.create((Object)true, null);
            if (pair == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(14);
            }
            return pair;
        }
        PsiElement currentChild = startElement;
        PsiElement psiElement = afterWhitespaces = scope instanceof JSFile && currentChild instanceof PsiWhiteSpace ? JSRefactoringUtil.skipWhitespaces(startElement, true) : null;
        if (afterWhitespaces != null) {
            currentChild = afterWhitespaces;
        }
        PsiElement lastElement = null;
        while (currentChild != null) {
            if (elementTypesToSkip.contains(currentChild.getNode().getElementType())) {
                lastElement = currentChild;
            } else if (lastElement == null && ES6ImportPsiUtil.shouldInsertImportBeforeElement(currentChild)) break;
            currentChild = currentChild.getNextSibling();
        }
        if (afterWhitespaces != null && afterWhitespaces == currentChild) {
            Pair pair = Pair.create((Object)false, (Object)startElement);
            if (pair == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(15);
            }
            return pair;
        }
        PsiElement place = lastElement;
        if (place == null) {
            if (!first) {
                ASTNode rBrace;
                place = scope.getLastChild();
                if (scope instanceof TypeScriptModule && (rBrace = scope.getNode().findChildByType(JSTokenTypes.RBRACE)) != null) {
                    place = rBrace.getPsi().getPrevSibling();
                }
                Pair pair = Pair.create((Object)true, (Object)place);
                if (pair == null) {
                    ES6ImportPsiUtil.$$$reportNull$$$0(16);
                }
                return pair;
            }
            place = currentChild;
        }
        Pair pair = Pair.create((Object)(lastElement != null ? 1 : 0), (Object)place);
        if (pair == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(17);
        }
        return pair;
    }

    private static boolean shouldInsertImportBeforeElement(@Nullable PsiElement currentChild) {
        return !(currentChild instanceof PsiWhiteSpace) && !JSPsiImplUtils.isCompilerDirectiveStatement(currentChild) && !(currentChild instanceof PsiComment);
    }

    @Nullable
    public static ES6ImportDeclaration findExistingES6Import(@NotNull PsiElement placeModule, @Nullable PsiElement module, @NotNull String moduleName, boolean anyImport) {
        PsiElement[] declarations;
        if (placeModule == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(18);
        }
        if (moduleName == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(19);
        }
        if ((declarations = JSResolveUtil.getStubbedChildren(placeModule, ES6_IMPORT_DECLARATION)).length == 0) {
            return null;
        }
        ES6ImportDeclaration result2 = ES6ImportPsiUtil.findExistingES6ImportByFromText(declarations, moduleName, anyImport);
        if (result2 != null) {
            return result2;
        }
        return ES6ImportPsiUtil.findExistingES6ImportByFromModules(declarations, module, anyImport);
    }

    @Nullable
    public static ES6ImportDeclaration findExistingES6ImportByFromModules(@NotNull PsiElement[] declarations, @Nullable PsiElement module, boolean checkAcceptable) {
        if (declarations == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(20);
        }
        if (module == null) {
            return null;
        }
        for (PsiElement declaration : declarations) {
            Collection resolvedElements;
            ES6ImportDeclaration es6Import;
            ES6FromClause clause;
            if (!(declaration instanceof ES6ImportDeclaration) || (clause = (es6Import = (ES6ImportDeclaration)declaration).getFromClause()) == null || !(resolvedElements = clause.resolveReferencedElements()).contains(module) || checkAcceptable && !ES6ImportPsiUtil.isAcceptableAsExistingImport((ES6ImportDeclaration)declaration)) continue;
            return es6Import;
        }
        return null;
    }

    public static String getExportedElementName(@NotNull JSElement element) {
        if (element == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(21);
        }
        if (element instanceof JSExportAssignment) {
            String fileName = element.getContainingFile().getName();
            return JSFileReference.getFileNameWithoutExtension(fileName, JSFileReference.IMPLICIT_EXTENSIONS);
        }
        if (element instanceof ES6ExportSpecifier) {
            return ((ES6ExportSpecifier)element).getDeclaredName();
        }
        return element.getName();
    }

    @NotNull
    public static String getQuote(@NotNull PsiElement context, @Nullable ASTNode stringLiteralNode) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(22);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        if (settings.FORCE_QUOTE_STYlE || stringLiteralNode == null) {
            String string = JSCodeStyleSettings.getQuote(context);
            if (string == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(23);
            }
            return string;
        }
        String text = stringLiteralNode.getText();
        String string = StringUtil.isEmpty((String)text) ? "\"" : String.valueOf(text.charAt(0));
        if (string == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static boolean isFlowTypeDefinition(@Nullable PsiElement current) {
        return current != null && DialectDetector.isFlow(current) && current instanceof TypeScriptCompileTimeType;
    }

    @NotNull
    public static String wrapWithQuotesFromSettings(String externalModuleName, @NotNull PsiElement context) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(25);
        }
        String quote = JSCodeStyleSettings.getQuote(context);
        String string = externalModuleName = quote + externalModuleName + quote;
        if (string == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static List<ES6ImportDeclaration> getImportDeclarations(@NotNull PsiElement scope) {
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(27);
        }
        List list = PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)scope, ES6ImportDeclaration.class);
        if (list == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public static ES6ExistingImports getExistingImports(@NotNull PsiElement scope, @NotNull String fromReferenceText) {
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(29);
        }
        if (fromReferenceText == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(30);
        }
        List<ES6ImportDeclaration> elements = ES6ImportPsiUtil.getImportDeclarations(scope);
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)elements.size());
        for (ES6ImportDeclaration declaration : elements) {
            String quotedFromClauseText = ES6ImportPsiUtil.getFromClauseText((ES6ImportExportDeclaration)declaration);
            if (quotedFromClauseText == null || !fromReferenceText.equals(JSStringUtil.unquoteStringLiteralValue(quotedFromClauseText))) continue;
            result2.add(declaration);
        }
        ES6ExistingImports eS6ExistingImports = new ES6ExistingImports(result2);
        if (eS6ExistingImports == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(31);
        }
        return eS6ExistingImports;
    }

    @Nullable
    public static String getFromClauseText(@Nullable ES6ImportExportDeclaration declaration) {
        ES6FromClause clause;
        ES6FromClause eS6FromClause = clause = declaration == null ? null : declaration.getFromClause();
        if (clause == null) {
            return null;
        }
        return StringUtil.nullize((String)clause.getReferenceText());
    }

    @Nullable
    public static String getUnquotedFromClauseOrModuleText(@NotNull ES6ImportExportDeclaration declaration) {
        String text;
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(32);
        }
        if ((text = ES6ImportPsiUtil.getUnquotedFromClauseText(declaration)) != null) {
            return text;
        }
        String moduleText = declaration instanceof ES6ImportDeclaration ? ((ES6ImportDeclaration)declaration).getImportModuleText() : null;
        return moduleText == null ? null : JSStringUtil.unquoteStringLiteralValue(moduleText);
    }

    @Nullable
    public static String getUnquotedFromClauseText(@NotNull ES6ImportExportDeclaration declaration) {
        String fromClauseText;
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(33);
        }
        return (fromClauseText = ES6ImportPsiUtil.getFromClauseText(declaration)) == null ? null : JSStringUtil.unquoteStringLiteralValue(fromClauseText);
    }

    @Nullable
    public static ES6ImportedBinding insertBinding(@NotNull ES6ImportDeclaration declaration, String name) {
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(34);
        }
        assert (declaration.getImportedBindings().length == 0);
        ASTNode originalDeclarationNode = declaration.getNode();
        ASTNode importKeyword = originalDeclarationNode.findChildByType(JSTokenTypes.IMPORT_KEYWORD);
        assert (importKeyword != null);
        boolean needComma = declaration.getImportSpecifiers().length > 0;
        ES6ImportDeclaration tempDeclaration = JSChangeUtil.createStatementPsiFromTextWithContext("import " + name + (needComma ? ", {}" : "") + " from ''", (PsiElement)declaration, ES6ImportDeclaration.class);
        assert (tempDeclaration != null);
        ES6ImportedBinding binding = (ES6ImportedBinding)ArrayUtil.getFirstElement((Object[])tempDeclaration.getImportedBindings());
        assert (binding != null);
        Project project = declaration.getProject();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{declaration.getContainingFile()}).withName("Add import binding to import").run(() -> {
            if (declaration == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(75);
            }
            if (needComma) {
                ES6NamedImports imports = tempDeclaration.getNamedImports();
                assert (imports != null);
                declaration.addRangeAfter((PsiElement)binding, imports.getPrevSibling(), importKeyword.getPsi());
            } else {
                declaration.addAfter((PsiElement)binding, importKeyword.getPsi());
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformat((PsiElement)declaration);
        });
        return (ES6ImportedBinding)ArrayUtil.getFirstElement((Object[])declaration.getImportedBindings());
    }

    @Nullable
    public static ES6ImportSpecifier insertImportSpecifier(@NotNull ES6ImportDeclaration declaration, @NotNull CreateImportExportInfo info) {
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(35);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(36);
        }
        Project project = declaration.getProject();
        String importedName = info.getImportedName();
        String exportedName = info.getExportedName();
        if (importedName == null && exportedName == null) {
            return null;
        }
        InsertPlaceInDeclaration insertPlace = ES6ImportPsiUtil.getSpecifierInsertPlace(declaration, exportedName != null ? exportedName : importedName);
        if (insertPlace == null) {
            return null;
        }
        String importText = info.getImportType() == ImportExportType.SPECIFIER ? info.getRawText() : "{default as " + importedName + "}";
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(info.getDeclarationPrefixWithKeyword() + " " + importText, (PsiElement)declaration);
        if (importNode == null) {
            return null;
        }
        PsiElement anchor = insertPlace.getAnchor();
        if (anchor == null) {
            return null;
        }
        ArrayList elementsToAdd = ContainerUtil.newArrayList();
        ASTNode namedPart = importNode.findChildByType((IElementType)ES6ElementTypes.NAMED_IMPORTS);
        assert (namedPart != null);
        PsiElement host = insertPlace.host();
        if (insertPlace.hasSpecifiers()) {
            ASTNode specifier;
            if (insertPlace.needCommaBefore()) {
                elementsToAdd.add(JSChangeUtil.createCommaPsiElement((PsiElement)declaration));
            }
            if (ES6ImportPsiUtil.isInvalid(specifier = namedPart.findChildByType((IElementType)ES6ElementTypes.IMPORT_SPECIFIER))) {
                return null;
            }
            elementsToAdd.add(specifier.getPsi());
            if (insertPlace.needCommaAfter()) {
                elementsToAdd.add(JSChangeUtil.createCommaPsiElement((PsiElement)declaration));
            }
        } else {
            PsiElement namedImports = namedPart.getPsi().copy();
            if (insertPlace.needCommaBefore()) {
                elementsToAdd.add(JSChangeUtil.createCommaPsiElement((PsiElement)declaration));
            }
            elementsToAdd.add(namedImports);
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{declaration.getContainingFile()}).withName("Add import specifier to import").run(() -> {
            if (declaration == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(74);
            }
            PsiElement currentAnchor = anchor;
            for (PsiElement element : elementsToAdd) {
                currentAnchor = host.addAfter(element, currentAnchor);
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformat((PsiElement)declaration);
        });
        String name = info.getImportedName();
        if (name == null) {
            name = info.getExportedName();
        }
        return name == null ? null : ES6ImportPsiUtil.findImportSpecifierByReferenceName(declaration, name);
    }

    @Nullable
    public static ES6ImportSpecifier findImportSpecifierByReferenceName(@NotNull ES6ImportDeclaration element, @NotNull String referenceName) {
        ES6ImportSpecifier[] specifiers;
        if (element == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(37);
        }
        if (referenceName == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(38);
        }
        for (ES6ImportSpecifier importSpecifier : specifiers = element.getImportSpecifiers()) {
            if (!referenceName.equals(importSpecifier.getDeclaredName())) continue;
            return importSpecifier;
        }
        return null;
    }

    @Contract(value="null->true")
    private static boolean isInvalid(@Nullable ASTNode node) {
        return node == null;
    }

    public static void insertJSImport(@NotNull PsiElement contextToInsert, @NotNull String name, @NotNull PsiElement targetElement, @Nullable Editor editor) {
        if (contextToInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(39);
        }
        if (name == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(40);
        }
        if (targetElement == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(41);
        }
        boolean isDefault = targetElement instanceof JSExportAssignment || targetElement instanceof JSElementBase && ((JSElementBase)targetElement).isExportedWithDefault();
        ImportExportType importType = isDefault ? ImportExportType.DEFAULT : ImportExportType.SPECIFIER;
        ES6ImportPsiUtil.insertJSImport(contextToInsert, name, importType, targetElement, editor);
    }

    public static void insertJSImport(@NotNull PsiElement contextToInsert, @NotNull String name, @NotNull ImportExportType type, @NotNull PsiElement targetElementOrFile, @Nullable Editor editor) {
        if (contextToInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(42);
        }
        if (name == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(43);
        }
        if (type == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(44);
        }
        if (targetElementOrFile == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(45);
        }
        ES6ImportPsiUtil.insertJSImport(contextToInsert, name, name, type, targetElementOrFile, editor, false);
    }

    public static void insertJSImport(@NotNull PsiElement contextToInsert, @NotNull CreateImportExportInfo info, @NotNull PsiElement targetElementOrFile, @Nullable Editor editor) {
        if (contextToInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(46);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(47);
        }
        if (targetElementOrFile == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(48);
        }
        String exportedName = info.getExportedName();
        String importedName = info.getImportedName();
        String actualExportedName = (String)ObjectUtils.coalesce((Object)exportedName, (Object)importedName);
        String actualImportedName = (String)ObjectUtils.coalesce((Object)importedName, (Object)exportedName);
        if (actualExportedName == null) {
            return;
        }
        ES6ImportPsiUtil.insertJSImport(contextToInsert, actualExportedName, actualImportedName, info.getImportType(), targetElementOrFile, editor, info.isFlowTypeContext());
    }

    public static void insertJSImport(@NotNull PsiElement contextToInsert, @NotNull String exportedName, @NotNull String refName, @NotNull ImportExportType type, @NotNull PsiElement targetElementOrFile, @Nullable Editor editor, boolean flowTypeContext) {
        PsiFile targetFile;
        if (contextToInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(49);
        }
        if (exportedName == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(50);
        }
        if (refName == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(51);
        }
        if (type == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(52);
        }
        if (targetElementOrFile == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(53);
        }
        if ((targetFile = targetElementOrFile.getContainingFile().getOriginalFile()).equals(contextToInsert.getContainingFile())) {
            return;
        }
        JSModuleNameInfo moduleInfo = ES6CreateImportUtil.getExternalFileModuleName(targetElementOrFile, targetFile.getVirtualFile(), contextToInsert, true);
        JSModuleFixDescriptor descriptor2 = NodeJSModulesSearcher.createFixDescriptionFromFile(moduleInfo, ModuleFixCreator.ModuleType.es6, refName, exportedName);
        if (descriptor2 == null) {
            return;
        }
        descriptor2.setImportType(type);
        descriptor2.setIsFlowType(flowTypeContext || DialectDetector.isFlow(contextToInsert) && ES6ImportPsiUtil.isFlowTypeDefinition(targetElementOrFile));
        ES6ImportPsiUtil.insertJSImport(contextToInsert, descriptor2, editor);
    }

    private static void insertJSImport(@NotNull PsiElement contextToInsert, @NotNull JSModuleFixDescriptor descriptor2, @Nullable Editor editor) {
        if (contextToInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(54);
        }
        if (descriptor2 == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(55);
        }
        ImportES6ModuleFix fix = new ImportES6ModuleFix(contextToInsert, descriptor2, JSCodeStyleSettings.getQuote(contextToInsert), false){

            @Override
            protected boolean isAcceptableReference(@Nullable PsiElement element) {
                return true;
            }
        };
        fix.invokeAction(contextToInsert, editor);
    }

    @Nullable
    private static InsertPlaceInDeclaration getSpecifierInsertPlace(@NotNull ES6ImportDeclaration declaration, @NotNull String name) {
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(56);
        }
        if (name == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(57);
        }
        ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        ES6FromClause clause = declaration.getFromClause();
        boolean hasBindings = bindings.length > 0;
        ASTNode declarationNode = declaration.getNode();
        ASTNode namedImportsNode = declarationNode.findChildByType((IElementType)ES6ElementTypes.NAMED_IMPORTS);
        if (namedImportsNode == null) {
            PsiElement anchor;
            if (hasBindings) {
                for (ES6ImportedBinding binding : bindings) {
                    if (!binding.isNamespaceImport()) continue;
                    return null;
                }
            }
            PsiElement psiElement = anchor = clause != null ? clause.getPrevSibling() : null;
            if (anchor == null) {
                ASTNode importKeyword = declarationNode.findChildByType(JSTokenTypes.IMPORT_KEYWORD);
                anchor = importKeyword == null ? null : importKeyword.getPsi();
            }
            return ES6ImportPsiUtil.createInsertPlace(anchor, (PsiElement)declaration, hasBindings && !ES6ImportPsiUtil.hasComma(anchor), false, false);
        }
        ES6NamedImports namedImports = (ES6NamedImports)namedImportsNode.getPsi(ES6NamedImports.class);
        if (specifiers.length > 0) {
            boolean needCommaBefore;
            PsiElement anchor;
            return ES6ImportPsiUtil.createInsertPlace(anchor, (PsiElement)namedImports, needCommaBefore, !(needCommaBefore = (anchor = ES6ImportPsiUtil.getSpecifierAnchor(namedImports, specifiers, name)) instanceof ES6ImportExportSpecifier), true);
        }
        ASTNode node = namedImportsNode.findChildByType(JSTokenTypes.LBRACE);
        assert (node != null);
        PsiElement anchor = node.getPsi();
        return ES6ImportPsiUtil.createInsertPlace(anchor, (PsiElement)namedImports, false, false, true);
    }

    @Nullable
    private static PsiElement getSpecifierAnchor(@NotNull ES6NamedImports namedImports, @NotNull ES6ImportSpecifier[] specifiers, @NotNull String name) {
        boolean severalSpecifiers;
        if (namedImports == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(58);
        }
        if (specifiers == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(59);
        }
        if (name == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(60);
        }
        if (!JSCodeStyleSettings.getSettings((PsiElement)namedImports).IMPORT_SORT_MEMBERS) {
            return (PsiElement)ArrayUtil.getLastElement((Object[])specifiers);
        }
        List names = Arrays.stream(specifiers).map(el -> el.getReferenceName()).collect(Collectors.toList());
        ArrayList toProcess = ContainerUtil.newArrayList(names);
        Comparator<String> comparator = ES6ImportPsiUtil.getStringImportMemberComparator((PsiElement)namedImports);
        boolean bl = severalSpecifiers = toProcess.size() > 1;
        if (severalSpecifiers) {
            ContainerUtil.sort((List)toProcess, comparator);
        }
        if (severalSpecifiers && !toProcess.equals(names)) {
            return (PsiElement)ArrayUtil.getLastElement((Object[])specifiers);
        }
        int index = ES6ImportPsiUtil.getInsertAfterPosition(toProcess, el -> el, comparator, name);
        if (index == -1) {
            ASTNode lbraceNode = namedImports.getNode().findChildByType(JSTokenTypes.LBRACE);
            return lbraceNode == null ? (PsiElement)ArrayUtil.getLastElement((Object[])specifiers) : lbraceNode.getPsi();
        }
        return specifiers[index];
    }

    private static <T> int getInsertAfterPosition(Collection<T> elements, @NotNull Function<T, String> mapper, @NotNull Comparator<String> comparator, @NotNull String toInsert) {
        if (mapper == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(61);
        }
        if (comparator == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(62);
        }
        if (toInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(63);
        }
        int i = -1;
        for (T element : elements) {
            String currentString = (String)mapper.fun(element);
            if (comparator.compare(currentString, toInsert) >= 0) {
                return i;
            }
            ++i;
        }
        return elements.size() - 1;
    }

    @NotNull
    private static InsertPlaceInDeclaration createInsertPlace(final @Nullable PsiElement anchor, final @NotNull PsiElement host, final boolean needCommaBefore, final boolean needCommaAfter, final boolean hasSpecifiers) {
        if (host == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(64);
        }
        InsertPlaceInDeclaration insertPlaceInDeclaration = new InsertPlaceInDeclaration(){

            @Override
            @NotNull
            public PsiElement host() {
                PsiElement psiElement = host;
                if (psiElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiElement;
            }

            @Override
            @Nullable
            public PsiElement getAnchor() {
                return anchor;
            }

            @Override
            public boolean needCommaBefore() {
                return needCommaBefore;
            }

            @Override
            public boolean needCommaAfter() {
                return needCommaAfter;
            }

            @Override
            public boolean hasSpecifiers() {
                return hasSpecifiers;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$2", "host"));
            }
        };
        if (insertPlaceInDeclaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(65);
        }
        return insertPlaceInDeclaration;
    }

    public static Comparator<String> getStringImportMemberComparator(@NotNull PsiElement context) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(66);
        }
        return (o1, o2) -> StringUtil.compare((String)o1, (String)o2, (boolean)true);
    }

    public static Comparator<String> getStringImportFromComparator() {
        return IMPORT_FROM_PART_COMPARATOR;
    }

    public static Comparator<ES6ImportSpecifier> getImportMemberComparator(@NotNull PsiElement context) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(67);
        }
        Comparator<String> stringComparator = ES6ImportPsiUtil.getStringImportMemberComparator(context);
        return (o1, o2) -> {
            String name = o1 == null ? null : o1.getReferenceName();
            String name2 = o2 == null ? null : o2.getReferenceName();
            return stringComparator.compare(name, name2);
        };
    }

    @Nullable
    public static ES6ImportExportDeclaration createImportExport(@NotNull PsiElement context, @NotNull CreateImportExportInfo info, @Nullable String quotedModuleName) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(68);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(69);
        }
        if (quotedModuleName == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(info.getDeclarationPrefixWithKeyword());
        builder.append(" ");
        if (info.getImportType() != ImportExportType.BARE) {
            JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
            builder.append(info.getRawText(settings.SPACES_WITHIN_IMPORTS));
            builder.append(" from ");
        }
        builder.append(quotedModuleName);
        builder.append(JSCodeStyleSettings.getSemicolon((PsiElement)context.getContainingFile()));
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(builder.toString(), context);
        if (importNode == null) {
            return null;
        }
        return (ES6ImportExportDeclaration)importNode.getPsi(ES6ImportExportDeclaration.class);
    }

    public static boolean hasNamespaceImport(@NotNull ES6ImportDeclaration declaration) {
        ES6ImportedBinding[] bindings;
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(70);
        }
        for (ES6ImportedBinding binding : bindings = declaration.getImportedBindings()) {
            if (!binding.isNamespaceImport()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasComma(PsiElement current) {
        boolean hasComma = false;
        for (PsiElement forComma = current; forComma != null; forComma = forComma.getPrevSibling()) {
            if (ES6ImportPsiUtil.isComma(forComma)) {
                hasComma = true;
                break;
            }
            if (!(forComma instanceof PsiWhiteSpace)) break;
        }
        return hasComma;
    }

    @NotNull
    public static String invertQuote(@NotNull String quote) {
        if (quote == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(71);
        }
        String string = "'".equals(quote) ? "\"" : "'";
        if (string == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(72);
        }
        return string;
    }

    private static boolean isComma(@NotNull PsiElement forComma) {
        if (forComma == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(73);
        }
        return forComma.getNode().getElementType() == JSTokenTypes.COMMA;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 65: 
            case 72: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 65: 
            case 72: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: 
            case 2: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 56: 
            case 70: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: 
            case 40: 
            case 43: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 65: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeModule";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 21: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 25: 
            case 66: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromReferenceText";
                break;
            }
            case 36: 
            case 47: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 39: 
            case 42: 
            case 46: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextToInsert";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 45: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElementOrFile";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportedName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedImports";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiers";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quote";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forComma";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findPlaceByModuleName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findPlaceForImport";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnchorToInsert";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuote";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithQuotesFromSettings";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportDeclarations";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingImports";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createInsertPlace";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "invertQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findExistingES6ImportByFromText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableAsExistingImport";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToAddImportToExistingDeclaration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceByModuleName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 65: 
            case 72: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceForImport";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAnchorToInsert";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findExistingES6Import";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findExistingES6ImportByFromModules";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getExportedElementName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getQuote";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithQuotesFromSettings";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImportDeclarations";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getExistingImports";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getUnquotedFromClauseOrModuleText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getUnquotedFromClauseText";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "insertBinding";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "insertImportSpecifier";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findImportSpecifierByReferenceName";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "insertJSImport";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getSpecifierInsertPlace";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getSpecifierAnchor";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getInsertAfterPosition";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createInsertPlace";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getStringImportMemberComparator";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getImportMemberComparator";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createImportExport";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "hasNamespaceImport";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "invertQuote";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isComma";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$insertImportSpecifier$3";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "lambda$insertBinding$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 65: 
            case 72: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface InsertPlaceInDeclaration {
        @NotNull
        public PsiElement host();

        @Nullable
        public PsiElement getAnchor();

        public boolean needCommaBefore();

        public boolean needCommaAfter();

        public boolean hasSpecifiers();
    }

    public static final class ES6ExistingImports {
        @NotNull
        private final Map<String, ES6ImportSpecifier> mySpecifiers;
        @NotNull
        private final Collection<ES6ImportedBinding> myBindings;
        @NotNull
        private final List<ES6ImportDeclaration> myDeclarations;

        public ES6ExistingImports(@NotNull List<ES6ImportDeclaration> declarations) {
            if (declarations == null) {
                ES6ExistingImports.$$$reportNull$$$0(0);
            }
            this.myDeclarations = ContainerUtil.newArrayListWithCapacity((int)declarations.size());
            this.mySpecifiers = ContainerUtil.newHashMap();
            this.myBindings = ContainerUtil.newArrayListWithCapacity((int)declarations.size());
            for (ES6ImportDeclaration declaration : declarations) {
                this.addDeclaration(declaration);
            }
        }

        public void addDeclaration(ES6ImportDeclaration declaration) {
            ES6ImportSpecifier[] specifiers;
            this.myDeclarations.add(declaration);
            for (ES6ImportSpecifier importSpecifier : specifiers = declaration.getImportSpecifiers()) {
                this.mySpecifiers.put(importSpecifier.getReferenceName(), importSpecifier);
            }
            ContainerUtil.addAll(this.myBindings, (Object[])declaration.getImportedBindings());
        }

        public boolean isEmpty() {
            return this.mySpecifiers.isEmpty() && this.myBindings.isEmpty();
        }

        @NotNull
        public Map<String, ES6ImportSpecifier> getSpecifiers() {
            Map<String, ES6ImportSpecifier> map = this.mySpecifiers;
            if (map == null) {
                ES6ExistingImports.$$$reportNull$$$0(1);
            }
            return map;
        }

        @NotNull
        public Collection<ES6ImportedBinding> getBindings() {
            Collection<ES6ImportedBinding> collection = this.myBindings;
            if (collection == null) {
                ES6ExistingImports.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public void addSpecifier(@NotNull ES6ImportSpecifier specifier) {
            if (specifier == null) {
                ES6ExistingImports.$$$reportNull$$$0(3);
            }
            this.mySpecifiers.put(specifier.getReferenceName(), specifier);
        }

        public void addBinding(@NotNull ES6ImportedBinding binding) {
            if (binding == null) {
                ES6ExistingImports.$$$reportNull$$$0(4);
            }
            this.myBindings.add(binding);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declarations";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$ES6ExistingImports";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "specifier";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binding";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$ES6ExistingImports";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpecifiers";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBindings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addSpecifier";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addBinding";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CreateImportExportInfo
    implements Serializable {
        public static final String IMPORT = "import";
        public static final String IMPORT_TYPE = "import type";
        public static final String EXPORT = "export";
        @Nullable
        private final String myExportedName;
        @Nullable
        private final String myImportedName;
        @NotNull
        private final ImportExportType myImportType;
        private final boolean myImportDeclaration;
        private final boolean myFlowTypeContext;

        @NotNull
        public ImportExportType getImportType() {
            ImportExportType importExportType = this.myImportType;
            if (importExportType == null) {
                CreateImportExportInfo.$$$reportNull$$$0(0);
            }
            return importExportType;
        }

        @Nullable
        public String getExportedName() {
            return this.myExportedName;
        }

        public CreateImportExportInfo(@Nullable String exportedName, @Nullable String importedName, @NotNull ImportExportType importType, boolean importDeclaration, boolean flowTypeContext) {
            if (importType == null) {
                CreateImportExportInfo.$$$reportNull$$$0(1);
            }
            this.myExportedName = exportedName;
            this.myImportedName = importedName;
            this.myImportType = importType;
            this.myImportDeclaration = importDeclaration;
            this.myFlowTypeContext = flowTypeContext;
        }

        public CreateImportExportInfo(@NotNull String importedName, @NotNull ImportExportType importType) {
            if (importedName == null) {
                CreateImportExportInfo.$$$reportNull$$$0(2);
            }
            if (importType == null) {
                CreateImportExportInfo.$$$reportNull$$$0(3);
            }
            this(null, importedName, importType, true, false);
        }

        public CreateImportExportInfo(@Nullable String importedName) {
            this(null, importedName, ImportExportType.DEFAULT, true, false);
        }

        public CreateImportExportInfo(@Nullable String exportedName, @Nullable String importedName, @NotNull ImportExportType importType) {
            if (importType == null) {
                CreateImportExportInfo.$$$reportNull$$$0(4);
            }
            this(exportedName, importedName, importType, true, false);
        }

        @Nullable
        public String getImportedName() {
            return this.myImportedName;
        }

        public boolean isImportDeclaration() {
            return this.myImportDeclaration;
        }

        public boolean isFlowTypeContext() {
            return this.myFlowTypeContext;
        }

        public String getRawText() {
            return this.getRawText(false);
        }

        public String getDeclarationPrefixWithKeyword() {
            return this.isImportDeclaration() ? IMPORT : EXPORT;
        }

        @Nullable
        public String getRawText(boolean spaces) {
            if (this.myImportType == ImportExportType.SPECIFIER) {
                if (this.myExportedName == null) {
                    return CreateImportExportInfo.wrapWithBraces(this.myImportedName, spaces);
                }
                if (this.myImportedName == null) {
                    return CreateImportExportInfo.wrapWithBraces(this.myExportedName, spaces);
                }
                if (this.myImportedName.equals(this.myExportedName)) {
                    return CreateImportExportInfo.wrapWithBraces(this.myImportedName, spaces);
                }
                return CreateImportExportInfo.wrapWithBraces(this.myExportedName + " as " + this.myImportedName, spaces);
            }
            if (this.myImportType == ImportExportType.IMPORT_BINDING_ALL && this.myImportedName != null) {
                return "* as " + this.myImportedName;
            }
            if (this.myImportType == ImportExportType.DEFAULT && !this.isImportDeclaration()) {
                return CreateImportExportInfo.wrapWithBraces(ES6ImportPsiUtil.DEFAULT.equals(this.myExportedName) ? ES6ImportPsiUtil.DEFAULT : this.myExportedName + " as " + ES6ImportPsiUtil.DEFAULT, spaces);
            }
            if (this.myImportedName != null) {
                return this.myImportedName;
            }
            return this.myExportedName;
        }

        private static String wrapWithBraces(String text, boolean needSpaces) {
            String space = needSpaces ? " " : "";
            return "{" + space + text + space + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CreateImportExportInfo info = (CreateImportExportInfo)o;
            if (this.myImportDeclaration != info.myImportDeclaration) {
                return false;
            }
            if (this.myExportedName != null ? !this.myExportedName.equals(info.myExportedName) : info.myExportedName != null) {
                return false;
            }
            if (this.myImportedName != null ? !this.myImportedName.equals(info.myImportedName) : info.myImportedName != null) {
                return false;
            }
            return this.myImportType == info.myImportType;
        }

        public int hashCode() {
            int result2 = this.myExportedName != null ? this.myExportedName.hashCode() : 0;
            result2 = 31 * result2 + (this.myImportedName != null ? this.myImportedName.hashCode() : 0);
            result2 = 31 * result2 + this.myImportType.hashCode();
            result2 = 31 * result2 + (this.myImportDeclaration ? 1 : 0);
            return result2;
        }

        public String toString() {
            return (String)ObjectUtils.coalesce((Object)this.getRawText(true), (Object)"<empty>");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$CreateImportExportInfo";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$CreateImportExportInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ImportExportType implements Serializable
    {
        SPECIFIER,
        DEFAULT,
        IMPORT_BINDING_ALL,
        BARE,
        EXPORT_ALL,
        TS_NS_AND_MODULE{

            @Override
            public boolean isES6() {
                return false;
            }
        }
        ,
        TS_REQUIRE_IMPORT{

            @Override
            public boolean isES6() {
                return false;
            }
        }
        ,
        TS_NAMESPACE{

            @Override
            public boolean isES6() {
                return false;
            }
        };


        public boolean isES6() {
            return true;
        }
    }
}

