/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersDialog;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersHandler
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        PsiElement firstModule = null;
        for (PsiElement element : elements) {
            PsiElement module = ES6MoveModuleMembersHandler.getModuleOrContainingFile(element);
            if (module == null) {
                return false;
            }
            if (firstModule == null) {
                firstModule = module;
                continue;
            }
            if (firstModule.isEquivalentTo(module)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiElement getModuleOrContainingFile(@Nullable PsiElement element) {
        PsiElement module;
        if (!(element instanceof JSQualifiedNamedElement) && !(element instanceof ES6ExportDefaultAssignment)) {
            return null;
        }
        if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            element = element.getParent();
        }
        if ((module = JSResolveUtil.findParent(element)) != null && ES6MoveModuleMembersHandler.isAcceptableFileOrModule(module)) {
            return module;
        }
        return null;
    }

    private static boolean isAcceptableFileOrModule(@Nullable PsiElement element) {
        if (element instanceof JSFile) {
            JSFile.ModuleStatus moduleStatus = ((JSFile)element).getModuleStatus();
            return moduleStatus == JSFile.ModuleStatus.ES6 || moduleStatus == JSFile.ModuleStatus.NONE;
        }
        return ES6PsiUtil.isEmbeddedModule(element);
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        super.doMove(project, elements, targetContainer, callback);
        if (elements.length == 0) {
            return;
        }
        PsiElement sourceModuleOrFile = ES6MoveModuleMembersHandler.getModuleOrContainingFile(elements[0]);
        if (sourceModuleOrFile == null) {
            return;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)sourceModuleOrFile);
        if (file2 == null) {
            return;
        }
        String initialPath = StringUtil.notNullize((String)file2.getPresentableUrl());
        List<JSPsiElementBase> selectedElements = Arrays.stream(elements).filter(el -> el instanceof JSQualifiedNamedElement).map(el -> (JSQualifiedNamedElement)el).collect(Collectors.toList());
        ES6MoveModuleMembersDialog dialog = new ES6MoveModuleMembersDialog(project, initialPath, initialPath, selectedElements, sourceModuleOrFile, callback);
        dialog.show();
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiElement module = ES6MoveModuleMembersHandler.getModuleOrContainingFile(element);
        if (module != null) {
            this.doMove(project, new PsiElement[]{element}, null, null);
            return true;
        }
        return false;
    }
}

