/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.imports.JSXNamespaceProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReferenceExpressionsInfo {
    public static final ES6ReferenceExpressionsInfo EMPTY = new ES6ReferenceExpressionsInfo(ContainerUtil.emptyList(), ContainerUtil.emptyList(), ContainerUtil.newHashMap(), Collections.emptySet());
    @NotNull
    private final Collection<PsiElement> myLocals;
    @NotNull
    private final Collection<PsiElement> myExportedLocals;
    @NotNull
    private final Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> myImports;
    @NotNull
    private final Set<String> myUnresolvedImports;

    private ES6ReferenceExpressionsInfo(@NotNull Collection<PsiElement> locals, @NotNull Collection<PsiElement> exportedLocals, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports, @NotNull Set<String> unresolvedImports) {
        if (locals == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(0);
        }
        if (exportedLocals == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(1);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(2);
        }
        if (unresolvedImports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(3);
        }
        this.myLocals = locals;
        this.myExportedLocals = exportedLocals;
        this.myImports = imports;
        this.myUnresolvedImports = unresolvedImports;
    }

    @NotNull
    public Collection<PsiElement> getLocalReferencedElements() {
        Collection<PsiElement> collection = this.myLocals;
        if (collection == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> getReferencedImports() {
        Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> map = this.myImports;
        if (map == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    public Collection<PsiElement> getExportedLocalReferencedElements() {
        Collection<PsiElement> collection = this.myExportedLocals;
        if (collection == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public static void addValidations(@NotNull ES6ReferenceExpressionsInfo info, @NotNull JSPsiElementBase element, @NotNull Condition<PsiElement> excludedFilter, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (info == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(7);
        }
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(8);
        }
        if (excludedFilter == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(9);
        }
        if (conflicts == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(10);
        }
        for (String message : ES6ReferenceExpressionsInfo.getValidations(info, element, excludedFilter)) {
            conflicts.putValue((Object)element, (Object)message);
        }
    }

    @NotNull
    public static List<String> getValidations(@NotNull ES6ReferenceExpressionsInfo info, @NotNull JSPsiElementBase element, @NotNull Condition<PsiElement> excludedFilter) {
        if (info == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(11);
        }
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(12);
        }
        if (excludedFilter == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(13);
        }
        String elementDescription = RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (String unresolvedImport : info.myUnresolvedImports) {
            result2.add(JSBundle.message((String)"es6.move.module.members.references.unresolved.import.message", (Object[])new Object[]{elementDescription, unresolvedImport}));
        }
        for (PsiElement referencedElement : info.getLocalReferencedElements()) {
            if (excludedFilter.value((Object)referencedElement)) continue;
            String referencedDescription = RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)false);
            String message = JSBundle.message((String)"es6.move.module.members.references.local.message", (Object[])new Object[]{elementDescription, referencedDescription});
            result2.add(message);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(@NotNull PsiElement element) {
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(15);
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo(element, (TextRange)null);
        if (eS6ReferenceExpressionsInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(16);
        }
        return eS6ReferenceExpressionsInfo;
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(@NotNull PsiElement element, @Nullable TextRange range) {
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(17);
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo(element, range, ES6PsiUtil.findExternalModule(element, false));
        if (eS6ReferenceExpressionsInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(18);
        }
        return eS6ReferenceExpressionsInfo;
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(@NotNull PsiElement element, @Nullable PsiElement module) {
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(19);
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo(element, null, module);
        if (eS6ReferenceExpressionsInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(20);
        }
        return eS6ReferenceExpressionsInfo;
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(@NotNull PsiElement element, @Nullable TextRange textRange, @Nullable PsiElement module) {
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(21);
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfoForRange(element, element, textRange, module);
        if (eS6ReferenceExpressionsInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(22);
        }
        return eS6ReferenceExpressionsInfo;
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfoForRange(@NotNull PsiElement first, @NotNull PsiElement last) {
        if (first == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(23);
        }
        if (last == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(24);
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfoForRange(first, last, null, ES6PsiUtil.findExternalModule(first, false));
        if (eS6ReferenceExpressionsInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(25);
        }
        return eS6ReferenceExpressionsInfo;
    }

    @NotNull
    private static ES6ReferenceExpressionsInfo getInfoForRange(final @NotNull PsiElement first, final @NotNull PsiElement last, final @Nullable TextRange textRange, final @Nullable PsiElement module) {
        if (first == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(26);
        }
        if (last == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(27);
        }
        if (module == null) {
            ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = EMPTY;
            if (eS6ReferenceExpressionsInfo == null) {
                ES6ReferenceExpressionsInfo.$$$reportNull$$$0(28);
            }
            return eS6ReferenceExpressionsInfo;
        }
        final LinkedHashSet locals = ContainerUtil.newLinkedHashSet();
        final LinkedHashSet exportedLocals = ContainerUtil.newLinkedHashSet();
        final Ref containsJsx = new Ref((Object)Boolean.FALSE);
        final LinkedHashMap imports = ContainerUtil.newLinkedHashMap();
        final HashSet unresolvedImports = ContainerUtil.newHashSet();
        JSRecursiveWalkingElementVisitor visitor = new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                ResolveResult[] results;
                super.visitJSReferenceExpression(node);
                if (node.getQualifier() != null) {
                    return;
                }
                if (textRange != null && !textRange.intersects(node.getTextRange())) {
                    return;
                }
                String referenceName = node.getReferenceName();
                if (StringUtil.isEmpty((String)referenceName)) {
                    return;
                }
                for (ResolveResult result2 : results = node.multiResolve(false)) {
                    PsiElement resultElement = result2.getElement();
                    if (!result2.isValidResult() || resultElement == null || !(result2 instanceof JSResolveResult)) continue;
                    if (resultElement instanceof TypeScriptImplicitOverloadedAliasElement) {
                        TypeScriptImplicitOverloadedAliasElement aliased = (TypeScriptImplicitOverloadedAliasElement)resultElement;
                        JSNamedElement actualElement = aliased.getAliasElement();
                        this.processResolveResult(referenceName, (PsiElement)actualElement, null);
                        continue;
                    }
                    this.processResolveResult(referenceName, resultElement, ((JSResolveResult)result2).getES6Import());
                }
            }

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                super.visitJSLiteralExpression(node);
                if (!(node instanceof JSXXmlLiteralExpressionImpl)) {
                    return;
                }
                if (textRange != null && !textRange.intersects(node.getTextRange())) {
                    return;
                }
                JSXmlLiteralExpression xmlLiteral = (JSXmlLiteralExpression)node;
                containsJsx.set((Object)Boolean.TRUE);
                PsiReference tagNameReference = node.getReference();
                PsiReference topLevelReference = (PsiReference)ObjectUtils.coalesce((Object)ReactXmlExtension.getFirstQualifierReference((XmlTag)xmlLiteral), (Object)tagNameReference);
                if (topLevelReference == null) {
                    return;
                }
                String referenceName = topLevelReference.getCanonicalText();
                if (StringUtil.isEmpty((String)referenceName)) {
                    return;
                }
                PsiElement resolved = topLevelReference.resolve();
                if (resolved instanceof JSElement) {
                    PsiElement localResult = JSStubBasedPsiTreeUtil.resolveLocally(referenceName, (PsiElement)node);
                    this.processResolveResult(referenceName, resolved, (ES6ImportExportDeclarationPart)ObjectUtils.tryCast((Object)localResult, ES6ImportExportDeclarationPart.class));
                }
            }

            private void processResolveResult(@NotNull String referenceName, @NotNull PsiElement resultElement, @Nullable ES6ImportExportDeclarationPart importPart) {
                PsiElement resultModule;
                if (referenceName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (resultElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (module.isEquivalentTo(resultModule = ES6PsiUtil.findExternalModule(resultElement)) && !(resultElement instanceof ES6ImportedBinding) && !(resultElement instanceof ES6ImportSpecifierAlias) && !(resultElement instanceof ES6ImportSpecifier)) {
                    if (!this.isContainedInRange(resultElement)) {
                        Set toProcess = ES6ImportHandler.isExportedWithNameOrDefault(resultElement) ? exportedLocals : locals;
                        toProcess.add(resultElement);
                    }
                } else {
                    ES6ReferenceExpressionsInfo.addImportInfo(referenceName, resultElement, importPart, (Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement>)imports, (Set<String>)unresolvedImports);
                }
            }

            private boolean isContainedInRange(@NotNull PsiElement resultElement) {
                TextRange resultElementRange;
                if (resultElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((resultElementRange = resultElement.getTextRange()) == null || textRange != null && !textRange.contains(resultElementRange)) {
                    return false;
                }
                for (PsiElement element : JSPsiImplUtils.getSiblingsForward(first, last)) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)resultElement, (boolean)false)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resultElement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processResolveResult";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isContainedInRange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (PsiElement element : JSPsiImplUtils.getSiblingsForward(first, last)) {
            element.accept((PsiElementVisitor)visitor);
        }
        if (Boolean.TRUE.equals(containsJsx.get())) {
            ES6ReferenceExpressionsInfo.addReactImport(first, imports, unresolvedImports);
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = new ES6ReferenceExpressionsInfo(locals, exportedLocals, imports, unresolvedImports);
        if (eS6ReferenceExpressionsInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(29);
        }
        return eS6ReferenceExpressionsInfo;
    }

    private static void addReactImport(@NotNull PsiElement context, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports, @NotNull Set<String> unresolvedImports) {
        String namespace;
        if (context == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(30);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(31);
        }
        if (unresolvedImports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(32);
        }
        if (StringUtil.isEmpty((String)(namespace = JSXNamespaceProvider.getDefaultNamespace(context)))) {
            return;
        }
        PsiElement result2 = JSStubBasedPsiTreeUtil.resolveLocally(namespace, context);
        if (result2 == null) {
            return;
        }
        ES6ReferenceExpressionsInfo.addImportInfo(namespace, result2, null, imports, unresolvedImports);
    }

    private static void addImportInfo(@NotNull String referenceName, @NotNull PsiElement resultElement, @Nullable ES6ImportExportDeclarationPart importPart, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports, @NotNull Set<String> unresolvedImports) {
        ES6ImportPsiUtil.CreateImportExportInfo info;
        ES6ImportSpecifier specifier;
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(33);
        }
        if (resultElement == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(34);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(35);
        }
        if (unresolvedImports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(36);
        }
        if (resultElement instanceof ES6ImportedBinding) {
            ES6ImportedBinding binding = (ES6ImportedBinding)resultElement;
            ES6ReferenceExpressionsInfo.addImportInfo((ES6ImportExportDeclarationPart)binding, (PsiElement)ContainerUtil.getFirstItem((Collection)binding.findReferencedElements()), ES6ReferenceExpressionsInfo.createImportInfoForBinding(referenceName, binding), imports, unresolvedImports);
            return;
        }
        if (resultElement instanceof ES6ImportSpecifierAlias) {
            ES6ImportSpecifierAlias alias = (ES6ImportSpecifierAlias)resultElement;
            ES6ImportSpecifier specifier2 = (ES6ImportSpecifier)alias.findSpecifierElement();
            if (specifier2 == null) {
                return;
            }
            ES6ReferenceExpressionsInfo.addImportInfo((ES6ImportExportDeclarationPart)specifier2, alias.findAliasedElement(), ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, specifier2, alias), imports, unresolvedImports);
        }
        if (resultElement instanceof ES6ImportSpecifier) {
            specifier = (ES6ImportSpecifier)resultElement;
            info = ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, specifier, null);
            ES6ReferenceExpressionsInfo.addImportInfo((ES6ImportExportDeclarationPart)specifier, null, info, imports, unresolvedImports);
        }
        if (importPart instanceof ES6ImportSpecifier) {
            specifier = (ES6ImportSpecifier)importPart;
            ES6ImportSpecifierAlias alias = specifier.getAlias();
            ES6ImportPsiUtil.CreateImportExportInfo info2 = ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, specifier, alias);
            ES6ReferenceExpressionsInfo.addImportInfo((ES6ImportExportDeclarationPart)specifier, resultElement, info2, imports, unresolvedImports);
        } else if (importPart instanceof ES6ImportedBinding) {
            ES6ImportedBinding binding = (ES6ImportedBinding)importPart;
            info = ES6ReferenceExpressionsInfo.createImportInfoForBinding(referenceName, binding);
            ES6ReferenceExpressionsInfo.addImportInfo((ES6ImportExportDeclarationPart)binding, resultElement, info, imports, unresolvedImports);
        }
    }

    private static void addImportInfo(@NotNull ES6ImportExportDeclarationPart importPart, @Nullable PsiElement resolvedElement, @NotNull ES6ImportPsiUtil.CreateImportExportInfo info, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports, @NotNull Set<String> unresolvedImports) {
        ES6ImportExportDeclaration declaration;
        ES6FromClause fromClause;
        if (importPart == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(37);
        }
        if (info == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(38);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(39);
        }
        if (unresolvedImports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(40);
        }
        ES6FromClause eS6FromClause = fromClause = (declaration = importPart.getDeclaration()) != null ? declaration.getFromClause() : null;
        if (fromClause == null) {
            return;
        }
        PsiElement fromClauseReferencedModule = (PsiElement)ContainerUtil.getFirstItem((Collection)fromClause.resolveReferencedElements());
        if (fromClauseReferencedModule == null) {
            unresolvedImports.add(JSStringUtil.unquoteStringLiteralValue(StringUtil.notNullize((String)fromClause.getReferenceText())));
            return;
        }
        PsiElement element = (PsiElement)ObjectUtils.coalesce((Object)resolvedElement, (Object)fromClauseReferencedModule);
        if (ES6ReferenceExpressionsInfo.isAvailableForES6Import(element)) {
            imports.put(info, element);
        }
    }

    private static boolean isAvailableForES6Import(@NotNull PsiElement element) {
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(41);
        }
        return !TypeScriptPsiUtil.isAugmentationModule(ES6PsiUtil.findExternalModule(element, false));
    }

    @NotNull
    private static ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForBinding(@NotNull String referenceName, @NotNull ES6ImportedBinding binding) {
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(42);
        }
        if (binding == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(43);
        }
        ES6ImportPsiUtil.ImportExportType importType = binding.isNamespaceImport() ? ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL : ES6ImportPsiUtil.ImportExportType.DEFAULT;
        ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(referenceName, null, importType, true, ES6ReferenceExpressionsInfo.isFlowTypeContext((ES6ImportExportDeclarationPart)binding));
        if (createImportExportInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(44);
        }
        return createImportExportInfo;
    }

    @NotNull
    private static ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForSpecifier(@NotNull String referenceName, @NotNull ES6ImportSpecifier specifier, @Nullable ES6ImportSpecifierAlias alias) {
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(45);
        }
        if (specifier == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(46);
        }
        ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(alias == null ? referenceName : specifier.getCanonicalText(), referenceName, ES6ImportPsiUtil.ImportExportType.SPECIFIER, true, ES6ReferenceExpressionsInfo.isFlowTypeContext((ES6ImportExportDeclarationPart)specifier));
        if (createImportExportInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(47);
        }
        return createImportExportInfo;
    }

    private static boolean isFlowTypeContext(@NotNull ES6ImportExportDeclarationPart part) {
        ES6ImportExportDeclaration declaration;
        if (part == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(48);
        }
        if ((declaration = part.getDeclaration()) == null || !DialectDetector.isFlow((PsiElement)part)) {
            return false;
        }
        ASTNode node = declaration.getNode();
        ASTNode keyword = node.findChildByType(JSTokenTypes.IMPORT_KEYWORD);
        if (keyword != null) {
            if (ES6ReferenceExpressionsInfo.isTypeImport(keyword.getPsi())) {
                return true;
            }
            if (part instanceof ES6ImportSpecifier) {
                PsiElement firstChild = part.getFirstChild();
                return firstChild != null && firstChild.getNode().getElementType() == JSTokenTypes.TYPE_KEYWORD;
            }
        }
        return false;
    }

    public static boolean isTypeImport(@NotNull PsiElement importKeyWord) {
        PsiElement next;
        if (importKeyWord == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(49);
        }
        if ((next = importKeyWord.getNextSibling()) != null) {
            PsiElement typeElement;
            PsiElement psiElement = typeElement = next instanceof PsiWhiteSpace ? next.getNextSibling() : next;
            if (typeElement != null && typeElement.getNode().getElementType() == JSTokenTypes.TYPE_KEYWORD) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 44: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 44: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportedLocals";
                break;
            }
            case 2: 
            case 31: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 3: 
            case 32: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedImports";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo";
                break;
            }
            case 7: 
            case 11: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedFilter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultElement";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPart";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importKeyWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalReferencedElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedImports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedLocalReferencedElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidations";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForRange";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportInfoForBinding";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportInfoForSpecifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 44: 
            case 47: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addValidations";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getValidations";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForRange";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addReactImport";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addImportInfo";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForES6Import";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createImportInfoForBinding";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createImportInfoForSpecifier";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isFlowTypeContext";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isTypeImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 44: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

