/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6DoExpression;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSUnwrapPromiseTypeElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.regexp.RegExpFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6TypeEvaluator
extends JSTypeEvaluator {
    public ES6TypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor) {
        super(context, processor);
    }

    @Override
    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof ES6ExportSpecifierAlias) {
            if ((resolveResult = resolveResult.getParent()) instanceof ES6ExportSpecifier) {
                this.processItem((ES6ExportSpecifier)resolveResult, JSEvaluateContext.JSEvaluationPlace.DEFAULT, specifier -> {
                    ResolveResult[] exportSpecifierResults;
                    for (ResolveResult result2 : exportSpecifierResults = specifier.multiResolve(false)) {
                        PsiElement element;
                        if (!result2.isValidResult() || (element = result2.getElement()) == null) continue;
                        this.addTypeFromResolvedImport(element);
                    }
                });
            }
            return true;
        }
        if (resolveResult instanceof ES6ImportedExportedDefaultBinding) {
            String type;
            JSDocComment docComment;
            Collection referencedElements = ((ES6ImportedExportedDefaultBinding)resolveResult).findReferencedElements();
            for (PsiElement referencedElement : referencedElements) {
                this.addTypeFromResolvedImport(referencedElement);
            }
            PsiElement parent = resolveResult.getParent();
            if (parent instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)parent).getImportSpecifiers().length == 0 && (!DialectDetector.isTypeScript(parent) || referencedElements.size() == 0) && (docComment = JSStubBasedPsiTreeUtil.findDocComment(parent)) != null && (type = docComment.getType()) != null) {
                this.addType(JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true)), resolveResult);
            }
            if (referencedElements.isEmpty()) {
                this.myTypeProcessor.processResolvedElement(resolveResult, this.myContext);
            }
            this.addTypeFromLocalName((PsiNamedElement)resolveResult);
            return true;
        }
        if (resolveResult instanceof ES6ImportSpecifierAlias) {
            this.addTypeFromES6ImportSpecifier((ES6ImportSpecifierAlias)resolveResult);
            return true;
        }
        if (resolveResult instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)resolveResult);
        }
        return super.addTypeFromDialectSpecificElements(resolveResult);
    }

    @Override
    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        ES6ImportCall possibleImportCall;
        if (jsVariable == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(0);
        }
        if (jsVariable instanceof JSParameter && this.isFromCurrentFile((PsiElement)jsVariable) && (possibleImportCall = ES6PsiUtil.getImportCallIfContinuationParameter((JSParameterListElement)((JSParameter)jsVariable))) != null) {
            this.addTypeFromImportCall(possibleImportCall);
        }
        super.addTypeFromVariableResolveResult(jsVariable);
    }

    private void addTypeFromES6ImportSpecifier(ES6ImportSpecifierAlias resolveResult) {
        PsiElement aliasedElement = resolveResult.findAliasedElement();
        if (aliasedElement != null) {
            this.processItem(aliasedElement, JSEvaluateContext.JSEvaluationPlace.DEFAULT, element -> this.addTypeFromResolveResult((PsiElement)element));
        }
        this.addTypeFromLocalName((PsiNamedElement)resolveResult);
    }

    private void addTypeFromLocalName(PsiNamedElement resolveResult) {
        String name = resolveResult.getName();
        if (name != null && DialectDetector.isJavaScript((PsiElement)resolveResult)) {
            JSNamespace ns = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, null), JSContext.STATIC, (PsiElement)resolveResult, false, true, true);
            this.addNamespace(ns, (PsiElement)resolveResult);
        }
    }

    protected void addTypeFromResolvedImport(PsiElement referencedElement) {
        if (referencedElement instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)referencedElement);
        } else if (referencedElement instanceof JSFile) {
            this.addTypeFromExternalModuleReferenceResolveResult(referencedElement);
        } else if (referencedElement instanceof StylesheetFile) {
            this.myTypeProcessor.processResolvedElement(referencedElement, this.myContext);
        } else if (referencedElement != null) {
            this.addTypeFromResolveResult(referencedElement);
        }
    }

    protected void evaluateExportAssignment(@NotNull JSExportAssignment assignment) {
        JSElement element;
        if (assignment == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(1);
        }
        if ((element = assignment.getStubSafeElement()) instanceof JSClass || element != null && !(element instanceof JSExpression)) {
            this.addTypeFromResolveResult((PsiElement)element);
            return;
        }
        if (element instanceof JSFunction) {
            this.processFunction((JSFunction)element);
        } else if (element instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)element, false);
        } else if (this.myContext.isAstAccessAllowed()) {
            JSExpression exportDefaultAssignmentExpression;
            JSExpression jSExpression = exportDefaultAssignmentExpression = element == null ? assignment.getExpression() : (JSExpression)element;
            if (exportDefaultAssignmentExpression != null) {
                Runnable r = () -> this.evaluateTypes(exportDefaultAssignmentExpression, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
                if (!DialectDetector.isTypeScript((PsiElement)assignment)) {
                    this.myContext.withAstAccessForbidden(r);
                } else {
                    r.run();
                }
            }
        } else if (element instanceof JSAssignmentExpression) {
            JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)element).getDefinitionExpression();
            if (definitionExpression != null) {
                this.addTypeFromDefExpr(definitionExpression);
            }
        } else {
            this.tryAddTypeFromInitializerReference((PsiElement)assignment);
        }
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        JSType expressionType;
        if (rawqualifier instanceof JSSpreadExpression && (expressionType = this.getExpressionTypeInContext(((JSSpreadExpression)rawqualifier).getExpression())) != null) {
            this.addType(new JSSpreadTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), expressionType), (PsiElement)rawqualifier);
            return true;
        }
        if (rawqualifier instanceof Es6MetaProperty && ((Es6MetaProperty)rawqualifier).getKind() == Es6MetaProperty.Kind.ImportMeta) {
            this.addType(JSNamedTypeFactory.createType("ImportMeta", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, DialectDetector.isTypeScript((PsiElement)rawqualifier)), JSTypeContext.INSTANCE), (PsiElement)rawqualifier);
        } else {
            if (rawqualifier instanceof JSClassExpression) {
                this.addTypeFromClassExpression((JSClassExpression)rawqualifier);
                return true;
            }
            if (rawqualifier instanceof ES6DoExpression) {
                JSExpression expression;
                JSExpressionStatement expressionStatement;
                ES6DoExpression doExpression = (ES6DoExpression)rawqualifier;
                JSStatement lastStatement = (JSStatement)ArrayUtil.getLastElement((Object[])doExpression.getStatements());
                JSExpressionStatement jSExpressionStatement = expressionStatement = lastStatement instanceof JSExpressionStatement ? (JSExpressionStatement)lastStatement : null;
                if (expressionStatement != null && (expression = expressionStatement.getExpression()) != null) {
                    this.evaluateTypes(expression, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
                }
            } else if (rawqualifier instanceof ES6ImportCall) {
                boolean isImportType;
                ES6ImportCall importCall = (ES6ImportCall)rawqualifier;
                boolean bl = isImportType = importCall.getContext() != null && importCall.getContext().getContext() instanceof TypeScriptSingleType;
                if (isImportType) {
                    this.myContext.pushJSElementToApply(JSUnwrapPromiseTypeElement.INSTANCE);
                }
                if (this.myContext.peekJSElementToApply() instanceof JSUnwrapPromiseTypeElement) {
                    this.myContext.processWithoutTopJSElementToApply(() -> this.addTypeFromImportCall(importCall));
                } else {
                    this.addType(JSTypeUtils.wrapInPromiseType(JSAnyType.get((PsiElement)importCall, true)), (PsiElement)importCall);
                }
            } else if (rawqualifier instanceof ES6TaggedTemplateExpression) {
                ES6TaggedTemplateExpression taggedTemplate = (ES6TaggedTemplateExpression)rawqualifier;
                JSApplyCallElement elementToApply = JSApplyCallElement.fromTaggedTemplateExpression(taggedTemplate);
                this.myContext.processWithJSElementToApply(elementToApply, () -> this.evaluateTypes(elementToApply.getMethodExpression(), JSEvaluateContext.JSEvaluationPlace.DEFAULT));
                return true;
            }
        }
        return super.evaluateDialectSpecificTypes(rawqualifier);
    }

    @Override
    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (callExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(3);
        }
        if (this.getEvaluationContext().isAstAccessAllowed() && DialectDetector.isES6((PsiElement)callExpression)) {
            this.processRegexpExecCall(callExpression);
        }
        if (DialectDetector.isTypeScript((PsiElement)callExpression) && this.addUniqueSymbolForConst(callExpression)) {
            return;
        }
        super.evaluateCallExpressionTypes(callExpression, place);
    }

    private boolean addUniqueSymbolForConst(@NotNull JSCallExpression callExpression) {
        JSExpression methodExpression;
        if (callExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(4);
        }
        if (!((methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
        String referencedName = invoked.getReferenceName();
        if (!"Symbol".equals(referencedName)) {
            return false;
        }
        JSFieldVariable variable = (JSFieldVariable)PsiTreeUtil.getContextOfType((PsiElement)methodExpression, (Class[])new Class[]{JSFieldVariable.class});
        if (variable == null || !variable.isConst() || variable.getInitializerOrStub() != callExpression) {
            return false;
        }
        this.addType(new JSUniqueSymbolTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)variable, true), JSTypeContext.INSTANCE, true), (PsiElement)variable);
        return true;
    }

    private void processRegexpExecCall(@NotNull JSCallExpression callExpression) {
        RegExpFile injectedRegexpFile;
        PsiElement sourceElement;
        JSExpression methodExpression;
        if (callExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(5);
        }
        if (!((methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
            return;
        }
        JSReferenceExpression methodRefExpr = (JSReferenceExpression)methodExpression;
        if (!"exec".equals(methodRefExpr.getReferenceName())) {
            return;
        }
        JSType targetJSType = JSResolveUtil.getExpressionJSType(methodRefExpr.getQualifier());
        if (targetJSType instanceof JSNamedType && "RegExp".equals(JSTypeUtils.getQualifiedNameMatchingType(targetJSType, true)) && (sourceElement = targetJSType.getSource().getSourceElement()) instanceof JSLiteralExpression && ((JSLiteralExpression)sourceElement).isRegExpLiteral() && this.isFromCurrentFile(sourceElement) && (injectedRegexpFile = ES6TypeEvaluator.findInjectedRegexpFile(sourceElement)) != null) {
            this.addType(ES6TypeEvaluator.getTypeForRegexpGroups(callExpression, injectedRegexpFile), sourceElement);
        }
    }

    @NotNull
    private static JSType getTypeForRegexpGroups(@NotNull JSCallExpression callExpression, @NotNull RegExpFile injectedFile) {
        if (callExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(6);
        }
        if (injectedFile == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(7);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)callExpression, true, false);
        List properties = ContainerUtil.mapNotNull((Collection)injectedFile.getGroups(), group -> {
            if (callExpression == null) {
                ES6TypeEvaluator.$$$reportNull$$$0(13);
            }
            String name = group.isAnyNamedGroup() ? group.getGroupName() : null;
            JSType jsStringType = JSNamedTypeFactory.createType("string", typeSource, JSTypeContext.INSTANCE);
            if (name == null) {
                return null;
            }
            JSLocalImplicitElementImpl groupElement = new JSLocalImplicitElementImpl(name, jsStringType, (PsiElement)callExpression, JSImplicitElement.Type.Property);
            return new JSRecordTypeImpl.PropertySignatureImpl(name, jsStringType, true, (PsiElement)groupElement);
        });
        JSSimpleRecordTypeImpl groupsType = new JSSimpleRecordTypeImpl(typeSource, properties);
        JSLocalImplicitElementImpl groupsElement = new JSLocalImplicitElementImpl("groups", groupsType, (PsiElement)callExpression, JSImplicitElement.Type.Property);
        JSSimpleRecordTypeImpl jSSimpleRecordTypeImpl = new JSSimpleRecordTypeImpl(typeSource, ContainerUtil.list((Object[])new JSRecordType.TypeMember[]{new JSRecordTypeImpl.PropertySignatureImpl("groups", (JSType)groupsType, false, (PsiElement)groupsElement)}));
        if (jSSimpleRecordTypeImpl == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(8);
        }
        return jSSimpleRecordTypeImpl;
    }

    @Nullable
    private static RegExpFile findInjectedRegexpFile(@NotNull PsiElement expression) {
        List files;
        if (expression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(9);
        }
        return (files = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles(expression)) == null || files.isEmpty() ? null : (RegExpFile)ObjectUtils.tryCast((Object)((Pair)files.get((int)0)).first, RegExpFile.class);
    }

    public void addTypeFromClassExpression(@NotNull JSClassExpression classExpression) {
        String qualifiedName;
        if (classExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(10);
        }
        if ((qualifiedName = classExpression.getQualifiedName()) == null || ES6PsiUtil.isLocalClass((JSClass)classExpression)) {
            this.myTypeProcessor.processResolvedElement((PsiElement)classExpression, this.myContext);
            return;
        }
        this.addTypeFromClassWithQName((JSClass)classExpression);
    }

    protected boolean isPrototypeOrNewExpression() {
        return this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement;
    }

    @Override
    protected void addTypeFromClassCandidate(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(11);
        }
        if (resolveResult instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)resolveResult);
        } else {
            this.addTypeFromClassWithQName(resolveResult);
        }
    }

    protected void addTypeFromClassWithQName(@NotNull JSClass resolveResult) {
        JSNamespace namespace;
        if (resolveResult == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(12);
        }
        if ((namespace = this.getNamespaceFromQualifiedNamedElement((JSQualifiedNamedElement)resolveResult, true)).getQualifiedName() == null) {
            return;
        }
        this.addType((JSType)namespace, (PsiElement)resolveResult);
    }

    @Override
    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, JSClass jsClass) {
        if (jsClass != null) {
            for (JSClass aClass : jsClass.getSuperClasses()) {
                this.addTypeFromClassCandidate(aClass);
            }
        }
    }

    @Override
    protected void addModuleFromRequire(PsiElement module, JSCallExpression callExpression) {
        if (module instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)module);
        } else {
            super.addModuleFromRequire(module, callExpression);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/ES6TypeEvaluator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classExpression";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6TypeEvaluator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForRegexpGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExportAssignment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCallExpressionTypes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addUniqueSymbolForConst";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processRegexpExecCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForRegexpGroups";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedRegexpFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassCandidate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassWithQName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypeForRegexpGroups$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

