/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImplicitMemberForComputedProperty;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.modules.TypeScriptFileModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        JSClass containingClass;
        if (element == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        if (element instanceof JSFunction ? (containingClass = JSUtils.getMemberContainingClass(element)) != null && containingClass.isInterface() : element instanceof JSClass) {
            return false;
        }
        return !(element instanceof JSQualifiedNamedElement) || !TypeScriptUtil.isDefinitionFile(element.getContainingFile().getVirtualFile());
    }

    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        if (ref == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        if (ref instanceof ES6ImportExportSpecifier) {
            return JSTargetElementEvaluator.getImplementationIfOverloads(((ES6ImportExportSpecifier)ref).multiResolve(false));
        }
        if (ref instanceof JSReferenceExpression || ref instanceof JSDocReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)ref).multiResolve(false);
            if (results.length > 1) {
                return (PsiElement)ObjectUtils.coalesce((Object)JSTargetElementEvaluator.getImplementationIfOverloads(results), (Object)JSTargetElementEvaluator.getFirstDefinitionIfDuplicates(results));
            }
            if (results.length == 1 && results[0].getElement() instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                return ((TypeScriptProxyImplicitElementWithBackingItem)results[0].getElement()).getExplicitElement();
            }
        } else {
            if (JSTargetElementEvaluator.isLastTypeScriptModuleRef(ref)) {
                return JSTargetElementEvaluator.getForTypeScriptModuleRef((TypeScriptFileModuleReference)ref);
            }
            if (ref instanceof PsiMultiReference) {
                for (PsiReference reference : ((PsiMultiReference)ref).getReferences()) {
                    ES6Property property;
                    if (JSTargetElementEvaluator.isLastTypeScriptModuleRef(reference)) {
                        return JSTargetElementEvaluator.getForTypeScriptModuleRef((TypeScriptFileModuleReference)reference);
                    }
                    ES6Property eS6Property = property = reference.getElement() instanceof ES6Property ? (ES6Property)reference.getElement() : null;
                    if (!(reference instanceof JSPropertyNameReference) || property == null || !property.isShorthanded()) continue;
                    return property;
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getImplementationIfOverloads(@NotNull ResolveResult[] results) {
        if (results == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        if (results.length < 2) {
            return null;
        }
        PsiElement firstElement = results[0].getElement();
        if (!(firstElement instanceof TypeScriptFunction)) {
            return null;
        }
        TypeScriptFunction implementation = TypeScriptPsiUtil.getLastOverload((TypeScriptFunction)firstElement);
        List overloadDeclarations = implementation.getOverloadDeclarations();
        for (ResolveResult result2 : results) {
            PsiElement element = result2.getElement();
            if (element == implementation || element instanceof TypeScriptFunction && overloadDeclarations.contains(element)) continue;
            return null;
        }
        return implementation;
    }

    @Nullable
    private static PsiElement getFirstDefinitionIfDuplicates(@NotNull ResolveResult[] results) {
        if (results == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(3);
        }
        boolean first = true;
        JSQualifiedName namespace = null;
        PsiFile file2 = null;
        for (ResolveResult result2 : results) {
            PsiElement element = result2.getElement();
            if (!(element instanceof JSDefinitionExpression)) {
                return null;
            }
            if (((JSDefinitionExpression)element).getInitializerOrStub() instanceof JSFunctionItem) {
                return null;
            }
            if (first) {
                first = false;
                namespace = ((JSDefinitionExpression)element).getNamespace();
                file2 = element.getContainingFile();
                continue;
            }
            if (Comparing.equal(namespace, (Object)((JSDefinitionExpression)element).getNamespace()) && Comparing.equal((Object)file2, (Object)element.getContainingFile())) continue;
            return null;
        }
        return results[0].getElement();
    }

    private static boolean isLastTypeScriptModuleRef(@NotNull PsiReference ref) {
        TypeScriptFileModuleReference moduleReference;
        if (ref == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(4);
        }
        return ref instanceof TypeScriptFileModuleReference && (moduleReference = (TypeScriptFileModuleReference)ref).isLast();
    }

    @Nullable
    private static PsiElement getForTypeScriptModuleRef(@NotNull TypeScriptFileModuleReference reference) {
        Collection elements;
        PsiElement element;
        if (reference == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(5);
        }
        if ((element = reference.getElement()) instanceof ES6FromClause && (elements = ((ES6FromClause)element).resolveReferencedElements()).size() == 1) {
            return (PsiElement)ContainerUtil.getFirstItem((Collection)elements);
        }
        return null;
    }

    @Nullable
    public PsiElement getNamedElement(@NotNull PsiElement element) {
        ASTNode node;
        Collection implicitElements;
        JSImplicitElement implicitElement;
        JSElementIndexingData indexingData;
        if (element == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(6);
        }
        PsiElement parent = element.getParent();
        if (!(element instanceof JSNamedElement) && !(element instanceof JSImplicitElementProvider) && parent instanceof JSImplicitElementProvider && (indexingData = ((JSImplicitElementProvider)parent).getIndexingData()) != null && (implicitElement = (JSImplicitElement)ContainerUtil.getFirstItem((Collection)(implicitElements = indexingData.getImplicitElements()))) != null) {
            return implicitElement;
        }
        if (parent instanceof ES6ExportDefaultAssignment && ((node = element.getNode()).getElementType() == JSTokenTypes.EXPORT_KEYWORD || node.getElementType() == JSTokenTypes.DEFAULT_KEYWORD)) {
            return parent;
        }
        if (parent instanceof JSFunction && element.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD || parent instanceof JSClass && element.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD) {
            JSQualifiedNamedElement initializedElement;
            if (parent instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)parent)) != null) {
                return initializedElement;
            }
            return parent;
        }
        return null;
    }

    @Nullable
    public PsiElement adjustTargetElement(Editor editor, int offset, int flags, @NotNull PsiElement targetElement) {
        if (targetElement == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(7);
        }
        if (targetElement instanceof TypeScriptProxyImplicitElement && !(targetElement instanceof TypeScriptImplicitMemberForComputedProperty) || targetElement instanceof JSQualifiedNamedElement && !BitUtil.isSet((int)flags, (int)2)) {
            targetElement = JSTargetElementEvaluator.adjustTargetElement(targetElement);
        }
        return targetElement;
    }

    @Nullable
    public static PsiElement adjustTargetElement(@Nullable PsiElement targetElement) {
        TypeScriptDeclarationMappings mappings;
        JSQualifiedNamedElement sourceElement;
        if (targetElement == null) {
            return null;
        }
        if (targetElement instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            targetElement = ((TypeScriptProxyImplicitElementWithBackingItem)targetElement).getBackingElement();
        }
        if (targetElement instanceof TypeScriptProxyImplicitElement) {
            targetElement = ((TypeScriptProxyImplicitElement)targetElement).getExplicitElement();
        }
        if (targetElement instanceof JSQualifiedNamedElement && (sourceElement = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((mappings = TypeScriptDeclarationMappings.getInstance(targetElement.getProject())).getTSSourceElements((JSQualifiedNamedElement)targetElement))) != null) {
            targetElement = sourceElement;
        }
        return targetElement;
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        PsiElement meaningfulElement;
        if (element == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(8);
        }
        if ((meaningfulElement = JSStubBasedPsiTreeUtil.calculateTargetElement(element)) != element) {
            return meaningfulElement;
        }
        return null;
    }

    @Nullable
    public Collection<PsiElement> getTargetCandidates(@NotNull PsiReference reference) {
        if (reference == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(9);
        }
        if (!(reference instanceof JSElement)) {
            return super.getTargetCandidates(reference);
        }
        if (reference instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference polyReference = (PsiPolyVariantReference)reference;
            ResolveResult[] results = polyReference.multiResolve(false);
            if (results == JSResolveResult.TOO_MANY_CANDIDATES) {
                if (polyReference instanceof JSReferenceExpressionImpl) {
                    results = JSTargetElementEvaluator.resolveReferenceExpressionWithAllResolveResults((JSReferenceExpressionImpl)polyReference);
                } else {
                    return ContainerUtil.emptyList();
                }
            }
            ArrayList<PsiElement> navigatableResults = new ArrayList<PsiElement>(results.length);
            for (ResolveResult r : results) {
                PsiElement element = JSTargetElementEvaluator.adjustTargetElement(r.getElement());
                if (!TargetElementUtil.getInstance().isNavigatableSource(element)) continue;
                navigatableResults.add(element);
            }
            return navigatableResults;
        }
        PsiElement resolve = JSTargetElementEvaluator.adjustTargetElement(reference.resolve());
        return ContainerUtil.createMaybeSingletonList((Object)(TargetElementUtil.getInstance().isNavigatableSource(resolve) ? resolve : null));
    }

    @NotNull
    public static ResolveResult[] resolveReferenceExpressionWithAllResolveResults(JSReferenceExpressionImpl polyReference) {
        ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)polyReference).createReferenceExpressionResolver(polyReference, true);
        ResolveResult[] resolveResultArray = resolver.resolve((PsiPolyVariantReference)polyReference, false);
        if (resolveResultArray == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(10);
        }
        return resolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSTargetElementEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSTargetElementEvaluator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceExpressionWithAllResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "includeSelfInGotoImplementation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementByReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationIfOverloads";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDefinitionIfDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLastTypeScriptModuleRef";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getForTypeScriptModuleRef";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustTargetElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTargetCandidates";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

