/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.EmbeddedJsonSchemaFileProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaScriptJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    private static final Map<String, SchemaData> USER_NAMES = new HashMap<String, SchemaData>();
    public static final String PATH = "/jsonSchemas/";

    @NotNull
    private static List<JsonSchemaFileProvider> createProviders() {
        ArrayList providers = ContainerUtil.newArrayList();
        for (Map.Entry<String, SchemaData> entry : USER_NAMES.entrySet()) {
            SchemaData value = entry.getValue();
            providers.add(JavaScriptJsonSchemaProviderFactory.createProvider(entry.getKey(), value.presentableName, value.remoteUrl, value.files));
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            JavaScriptJsonSchemaProviderFactory.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static JsonSchemaFileProvider createProvider(@NotNull String filename, @NotNull String presentableName, @NotNull String remoteUrl, String ... userNames) {
        if (filename == null) {
            JavaScriptJsonSchemaProviderFactory.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            JavaScriptJsonSchemaProviderFactory.$$$reportNull$$$0(2);
        }
        if (remoteUrl == null) {
            JavaScriptJsonSchemaProviderFactory.$$$reportNull$$$0(3);
        }
        return new EmbeddedJsonSchemaFileProvider(filename, presentableName, remoteUrl, JavaScriptJsonSchemaProviderFactory.class, PATH, userNames);
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        if (project == null) {
            JavaScriptJsonSchemaProviderFactory.$$$reportNull$$$0(4);
        }
        List<JsonSchemaFileProvider> list = JavaScriptJsonSchemaProviderFactory.createProviders();
        if (list == null) {
            JavaScriptJsonSchemaProviderFactory.$$$reportNull$$$0(5);
        }
        return list;
    }

    static {
        USER_NAMES.put(".babelrc-schema.json", new SchemaData("Babelrc", "http://json.schemastore.org/babelrc", ".babelrc"));
        USER_NAMES.put("tsconfig-schema.json", new SchemaData("TSConfig", "http://json.schemastore.org/tsconfig", "tsconfig.json"));
        USER_NAMES.put("jsconfig-schema.json", new SchemaData("JSConfig", "http://json.schemastore.org/jsconfig", "jsconfig.json"));
        USER_NAMES.put("tsd-schema.json", new SchemaData("TSD", "http://json.schemastore.org/tsd", "tsd.json"));
        USER_NAMES.put("typings-schema.json", new SchemaData("Typings", "http://json.schemastore.org/typings", "typings.json"));
        USER_NAMES.put(".eslintrc-schema.json", new SchemaData("ESLint", "http://json.schemastore.org/eslintrc", ".eslintrc.json", ".eslintrc"));
        USER_NAMES.put(".stylelintrc-schema.json", new SchemaData("StyleLint", "http://json.schemastore.org/stylelintrc", ".stylelintrc", ".stylelintrc.json"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JavaScriptJsonSchemaProviderFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createProviders";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JavaScriptJsonSchemaProviderFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SchemaData {
        String[] files;
        String remoteUrl;
        String presentableName;

        public SchemaData(String presentableName, String remoteUrl, String ... files) {
            this.files = files;
            this.remoteUrl = remoteUrl;
            this.presentableName = presentableName;
        }
    }
}

