/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtFileListener;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsbtFileManager {
    private final Project myProject;
    private final LinkedHashMap<VirtualFile, JsbtFileStructure> myBuildfiles;
    private final List<JsbtFileListener> myListeners;
    private final JsbtService myService;
    private boolean myDetectionDone;
    private VirtualFileListener myVirtualFileListener;
    private JsbtSortingMode mySortingMode;

    public JsbtFileManager(@NotNull Project project, @NotNull JsbtService service) {
        if (project == null) {
            JsbtFileManager.$$$reportNull$$$0(0);
        }
        if (service == null) {
            JsbtFileManager.$$$reportNull$$$0(1);
        }
        this.myBuildfiles = ContainerUtil.newLinkedHashMap();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDetectionDone = false;
        this.mySortingMode = JsbtSortingMode.DEFINITION_ORDER;
        this.myProject = project;
        this.myService = service;
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                JsbtFileManager.this.myListeners.clear();
                JsbtFileManager.this.myBuildfiles.clear();
                JsbtFileManager.this.removeVirtualFileListener();
            }
        });
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JsbtFileManager.$$$reportNull$$$0(2);
        }
        return project;
    }

    public boolean isDetectionDone() {
        return this.myDetectionDone;
    }

    public void setDetectionDone() {
        this.myDetectionDone = true;
    }

    public final void fetchStructure(@NotNull VirtualFile buildfile, @NotNull CatchingConsumer<JsbtFileStructure, JsbtTaskFetchException> consumer) {
        if (buildfile == null) {
            JsbtFileManager.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            JsbtFileManager.$$$reportNull$$$0(4);
        }
        TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, () -> {
            if (buildfile == null) {
                JsbtFileManager.$$$reportNull$$$0(20);
            }
            if (consumer == null) {
                JsbtFileManager.$$$reportNull$$$0(21);
            }
            if (this.shouldSaveAllDocumentBeforeFetch()) {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (buildfile == null) {
                    JsbtFileManager.$$$reportNull$$$0(22);
                }
                if (consumer == null) {
                    JsbtFileManager.$$$reportNull$$$0(23);
                }
                try {
                    JsbtFileStructure structure = this.myService.fetchBuildfileStructure(this.myProject, buildfile);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (buildfile == null) {
                            JsbtFileManager.$$$reportNull$$$0(26);
                        }
                        if (consumer == null) {
                            JsbtFileManager.$$$reportNull$$$0(27);
                        }
                        this.myBuildfiles.put(buildfile, structure);
                        consumer.consume((Object)structure);
                    }, ModalityState.any(), this.myProject.getDisposed());
                }
                catch (JsbtTaskFetchException e) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (buildfile == null) {
                            JsbtFileManager.$$$reportNull$$$0(24);
                        }
                        if (consumer == null) {
                            JsbtFileManager.$$$reportNull$$$0(25);
                        }
                        this.myBuildfiles.put(buildfile, null);
                        consumer.consume((Throwable)e);
                    }, ModalityState.any(), this.myProject.getDisposed());
                }
            });
        });
    }

    protected boolean shouldSaveAllDocumentBeforeFetch() {
        return true;
    }

    public void clearAllBuildfiles() {
        this.myBuildfiles.clear();
        this.removeVirtualFileListener();
    }

    public void addBuildfile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsbtFileManager.$$$reportNull$$$0(5);
        }
        this.myDetectionDone = true;
        if (this.myBuildfiles.containsKey(file2)) {
            this.fireBuildfileSelected(file2);
        } else {
            this.myBuildfiles.put(file2, null);
            this.fireBuildfileAdded(file2);
            this.ensureVirtualFileListenerAdded();
        }
    }

    private void ensureVirtualFileListenerAdded() {
        if (this.myVirtualFileListener == null) {
            this.myVirtualFileListener = new MyVirtualFileListener();
            VirtualFileManager.getInstance().addVirtualFileListener(this.myVirtualFileListener);
        }
    }

    private void removeVirtualFileListener() {
        if (this.myVirtualFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener(this.myVirtualFileListener);
            this.myVirtualFileListener = null;
        }
    }

    protected void addBuildfileStructure(@NotNull JsbtFileStructure structure) {
        if (structure == null) {
            JsbtFileManager.$$$reportNull$$$0(6);
        }
        this.myBuildfiles.put(structure.getBuildfile(), structure);
        this.ensureVirtualFileListenerAdded();
    }

    @Nullable
    public JsbtFileStructure getCachedStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtFileManager.$$$reportNull$$$0(7);
        }
        return this.myBuildfiles.get(buildfile);
    }

    public void removeBuildfile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsbtFileManager.$$$reportNull$$$0(8);
        }
        if (this.myBuildfiles.containsKey(file2)) {
            this.myBuildfiles.remove(file2);
            this.fireBuildfileRemoved(file2);
            if (this.myBuildfiles.isEmpty()) {
                this.removeVirtualFileListener();
            }
        }
    }

    public boolean containsBuildfile(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtFileManager.$$$reportNull$$$0(9);
        }
        return this.myBuildfiles.containsKey(buildfile);
    }

    @NotNull
    public Collection<VirtualFile> getBuildfiles() {
        Set<VirtualFile> set = this.myBuildfiles.keySet();
        if (set == null) {
            JsbtFileManager.$$$reportNull$$$0(10);
        }
        return set;
    }

    public boolean hasBuildfiles() {
        return !this.myBuildfiles.isEmpty();
    }

    public void addListener(final @NotNull JsbtFileListener listener2, @Nullable Disposable parentDisposable) {
        if (listener2 == null) {
            JsbtFileManager.$$$reportNull$$$0(11);
        }
        this.myListeners.add(listener2);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    JsbtFileManager.this.myListeners.remove(listener2);
                }
            });
        }
    }

    public void removeListener(@NotNull JsbtFileListener listener2) {
        if (listener2 == null) {
            JsbtFileManager.$$$reportNull$$$0(12);
        }
        this.myListeners.remove(listener2);
    }

    private void fireBuildfileAdded(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtFileManager.$$$reportNull$$$0(13);
        }
        for (JsbtFileListener listener2 : this.myListeners) {
            listener2.onBuildfileAdded(buildfile);
        }
    }

    private void fireBuildfileSelected(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtFileManager.$$$reportNull$$$0(14);
        }
        for (JsbtFileListener listener2 : this.myListeners) {
            listener2.onBuildfileSelected(buildfile);
        }
    }

    private void fireBuildfileRemoved(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtFileManager.$$$reportNull$$$0(15);
        }
        for (JsbtFileListener listener2 : this.myListeners) {
            listener2.onBuildfileRemoved(buildfile);
        }
    }

    @NotNull
    public JsbtSortingMode getSortingMode() {
        JsbtSortingMode jsbtSortingMode = this.mySortingMode;
        if (jsbtSortingMode == null) {
            JsbtFileManager.$$$reportNull$$$0(16);
        }
        return jsbtSortingMode;
    }

    public void setSortingMode(@NotNull JsbtSortingMode sortingMode) {
        if (sortingMode == null) {
            JsbtFileManager.$$$reportNull$$$0(17);
        }
        JsbtSortingMode oldSortingMode = this.mySortingMode;
        this.mySortingMode = sortingMode;
        if (oldSortingMode != sortingMode) {
            for (JsbtFileListener listener2 : this.myListeners) {
                listener2.onSortingModeChanged(sortingMode);
            }
        }
    }

    public void changeBuildfile(@NotNull VirtualFile oldBuildfile, @NotNull VirtualFile newBuildfile) {
        if (oldBuildfile == null) {
            JsbtFileManager.$$$reportNull$$$0(18);
        }
        if (newBuildfile == null) {
            JsbtFileManager.$$$reportNull$$$0(19);
        }
        if (this.myBuildfiles.containsKey(oldBuildfile)) {
            this.myBuildfiles.remove(oldBuildfile);
            this.myBuildfiles.put(newBuildfile, null);
            for (JsbtFileListener listener2 : this.myListeners) {
                listener2.onBuildfileChanged(oldBuildfile, newBuildfile);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtFileManager";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 4: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingMode";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldBuildfile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBuildfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtFileManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildfiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 10: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchStructure";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBuildfile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBuildfileStructure";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedStructure";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeBuildfile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsBuildfile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireBuildfileAdded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireBuildfileSelected";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fireBuildfileRemoved";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setSortingMode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "changeBuildfile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetchStructure$3";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            VirtualFile file2;
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            if ((file2 = event.getFile()).isDirectory()) {
                if (JsbtFileManager.this.myProject.isDisposed()) {
                    return;
                }
                ProjectFileIndex.getInstance((Project)JsbtFileManager.this.myProject).iterateContentUnderDirectory(file2, descendant -> {
                    if (!descendant.isDirectory() && JsbtFileManager.this.myBuildfiles.containsKey(descendant)) {
                        JsbtFileManager.this.removeBuildfile(descendant);
                    }
                    return !JsbtFileManager.this.myProject.isDisposed();
                });
            } else if (JsbtFileManager.this.myBuildfiles.containsKey(file2)) {
                JsbtFileManager.this.removeBuildfile(file2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager$MyVirtualFileListener", "beforeFileDeletion"));
        }
    }
}

