/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.nodejs.NodePackageVersion;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.gulp.GulpJsonTaskListParser;
import com.intellij.lang.javascript.buildTools.gulp.GulpPseudoGraphicTaskListParser;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpTask;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListParseException;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListParser;
import com.intellij.lang.javascript.buildTools.gulp.GulpUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.CommandLineUtil;
import com.intellij.webcore.util.ProcessOutputCatcher;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpTaskListFetchUtil {
    private static final Logger LOG = Logger.getInstance(GulpTaskListFetchUtil.class);

    private GulpTaskListFetchUtil() {
    }

    @NotNull
    public static GulpfileStructure listTasks(@NotNull Project project, @NotNull VirtualFile gulpfile) throws JsbtTaskFetchException {
        GulpfileStructure gulpfileStructure;
        if (project == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(0);
        }
        if (gulpfile == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(1);
        }
        GulpRunSettings templateRunSettings = GulpRunConfiguration.getTemplateRunSettings(project);
        NodeJsInterpreterRef interpreterRef = templateRunSettings.getInterpreterRef();
        NodeJsInterpreter interpreter = interpreterRef.resolve(project);
        NodePackage gulpPackage = GulpUtil.getGulpPackage(project, interpreter, gulpfile);
        String nodeOptions = templateRunSettings.getNodeOptions();
        EnvironmentVariablesData envData = templateRunSettings.getEnvData();
        try {
            long startTime = System.currentTimeMillis();
            GulpfileStructure structure = GulpTaskListFetchUtil.doListTasks(interpreter, nodeOptions, gulpPackage, gulpfile, envData);
            LOG.info(String.format("%s: %d tasks listed in %d ms", gulpfile.getPath(), structure.getTasks().size(), System.currentTimeMillis() - startTime));
            gulpfileStructure = structure;
        }
        catch (JsbtTaskFetchException e) {
            String description = e.getDescription();
            LOG.info(description);
            throw e;
        }
        if (gulpfileStructure == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(2);
        }
        return gulpfileStructure;
    }

    @NotNull
    private static List<JsbtInvalidSetting> checkSettings(@Nullable NodeJsInterpreter interpreter, @NotNull NodePackage gulpPackage) {
        String gulpPackageError;
        if (gulpPackage == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(3);
        }
        ArrayList errorInfos = ContainerUtil.newArrayList();
        JsbtInvalidSetting nodeInterpreterErrorInfo = GulpTaskListFetchUtil.validateNodeInterpreter(interpreter);
        if (nodeInterpreterErrorInfo != null) {
            errorInfos.add(nodeInterpreterErrorInfo);
        }
        if ((gulpPackageError = gulpPackage.getErrorMessage(GulpUtil.GULP.getPackageNames().get(0))) != null) {
            errorInfos.add(new JsbtInvalidSetting("Gulp package", gulpPackage.getSystemDependentPath(), gulpPackageError));
        }
        ArrayList arrayList = errorInfos;
        if (arrayList == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static JsbtInvalidSetting validateNodeInterpreter(@Nullable NodeJsInterpreter interpreter) {
        String name = "Node interpreter";
        String errorMessage = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter);
        if (errorMessage != null) {
            return new JsbtInvalidSetting(name, null, errorMessage);
        }
        return null;
    }

    @NotNull
    private static GulpfileStructure doListTasks(@Nullable NodeJsInterpreter interpreter, @NotNull String nodeOptions, @NotNull NodePackage gulpPackage, @NotNull VirtualFile gulpfile, @NotNull EnvironmentVariablesData envData) throws JsbtTaskFetchException {
        GulpfileStructure gulpfileStructure;
        KillableColoredProcessHandler processHandler;
        List<JsbtInvalidSetting> valueErrorInfos;
        if (nodeOptions == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(5);
        }
        if (gulpPackage == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(6);
        }
        if (gulpfile == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(7);
        }
        if (envData == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(8);
        }
        if (!(valueErrorInfos = GulpTaskListFetchUtil.checkSettings(interpreter, gulpPackage)).isEmpty()) {
            throw JsbtTaskFetchException.newInvalidSettings(gulpfile, valueErrorInfos);
        }
        interpreter = Objects.requireNonNull(interpreter);
        String gulpfilePath = FileUtil.toSystemDependentName((String)gulpfile.getPath());
        NodePackageVersion packageVersion = NodePackageVersionUtil.getPackageVersion(gulpPackage.getSystemDependentPath());
        boolean jsonOutput = GulpTaskListFetchUtil.isJsonOutputSupported(packageVersion);
        GeneralCommandLine commandLine = GulpTaskListFetchUtil.createTasksFetchCommandLine(nodeOptions, gulpPackage, jsonOutput, gulpfilePath, envData);
        try {
            NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
        }
        catch (ExecutionException e) {
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, e.getMessage(), commandLine, e, null, null);
        }
        LOG.info("[" + packageVersion + "] Fetching gulp tasks: " + commandLine.getCommandLineString());
        try {
            processHandler = new KillableColoredProcessHandler(commandLine, true);
        }
        catch (ExecutionException e) {
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, "cannot execute command", commandLine, e, null, null);
        }
        long startTimeMillis = System.currentTimeMillis();
        ProcessOutput processOutput = GulpTaskListFetchUtil.captureTasksFetchOutput((BaseOSProcessHandler)processHandler, jsonOutput);
        if (processOutput.isTimeout()) {
            long duration = System.currentTimeMillis() - startTimeMillis;
            String message = String.format("timed limit exceeded (%.1f sec), process was terminated forcibly", (double)duration / 1000.0);
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, message, commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        if (processOutput.getExitCode() != 0) {
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, "process finished with exit code " + processOutput.getExitCode() + " (a non-zero exit code means an error)", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        try {
            GulpTaskListParser parser = jsonOutput ? GulpJsonTaskListParser.INSTANCE : GulpPseudoGraphicTaskListParser.INSTANCE;
            List<Pair<String, List<String>>> taskList = parser.parseTaskList(processOutput.getStdout());
            gulpfileStructure = GulpTaskListFetchUtil.createStructure(gulpfile, taskList);
        }
        catch (GulpTaskListParseException e) {
            Throwable cause = e.getCause();
            String message = e.getMessage();
            if (cause != null) {
                message = message + " -> " + cause.getMessage();
                LOG.warn(message, (Throwable)e);
            }
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, message, commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        catch (Throwable t) {
            LOG.warn("Failed to parse gulp task list output", t);
            throw GulpTaskListFetchUtil.newFetchFail(gulpfile, "internal problem occurred when parsing output", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        if (gulpfileStructure == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(9);
        }
        return gulpfileStructure;
    }

    private static boolean isJsonOutputSupported(@Nullable NodePackageVersion packageVersion) {
        if (packageVersion == null) {
            return false;
        }
        if (GulpUtil.isGulpPackage(packageVersion)) {
            SemVer semVer = packageVersion.getSemVer();
            return semVer != null && semVer.getMajor() >= 4;
        }
        return GulpUtil.isGulpCliPackage(packageVersion);
    }

    @NotNull
    private static GulpfileStructure createStructure(@NotNull VirtualFile gulpfile, @NotNull List<Pair<String, List<String>>> taskList) {
        if (gulpfile == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(10);
        }
        if (taskList == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(11);
        }
        GulpfileStructure structure = new GulpfileStructure(gulpfile);
        List tasks = ContainerUtil.map(taskList, pair -> new GulpTask(structure, (String)pair.getFirst(), (List)pair.getSecond()));
        structure.setTasks(tasks);
        GulpfileStructure gulpfileStructure = structure;
        if (gulpfileStructure == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(12);
        }
        return gulpfileStructure;
    }

    @NotNull
    private static JsbtTaskFetchException newFetchFail(@NotNull VirtualFile gulpfile, @NotNull String message, @NotNull GeneralCommandLine commandLine, @Nullable ExecutionException executionException, @Nullable ProcessHandler processHandler, @Nullable ProcessOutput processOutput) {
        if (gulpfile == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(13);
        }
        if (message == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(14);
        }
        if (commandLine == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(15);
        }
        JsbtTaskFetchException jsbtTaskFetchException = JsbtTaskFetchException.newFetchFail(gulpfile, GulpService.getInstance(), "gulp", JavaScriptLanguageIcons.BuildTools.Gulp16, message, commandLine, "gulp <list tasks>", executionException, processHandler, processOutput);
        if (jsbtTaskFetchException == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(16);
        }
        return jsbtTaskFetchException;
    }

    @NotNull
    private static ProcessOutput captureTasksFetchOutput(final @NotNull BaseOSProcessHandler processHandler, final boolean jsonOutput) {
        if (processHandler == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(17);
        }
        final AtomicBoolean taskOutputStarted = new AtomicBoolean(false);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                boolean started;
                String text;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType != ProcessOutputTypes.STDERR && outputType != ProcessOutputTypes.SYSTEM && (text = event.getText()) != null && (started = jsonOutput ? StringUtil.containsChar((String)text, (char)'[') || StringUtil.containsChar((String)text, (char)'{') : text.contains("Tasks for"))) {
                    taskOutputStarted.set(true);
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ProcessOutputCatcher catcher = new ProcessOutputCatcher(processHandler);
        catcher.startNotify();
        ProcessOutput output = catcher.getOutput();
        for (int i = 0; i < 300; ++i) {
            if (catcher.run(1000L)) {
                ProcessOutput processOutput = output;
                if (processOutput == null) {
                    GulpTaskListFetchUtil.$$$reportNull$$$0(18);
                }
                return processOutput;
            }
            if (taskOutputStarted.get()) break;
        }
        if (taskOutputStarted.get()) {
            if (!catcher.run(10000L)) {
                catcher.terminateAndWait();
                if (output.getStderr().isEmpty()) {
                    output.setExitCode(0);
                } else {
                    output.setTimeout();
                }
            }
        } else {
            catcher.terminateAndWait();
            output.setTimeout();
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(19);
        }
        return processOutput;
    }

    @NotNull
    private static GeneralCommandLine createTasksFetchCommandLine(@NotNull String nodeOptions, @NotNull NodePackage gulpPackage, boolean jsonOutput, @NotNull String gulpfilePath, @NotNull EnvironmentVariablesData envData) {
        if (nodeOptions == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(20);
        }
        if (gulpPackage == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(21);
        }
        if (gulpfilePath == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(22);
        }
        if (envData == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(23);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(CharsetToolkit.UTF8_CHARSET);
        envData.configureCommandLine(commandLine, true);
        CommandLineUtil.setWorkingDirectory((GeneralCommandLine)commandLine, (File)new File(gulpfilePath).getParentFile(), (boolean)false);
        nodeOptions = nodeOptions.trim();
        if (StringUtil.isNotEmpty((String)nodeOptions)) {
            commandLine.addParameters(ParametersList.parse((String)nodeOptions));
        }
        File gulpBinFile = GulpUtil.getGulpBinFile(gulpPackage);
        commandLine.addParameter(gulpBinFile.getAbsolutePath());
        commandLine.addParameter("--no-color");
        commandLine.addParameter("--gulpfile");
        commandLine.addParameter(gulpfilePath);
        if (jsonOutput) {
            commandLine.addParameter("--tasks-json");
            commandLine.addParameter("--silent");
        } else {
            commandLine.addParameter("--tasks");
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            GulpTaskListFetchUtil.$$$reportNull$$$0(24);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpfile";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil";
                break;
            }
            case 3: 
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpPackage";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeOptions";
                break;
            }
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpfilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpTaskListFetchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "listTasks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doListTasks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructure";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newFetchFail";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "captureTasksFetchOutput";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createTasksFetchCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listTasks";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doListTasks";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStructure";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newFetchFail";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "captureTasksFetchOutput";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTasksFetchCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

