/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private static final String NODE_DEBUG_OPTION = "NODE_DEBUG_OPTION";
    private final NpmRunSettings myRunSettings;
    private final NodeJsInterpreter myNodeInterpreter;
    private final ExecutionEnvironment myEnvironment;

    public NpmRunProfileState(@NotNull NpmRunSettings runSettings, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (runSettings == null) {
            NpmRunProfileState.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            NpmRunProfileState.$$$reportNull$$$0(1);
        }
        this.myNodeInterpreter = runSettings.getInterpreterRef().resolveNotNull(environment.getProject());
        this.myRunSettings = runSettings;
        this.myEnvironment = environment;
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        GeneralCommandLine commandLine = this.createCommandLine(debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, true);
        if (debugPort != -1) {
            this.checkTasksNotConfiguredForDebug((ProcessHandler)processHandler);
        }
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        ConsoleView console = this.createConsole((ProcessHandler)processHandler, commandLine.getWorkDirectory());
        console.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(console, (ProcessHandler)processHandler);
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        if (defaultExecutionResult == null) {
            NpmRunProfileState.$$$reportNull$$$0(2);
        }
        return defaultExecutionResult;
    }

    private void checkTasksNotConfiguredForDebug(final @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(3);
        }
        final List<String> tasksNotConfiguredForDebug = this.findTasksNotConfiguredForDebug();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (String task : tasksNotConfiguredForDebug) {
                    String variableRefName = SystemInfo.isWindows ? "%NODE_DEBUG_OPTION%" : "$NODE_DEBUG_OPTION";
                    processHandler.notifyTextAvailable("\nTo debug the \"" + task + "\" script, make sure the " + variableRefName + " string is specified as the first argument for the node command you'd like to debug.\nFor example:\n  \"scripts\": {\n    \"start\": \"node " + variableRefName + " server.js\"\n  }\n", ProcessOutputTypes.SYSTEM);
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState$1", "startNotified"));
            }
        });
    }

    @NotNull
    private List<String> findTasksNotConfiguredForDebug() {
        VirtualFile packageJson = LocalFileSystem.getInstance().findFileByPath(this.myRunSettings.getPackageJsonSystemIndependentPath());
        ArrayList result2 = ContainerUtil.newArrayList();
        if (packageJson != null) {
            for (String scriptName : this.myRunSettings.getScriptNames()) {
                JsonValue value;
                String text;
                JsonProperty property = NpmScriptsUtil.findScriptProperty(this.myEnvironment.getProject(), packageJson, scriptName);
                if (property == null || (text = (value = property.getValue()) == null ? null : value.getText()) == null || text.contains(NODE_DEBUG_OPTION)) continue;
                result2.add(scriptName);
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            NpmRunProfileState.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private ConsoleView createConsole(@NotNull ProcessHandler processHandler, @Nullable File cwd) {
        if (processHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(5);
        }
        ConsoleView console = NodeCommandLineUtil.createConsole(processHandler, this.myEnvironment.getProject(), false);
        console.addMessageFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), cwd));
        console.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), cwd));
        console.addMessageFilter((Filter)new TypeScriptErrorConsoleFilter(this.myEnvironment.getProject(), cwd));
        ConsoleView consoleView = console;
        if (consoleView == null) {
            NpmRunProfileState.$$$reportNull$$$0(6);
        }
        return consoleView;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(int debugPort) throws ExecutionException {
        GeneralCommandLine generalCommandLine = NpmRunProfileState.createCommandLine(NodeCommandLineUtil.createCommandLine(), debugPort, this.myNodeInterpreter, this.myRunSettings.getNodeOptions(), this.myRunSettings.getPackageManagerPackageRef(), this.myRunSettings.getPackageJsonSystemDependentPath(), this.getExecutionCommand(), this.myRunSettings.getScriptNames(), this.myRunSettings.getArguments(), this.myRunSettings.getEnvData(), this.myEnvironment.getProject());
        if (generalCommandLine == null) {
            NpmRunProfileState.$$$reportNull$$$0(7);
        }
        return generalCommandLine;
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort, @NotNull NodeJsInterpreter nodeInterpreter, @NotNull String nodeOptions, @NotNull NodePackageRef npmPackageRef, @NotNull String packageJsonPath, @NotNull NpmCommand command, @NotNull List<String> scriptNames, @NotNull String scriptArguments, @NotNull EnvironmentVariablesData envData, @NotNull Project project) throws ExecutionException {
        String arguments;
        if (commandLine == null) {
            NpmRunProfileState.$$$reportNull$$$0(8);
        }
        if (nodeInterpreter == null) {
            NpmRunProfileState.$$$reportNull$$$0(9);
        }
        if (nodeOptions == null) {
            NpmRunProfileState.$$$reportNull$$$0(10);
        }
        if (npmPackageRef == null) {
            NpmRunProfileState.$$$reportNull$$$0(11);
        }
        if (packageJsonPath == null) {
            NpmRunProfileState.$$$reportNull$$$0(12);
        }
        if (command == null) {
            NpmRunProfileState.$$$reportNull$$$0(13);
        }
        if (scriptNames == null) {
            NpmRunProfileState.$$$reportNull$$$0(14);
        }
        if (scriptArguments == null) {
            NpmRunProfileState.$$$reportNull$$$0(15);
        }
        if (envData == null) {
            NpmRunProfileState.$$$reportNull$$$0(16);
        }
        if (project == null) {
            NpmRunProfileState.$$$reportNull$$$0(17);
        }
        if (debugPort > 0) {
            NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, Collections.emptyList(), debugPort, true, nodeInterpreter, true);
            commandLine.getEnvironment().put(NODE_DEBUG_OPTION, StringUtil.join((Collection)commandLine.getParametersList().getList(), (String)" "));
            commandLine.getParametersList().clearAll();
        }
        commandLine.withCharset(CharsetToolkit.UTF8_CHARSET);
        File workingDirectory = new File(packageJsonPath).getParentFile();
        commandLine.withWorkDirectory(workingDirectory.getAbsolutePath());
        envData.configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.addParameters(ParametersListUtil.parse((String)nodeOptions.trim()));
        NodePackage pkg = NpmUtil.resolveRef(npmPackageRef, project, nodeInterpreter);
        if (pkg == null) {
            throw new ExecutionException("Cannot resolve '" + npmPackageRef.getIdentifier() + "' package manager");
        }
        commandLine.addParameter(NpmUtil.getValidNpmCliJsFilePath(pkg));
        commandLine.addParameter(command.getCliOption());
        if (command == NpmCommand.RUN_SCRIPT) {
            commandLine.addParameters(scriptNames);
        }
        if (!(command != NpmCommand.RUN_SCRIPT && command != NpmCommand.TEST && command != NpmCommand.INSTALL && command != NpmCommand.UPDATE || NpmUtil.isYarnAlikePackage(pkg))) {
            commandLine.addParameter("--scripts-prepend-node-path=auto");
        }
        if (!(arguments = scriptArguments.trim()).isEmpty()) {
            commandLine.addParameters(ParametersList.parse((String)arguments));
        }
        NodeCommandLineConfigurator.find(nodeInterpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            NpmRunProfileState.$$$reportNull$$$0(18);
        }
        return generalCommandLine;
    }

    @NotNull
    private NpmCommand getExecutionCommand() {
        List<String> scripts;
        if (this.myRunSettings.getCommand() == NpmCommand.RUN_SCRIPT && (scripts = this.myRunSettings.getScriptNames()).size() == 1 && "test".equals(ContainerUtil.getFirstItem(scripts))) {
            NpmCommand npmCommand = NpmCommand.TEST;
            if (npmCommand == null) {
                NpmRunProfileState.$$$reportNull$$$0(19);
            }
            return npmCommand;
        }
        NpmCommand npmCommand = this.myRunSettings.getCommand();
        if (npmCommand == null) {
            NpmRunProfileState.$$$reportNull$$$0(20);
        }
        return npmCommand;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        String arguments;
        if (consoleView == null) {
            NpmRunProfileState.$$$reportNull$$$0(21);
        }
        if (processHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(22);
        }
        NodePackageRef npmRef = NpmUtil.DESCRIPTOR.dereferenceIfProjectRef(this.myEnvironment.getProject(), this.myRunSettings.getPackageManagerPackageRef());
        boolean yarn = NpmUtil.isYarnAlikePackageRef(npmRef);
        ConsoleCommandLineFolder folder = new ConsoleCommandLineFolder(NpmManager.getNpmPackagePresentableName(yarn));
        NpmCommand command = this.getExecutionCommand();
        folder.addPlaceholderText(command.getCliOption(yarn));
        if (command == NpmCommand.RUN_SCRIPT) {
            folder.addPlaceholderTexts(this.myRunSettings.getScriptNames());
        }
        if (!(arguments = this.myRunSettings.getArguments().trim()).isEmpty()) {
            folder.addPlaceholderText(arguments);
        }
        folder.foldCommandLine(consoleView, processHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState";
                break;
            }
            case 3: 
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeInterpreter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeOptions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackageRef";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptNames";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptArguments";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksNotConfiguredForDebug";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 7: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkTasksNotConfiguredForDebug";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

