/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.webpack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfig;
import com.intellij.lang.javascript.buildTools.webpack.WebPackNotifier;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.webcore.util.JsonUtil;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J \u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/buildTools/webpack/WebPackExecutor;", "", "()V", "MARKER", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "notifier", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackNotifier;", "createGson", "Lcom/google/gson/Gson;", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "errorNotify", "", "project", "Lcom/intellij/openapi/project/Project;", "configPath", "stdErr", "extractErrorDetails", "getInterpreter", "loadConfig", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackConfig;", "run", "Lcom/intellij/execution/process/ProcessOutput;", "path", "intellij.javascript.impl"})
public final class WebPackExecutor {
    private final String MARKER;
    private final WebPackNotifier notifier;
    @NotNull
    private final Logger logger;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final ProcessOutput run(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)interpreter, (String)"interpreter");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        Map map = commandLine.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"commandLine.environment");
        Map map2 = map;
        CharSequence charSequence = "NODE_ENV";
        String string = "development";
        map2.put(charSequence, string);
        commandLine.setWorkDirectory(VfsUtil.virtualToIoFile((VirtualFile)project.getBaseDir()));
        commandLine.addParameter("-e");
        String loader = "";
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)".babel.", (boolean)false, (int)2, null)) {
            loader = StringsKt.trimIndent((String)"\n        try {\n          require('@babel/register');\n        } catch (e) {\n          require('babel-register');\n        }\n        ");
        } else if (StringsKt.endsWith$default((String)path, (String)".ts", (boolean)false, (int)2, null)) {
            loader = "require('ts-node/register');";
        }
        charSequence = loader;
        StringBuilder stringBuilder = new StringBuilder().append("\n      ").append(loader).append("\n      function mergeConfigs(array){\n        result = {};\n        for (var i = 0; i < array.length; i++) {\n          var obj = array[i];\n          result.output = result.output || obj.output;\n          if (!result.resolve) {\n            result.resolve = obj.resolve;\n          } else if (obj.resolve) {\n            if (!result.resolve.alias) {\n              result.resolve.alias = obj.resolve.alias;\n            } else if (obj.resolve.alias) {\n              result.resolve.alias = Object.assign(result.resolve.alias, obj.resolve.alias);\n            }\n            if (!result.resolve.modules) {\n              result.resolve.modules = obj.resolve.modules;\n            } else if (obj.resolve.modules) {\n              result.resolve.modules = result.resolve.modules.concat(obj.resolve.modules);\n            }\n            if (!result.resolve.modulesDirectories) {\n              result.resolve.modulesDirectories = obj.resolve.modulesDirectories;\n            } else if (obj.resolve.modulesDirectories) {\n              result.resolve.modulesDirectories = result.resolve.modulesDirectories.concat(obj.resolve.modulesDirectories);\n            }\n            result.resolve.root = result.resolve.root || obj.resolve.root;\n          }\n        }\n        return result;\n      }\n      var config = require('").append(NodeInterpreterUtil.convertLocalPathToRemote(path, interpreter)).append("');\n      function printConfig(config) {\n        if (");
        GeneralCommandLine generalCommandLine = commandLine;
        boolean bl = charSequence.length() > 0;
        generalCommandLine.addParameter(StringsKt.trimIndent((String)stringBuilder.append(bl).append(" && config.default !== undefined) config = config.default;\n        if (typeof(config) === 'function') config = config({development: true});\n        if (Array.isArray(config)) {\n          config = mergeConfigs(config);\n        }\n        config = {resolve: config.resolve, output: config.output}\n        if (config.resolve) config.resolve.plugins = undefined;\n        console.log(\"").append(this.MARKER).append("\")\n        console.log(JSON.stringify(config, null, 1));\n        process.exit(0);\n      }\n      if (typeof Promise !== 'undefined') {\n        config = Promise.resolve(config).then(function(value) {\n          printConfig(value)\n        })\n      } else {\n        printConfig(config)\n      }\n      ").toString()));
        NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
        return NodeCommandLineUtil.execute(commandLine, 10000L);
    }

    private final NodeJsInterpreter getInterpreter(Project project) {
        NodeJsLocalInterpreter localInterpreter;
        NodeJsInterpreterManager nodeJsInterpreterManager = NodeJsInterpreterManager.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterManager, (String)"NodeJsInterpreterManager.getInstance(project)");
        NodeJsInterpreter interpreter = nodeJsInterpreterManager.getInterpreter();
        if (!(interpreter instanceof NodeJsLocalInterpreter) && (localInterpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant()) != null) {
            interpreter = localInterpreter;
        }
        return interpreter != null && interpreter.validate(project) == null ? interpreter : null;
    }

    @NotNull
    public final WebPackConfig loadConfig(@NotNull Project project, @NotNull String configPath) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        NodeJsInterpreter interpreter = this.getInterpreter(project);
        if (interpreter == null) {
            String string = "Failed to load " + PathUtil.getFileName((String)configPath);
            MessageType messageType = MessageType.WARNING;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.WARNING");
            this.notifier.notify(project, string, messageType, configPath, new AnAction(project, "Set up Node.js interpreter"){
                final /* synthetic */ Project $project;

                public void actionPerformed(@Nullable AnActionEvent e) {
                    NodeJSSettingsManager.editSettingsAppropriately(this.$project);
                }
                {
                    this.$project = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            });
            return new WebPackConfig(null, null, 3, null);
        }
        ProcessOutput run = this.run(project, interpreter, configPath);
        if (run != null && run.getExitCode() == 0) {
            String string;
            String string2;
            String string3 = run.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"run.stdout");
            String string4 = string2 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String stdOut = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            int lastNewLine = StringsKt.lastIndexOf$default((CharSequence)stdOut, (String)this.MARKER, (int)0, (boolean)false, (int)6, null);
            if (lastNewLine >= 0) {
                String string5 = stdOut;
                int n = lastNewLine + this.MARKER.length() + 1;
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                string = string7;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = stdOut;
            }
            String result2 = string;
            try {
                Gson gson = this.createGson(interpreter);
                WebPackConfig config2 = (WebPackConfig)gson.fromJson(result2, WebPackConfig.class);
                String string8 = "Module resolution rules from <a href='#'>" + PathUtil.getFileName((String)configPath) + "</a> are now used for coding assistance.";
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.INFO");
                WebPackNotifier.notify$default(this.notifier, project, string8, messageType, configPath, null, 16, null);
                WebPackConfig webPackConfig = config2;
                Intrinsics.checkExpressionValueIsNotNull((Object)webPackConfig, (String)"config");
                return webPackConfig;
            }
            catch (RuntimeException e) {
                this.logger.debug(e.getMessage() + "\nstdout: " + run.getStdout() + "\nstderr: " + run.getStderr(), (Throwable)e);
                String string9 = run.getStderr();
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"run.stderr");
                this.errorNotify(project, configPath, string9);
            }
        } else if (run != null) {
            this.logger.warn("failed to evaluate webpack config. exit code: " + run.getExitCode() + (run.isTimeout() ? ", timed out" : "") + '\n' + "stdout: " + run.getStdout() + "\nstderr: " + run.getStderr());
            String string = run.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"run.stderr");
            this.errorNotify(project, configPath, string);
        }
        return new WebPackConfig(null, null, 3, null);
    }

    private final Gson createGson(NodeJsInterpreter interpreter) {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)String.class), new JsonDeserializer<String>(interpreter){
            final /* synthetic */ NodeJsInterpreter $interpreter;

            @Nullable
            public final String deserialize(JsonElement json, Type $noName_1, JsonDeserializationContext $noName_2) {
                String string = JsonUtil.getString((JsonElement)json);
                if (string == null) {
                    return null;
                }
                String path = string;
                return NodeInterpreterUtil.convertRemotePathToLocal(path, this.$interpreter);
            }
            {
                this.$interpreter = nodeJsInterpreter;
            }
        }).create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder().registerTy\u2026erpreter)\n    }).create()");
        return gson;
    }

    private final String extractErrorDetails(String stdErr) {
        for (String part : StringsKt.split$default((CharSequence)stdErr, (char[])new char[]{'\n', '\r'}, (boolean)false, (int)0, (int)6, null)) {
            int indexOfErrorMessage = StringsKt.indexOf$default((CharSequence)part, (String)"Error:", (int)0, (boolean)false, (int)6, null);
            if (indexOfErrorMessage < 0) continue;
            String string = part;
            int n = indexOfErrorMessage + "Error:".length();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return "";
    }

    private final void errorNotify(Project project, String configPath, String stdErr) {
        String errorDetails = this.extractErrorDetails(stdErr);
        String string = "Can't analyse <a href='#'>" + PathUtil.getFileName((String)configPath) + "</a>: coding assistance will ignore module resolution rules in this file.\n" + "Possible reasons: this file is not a valid webpack configuration file or its format is not currently supported by the IDE." + (StringUtil.isEmpty((String)errorDetails) ? "" : "\nError details: " + errorDetails);
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.WARNING");
        WebPackNotifier.notify$default(this.notifier, project, string, messageType, configPath, null, 16, null);
    }

    public WebPackExecutor() {
        StringBuilder stringBuilder = new StringBuilder().append("!!!");
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        this.MARKER = stringBuilder.append(applicationNamesInfo.getFullProductName()).append(" webpack loader!!!").toString();
        this.notifier = new WebPackNotifier();
        Logger logger = Logger.getInstance((String)"#com.intellij.lang.javascript.buildTools.webpack.WebPackExecutor");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026webpack.WebPackExecutor\")");
        this.logger = logger;
    }
}

