/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSKeywordInsertHandlerBase
implements InsertHandler<LookupElement> {
    public void handleInsert(InsertionContext context, LookupElement item) {
        PsiElement at;
        PsiFile file2 = context.getFile();
        Template template = this.applyAndCreateTemplate(context, file2, at = file2.findElementAt(context.getStartOffset()));
        if (template != null) {
            TemplateManager.getInstance((Project)context.getProject()).startTemplate(context.getEditor(), template);
            context.setAddCompletionChar(false);
        }
    }

    @Nullable
    protected abstract Template applyAndCreateTemplate(InsertionContext var1, PsiFile var2, PsiElement var3);

    @Contract(value="null -> false")
    protected static boolean isFollowedByIdentifierOrReferenceName(@Nullable PsiElement at) {
        PsiElement element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)at);
        if (element == null) {
            return false;
        }
        IElementType elementType = element.getNode().getElementType();
        return elementType == JSTokenTypes.IDENTIFIER || elementType == JSElementTypes.REFERENCE_EXPRESSION;
    }

    protected static void insertWhitespaceIfNeeded(@NotNull PsiElement at, @NotNull InsertionContext context) {
        PsiElement nextSibling;
        if (at == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(1);
        }
        if ((nextSibling = at.getNextSibling()) == null || nextSibling.getNode().getElementType() != JSTokenTypes.WHITE_SPACE) {
            JSKeywordInsertHandlerBase.insertWhitespace(context);
        }
    }

    protected static void insertWhitespace(@NotNull InsertionContext context) {
        if (context == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(2);
        }
        EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)" ");
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
    }

    protected static boolean isKeywordWithIdentifierAppended(@Nullable PsiElement at, @NotNull String identifierText) {
        if (identifierText == null) {
            JSKeywordInsertHandlerBase.$$$reportNull$$$0(3);
        }
        if (at == null) {
            return false;
        }
        if (at.getNode().getElementType() != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        return at.getText().startsWith(identifierText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSKeywordInsertHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insertWhitespaceIfNeeded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "insertWhitespace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isKeywordWithIdentifierAppended";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

