/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSKeywordsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final String[] TYPE_LITERAL_VALUES = new String[]{"true", "false", "null"};
    private static final String[] KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE = new String[]{"true", "false", "null", "debugger"};
    private static final String[] DEFAULT_KEYWORDS_WITH_WHITESPACE = new String[]{"const", "delete", "new", "throw", "typeof", "var", "void"};

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiFile containingFile;
        if (parameters == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(1);
        }
        List<Object> variants = (containingFile = parameters.getPosition().getContainingFile().getOriginalFile()) instanceof JSExpressionCodeFragment ? ((JSExpressionCodeFragment)containingFile).getTopLevelVariants(parameters.getPosition()) : Arrays.asList(JSKeywordsCompletionProvider.getDefaultKeywordVariants(parameters.getPosition()));
        ArrayList<LookupElement> lookupElements = new ArrayList<LookupElement>(variants.size());
        for (Object variant : variants) {
            lookupElements.add(JSLookupUtilImpl.toBoldLookupElement(variant));
        }
        result2.addAllElements(lookupElements);
    }

    @NotNull
    public static LookupElement[] getDefaultKeywordVariants(@NotNull PsiElement context) {
        PsiElement sibling;
        KeywordCompletionConsumer consumer;
        if (context == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(2);
        }
        ArrayList<Trinity<String, JSLookupPriority, Boolean>> keywords = new ArrayList<Trinity<String, JSLookupPriority, Boolean>>();
        JSCompletionKeywordsContributor contributor = JSHandlersFactory.forElement(context).newCompletionKeywordsContributor();
        if (!contributor.process(consumer = JSKeywordsCompletionProvider.createKeywordConsumer(keywords), context)) {
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
            if (lookupElementArray == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(3);
            }
            return lookupElementArray;
        }
        PsiElement parent = context.getParent();
        if (parent instanceof Es6MetaProperty) {
            String parentText = parent.getText();
            if (parentText.startsWith("new.")) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "target");
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                if (lookupElementArray == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(4);
                }
                return lookupElementArray;
            }
            if (parentText.startsWith("import.")) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "meta");
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                if (lookupElementArray == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(5);
                }
                return lookupElementArray;
            }
        }
        if (JSKeywordsCompletionProvider.isNoKeywordsContext(context, parent)) {
            if (LookupElement.EMPTY_ARRAY == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(6);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        if (JSKeywordsCompletionProvider.isCaseClauseContext(context, parent)) {
            JSKeywordsCompletionProvider.appendCaseKeywords(keywords);
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
            if (lookupElementArray == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(7);
            }
            return lookupElementArray;
        }
        CommonCodeStyleSettings commonSettings = JSCodeStyleSettings.getCommonSettings(context);
        PsiElement grandParent = parent.getParent();
        if (parent instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)parent).getQualifier() != null || parent.textContains('.') || parent.textContains(':')) {
                if (LookupElement.EMPTY_ARRAY == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(8);
                }
                return LookupElement.EMPTY_ARRAY;
            }
            if (grandParent instanceof JSNewExpression) {
                boolean appendSpace = JSCodeStyleSettings.getSettings((PsiElement)context).SPACE_BEFORE_FUNCTION_LEFT_PARENTH;
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, appendSpace, "function");
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                if (lookupElementArray == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(9);
                }
                return lookupElementArray;
            }
            if (grandParent instanceof JSDoWhileStatement) {
                boolean appendSpace = commonSettings.SPACE_BEFORE_WHILE_PARENTHESES;
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "while");
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                if (lookupElementArray == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(10);
                }
                return lookupElementArray;
            }
            if (grandParent instanceof JSStatement) {
                boolean appendSpace;
                PsiElement prevStatement = PsiTreeUtil.getPrevSiblingOfType((PsiElement)grandParent, JSStatement.class);
                if (prevStatement instanceof JSIfStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_ELSE_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "else");
                } else if (prevStatement instanceof JSTryStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_CATCH_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "catch");
                    appendSpace = commonSettings.SPACE_BEFORE_FINALLY_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "finally");
                }
                if (grandParent instanceof JSExpressionStatement) {
                    PsiElement grandParentParent;
                    PsiElement prevSibling = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(grandParent);
                    if (prevSibling != null && prevSibling.getNode().getElementType() == JSTokenTypes.ELSE_KEYWORD) {
                        boolean appendSpace2 = commonSettings.SPACE_BEFORE_IF_PARENTHESES;
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace2, "if");
                    }
                    if ((grandParentParent = grandParent.getParent()) instanceof JSCaseClause) {
                        JSKeywordsCompletionProvider.appendCaseKeywords(keywords);
                    }
                    if (grandParentParent instanceof JSForStatement) {
                        if (prevSibling instanceof PsiErrorElement) {
                            prevSibling = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(prevSibling);
                        }
                        if (prevSibling instanceof JSVarStatement) {
                            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "of", "in");
                            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                            if (lookupElementArray == null) {
                                JSKeywordsCompletionProvider.$$$reportNull$$$0(11);
                            }
                            return lookupElementArray;
                        }
                    } else if (JSKeywordsCompletionProvider.isContextForOperation(prevSibling)) {
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "in");
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "instanceof");
                    }
                }
            } else {
                if (JSKeywordsCompletionProvider.isES6ShortHandedProperty(parent, grandParent)) {
                    if (LookupElement.EMPTY_ARRAY == null) {
                        JSKeywordsCompletionProvider.$$$reportNull$$$0(12);
                    }
                    return LookupElement.EMPTY_ARRAY;
                }
                boolean isComparison = JSKeywordsCompletionProvider.isComparisonContext(grandParent);
                boolean isAssignment = JSKeywordsCompletionProvider.isAssignmentContext(grandParent);
                JSLookupPriority priority = JSLookupPriority.KEYWORDS_PRIORITY;
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, TYPE_LITERAL_VALUES);
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, "this");
                if (isAssignment || !isComparison) {
                    boolean appendSpace = commonSettings.SPACE_BEFORE_METHOD_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpace, "function");
                }
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, "typeof");
                if (isAssignment || !isComparison) {
                    JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, "new");
                }
                if (isAssignment || !isComparison) {
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "void", "delete");
                }
                contributor.appendExpressionContextKeywords(consumer);
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                if (lookupElementArray == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(13);
                }
                return lookupElementArray;
            }
        }
        if (JSKeywordsCompletionProvider.isEmbeddedContentExpression(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, TYPE_LITERAL_VALUES);
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "int", "uint");
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
            if (lookupElementArray == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(14);
            }
            return lookupElementArray;
        }
        boolean isLoop = JSKeywordsCompletionProvider.isLoopContext(grandParent);
        if (isLoop) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "continue");
        }
        if (isLoop || JSKeywordsCompletionProvider.isCaseClauseBodyContext(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "break");
        }
        if (JSKeywordsCompletionProvider.isFunctionContext(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "return");
        }
        if (JSKeywordsCompletionProvider.isThisOwnerContext(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "this");
        }
        if ((sibling = PsiTreeUtil.prevVisibleLeaf((PsiElement)parent)) != null && sibling.getNode().getElementType() == JSTokenTypes.FOR_KEYWORD) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, commonSettings.SPACE_BEFORE_FOR_PARENTHESES, "each");
        }
        if (sibling != null && sibling.getNode().getElementType() == JSTokenTypes.LPAR && grandParent instanceof JSForStatement) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "var", "let", "const");
        }
        JSKeywordsCompletionProvider.appendDefaultKeywords(keywords, context, commonSettings);
        contributor.appendSpecificKeywords(consumer);
        LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
        if (lookupElementArray == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(15);
        }
        return lookupElementArray;
    }

    private static boolean isContextForOperation(@Nullable PsiElement prevSibling) {
        if (prevSibling instanceof PsiErrorElement) {
            return true;
        }
        if (!(prevSibling instanceof JSVarStatement)) {
            return false;
        }
        JSVarStatement prev = (JSVarStatement)prevSibling;
        PsiElement child = prev.getLastChild();
        return child == null || child.getNode().getElementType() != JSTokenTypes.SEMICOLON;
    }

    @NotNull
    private static KeywordCompletionConsumer createKeywordConsumer(final List<Trinity<String, JSLookupPriority, Boolean>> keywords) {
        KeywordCompletionConsumer keywordCompletionConsumer = new KeywordCompletionConsumer(){

            @Override
            public void consume(JSLookupPriority priority, boolean appendSpaces, String ... contributorKeywords) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpaces, contributorKeywords);
            }
        };
        if (keywordCompletionConsumer == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(16);
        }
        return keywordCompletionConsumer;
    }

    private static boolean isComparisonContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSBinaryExpression && JSTokenTypes.EQUALITY_OPERATIONS.contains(((JSBinaryExpression)grandParent).getOperationSign());
    }

    private static boolean isAssignmentContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSArgumentList || grandParent instanceof JSBinaryExpression && ((JSBinaryExpression)grandParent).getOperationSign() == JSTokenTypes.EQ;
    }

    private static void appendDefaultKeywords(@NotNull List<Trinity<String, JSLookupPriority, Boolean>> keywords, @NotNull PsiElement context, @NotNull CommonCodeStyleSettings commonSettings) {
        if (keywords == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(17);
        }
        if (context == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(18);
        }
        if (commonSettings == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(19);
        }
        ArrayList withoutSpace = new ArrayList(30);
        ContainerUtil.addAll(withoutSpace, (Object[])KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE);
        ArrayList<String> withSpace = new ArrayList<String>(20);
        ContainerUtil.addAll(withSpace, (Object[])DEFAULT_KEYWORDS_WITH_WHITESPACE);
        keywords.add((Trinity<String, JSLookupPriority, Boolean>)Trinity.create((Object)"with", (Object)((Object)JSLookupPriority.LOWEST_PRIORITY), (Object)true));
        (commonSettings.SPACE_BEFORE_WHILE_PARENTHESES ? withSpace : withoutSpace).add("while");
        (commonSettings.SPACE_BEFORE_DO_LBRACE ? withSpace : withoutSpace).add("do");
        (commonSettings.SPACE_BEFORE_FOR_PARENTHESES ? withSpace : withoutSpace).add("for");
        (JSCodeStyleSettings.getSettings((PsiElement)context).SPACE_BEFORE_FUNCTION_LEFT_PARENTH ? withSpace : withoutSpace).add("function");
        (commonSettings.SPACE_BEFORE_IF_PARENTHESES ? withSpace : withoutSpace).add("if");
        (commonSettings.SPACE_BEFORE_TRY_LBRACE ? withSpace : withoutSpace).add("try");
        (commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES ? withSpace : withoutSpace).add("switch");
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, ArrayUtil.toStringArray(withoutSpace));
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, ArrayUtil.toStringArray(withSpace));
    }

    private static boolean isCaseClauseContext(@NotNull PsiElement context, @Nullable PsiElement parent) {
        if (context == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(20);
        }
        return parent instanceof JSCaseClause && JSUtils.getChildExcludingTypes(parent, PsiErrorElement.class, PsiWhiteSpace.class) == context;
    }

    private static boolean isCaseClauseBodyContext(@Nullable PsiElement context) {
        return PsiTreeUtil.getParentOfType((PsiElement)context, JSCaseClause.class) != null;
    }

    private static boolean isLoopContext(@Nullable PsiElement context) {
        return PsiTreeUtil.getParentOfType((PsiElement)context, JSLoopStatement.class) != null;
    }

    private static boolean isFunctionContext(@Nullable PsiElement parent) {
        return PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class) != null;
    }

    private static boolean isThisOwnerContext(@Nullable PsiElement parent) {
        if (PsiTreeUtil.getParentOfType((PsiElement)parent, TypeScriptEnum.class, (boolean)true, (Class[])new Class[]{TypeScriptFunction.class, TypeScriptModule.class, TypeScriptClass.class, JSObjectLiteralExpression.class}) != null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)parent, TypeScriptModule.class) == null) {
            return true;
        }
        JSFunction parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        if (parentFunction == null) {
            parentFunction = (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
        }
        return parentFunction != null;
    }

    private static boolean isNoKeywordsContext(@NotNull PsiElement context, PsiElement parent) {
        if (context == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(21);
        }
        return parent instanceof JSBreakStatement || parent instanceof JSContinueStatement || parent instanceof JSLiteralExpression || parent instanceof JSParameter || parent instanceof JSProperty || parent instanceof JSVariable || parent instanceof XmlAttribute || parent instanceof XmlAttributeValue || parent instanceof JSFunction && ((JSFunction)parent).getNameIdentifier() == context || parent instanceof TypeScriptModule && ((TypeScriptModule)parent).getNameIdentifier() == context || JSTokenTypes.STRING_LITERALS.contains(context.getNode().getElementType()) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiComment.class}) != null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSAttribute.class}) != null || parent instanceof JSReferenceExpression && JSResolveUtil.isSelfReference(parent);
    }

    private static boolean isES6ShortHandedProperty(PsiElement parent, PsiElement grandParent) {
        return grandParent instanceof JSProperty && ((JSProperty)grandParent).getNameIdentifier() == parent;
    }

    private static boolean isEmbeddedContentExpression(PsiElement grandParent) {
        ASTNode grandParentNode;
        return grandParent instanceof JSEmbeddedContent && (grandParentNode = grandParent.getNode()) != null && grandParentNode.getElementType() == JSElementTypes.EMBEDDED_EXPRESSION;
    }

    private static void appendCaseKeywords(List<Trinity<String, JSLookupPriority, Boolean>> keywords) {
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "case");
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "default");
    }

    public static void appendKeywords(List<Trinity<String, JSLookupPriority, Boolean>> keywords, @NotNull JSLookupPriority priority, boolean appendSpace, String ... names) {
        if (priority == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(22);
        }
        for (String name : names) {
            keywords.add((Trinity<String, JSLookupPriority, Boolean>)Trinity.create((Object)name, (Object)((Object)priority), (Object)appendSpace));
        }
    }

    private static LookupElement[] createKeywordItems(List<Trinity<String, JSLookupPriority, Boolean>> keywords, JSCompletionKeywordsContributor contributor) {
        THashMap keywordsMap = new THashMap();
        for (Trinity<String, JSLookupPriority, Boolean> keyword : keywords) {
            Pair oldKeywordValue = (Pair)keywordsMap.get(keyword.first);
            if (oldKeywordValue != null && ((JSLookupPriority)((Object)oldKeywordValue.first)).compareTo((Enum)keyword.second) >= 0) continue;
            keywordsMap.put(keyword.first, Pair.create((Object)keyword.second, (Object)keyword.third));
        }
        LookupElement[] result2 = new LookupElement[keywordsMap.size()];
        int i = 0;
        for (Map.Entry<String, Pair<JSLookupPriority, Boolean>> entry : keywordsMap.entrySet()) {
            String option = (String)entry.getKey();
            LookupElementBuilder element = LookupElementBuilder.create((String)option).withBoldness(true).withInsertHandler(JSKeywordsCompletionProvider.getInsertHandler(entry, option, contributor));
            LookupElement item = JSCompletionUtil.withJSLookupPriority((LookupElement)element, (JSLookupPriority)((Object)entry.getValue().first));
            result2[i++] = item;
        }
        return result2;
    }

    @NotNull
    private static InsertHandler<LookupElement> getInsertHandler(Map.Entry<String, Pair<JSLookupPriority, Boolean>> entry, String option, JSCompletionKeywordsContributor contributor) {
        InsertHandler<LookupElement> handlerForKeyword = contributor.createInsertHandlerForKeyword(option);
        if (handlerForKeyword != null) {
            InsertHandler<LookupElement> insertHandler = handlerForKeyword;
            if (insertHandler == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(23);
            }
            return insertHandler;
        }
        if (((Boolean)entry.getValue().second).booleanValue()) {
            InsertHandler insertHandler = AddSpaceInsertHandler.INSTANCE;
            if (insertHandler == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(24);
            }
            return insertHandler;
        }
        JSInsertHandler jSInsertHandler = JSInsertHandler.DEFAULT;
        if (jSInsertHandler == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(25);
        }
        return jSInsertHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultKeywordVariants";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeywordConsumer";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultKeywordVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendDefaultKeywords";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCaseClauseContext";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isNoKeywordsContext";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendKeywords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

