/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableTypeBase;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;

public class JSSmartCompletionContributor {
    public static final LanguageExtension<JSSmartCompletionContributor> EP_NAME = new LanguageExtension("JavaScript.smartCompletionContributor");
    private static final JSSmartCompletionContributor INSTANCE = new JSSmartCompletionContributor();

    public static JSSmartCompletionContributor getInstance() {
        return INSTANCE;
    }

    @ReadOnly
    @Nullable
    public List<LookupElement> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        PsiElement parent;
        PsiElement originalParent;
        JSType expectedClassType;
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(0);
        }
        if ((expectedClassType = JSTypeUtils.getValuableType(JSCompositeTypeImpl.optimizeTypeIfComposite(this.findClassType(originalParent = CompletionUtil.getOriginalOrSelf((PsiElement)(parent = location.getParent()))), true, JSCompositeTypeImpl.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED))) instanceof JSNamedType || expectedClassType instanceof JSGenericTypeImpl) {
            if (expectedClassType instanceof JSGenericTypeImpl && !DialectDetector.hasFeature((PsiElement)location, JSLanguageFeature.GENERICS)) {
                expectedClassType = ((JSGenericTypeImpl)expectedClassType).getType();
            }
            return this.getClassTypeVariants((PsiElement)location, parent, expectedClassType);
        }
        if (location.getQualifier() == null) {
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)location);
            List<LookupElement> stringLiteralVariants = this.getStringLiteralVariants((JSExpression)location, false, expectedType);
            if (stringLiteralVariants != null) {
                return stringLiteralVariants;
            }
            return JSSmartCompletionContributor.addOtherSmartVariants(location, expectedType);
        }
        return null;
    }

    @Nullable
    private static List<LookupElement> addOtherSmartVariants(@NotNull JSReferenceExpression location, @Nullable JSType expectedType) {
        List<LookupElement> staticItems;
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(1);
        }
        if (expectedType == null) {
            return null;
        }
        if (expectedType instanceof JSGenericTypeImpl) {
            expectedType = ((JSGenericTypeImpl)expectedType).getType();
        }
        if ((staticItems = JSSmartCompletionContributor.addStaticFactoryMethods(expectedType = JSTypeUtils.getValuableType(JSCompositeTypeImpl.optimizeTypeIfComposite(expectedType, true, JSCompositeTypeImpl.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED)))) != null) {
            return staticItems;
        }
        return null;
    }

    @Nullable
    private static List<LookupElement> addStaticFactoryMethods(@NotNull JSType expectedType) {
        if (expectedType == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(2);
        }
        if (!(expectedType instanceof JSResolvableType)) {
            return null;
        }
        JSClass jsClass = ((JSResolvableType)expectedType).resolveType().getDeclarationOfType(JSClass.class);
        if (jsClass == null) {
            return null;
        }
        ArrayList staticItems = ContainerUtil.newArrayList();
        for (JSFunction function : jsClass.getFunctions()) {
            JSAttributeList list = function.getAttributeList();
            if (list == null || list.getAccessType() != JSAttributeList.AccessType.PUBLIC || !list.hasModifier(JSAttributeList.ModifierType.STATIC)) continue;
            JSType returnType = function.getReturnType();
            if (returnType instanceof JSEvaluableTypeBase) {
                returnType = ((JSEvaluableTypeBase)returnType).evaluateType();
            }
            if (returnType == null || !returnType.isEquivalentTo(expectedType, null)) continue;
            staticItems.add(JSLookupUtilImpl.createLookupItemForStaticCall((JSElement)function, (JSElement)jsClass));
        }
        return staticItems;
    }

    @NotNull
    public List<LookupElement> getClassTypeVariants(PsiElement location, PsiElement parent, JSType expectedClassType) {
        JSAttributeList.AccessType constructorAccessType;
        String qualifiedName;
        JSType possiblyResolvable;
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        String className = expectedClassType.getTypeText();
        JSClass valueElement = null;
        if (expectedClassType instanceof JSPrimitiveType) {
            String matchingTypeName = JSTypeUtils.getQualifiedNameMatchingType(expectedClassType, false);
            if (matchingTypeName == null) {
                ArrayList<LookupElement> arrayList = variants;
                if (arrayList == null) {
                    JSSmartCompletionContributor.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
            className = matchingTypeName;
        }
        JSType jSType = possiblyResolvable = expectedClassType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)expectedClassType).getType() : expectedClassType;
        if (possiblyResolvable instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)possiblyResolvable).resolveType();
            valueElement = info.getDeclarationOfType(JSClass.class);
        }
        JSVariable variable = null;
        if (valueElement instanceof TypeScriptInterface && (qualifiedName = valueElement.getQualifiedName()) != null) {
            Collection<PsiElement> elements = new TypeScriptQualifiedNameResolver(parent, false).resolveQualifiedName(qualifiedName);
            for (PsiElement element : elements) {
                if (element instanceof JSClass && ((JSClass)element).isClassOrInterface() == JSElementBase.ClassOrInterface.CLASS) {
                    valueElement = (JSClass)element;
                    break;
                }
                if (!(element instanceof JSVariable)) continue;
                variable = JSSmartCompletionContributor.verifyVariable((JSVariable)element, possiblyResolvable);
            }
        }
        JSFunction constructor = valueElement == null ? null : JSResolveUtil.getClassConstructor(valueElement);
        JSAttributeList.AccessType accessType = constructorAccessType = constructor == null ? JSAttributeList.AccessType.PUBLIC : constructor.getAccessType();
        if (variable == null && this.shouldAddAsAbstract(parent, valueElement)) {
            if (constructorAccessType != JSAttributeList.AccessType.PRIVATE) {
                variants.add(JSLookupUtilImpl.createImplementAbstractOrInterfaceLookupItem((PsiElement)valueElement, className));
            }
        } else if (variable != null || constructorAccessType == JSAttributeList.AccessType.PUBLIC || JSDialectSpecificHandlersFactory.forElement(location).createAccessibilityProcessingHandler(location, false).acceptsConstructorWithNew((PsiElement)valueElement, valueElement.getName())) {
            LookupElement lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)(variable == null ? valueElement : variable), className.endsWith(">") ? className + "()" : className, JSLookupPriority.SMART_PRIORITY, false, false);
            variants.add(lookupItem);
        }
        JSSmartCompletionContributor.addAllJSClassInheritors(variants, className, parent);
        ArrayList<LookupElement> arrayList = variants;
        if (arrayList == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static JSVariable verifyVariable(@Nullable JSVariable variable, @NotNull JSType possiblyResolvable) {
        if (possiblyResolvable == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(5);
        }
        if (variable == null) {
            return null;
        }
        JSType elementType = JSTypeUtils.getTypeOfElement((PsiElement)variable);
        if (elementType == null) {
            return null;
        }
        List callSignatures = elementType.asRecordType().getCallSignatures();
        if (callSignatures.size() > 0 && callSignatures.stream().filter(s -> s.hasNew()).anyMatch(signature -> {
            if (possiblyResolvable == null) {
                JSSmartCompletionContributor.$$$reportNull$$$0(26);
            }
            return JSSmartCompletionContributor.areEquivalentDroppingGenerics(signature.getReturnType(), possiblyResolvable);
        })) {
            return variable;
        }
        return null;
    }

    private static boolean areEquivalentDroppingGenerics(@Nullable JSType type, @NotNull JSType resolvable) {
        if (resolvable == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(6);
        }
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        return resolvable.isEquivalentTo(type, null);
    }

    @Contract(value="_, null -> false")
    public boolean shouldAddAsAbstract(@Nullable PsiElement parent, @Nullable JSClass valueElement) {
        return parent instanceof JSNewExpression && valueElement != null && (valueElement.isInterface() || TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)valueElement));
    }

    @Nullable
    protected List<LookupElement> getStringLiteralVariants(@NotNull JSExpression location, boolean insideStringLiteral) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(7);
        }
        return this.getStringLiteralVariants(location, insideStringLiteral, JSDialectSpecificHandlersFactory.findExpectedType(location));
    }

    @Nullable
    private List<LookupElement> getStringLiteralVariants(@NotNull JSExpression location, boolean insideStringLiteral, @Nullable JSType expectedType) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(8);
        }
        return expectedType == null ? null : this.getLiteralVariantsForExpectedType(location, insideStringLiteral, expectedType);
    }

    @Nullable
    protected List<LookupElement> getLiteralVariantsForExpectedType(@NotNull JSExpression location, boolean insideStringLiteral, JSType expectedType) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(9);
        }
        List literalVariants = ContainerUtil.newSmartList();
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)type -> {
            if (location == null) {
                JSSmartCompletionContributor.$$$reportNull$$$0(25);
            }
            this.processSingleLiteralVariant(location, insideStringLiteral, literalVariants, (JSType)type);
            return true;
        }), expectedType, false, true, true);
        if (!literalVariants.isEmpty()) {
            return literalVariants;
        }
        return null;
    }

    protected void processSingleLiteralVariant(@NotNull JSExpression location, boolean insideStringLiteral, @NotNull List<LookupElement> literalVariants, JSType type) {
        List<LookupElement> variantsForExpectedType;
        JSType constraintType;
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(10);
        }
        if (literalVariants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(11);
        }
        if (!DialectDetector.isActionScript((PsiElement)location) && type instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)type).getConstraintType()) != null && (variantsForExpectedType = this.getLiteralVariantsForExpectedType(location, insideStringLiteral, constraintType)) != null) {
            literalVariants.addAll(variantsForExpectedType);
        }
        if (type instanceof JSPrimitiveLiteralType) {
            Object literal = ((JSPrimitiveLiteralType)type).getLiteral();
            this.addLiteralLookupItem(location, insideStringLiteral, literalVariants, type, literal, JSLookupPriority.SMART_PRIORITY);
        }
    }

    protected void addLiteralLookupItem(@NotNull JSExpression location, boolean insideStringLiteral, @NotNull List<LookupElement> literalVariants, @Nullable JSType type, Object literal, JSLookupPriority priority) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(12);
        }
        if (literalVariants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(13);
        }
        if (insideStringLiteral && !(literal instanceof String)) {
            return;
        }
        assert (literal instanceof String || type != null);
        String q = literal instanceof String && !insideStringLiteral ? JSCodeStyleSettings.getQuote((PsiElement)location) : "";
        String desc = literal instanceof String ? q + literal + q : type.getTypeText(JSType.TypeTextFormat.CODE);
        LookupElement prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(null, desc, priority, false, false, null, false, literal instanceof String ? (String)literal : null);
        literalVariants.add(JSLookupUtilImpl.setBold(prioritizedLookupItem, true));
    }

    private static void addAllJSClassInheritors(List<LookupElement> variants, String className, PsiElement place) {
        final ArrayList all = new ArrayList();
        JSTypeEvaluateManager.iterateSubclasses(place, className, new JSTypeEvaluateManager.NamespaceProcessor(){

            @Override
            public boolean process(String qName, VirtualFile file2) {
                all.add(qName);
                return true;
            }
        });
        for (String subclass : all) {
            LookupElement item = JSLookupUtilImpl.createPrioritizedLookupItem(null, subclass, JSLookupPriority.SMART_PRIORITY, false, false);
            variants.add(item);
        }
    }

    @Nullable
    protected JSType findClassType(PsiElement parent) {
        IElementType opSign;
        if (parent instanceof JSNewExpression) {
            return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent);
        }
        if (parent instanceof JSBinaryExpression && ((opSign = ((JSBinaryExpression)parent).getOperationSign()) == JSTokenTypes.AS_KEYWORD || opSign == JSTokenTypes.IS_KEYWORD || opSign == JSTokenTypes.INSTANCEOF_KEYWORD)) {
            JSType type = JSResolveUtil.getExpressionJSType(((JSBinaryExpression)parent).getLOperand());
            if (type != null && !(type instanceof JSAnyType) && !(type instanceof JSObjectType)) {
                return type;
            }
            return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent);
        }
        return null;
    }

    @NotNull
    protected List<LookupElement> addVariantsForUnqualifiedReference(@NotNull JSReferenceExpression location) {
        JSType expectedType;
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(14);
        }
        if ((expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)location)) == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                JSSmartCompletionContributor.$$$reportNull$$$0(15);
            }
            return list;
        }
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        this.addVariantsForUnqualifiedExpectedType(expectedType, location, variants);
        ArrayList<LookupElement> arrayList = variants;
        if (arrayList == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    protected void addVariantsForUnqualifiedExpectedType(@NotNull JSType expectedType, @NotNull JSReferenceExpression location, @NotNull List<LookupElement> variants) {
        if (expectedType == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(17);
        }
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(18);
        }
        if (variants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(19);
        }
        PsiElement parent = location.getParent();
        int qualifiedStaticVariantsStart = Integer.MAX_VALUE;
        PsiElement parentInOriginalTree = CompletionUtil.getOriginalOrSelf((PsiElement)parent);
        SinkResolveProcessor<CompletionResultSink> processor = JSSmartCompletionContributor.createProcessor(expectedType, parentInOriginalTree);
        JSClass ourClass = JSResolveUtil.getClassOfContext(parentInOriginalTree);
        this.processVariantsIfDoingSmartCompletion(expectedType, variants, parentInOriginalTree, processor, ourClass);
        this.processClasses(parentInOriginalTree, processor);
        qualifiedStaticVariantsStart = this.processContextClass(location, expectedType, parent, variants, qualifiedStaticVariantsStart, processor, ourClass);
        int i = 0;
        THashSet used = new THashSet();
        List<PsiElement> results = processor.getResults();
        if (results != null) {
            JSParameterItem parameter;
            String referencedParameterName = null;
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)location, (JSArgumentList)parent)) != null) {
                referencedParameterName = parameter.getName();
            }
            for (PsiElement o : results) {
                PsiElement element;
                JSNamedElement namedElement = (JSNamedElement)o;
                String name = namedElement.getName();
                String additionalPrefix = null;
                if ((namedElement instanceof JSVariable || namedElement instanceof JSFunction) && this.needToQualify(qualifiedStaticVariantsStart, i) && (element = JSResolveUtil.findParent((PsiElement)namedElement)) instanceof JSClass) {
                    additionalPrefix = name;
                    name = ((JSClass)element).getName() + "." + name;
                }
                if (name == null || !used.add(name)) {
                    if (i >= qualifiedStaticVariantsStart) continue;
                    --qualifiedStaticVariantsStart;
                    continue;
                }
                JSLookupPriority priority = JSLookupPriority.getSmartVariantPriority(name.equals(referencedParameterName));
                LookupElement prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)namedElement, name, priority, false, true, null, false, additionalPrefix);
                variants.add(prioritizedLookupItem);
                ++i;
            }
        }
    }

    protected void processVariantsIfDoingSmartCompletion(@NotNull JSType expectedType, @NotNull List<LookupElement> variants, PsiElement parentInOriginalTree, @NotNull SinkResolveProcessor<?> processor, JSClass ourClass) {
        if (expectedType == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(20);
        }
        if (variants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(22);
        }
        if (JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction()) {
            processor.setToProcessHierarchy(true);
            processor.configureClassScope(ourClass);
            JSResolveUtil.treeWalkUp(processor, parentInOriginalTree, parentInOriginalTree.getParent(), parentInOriginalTree);
            processor.setAllowUnqualifiedStaticsFromInstance(false);
            if (expectedType instanceof JSBooleanType) {
                variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, "true", JSLookupPriority.SMART_PRIORITY, true, true));
                variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, "false", JSLookupPriority.SMART_PRIORITY, true, true));
            }
        }
    }

    @NotNull
    private static SinkResolveProcessor<CompletionResultSink> createProcessor(final JSType expectedType, PsiElement parentInOriginalTree) {
        final CompletionResultSink resultSink = new CompletionResultSink(parentInOriginalTree);
        resultSink.setSmartCompletionInheritanceProcessingContext(JSSmartCompletionVariantsHandler.initProcessingContext(parentInOriginalTree));
        SinkResolveProcessor<CompletionResultSink> sinkResolveProcessor = new SinkResolveProcessor<CompletionResultSink>(resultSink){
            {
                super(arg0);
                this.setAllowUnqualifiedStaticsFromInstance(true);
                this.setLocalResolve(true);
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                return !JSSmartCompletionVariantsHandler.isAcceptableVariant(element, expectedType, resultSink.getSmartCompletionInheritanceProcessingContext()) || super.execute(element, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/completion/JSSmartCompletionContributor$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (sinkResolveProcessor == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(23);
        }
        return sinkResolveProcessor;
    }

    protected int processContextClass(@NotNull JSReferenceExpression location, JSType expectedType, PsiElement parent, List<LookupElement> variants, int qualifiedStaticVariantsStart, SinkResolveProcessor<?> processor, JSClass ourClass) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(24);
        }
        return qualifiedStaticVariantsStart;
    }

    protected boolean needToQualify(int qualifiedStaticVariantsStart, int i) {
        return qualifiedStaticVariantsStart <= i;
    }

    protected void processClasses(PsiElement parentInOriginalTree, SinkResolveProcessor<?> processor) {
    }

    @ReadOnly
    @Nullable
    protected static <T> List<T> mergeVariants(@Nullable @ReadOnly List<T> completionVariants, @Nullable @ReadOnly List<T> extraVariants) {
        if (extraVariants == null) {
            return completionVariants;
        }
        if (completionVariants == null) {
            return extraVariants;
        }
        return ContainerUtil.concat(extraVariants, completionVariants);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 16: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 16: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSSmartCompletionContributor";
                break;
            }
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possiblyResolvable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvable";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalVariants";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSSmartCompletionContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassTypeVariants";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addVariantsForUnqualifiedReference";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSmartCompletionVariants";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addOtherSmartVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStaticFactoryMethods";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 16: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "verifyVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "areEquivalentDroppingGenerics";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralVariantsForExpectedType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processSingleLiteralVariant";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLiteralLookupItem";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addVariantsForUnqualifiedReference";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addVariantsForUnqualifiedExpectedType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processVariantsIfDoingSmartCompletion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processContextClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLiteralVariantsForExpectedType$2";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$verifyVariable$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 16: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

