/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptQuickNavigateBuilder
extends JSQuickNavigateBuilder {
    @Override
    @Nullable
    protected String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if (element instanceof TypeScriptModule) {
            return this.createQuickNavigateForJSElement((JSElement)((TypeScriptModule)element), originalElement, "module", JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION);
        }
        if (element instanceof ES6ImportExportDeclarationPart) {
            ES6ImportExportDeclarationPart part = (ES6ImportExportDeclarationPart)element;
            JSQuickNavigateBuilder.ObjectKind kind = this.getKindForImport(part);
            return this.createQuickNavigateForJSElement((JSElement)part, originalElement, "", kind);
        }
        return super.getQuickNavigateInfoForNavigationElement(element, originalElement);
    }

    @NotNull
    protected JSQuickNavigateBuilder.ObjectKind getKindForImport(@NotNull ES6ImportExportDeclarationPart part) {
        if (part == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (part instanceof ES6ImportSpecifier) {
            JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.IMPORT_SPECIFIER;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(3);
            }
            return objectKind;
        }
        if (part instanceof ES6ImportedBinding) {
            JSQuickNavigateBuilder.ObjectKind objectKind = ((ES6ImportedBinding)part).isNamespaceImport() ? JSQuickNavigateBuilder.ObjectKind.IMPORT_ALL : JSQuickNavigateBuilder.ObjectKind.IMPORT_DEFAULT;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(4);
            }
            return objectKind;
        }
        if (part instanceof ES6ExportSpecifier || part instanceof ES6ExportedDefaultBinding) {
            JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.EXPORT;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(5);
            }
            return objectKind;
        }
        JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION;
        if (objectKind == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Override
    @Nullable
    protected String getTypeTextForQuickNavigate(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor) {
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        rawType = JSTypeUtils.applyCompositeMapping(rawType, (Function<JSType, JSType>)((Function)el -> JSArrayType.GenericArrayBuilder.asArrayIfGenericType(JSCompositeTypeImpl.optimizeTypeIfComposite(el))));
        return super.getTypeTextForQuickNavigate(rawType, substitutor);
    }

    @Override
    @Nullable
    protected String getVariableOrFieldTypeText(@NotNull JSFieldVariable variableOrField, @NotNull JSTypeSubstitutor substitutor) {
        String typeFromService;
        if (variableOrField == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        if ((typeFromService = FlowJSServerService.getTypeIfServiceEnabled((PsiElement)variableOrField)) != null) {
            return typeFromService;
        }
        return super.getVariableOrFieldTypeText(variableOrField, substitutor);
    }

    @Override
    @Nullable
    protected String getVariableOrFieldInferredTypeText(@NotNull JSElement resolved, @NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        JSType narrowType;
        String typeFromService;
        if (resolved == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        if ((typeFromService = FlowJSServerService.getTypeIfServiceEnabled(originalElement)) != null) {
            return typeFromService;
        }
        String name = resolved.getName();
        originalElement = JavaScriptQuickNavigateBuilder.getOriginalElementOrParentIfLeaf(originalElement);
        if (name != null && originalElement instanceof JSReferenceExpression && JSTypeGuardChecker.isNarrowableReference((JSExpression)originalElement) && (narrowType = JSResolveUtil.getExpressionJSType((JSExpression)originalElement)) != null && (narrowType.getSource().isTypeScript() || narrowType.getSource().isStrict())) {
            return this.getTypeTextForQuickNavigate(narrowType, substitutor);
        }
        return super.getVariableOrFieldInferredTypeText(resolved, originalElement, substitutor);
    }

    @Override
    @NotNull
    protected JSQuickNavigateBuilder.ObjectKind getFieldOrVariableKind(@NotNull JSFieldVariable variableOrField) {
        if (variableOrField == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        if (variableOrField instanceof JSField || variableOrField instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)variableOrField)) {
            JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.PROPERTY;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(14);
            }
            return objectKind;
        }
        JSQuickNavigateBuilder.ObjectKind objectKind = super.getFieldOrVariableKind(variableOrField);
        if (objectKind == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        return objectKind;
    }

    @Override
    protected boolean isInferredVariableType(@NotNull JSFieldVariable variableOrField, @Nullable String variableOrFieldTypeText, @Nullable String inferredType) {
        if (variableOrField == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        if (variableOrField instanceof TypeScriptVariable && ((TypeScriptVariable)variableOrField).isConst()) {
            return false;
        }
        return super.isInferredVariableType(variableOrField, variableOrFieldTypeText, inferredType) || DialectDetector.isTypeScript((PsiElement)variableOrField) && variableOrField.getTypeElement() == null;
    }

    @Override
    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement candidate, @NotNull PsiElement originalElement) {
        if (candidate == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        if (!DialectDetector.isTypeScript((PsiElement)candidate)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(19);
            }
            return jSTypeSubstitutor;
        }
        originalElement = JavaScriptQuickNavigateBuilder.getOriginalElementOrParentIfLeaf(originalElement);
        boolean isSourceElement = JavaScriptQuickNavigateBuilder.isElementFromTSSources(candidate, originalElement);
        JSElement typeSubstitutorTarget = candidate;
        if (isSourceElement) {
            typeSubstitutorTarget = JavaScriptQuickNavigateBuilder.getOriginalResolvedElement(candidate, (JSReferenceExpression)originalElement);
        }
        JSTypeSubstitutor substitutorForMember = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember(typeSubstitutorTarget, originalElement);
        Object object = isSourceElement ? new JSTypeSubstitutor.StringTypeSubstitutor(substitutorForMember) : substitutorForMember;
        if (object == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(20);
        }
        return object;
    }

    private static boolean isElementFromTSSources(@NotNull JSElement member, @NotNull PsiElement originalElement) {
        if (member == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        return originalElement instanceof JSReferenceExpression && Boolean.TRUE.equals(TypeScriptDeclarationMappings.SOURCE_FILE_MARKER.get((UserDataHolder)member));
    }

    @NotNull
    private static JSElement getOriginalResolvedElement(@NotNull JSElement member, @NotNull JSReferenceExpression originalElement) {
        ResolveResult[] results;
        List<PsiElement> resolvedElements;
        if (member == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(23);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(24);
        }
        if ((resolvedElements = JSResolveResult.toElements(results = originalElement.multiResolve(false))).size() != 1) {
            JSElement jSElement = member;
            if (jSElement == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(25);
            }
            return jSElement;
        }
        PsiElement candidate = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
        if (candidate instanceof JSElement) {
            member = (JSElement)candidate;
        }
        JSElement jSElement = member;
        if (jSElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(26);
        }
        return jSElement;
    }

    @Override
    protected void appendFunctionAttributesAndName(@NotNull JSFunction function, @Nullable PsiElement parent, @NotNull StringBuilder result2, boolean shouldAppendKeyword, @NotNull JSTypeSubstitutor substitutor) {
        String generics;
        if (function == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(27);
        }
        if (result2 == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(28);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(29);
        }
        super.appendFunctionAttributesAndName(function, parent, result2, shouldAppendKeyword, substitutor);
        if (function instanceof TypeScriptTypeParameterListOwner && (generics = JavaScriptQuickNavigateBuilder.getGenerics((TypeScriptTypeParameterListOwner)function, substitutor)) != null) {
            result2.append(generics);
        }
    }

    @Nullable
    protected static String getGenerics(@NotNull TypeScriptTypeParameterListOwner owner, @NotNull JSTypeSubstitutor substitutor) {
        TypeScriptTypeParameterList list;
        if (owner == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(30);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(31);
        }
        if ((list = owner.getTypeParameterList()) == null) {
            return null;
        }
        Object[] parameters = list.getTypeParameters();
        if (parameters.length == 0) {
            return null;
        }
        StringBuilder newBuilder = new StringBuilder();
        newBuilder.append("<");
        newBuilder.append(StringUtil.join((Object[])parameters, el -> {
            TypeScriptTypeParser.TypeParameterGenericId id;
            JSType type;
            String name;
            if (substitutor == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(37);
            }
            if ((name = el.getName()) == null) {
                name = "?";
            }
            return (type = substitutor.get((JSTypeSubstitutor.JSTypeGenericId)(id = TypeScriptTypeParser.getTypeParameterId(el)))) == null ? name : type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }, (String)","));
        newBuilder.append(">");
        return StringUtil.escapeXml((String)newBuilder.toString());
    }

    @Override
    protected void appendClassAttributesAndName(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @Nullable String packageOrModule, @NotNull StringBuilder result2) {
        JSTypeSubstitutor substitutor;
        String generics;
        if (jsClass == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(32);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(33);
        }
        if (result2 == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(34);
        }
        boolean isAlias = jsClass instanceof TypeScriptTypeAlias;
        boolean isEnum = jsClass instanceof TypeScriptEnum;
        if (isAlias || isEnum) {
            this.appendAttrList((JSAttributeListOwner)jsClass, result2);
            result2.append(isAlias ? "type " : "enum ");
            this.appendClassNameWithPackage(jsClass, packageOrModule, result2);
        } else {
            super.appendClassAttributesAndName(jsClass, originalElement, packageOrModule, result2);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && (generics = JavaScriptQuickNavigateBuilder.getGenerics((TypeScriptTypeParameterListOwner)jsClass, substitutor = this.getTypeSubstitutor((JSElement)jsClass, originalElement))) != null) {
            result2.append(generics);
        }
    }

    @Override
    protected String getParentInfo(@Nullable PsiElement parent, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        String generics;
        if (element == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(35);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(36);
        }
        if (element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            parent = JSUtils.getMemberContainingClass((PsiElement)element);
        }
        if (parent instanceof TypeScriptInterfaceClass && (generics = JavaScriptQuickNavigateBuilder.getGenerics((TypeScriptTypeParameterListOwner)parent, substitutor)) != null) {
            String className = StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)"default");
            return className + generics;
        }
        if (parent instanceof TypeScriptModule && ((TypeScriptModule)parent).isInternal()) {
            return ((TypeScriptModule)parent).getQualifiedName();
        }
        return super.getParentInfo(parent, element, substitutor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 11: 
            case 18: 
            case 22: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JavaScriptQuickNavigateBuilder";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 29: 
            case 31: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JavaScriptQuickNavigateBuilder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindForImport";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldOrVariableKind";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalResolvedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKindForImport";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 25: 
            case 26: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextForQuickNavigate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldTypeText";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldInferredTypeText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFieldOrVariableKind";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInferredVariableType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isElementFromTSSources";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalResolvedElement";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionAttributesAndName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getGenerics";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributesAndName";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getParentInfo";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGenerics$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

